/*  XMMS STATUS PLUGIN - Status Docklet Plugin for XMMS
 *  Copyright (C) 2000,2001,2002  Ian Campbell.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

#ifndef __XMMS_STATUS_DOCKLET_PLUGIN_H__
#define __XMMS_STATUS_DOCKLET_PLUGIN_H__

#ifdef ENABLE_NLS
#  include <locale.h>
#  include <libintl.h>
#  define _(String) dgettext(PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#define STATUS_DOCKLET_IMAGE(obj) \
     GTK_CHECK_CAST (obj, status_docklet_image_get_type(), StatusDockletImage)
#define STATUS_DOCKLET_IMAGE_CLASS(klass) \
     GTK_CHECK_CLASS_CAST (klass, status_docklet_image_get_type(), StatusDockletImageClass)
#define STATUS_DOCKLET_IS_IMAGE(obj) \
     GTK_CHECK_TYPE (obj, status_docklet_image_get_type())

typedef enum _StatusDockletButtonAction StatusDockletButtonAction;
typedef enum _StatusDockletButtonModifier StatusDockletButtonModifier;
typedef enum _StatusDockletState StatusDockletState;
typedef struct _StatusDockletConfig StatusDockletConfig;

typedef struct _StatusDockletImage StatusDockletImage;
typedef struct _StatusDockletImageClass StatusDockletImageClass;
typedef struct _StatusDockletImageInfo StatusDockletImageInfo;

#define STATUS_DOCKLET_BUTTON_LAST 9

enum _StatusDockletButtonAction {
	STATUS_DOCKLET_BUTTON_ACTION_NONE = 0,
	STATUS_DOCKLET_BUTTON_ACTION_TOGGLE_WINDOWS,
	STATUS_DOCKLET_BUTTON_ACTION_PLAYPAUSE,
	STATUS_DOCKLET_BUTTON_ACTION_STOP,
	STATUS_DOCKLET_BUTTON_ACTION_VOLUME_UP,
	STATUS_DOCKLET_BUTTON_ACTION_VOLUME_DOWN,
	STATUS_DOCKLET_BUTTON_ACTION_FORWARD,
	STATUS_DOCKLET_BUTTON_ACTION_BACKWARD,
	STATUS_DOCKLET_BUTTON_ACTION_MENU,
	STATUS_DOCKLET_BUTTON_ACTION_ADD_FILES,
	STATUS_DOCKLET_BUTTON_ACTION_LAST
};

enum _StatusDockletButtonModifier {
	STATUS_DOCKLET_BUTTON_MODIFIER_NONE = 0,
	STATUS_DOCKLET_BUTTON_MODIFIER_SHIFT,
	STATUS_DOCKLET_BUTTON_MODIFIER_CONTROL,
	STATUS_DOCKLET_BUTTON_MODIFIER_ALT,
	STATUS_DOCKLET_BUTTON_MODIFIER_LAST
};

enum _StatusDockletState {
	STATUS_DOCKLET_STATE_PLAYING = 0,
	STATUS_DOCKLET_STATE_PAUSED,
	STATUS_DOCKLET_STATE_STOPPED,
	STATUS_DOCKLET_STATE_LAST
};

struct _StatusDockletConfig {
	gboolean configured;
	gboolean freedesktop_docklet_support;

	StatusDockletButtonAction button_actions[STATUS_DOCKLET_BUTTON_MODIFIER_LAST][STATUS_DOCKLET_BUTTON_LAST];

	gchar *playing_image;
	gchar *paused_image;
	gchar *stopped_image;

	gint playing_image_delay;
	gint paused_image_delay;
	gint stopped_image_delay;

	gint balloon_delay;
};

struct _StatusDockletImage {
	GtkWidget parent;

	StatusDockletImageInfo *images[STATUS_DOCKLET_STATE_LAST];
	StatusDockletState current_state;
	
	gint timeout_tag;
	GdkPixmap *default_pixmap;
	GdkBitmap *default_mask;

	GdkPixmap *offscreen_pixmap;
	GdkPixmap *background_pixmap;
	
	GdkRectangle area;
};

struct _StatusDockletImageClass {
	GtkWidgetClass parent_class;
};

extern StatusDockletConfig status_docklet_config;

void status_docklet_about(void);
void status_docklet_configure(void);

void status_docklet_load_config(void);
void status_docklet_save_config(void);
void status_docklet_load_images(void);

GtkType status_docklet_image_get_type(void);
GtkWidget *status_docklet_image_new(void);
void status_docklet_image_load(StatusDockletImage *im, StatusDockletState state, const gchar *path, gint frame_delay);
void status_docklet_image_state_set(StatusDockletImage *im, StatusDockletState state);

#endif /* __XMMS_STATUS_DOCKLET_PLUGIN_H__ */




