/* Synaesthesia - program to display sound graphically
   Copyright (C) 1997  Paul Francis Harrison

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  675 Mass Ave, Cambridge, MA 02139, USA.

  The author may be contacted at:
    phar6@student.monash.edu.au
  or
    27 Bond St., Mt. Waverley, 3149, Melbourne, Australia
*/

#include <gtk/gtk.h>
#include "syna_xmms.h"

/***************************************/
/*   For the incurably fiddle prone:   */

/* log2 of sample size */
/* #define m 8 */

/* overlap amount between samples. Set to 1 or 2 if you have a fast computer */
#define overlap 0

/* Brightness */
#define brightness 150

/***************************************/

#define PROGNAME "synaesthesia-xmms"

#ifdef WORDS_BIGENDIAN
#define BIGENDIAN
#else
#define LITTLEENDIAN
#endif

/*
#define n (1<<m)
*/

/* core */
extern guint16 *synx_output[3];
#define output ((guchar*)(synx_output[0]))
#define lastOutput ((guchar*)(synx_output[1]))
#define lastLastOutput ((guchar*)(synx_output[2]))

#define fadeMode (synx_cfg.fadeMode)
#define starSize (synx_cfg.starSize)
#define brightnessTwiddler (synx_cfg.brightnessTwiddler)
#define pointsAreDiamonds (synx_cfg.pointsAreDiamonds)

inline unsigned short combiner(unsigned short a,unsigned short b) {
  unsigned char ah = a>>8, al = a&255, bh = b>>8, bl = b&255;
  if (ah < 64) ah *= 4; else ah = 255;
  if (al < 64) al *= 4; else al = 255;
  if (bh > ah) ah = bh;
  if (bl > al) al = bl;
  return ah*256+al;
}

#define outWidth synx_img_w
#define outHeight synx_img_h
