/*----------------------------------------------------------------------------

Authmysql is written by Ahmad S. Al-rasheedan. It does a simple job.
Takes login name and clear text password and compares it with stored
login name and password from MySQL database. Admins have the option 
of storing passwords in clear text (not recommended) or crypted.
Authmysql can deal with both as long as you compile source using
correct CFLAGS.

Standard Unix crypt have been used; use standard Unix crypt for storing
passwords in DB.

I wrote it to the best of my knowledge, don't blame me if it brakes
anything. All can use source freely.

Ahmad S. Al-rasheedan (alrasheedan@yahoo.com) 2000

-----------------------------------------------------------------------------*/

#include<stdio.h>
#include<mysql.h>
#include "conf.h"

char *crypt_pw();

int main(int argc, char *argv[])
{
MYSQL mysql;
MYSQL_RES *result;
MYSQL_ROW row;

char *command;
char *st;
char *salt;
char *pw_string;

int rc;
int command_length;



/*

Can we connect
to the database ?

*/

mysql_init(&mysql);
if (!mysql_real_connect(&mysql,MY_HOST,USER,USER_PASSWD,DATABASE,0,NULL,0))
{
    fprintf(stderr, "Failed to connect to database: Error: %s\n",
          mysql_error(&mysql));
}

/*

Lets construct 
the SQL query
along memory allocation

*/

    command_length = strlen(SQL_SELECT) + strlen(argv[1]) + strlen(argv[2]);
         command = (char *) malloc(command_length*sizeof(char)); 
             sprintf(command,SQL_SELECT,argv[1]);


/*

What do we get 
from the SQL query ?

*/

                rc = mysql_query(&mysql, command );
                   free(command);
                      result = mysql_store_result(&mysql);
                         row = mysql_fetch_row(result);
                            mysql_free_result(result);
                                mysql_close(&mysql);

                     if ( !row )
                       {
                        fprintf(stdout, "User '%s' does not exist\n", argv[1]);
                          exit(1);
                          }
/*

Simply assign returned value
from MySQL to variable pw_string

*/

               pw_string = (char *) malloc((strlen(row[0])*sizeof(char)));
                 if ( !pw_string )
                     {
                       fprintf(stdout, "Failed to alocate memory\n");
                         exit(1);
                         }
                            strcpy(pw_string, row[0]);
/*

Now we have some string for 
password, lets do our part
of crypting supplied clear
text password using salt
from stored password in DB.

*/

                      st = (char *) malloc(14*sizeof(char));
                       salt = (char *) malloc(3*sizeof(char));
                        if ( !st || !salt)
                          {
                            fprintf(stdout, "Failed to alocate memory\n");
                             exit(1);
                             } 

#ifdef CRYPT
                         strncpy(salt, pw_string, 2);
                           salt[2] =  '\0';
                              strcpy (st, crypt_pw( argv[2], salt));
                                if (strcmp(st, pw_string) == 0)
#else
                        if (strcmp(row[0] ,argv[2]) == 0)
#endif
	                   {
	                     printf("Auth ok.\n");
	                      exit(0);
	                      }
	                  else
                            {
	                      printf("Bad auth.\n");
	                       exit(1);
	                       }
}

/*

crypt_pw()  takes clear text passwd
and salt extracted from encrypted password
stored in DB and returns encrypted
password to main body

*/

char *crypt_pw(char *ct_pw, char *salt)
{
char *st;

                  st = (char *) malloc(14*sizeof(char));
                     strcpy(st, (char *) crypt(ct_pw, salt));
                        return st;
}
