/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#include <yehia/plugin.h>

namespace Yehia
{

using namespace std;

PluginInfo::PluginInfo(const std::string& name, Plugin *plugin)
    : name_(name), plugin_(plugin)
{
  if (plugin_)
    plugin_->reference();
}

PluginInfo::~PluginInfo()
{
  if (plugin_)
    plugin_->unreference();
}

void PluginInfo::set_plugin(Plugin *plugin)
{
  if (plugin) 
    plugin->reference();
  if (plugin_)
    plugin_->unreference();
  plugin_ = plugin;
}

PluginNode::PluginNode(const string& name, Plugin *p) 
    : Super(PluginInfo(name, p))
{
}

string PluginNode::full_name() const
{
  string fullname;
  iterator it(*this);
  
  while (it.parent() != end()) 
  {
    fullname.insert(0, it->name());
    
    it = it.parent();
    if (it != end() && it.parent() != end())
      fullname.insert(0, ".");
  }
  return fullname;
}

PluginNode::iterator PluginNode::insert(const string& name, Plugin *plugin)
{
  string::size_type pos = name.find('.');
  string namebase = name.substr(0, pos);
  
  iterator it = begin();
  while (true)
  {
    if (it == end() || it->name() > namebase)
    {
      if (pos != string::npos)
      {
        iterator new_node = insert_before(it, PluginInfo(namebase, 0));
        return PluginNode(new_node).insert(name.substr(pos + 1), plugin);
      }
      else
        return insert_before(it, PluginInfo(namebase, plugin));
    }
    if (it->name() == namebase)
    {
      if (pos != string::npos)
        return PluginNode(it).insert(name.substr(pos + 1), plugin);
      else
      {
        it->set_plugin(plugin);
        return it;
      }
    }
    ++it;
  }
}

bool PluginNode::erase(const std::string& name)
{
  iterator it = find(name);
  if (it == end())
    return false;
  erase(it);
  return true;
}

PluginNode::iterator PluginNode::find_(const string& name) const
{
  string::size_type pos = name.find('.');
  
  string namebase = (pos == string::npos) ? name : name.substr(0, pos);

  iterator it = begin();
  while (true)
  {
    if (it == end() || it->name() > namebase)
      return end();
    if (it->name() == namebase)
    {
      if (pos == string::npos)
        return it;
      else
        return PluginNode(it).find_(name.substr(pos + 1));
    }
    ++it;
  }
}

}
