#include <string>
#include <gtkmm/stock.h>
#include "facontext.h"
#include "dialogs.h"
#include "preferences.h"
#include "config.h"


/*********************
 File Selector Dialog
*********************/
MusicFileSelector::MusicFileSelector(FAContext *context, std::string caption)
{
	//Init
	m_context = context;
	set_title(caption);
	
	//Read Prefrences
	m_context->prefs->GetPrefBoolean(kSetLastResumePref, set_last_dir);
	if(set_last_dir) {
		std::string last_dir;
		m_context->prefs->GetPrefString(kLastDirPref, last_dir);
		set_filename(last_dir);
	}
	
	//Capture Response
	signal_response().connect( SigC::slot(*this, &MusicFileSelector::on_response) );
}

void MusicFileSelector::on_response(int response)
{
	if((response == Gtk::RESPONSE_OK) && set_last_dir) {
		m_context->prefs->SetPrefString(kLastDirPref, Glib::path_get_dirname(get_filename()) + DIR_MARKER);
	}
}

/*********************
 Message Dialog Class
*********************/
int MusicMessageDialog::run(bool in_main)
{
	if(in_main) {
		//Can Just Run The Dialog Like Normal
		return MessageDialog::run();
	}
	
	//Show Dialog
	response_mutex.lock();
	show();
	
	gdk_threads_leave();
	
	//Wait For Response
	response_cond.wait(response_mutex);
	
	//Return Response
	response_mutex.unlock();
	
	gdk_threads_enter();
	return m_response;
}

void MusicMessageDialog::on_response(int response)
{
	//Do Default Response Stuff
	MessageDialog::on_response(response);
	
	//Stop Waiting
	response_mutex.lock();
	m_response = response;
	response_cond.signal();
	response_mutex.unlock();
}
	

/*******************
 Entry Input Dialog
*******************/
MusicInputDialog::MusicInputDialog(const Glib::ustring& caption, const Glib::ustring& prompt)
	: Dialog(caption)
{
	//Setup Dialog Controls
	m_dialog_pic.set(Gtk::Stock::DIALOG_QUESTION, Gtk::ICON_SIZE_DIALOG);
	m_dialog_pic.set_padding(12 ,12);
	m_dialog_label.set_text(prompt);
	
	//Layout Dialog Controls
	Gtk::VBox *DialogBox = get_vbox();
	m_dialog_layout.pack_start(m_dialog_pic);
	m_dialog_entry_layout.pack_start(m_dialog_label, true, false, 12);
	m_dialog_entry_layout.pack_start(m_dialog_entry, true, false, 12);
	m_dialog_layout.pack_start(m_dialog_entry_layout);
	DialogBox->pack_start(m_dialog_layout);
		
	//Add Response Buttons
	add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
	add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);
	
	//Set Entry As Having Focus
	m_dialog_entry.grab_focus();
	
	//Add Signal Handlers
	m_dialog_entry.signal_activate().connect( SigC::slot(*this, &MusicInputDialog::entry_activated) );
	
	//Make Sure All Controls Will Be Visible
	show_all_children();
}
	
void MusicInputDialog::set_entry_text(Glib::ustring entry)
{
	m_dialog_entry.set_text(entry);
	m_dialog_entry.select_region(0, entry.length());
}

Glib::ustring MusicInputDialog::get_entry_text()
{
	return m_dialog_entry.get_text();
}

int MusicInputDialog::run(bool in_main)
{
	if(in_main) {
		//Can Just Run The Dialog Like Normal
		return Dialog::run();
	}
	
	//Show Dialog
	response_mutex.lock();
	show();
	
	gdk_threads_leave();
	
	//Wait For Response
	response_cond.wait(response_mutex);
	
	//Return Response
	response_mutex.unlock();
	
	gdk_threads_enter();
	return m_response;
}

void MusicInputDialog::entry_activated()
{
	response(Gtk::RESPONSE_OK);
}

void MusicInputDialog::on_response(int response)
{
	//Do Default Response Stuff
	Dialog::on_response(response);
	
	//Stop Waiting
	response_mutex.lock();
	m_response = response;
	response_cond.signal();
	response_mutex.unlock();
}



#if 0
MusicSearchDialog::MusicSearchDialog()
{
    add(m_vlayout);
    m_vlayout.pack_start(m_hlayout, Gtk::PACK_SHRINK);
}
#endif

/* arch-tag: c49bef24-155d-4bd4-a273-a35bec1e1a96 */
