/*
 * symlink.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"

int symlink(__const char *file_name1, __const char *file_name2)
{
  int st;
  struct STAT32 buf;

  /* file without z exists */
  st = ___zlibc_stat(file_name1, &buf );
  if ( st < 0 && errno == ENOENT ){
    char newname1[MAXPATHLEN + MAXEXTLEN + 1];
    char newname2[MAXPATHLEN + MAXEXTLEN + 1];

    zlib_initialise();
    if ( ! ( zlib_mode & CM_DISAB ) &&
	(zlib_getfiletype(file_name1,-1) & PM_READ_MASK) != PM_LEAVE_COMPR){

      strncpy(newname1,file_name1,1024);
      strcat(newname1,zlib_ext);

      st = ___zlibc_stat(newname1, &buf );
      
      /* file with z exists */
      if ( st >= 0 || errno != ENOENT ){
	errno = 0;
	strncpy(newname2,file_name2,1024);
	strcat(newname2,zlib_ext);
	return zlib_real_symlink(newname1, newname2);
      }
    }
  }

  /* neither file  exists */
  errno = 0;
  return zlib_real_symlink(file_name1, file_name2);
}
