##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product
"""


from config import *
import os
import string

from Products.ZAttachmentAttribute import ZAttachmentAttribute
from Products.ZAttachmentAttribute import ZAttachmentRegistry
from Products.ZAttachmentAttribute import ZAbstractAttachment
from Products.ZAttachmentAttribute.Log import *

class MSPowerpointAttachment(ZAbstractAttachment.ZAbstractAttachment):
    """
    MSPowerpoint file abstraction
    """
    
    icon_file = "powerpoint.gif"
    small_icon_file = "powerpoint_small.gif"
    content_types = ('application/powerpoint', 'application/mspowerpoint', 'application/x-powerpoint', 'application/x-mspowerpoint', 'application/vnd.ms-powerpoint', )
    index_list = ()


    def indexAttachment(self):
        """
        indexAttachment(self) => index a MSPowerpoint file and store it in the index variable.
        This method is called only once (in the __init__) during the class's lifetime.
        """
        fn = self.writeAttachmentFile()
        return self.callConverter(CONVERTER_PROGRAM, "%s" % (fn, ))


    def isPreviewAvailable(self,):
        return 1


    def convertPreview(self,):
        """
        Let's convert things into pretty HTML !
        """
        # Perform conversion and retreive files as well
        fn = self.writeAttachmentFile()
        try:
            # Actual HTML conversion
            ret = self.callConverter(CONVERTER_PROGRAM, "%s" % (fn, ))

        finally:
            self.deleteAttachmentFile()

        return self.stripBody(ret)




ZAttachmentRegistry.AttachmentRegistry.registerClass(MSPowerpointAttachment, globals())

