#charset "us-ascii"

/* 
 *   Copyright (c) 1999, 2002 Michael J. Roberts
 *.  This file is part of TADS 3.
 *   
 *   This file includes all of the standard TADS system headers, so programs
 *   can include this header alone rather than having to include all of the
 *   separate headers individually.  
 */

#ifndef TADS_H
#define TADS_H

/*
 *   To allow the standard library and header files to be used with
 *   alternative I/O intrinsics, we explicitly use macros for the I/O
 *   dependencies in the library - specifically, the I/O intrinsic header
 *   file name, and the name of the default stream output function.
 *   
 *   We define defaults for these if they aren't otherwise defined.  To
 *   compile library files with an alternative set of I/O intrinsics, define
 *   these symbols in the compiler (for example, by using the -D command-line
 *   option with t3make).  
 */
#ifndef TADS_IO_HEADER
#define TADS_IO_HEADER "tadsio.h"
#endif
#ifndef _tads_io_say
#define _tads_io_say(str) tadsSay(str)
#endif


/* include the T3 VM intrinsic function set */
#include "t3.h"

/* include the TADS general data manipulation function set */
#include "tadsgen.h"

/* include the TADS input/output function set */
#include TADS_IO_HEADER

/* include the system type definitions */
#include "systype.h"
 
#endif /* TADS_H */

