#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
# 
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_name(english:"Anonymous FTP enabled",
 	     francais:"FTP anonyme activ",
 	     portugues:"FTP annimo habilitado");
	     
 script_description(english:"The FTP service allows anonymous logins. If you do not
 want to share data with anyone you do not know, then you should deactivate
 the anonymous account, since it can only cause troubles.
 Under most Unix system, doing : 
 	echo ftp >> /etc/ftpusers
 will correct this.
 
 Risk factor : Low",
		    francais:"Le serveur FTP accepte les connections anonymes. Si vous
ne souhaitez pas partager des donnes avec des inconnus, alors vous devriez
dsactiver le compte anonyme, car il ne peut que vous apporter des problmes.
Sur la plupart des Unix, un simple :
	echo ftp >> /etc/ftpusers
corrigera ce problme.

Facteur de risque : Faible",
			    portugues:"O servidor FTP est permitindo login annimo. 
Se voc no quer compartilhar dados com pessoas que voc no conhea ento voc deve
desativar a conta anonymous (ftp), j que ela pode lhe trazer apenas problemas.
Na maioria dos sistemas UNIX, fazendo:
	echo ftp >> /etc/ftpusers
ir corrigir o problema.

Fator de risco : Baixo");
 
 script_summary(english:"Checks if the remote ftp server accepts anonymous logins",
 		francais:"Dtermine si le serveur ftp distant accepte les logins anonymes",
 		portugues:"Verifica se o servidor FTP remoto aceita login como anonymous");

 script_category(ACT_GATHER_INFO);
 script_family(english:"FTP");
 script_family(francais:"FTP");
 script_family(portugues:"FTP");
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
 		  francais:"Ce script est Copyright (C) 1999 Renaud Deraison",
 		  portugues:"Este script  Copyright (C) 1999 Renaud Deraison");
 script_dependencie("find_service.nes");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

#
# The script code starts here : 
#

port = get_kb_item("Services/ftp");
if(!port)port = 21;
state = get_port_state(port);
if(!state)exit(0);
soc = open_sock_tcp(port);
if(soc)
{
 if(ftp_log_in(socket:soc, user:"ftp", pass:"nessus@nessus.org"))
 {
  security_warning(port);
  set_kb_item(name:"ftp/anonymous", value:TRUE);
 }
}
