/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xlib.h>
#include <stdlib.h>
#include <stdio.h>

#include "CalendarP.h"
#include "Init.h"

char *day_names[] = {
	"Sun" ,
	"Mon" ,
	"Tue" ,
	"Wed" ,
	"Thu" ,
	"Fri" ,
	"Sat" ,
	NULL,
};

char *month_names[] = {
	"January" ,
	"February" ,
	"March" ,
	"April"
	"May" ,
	"Jun" ,
	"July" ,
	"August" ,
	"September" ,
	"October" ,
	"December" ,
	NULL ,
};

#define offset(field) XtOffsetOf(CalendarRec,calendar.field)

static XtResource resources [] = {
	{
	XtNactivate ,
	XtCActivate ,
	XtRCallback ,
	sizeof(XtCallbackList) ,
	offset(activate) ,
	XtRCallback ,
	(XtPointer) NULL
	},
	{
	 XtNmonth_color ,
	 XtCMonth_color ,
	 XtRPixel ,
	 sizeof(Pixel) ,
	 offset(month_color) ,
	 XtRString ,
	 (XtPointer) XtDefaultForeground
	},
	{
	 XtNsunday_color ,
	 XtCSunday_color ,
	 XtRPixel ,
	 sizeof(Pixel) ,
	 offset(sunday_color) ,
	 XtRString ,
	 (XtPointer) XtDefaultForeground
	},
	{
	 XtNselector_color ,
	 XtCSelector_color ,
	 XtRPixel ,
	 sizeof(Pixel) ,
	 offset(selector_color) ,
	 XtRString ,
	 (XtPointer) XtDefaultForeground
	},
	{
	 XtNday_font ,
	 XtCFont ,
	 XtRFontStruct ,
	 sizeof(XFontStruct *) ,
	 offset(day_font) ,
	 XtRString ,
	 (XtPointer) XtDefaultFont
	},
	{
	 XtNmonth_font ,
	 XtCFont ,
	 XtRFontStruct ,
	 sizeof(XFontStruct *) ,
	 offset(month_font) ,
	 XtRString ,
	 (XtPointer) XtDefaultFont
	},
	{
	 XtNtime ,
	 XtCTime ,
	 XtRImmediate ,
	 sizeof(struct tm *) ,
	 offset(_time) ,
	 XtRImmediate ,
	 (XtPointer) NULL
	},
	{
	 XtNspacing ,
	 XtCSpacing ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(spacing) ,
	 XtRImmediate ,
	 (XtPointer) 10
	},
	{
	 XtNday_names ,
	 XtCDay_names ,
	 XtRStringList ,
	 sizeof(char *) ,
	 offset(day_names) ,
	 XtRImmediate ,
	 (XtPointer) day_names ,
	},
	{
	 XtNmonth_names ,
	 XtCMonth_names ,
	 XtRStringList ,
	 sizeof(char *) ,
	 offset(month_names) ,
	 XtRImmediate ,
	 (XtPointer) month_names
	},
};

static int day_of_week();
static int days_of_month();
static char * cvt_month();
static char * cvt_day();

static void ClassInitialize();
static void Initialize ();
static void Destroy ();
static void Redisplay ();
static Boolean SetValues ();
static XtGeometryResult	QueryGeometry();
static void Activate ();

static XtActionsRec actions[] = {
{"activate", Activate},
};

static char trans_tab[] = 
	"<Btn1Down>: activate() \n\
	 ~Shift<Key>Tab: traverseForward()\n\
	 Shift<Key>Tab: traverseBackward()\n\
	 <FocusIn>: focusIn()\n\
	 <FocusOut>: focusOut()\n\
	 ";


CalendarClassRec calendarClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &baseClassRec,
    /* class_name            */ "Calendar",
    /* widget_size           */ sizeof(CalendarRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ actions,
    /* num_actions           */ XtNumber(actions),
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ TRUE,
    /* compress_exposure     */ TRUE,
    /* compress_enterleave   */ TRUE,
    /* visible_interest      */ FALSE,
    /* destroy               */ (XtWidgetProc) Destroy,
    /* resize                */ XtInheritResize,
    /* expose                */ (XtExposeProc) Redisplay,
    /* set_values            */ (XtSetValuesFunc) SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
 /* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight               */ XtInheritHighlight,
    /* unhighlight             */ XtInheritUnhighlight,
    /* highlightBorder	       */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* calendar */
   {
    /* empty		     */ 0
   },
};

WidgetClass calendarWidgetClass = (WidgetClass) & calendarClassRec;

static struct tm *new_tm_struct(t)
struct tm *t;
{
	struct tm* tn = malloc(sizeof(struct tm));
	memcpy((char *)tn , (char *)t , sizeof(struct tm));
	return tn;
}

static void ClassInitialize()
{
	_InitializeWidgetSet();

	XtSetTypeConverter(XtRString, XtRStringList, cvtStringToStringList ,
		NULL, 0, XtCacheNone, NULL);
}

static void Activate(w,event,params,num_params)
Widget w;
XEvent*event;
String*params;
Cardinal*num_params;
{
	CalendarWidget cw = (CalendarWidget) w;
	int xpos,ypos,dow,dow0,width,height;
	struct tm *t;
	
	if ((int) event->xbutton.y < cw->calendar.base) return;

	ypos = ((int) event->xbutton.y - cw->calendar.base ) / 
		(cw->calendar.day_font->ascent + cw->calendar.day_font->descent +
		 cw->calendar.spacing);

	xpos = ((int) event->xbutton.x ) / (3 * cw->calendar.day_font->max_bounds.width + 
		cw->calendar.spacing);

	dow0 = day_of_week(1, cw->calendar._time->tm_mon,cw->calendar._time->tm_year);
	if (xpos > 6) return;
	if ((7*ypos+xpos) < dow0) return;
	if ((7*ypos+xpos) > (dow0 - 1 + days_of_month(cw->calendar._time->tm_mon,
		cw->calendar._time->tm_year))) return;

	dow = day_of_week(cw->calendar.selected , cw->calendar._time->tm_mon,
			cw->calendar._time->tm_year);


	width = (3*cw->calendar.day_font->max_bounds.width);
	height = cw->calendar.day_font->ascent + cw->calendar.day_font->descent;

	XSetForeground(XtDisplay(w) , cw->calendar.selector_gc ,
			cw->core.background_pixel);
	XDrawRectangle(XtDisplay(w) , XtWindow(w) , cw->calendar.selector_gc ,
			dow * (width + cw->calendar.spacing) + cw->calendar.spacing / 2,
			((dow0 + cw->calendar.selected - 1) / 7) * (height + 
			cw->calendar.spacing) + cw->calendar.base , 
			width , height + 1);

	XSetForeground(XtDisplay(w) , cw->calendar.selector_gc ,
			cw->calendar.selector_color);
	XDrawRectangle(XtDisplay(w) , XtWindow(w) , cw->calendar.selector_gc ,
			xpos * (width + cw->calendar.spacing) + cw->calendar.spacing/2,
			ypos * (height + cw->calendar.spacing)+cw->calendar.base,
			width , height + 1);

	cw->calendar.selected = 7 * ypos + xpos - dow0 + 1;

	t = (struct tm *) XtMalloc(sizeof(struct tm));
	cw->calendar._time->tm_mday = t->tm_mday = cw->calendar.selected;
	cw->calendar._time->tm_mon = t->tm_mon = cw->calendar._time->tm_mon;
	cw->calendar._time->tm_year = t->tm_year = cw->calendar._time->tm_year;

        if (cw->calendar.activate)
                XtCallCallbackList(w,cw->calendar.activate, (XtPointer) t);

	XtFree((char *) t);
}
static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	CalendarWidget nw = (CalendarWidget) new_widget;
	XGCValues gc_res;
	XtGCMask gc_mask;
	Display *dpy=XtDisplay(new_widget);
	time_t __time = time(NULL);

	gc_mask = GCBackground;
	gc_res.background = nw->core.background_pixel;
	nw->calendar.grc= XCreateGC(dpy,DefaultRootWindow(dpy),gc_mask,&gc_res);

	gc_mask = GCBackground | GCForeground;
	gc_res.foreground = nw->calendar.selector_color;
	gc_res.background = nw->core.background_pixel;
	nw->calendar.selector_gc= XCreateGC(dpy,DefaultRootWindow(dpy),gc_mask,&gc_res);


	if (nw->calendar._time == NULL)
	{
		nw->calendar._time = new_tm_struct(localtime(& __time));
		nw->calendar.selected = nw->calendar._time->tm_mday;
	}
	else  nw->calendar.selected = nw->calendar._time->tm_mday;

	if (! nw->core.width) nw->core.width = 8 * nw->calendar.spacing + 
				21 * nw->calendar.day_font->max_bounds.width;

	if (! nw->core.height) nw->core.height = 7 * (nw->calendar.day_font->ascent +
						nw->calendar.day_font->descent) +
						10 * nw->calendar.spacing +
						nw->calendar.month_font->ascent +
						nw->calendar.month_font->descent;

	nw->calendar.base = 3 * nw->calendar.spacing +
		nw->calendar.month_font->descent +
		nw->calendar.month_font->ascent +
		nw->calendar.day_font->descent +
		nw->calendar.day_font->ascent;

}

static void Destroy(w)
Widget w;
{
	XFreeGC(XtDisplay(w),((CalendarWidget) w)->calendar.grc);
}

static void Redisplay(w , event , region)
Widget w;
XEvent *event;
Region region;
{
	Display *dpy=XtDisplay(w);
	CalendarWidget cw = (CalendarWidget) w;
	int twidth;
	char mtxt[20];
	int ypos,xpos;
	int ndays;
	int i;
	int dow,dow0;
	int width,height;

	sprintf(mtxt,"%s %d",cvt_month(cw , cw->calendar._time->tm_mon),
			cw->calendar._time->tm_year);

	twidth = XTextWidth(cw->calendar.month_font,mtxt,strlen(mtxt));

	XSetFont(dpy , cw->calendar.grc , cw->calendar.month_font->fid);
	XSetForeground(dpy , cw->calendar.grc , cw->calendar.month_color);
	XDrawString(dpy , XtWindow(w),cw->calendar.grc ,
		(cw->core.width - twidth) / 2 ,
		cw->calendar.spacing + cw->calendar.month_font->descent +
		cw->calendar.month_font->ascent,
		mtxt,strlen(mtxt));

	ypos = 	2 * cw->calendar.spacing +
		cw->calendar.month_font->descent +
		cw->calendar.month_font->ascent +
		cw->calendar.day_font->descent +
		cw->calendar.day_font->ascent ;

	XSetFont(dpy , cw->calendar.grc , cw->calendar.day_font->fid);
	for (i = 0;i < 7;i ++)
	{
		sprintf(mtxt,"%s",cvt_day(cw , i));

		XDrawString(dpy , XtWindow(w) , cw->calendar.grc ,
			i * (3 * cw->calendar.day_font->max_bounds.width + 
			cw->calendar.spacing) + cw->calendar.spacing ,
			ypos , mtxt , strlen(mtxt));
	}
	ypos += cw->calendar.day_font->ascent +
		cw->calendar.day_font->descent +
		cw->calendar.spacing ;
	ndays = days_of_month(cw->calendar._time->tm_mon,cw->calendar._time->tm_year);
	dow = day_of_week(1,cw->calendar._time->tm_mon,cw->calendar._time->tm_year);
	XSetForeground(dpy , cw->calendar.grc , cw->base.foreground);
	for(i = 0;i < ndays;i++)
	{
		xpos = ((i + dow) % 7) * (3 * cw->calendar.day_font->max_bounds.width + 
			cw->calendar.spacing) + cw->calendar.spacing;

		if (!((i + dow) % 7) && i)
			ypos += cw->calendar.day_font->ascent +
				cw->calendar.day_font->descent +
				cw->calendar.spacing ;
		if (!((i + dow) % 7))
			XSetForeground(dpy , cw->calendar.grc , cw->calendar.sunday_color);
		else if (((i + dow) % 7) == 1) 
			XSetForeground(dpy , cw->calendar.grc , cw->base.foreground);

		sprintf(mtxt,"%2d",i + 1);
		
		XDrawString(dpy , XtWindow(w) , cw->calendar.grc , xpos , ypos ,
				mtxt,strlen(mtxt));
	}

	if (cw->calendar.selected > days_of_month(cw->calendar._time->tm_mon ,
			cw->calendar._time->tm_year)) cw->calendar.selected = 1;

	dow = day_of_week(cw->calendar.selected , cw->calendar._time->tm_mon ,
			cw->calendar._time->tm_year);

	dow0 = day_of_week(1, cw->calendar._time->tm_mon,cw->calendar._time->tm_year);

	width = (3*cw->calendar.day_font->max_bounds.width);
	height = cw->calendar.day_font->ascent + cw->calendar.day_font->descent;

	XSetForeground(dpy, cw->calendar.selector_gc ,
			cw->calendar.selector_color);
	XDrawRectangle(dpy , XtWindow(w) , cw->calendar.selector_gc ,
			dow * (width + cw->calendar.spacing) + cw->calendar.spacing / 2,
			((dow0 + cw->calendar.selected - 1) / 7) * (height + 
			cw->calendar.spacing) + cw->calendar.base ,
			width , height + 1);

}

#define WidgetValuesDiffer(w1,w2,component) (w1->calendar.component != \
                                             w2->calendar.component)


static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	CalendarWidget cw = (CalendarWidget) current;
	CalendarWidget nw = (CalendarWidget) new_widget;


	if WidgetValuesDiffer(nw,cw,_time->tm_mon)
		nw->calendar.selected = 1;
 
 	if WidgetValuesDiffer(nw,cw,_time)
	{
		memcpy(cw->calendar._time , nw->calendar._time , sizeof(struct tm));
		nw->calendar._time = cw->calendar._time;
	}

	return True;
}

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
	CalendarWidget cw = (CalendarWidget) w;
        Dimension pwidth , pheight;
        Dimension width , height;
        Position x,y;

        calendarClassRec.base_class.get_internal_dimension(w , &x , &y ,
                        &width , &height);

	pwidth = 8 * cw->calendar.spacing +  21 * cw->calendar.day_font->max_bounds.width;

	pheight = 7 * (cw->calendar.day_font->ascent + cw->calendar.day_font->descent) +
			10 * cw->calendar.spacing + cw->calendar.month_font->ascent +
			cw->calendar.month_font->descent;

        preferred->request_mode = CWWidth | CWHeight;
        preferred->width = (Dimension)(pwidth + (cw->core.width - width));
        preferred->height = (Dimension)(pheight + (cw->core.height - height));

        if (((intended->request_mode & (CWWidth | CWHeight))
                == (CWWidth | CWHeight)) &&
                intended->width == preferred->width &&
                intended->height == preferred->height)
                return XtGeometryYes;

        else if (preferred->width == cw->core.width &&
                preferred->height == cw->core.height)
                return XtGeometryNo;

        else return XtGeometryAlmost;
}

static char * cvt_month(w , month)
CalendarWidget w;
int month;
{
	if (month < 12) return w->calendar.month_names[month];
	else return "";
}

static char * cvt_day(w , day)
CalendarWidget w;
int day;
{
	if (day < 7) return w->calendar.day_names[day];
	else return "";
}

static int days_of_month(month,year)
int month;
int year;
{
	switch (month)
	{
		case 0: return 31;
		case 1: return ((year < 1753) && (year % 4 == 0)) ||
			 	((year > 1753) && (year % 4 == 0) && 
			 	((year % 100 != 0) || (year % 400 == 0))) ?
				29 : 28;
		case 2: return 31;
		case 3: return 30;
		case 4: return 31;
		case 5: return 30;
		case 6: return 31;
		case 7: return 31;
		case 8: return 30;
		case 9: return 31;
		case 10: return 30;
		case 11: return 31;
		default: return 0;
	}
}

#define days_of_year(year) (year % 4) ? 365 : 366

static int day_of_week(day,month,year)
int day;
int month;
int year;
{
	int smonth = 0;
	int pyear;
	long dow = 4;

	pyear = (year - 1)/4 - (year - 1 - 1700)/100 + (year - 1)/400;

	dow += (pyear) * 366 + 
	       (year - pyear - 1) * 365;

	while (smonth != month)
	{
		dow += days_of_month(smonth,year);
		smonth++;
	}
	return (int) ((dow + day) % 7);
}
