/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _FileSelectorP_H_
#define _FileSelectorP_H_

#include <Nws/FileSel.h>
#include <Nws/RowP.h>

typedef struct {
	char	empty;
} FileSelClassPart;

typedef struct _FileSelClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	BaseConstClassPart	baseConst_class;
	RowClassPart		row_class;
	FileSelClassPart	fileSel_class;
} FileSelClassRec;

extern FileSelClassRec	fileSelClassRec;

typedef struct {
	/* resources */
	Boolean		dirsel;
	int		spacing;
	char		*filter;
	char		*dir;
	char		*file;
	XtCallbackList	ok_cb;
	XtCallbackList	cancel_cb;
	XtCallbackList	apply_cb;
	XtCallbackList	help_cb;
	char		*filter_label;
	char		*file_label;
	char		*dir_label;
	char		*ok_label;
	char		*apply_label;
	char		*rescan_label;
	char		*help_label;
	char		*cancel_label;
	/* private */
	ListStruct	*dir_list;
	ListStruct	*file_list;
	int		num_dir;
	int		num_files;
	Widget		filter_w;
	Widget		dir_w;
	Widget		file_w;
	Widget		dir_list_w;
	Widget		file_list_w;
	Widget		ok_button_w;
	Widget		apply_button_w;
	Widget		cancel_button_w;
	Widget		help_button_w;
	Widget		rescan_button_w;
	Widget		bcol_w;
} FileSelPart;

typedef struct _FileSelRec {
	CorePart		core;
	CompositePart		composite;
	ConstraintPart		constraint;
	BaseConstPart		baseConst;
	RowPart			row;
	FileSelPart		fileSel;
} FileSelRec;

typedef struct _FileSelConstraintsRec {
        RowConstraintsPart      row;
} FileSelConstraintsRec, *FileSelConstraints;

#endif
