/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _ListP_H_
#define _ListP_H_

#include <Nws/List.h>
#include <Nws/ColP.h>

typedef struct {
	char	empty;
} ListClassPart;

typedef struct _ListClassRec {
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	ConstraintClassPart	constraint_class;
	BaseConstClassPart	baseConst_class;
	ColClassPart		col_class;
	ListClassPart		list_class;
} ListClassRec;

extern ListClassRec listClassRec;


typedef struct {
	/* resourses */
	XFontStruct	*font;
	int		num_entry;
	int		num_selected;
	XtCallbackList	select_cb;
	XtCallbackList	select_changed_cb;
	Pixel		selected_fg;
	Pixel		selected_bg;
	ListStruct	*list;
	/* private */
        XtIntervalId    double_click_timer;
	WidgetList	w_list;
	Widget		last_selected;
	int		selected_idx;
} ListPart;

typedef struct _ListRec {
	CorePart		core;
	CompositePart		composite;
	ConstraintPart		constraint;
	BaseConstPart		baseConst;
	ColPart			col;
	ListPart		list;
} ListRec;

typedef struct {
	char empty;
} ListConstraintsPart;

typedef struct _ListConstraintsRec {
	ColConstraintsPart	col;
	ListConstraintsPart	list;
} ListConstraintsRec , *ListConstraints;

#endif
