/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "MenuBarP.h"
#include "Init.h"
#define HIDE_PROTO 1
#include "MenuP.h"
#include "MBButtonP.h"
#undef HIDE_PROTO

#define offset(field) XtOffsetOf(MBButtonRec,mBButton.field)

static XtResource resources [] = {
	{
	 XtNmenu_name ,
	 XtCMenu_name ,
	 XtRString ,
	 sizeof(String) ,
	 offset(menu_name) ,
	 XtRImmediate ,
	 (XtPointer) "menu" ,
	},
};

static void ClassInitialize();
static void Initialize ();
static void PopdownMenu ();
static void Activate ();
static void Leavenotify ();
static void ResolveInheritance ();

static Widget get_menu();
static void popdown_menu();

MBButtonClassRec mBButtonClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &labelMEClassRec,
    /* class_name            */ "MBButton",
    /* widget_size           */ sizeof(MBButtonRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ ResolveInheritance,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* rect1                 */ NULL,
    /* rect2                 */ NULL,
    /* rect3                 */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* rect4                 */ False,
    /* rect5                 */ False,
    /* rect6                 */ False,
    /* rect7                 */ False,
    /* destroy               */ NULL,
    /* resize                */ XtInheritResize,
    /* expose                */ XtInheritExpose,
    /* set_values            */ NULL,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* rect9                 */ NULL,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* rect10                */ NULL,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* rect11                */ NULL,
    /* extension             */ NULL
   },
/* baseME */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* enternotify	       */ XtInheritEnternotify,
    /* leavenotify	       */ Leavenotify,
    /* activate		       */ Activate,
   },
/* labelME */
   {
   /* empty		       */ 0,
   },
/* mBButton */
   {
   /* popdown_menu	       */ PopdownMenu ,
   },
};

WidgetClass mBButtonObjectClass = (WidgetClass) &mBButtonClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void ResolveInheritance(class)
WidgetClass class;
{
        MBButtonObjectClass c = (MBButtonObjectClass) class;
        MBButtonObjectClass super;

        if (class == mBButtonObjectClass) return;
        super = (MBButtonObjectClass)c->rect_class.superclass;

        if (c->mBButton_class.popdown_menu == XtInheritPopdownMenu)
                c->mBButton_class.popdown_menu =
                        super->mBButton_class.popdown_menu;

}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	MBButtonObject nw = (MBButtonObject) new_widget;

	nw->mBButton.menu = NULL;
}

static void Activate (w)
Widget w;
{
	MBButtonObject cw = (MBButtonObject) w;
	Display * dpy= XtDisplayOfObject(w);
	Position x,y;
	Dimension width , height ,
		dwidth = DisplayWidth(dpy,DefaultScreen(dpy)) ,
		dheight = DisplayHeight(dpy,DefaultScreen(dpy)) ;


        if (!XtIsSensitive(w)) return;
        
	XtCallCallbackList(w , cw->baseME.activate , NULL);

	cw->mBButton.menu = get_menu(w);

	cw->baseME.entered = True;

	((MBButtonObjectClass)cw->object.widget_class)->rect_class.expose(w , NULL , NULL);

	if (!cw->mBButton.menu) return;

	XtAddCallback(cw->mBButton.menu , XtNpopdownCallback ,
		popdown_menu , (XtPointer) cw);

	if (!XtIsRealized(cw->mBButton.menu))  XtRealizeWidget(cw->mBButton.menu);

	XtVaGetValues(cw->mBButton.menu , XtNwidth , &width ,
		XtNheight , &height , NULL);

	XtTranslateCoords(XtParent((Widget)cw) , cw->rectangle.x ,
		cw->rectangle.y + cw->rectangle.height , &x ,&y);

	if ( (x + width) > dwidth ) x = dwidth - width;

	if ( (y + height ) > dheight ) y = dheight - height;

	if ( y < 0 ) y = 0;

	XtVaSetValues(cw->mBButton.menu,XtNx,x,XtNy,y,NULL);

        XtPopupSpringLoaded(cw->mBButton.menu);
}


static void Leavenotify(w)
Widget w;
{
	MBButtonObject cw = (MBButtonObject) w;


	if (!cw->mBButton.menu)
	{
		labelMEClassRec.baseME_class.leavenotify(w);
	}
}

static void PopdownMenu(w)
Widget w;
{
	MBButtonObject cw = (MBButtonObject) w;

	if (cw->mBButton.menu)
	{
		((MenuWidgetClass)((MenuWidget)cw->mBButton.menu)->core.widget_class)->
			menu_class.popdown_all(cw->mBButton.menu);
	}

	cw->baseME.entered = False;

	((MBButtonObjectClass)cw->object.widget_class)
		->rect_class.expose(w , NULL , NULL);

	cw->mBButton.menu = NULL;
}

static void popdown_menu(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	MBButtonObject cw = (MBButtonObject) client_data;
	MenuBarWidget mw = (MenuBarWidget) XtParent((Widget)cw);

	XtRemoveCallback(w , XtNpopdownCallback , popdown_menu , client_data);

	cw->baseME.entered = False;

	((MBButtonObjectClass)cw->object.widget_class)
		->rect_class.expose((Widget)cw , NULL , NULL);

	cw->mBButton.menu = NULL;

	((MenuBarWidgetClass)mw->core.widget_class)->menuBar_class.unactivate((Widget)mw);

}

static Widget get_menu(w)
Widget w;
{
	MBButtonObject cw = (MBButtonObject) w;
        Widget menu = NULL;
        Widget parent = w;

        while (parent != NULL && menu == NULL)
        {
                if ((menu = XtNameToWidget(parent , cw->mBButton.menu_name)) == NULL)
                        parent = XtParent(parent);
        }

	return menu;
}
