/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _dimdefP_H_
#define _dimdefP_H_

#if NeedFunctionPrototypes
typedef void (*set_internal_dimension_Proc) (Widget,Dimension,Dimension);
#else
typedef void (*set_internal_dimension_Proc) ();
#endif

#if NeedFunctionPrototypes
typedef void (*get_internal_dimension_Proc) (Widget,Position *,Position *,Dimension *,Dimension *);
#else
typedef void (*get_internal_dimension_Proc) ();
#endif

#if NeedFunctionPrototypes
typedef Widget (*traverse_Proc) (Widget, int ,Time *);
typedef void (*traverseTo_Proc) (Widget, Widget ,Time *);
typedef void (*traverseOut_Proc) (Widget);
typedef Widget (*traverseInside_Proc) (Widget, int ,Time *);
typedef void (*highlightBorder_Proc) (Widget);
typedef void (*unhighlightBorder_Proc) (Widget);
#else
typedef Widget (*traverse_Proc) ();
typedef void (*traverseTo_Proc) ();
typedef void (*traverseOut_Proc) ();
typedef Widget (*traverseInside_Proc) ();
typedef void (*highlightBorder_Proc) ();
typedef void (*unhighlightBorder_Proc) ();
#endif

#define  XtInheritGetInternalDimension ((get_internal_dimension_Proc) _XtInherit)
#define  XtInheritSetInternalDimension ((set_internal_dimension_Proc) _XtInherit)
#define  XtInheritTraverse ((traverse_Proc) _XtInherit)
#define  XtInheritTraverseTo ((traverseTo_Proc) _XtInherit)
#define  XtInheritTraverseOut ((traverseOut_Proc) _XtInherit)
#define  XtInheritTraverseInside ((traverseInside_Proc) _XtInherit)
#define  XtInheritHighlightBorder ((highlightBorder_Proc) _XtInherit)
#define  XtInheritUnhighlightBorder ((unhighlightBorder_Proc) _XtInherit)

#endif
