/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef __ftp_h__
#define __ftp_h__

#include <time.h>
#include "doc.h"
#include "myssl.h"
#include "bufio.h"

#define DEFAULT_FTP_PORT 21
#define DEFAULT_FTP_PROXY_PORT	22

#define FTP_TYPE_F	0
#define FTP_TYPE_D	1
#define FTP_TYPE_L	2

typedef struct {
	protocol	proto;
	char		*user;
	char		*passwd;
	char		*host;
	unsigned short	port;
	bufio		*control;
#ifdef USE_SSL
	SSL		*control_ssl_con;
	BIO		*control_ssl_bio;
	SSL_CTX		*control_ssl_ctx;
#endif
} ftp_connection;

typedef struct _ftp_url_extension {
	char		type;	/*** type of file ***/
	short int	perm;	/*** permisions ***/
	unsigned int	size;	/*** size of file ***/
	char		*slink;	/*** where point symlink ***/
} ftp_url_extension;

extern bufio *ftp_get_data_socket(doc * , int , time_t);
extern void ftp_dir_to_html(doc *);
extern void ftp_dir_list_to_html(doc *);
extern int ftp_get_response(doc *, char ** , int);
extern ftp_url_extension *ftp_parse_ftpinf_ext(char *);
extern int ftp_make_symlink(url *);

#endif
