/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _http_h_
#define _http_h_

#include <time.h>
#include "bufio.h"
#include "dllist.h"

#define DEFAULT_HTTP_PORT	80
#define DEFAULT_HTTP_PROXY_PORT	8080
#define DEFAULT_SSL_PORT	443
#define DEFAULT_SSL_PROXY_PORT	8080

typedef struct {
	short	ver_maj;	/*** major version of HTTP protocol ***/
	short	ver_min;	/*** minor version of HTTP protocol ***/
	int	ret_code;	/*** cislo navratoveho kodu ***/
	char	*text;		/*** textova informacia k navratovemu kodu ***/
} http_response;

typedef struct {
	char		*nonce;
	char		*opaque;
	char		*realm;
	char		*site;
	unsigned short	port;
} http_digest_info;

typedef struct {
	bool	all;
	char	*name;
	char	*val;
} httphdr;

typedef struct {
	protocol		proto;
	char			*host;
	unsigned short		port;
	bufio			*connection;
        http_digest_info	*auth_digest;		/*** HTTP digest access authentification info ***/
	http_digest_info	*auth_proxy_digest;	/*** HTTP digest access proxy authentification info ***/
} http_connection;

typedef struct {
	dllist	*form_data;
} http_url_extension;

#include "doc.h"

extern int http_connect(char * , int);
extern int http_get_reguest(doc * , url * , int , time_t);
extern int http_head_reguest(doc * , url * , int , time_t);
extern int http_post_reguest(doc * , url * , int , time_t);
extern bufio *http_get_data_socket(doc * , int , time_t , int);
extern http_response * http_get_response_info(char *);
extern int http_read_mime_header(doc *, char ** , int *);
extern int http_dumy_proxy_connect(doc *, char * , int);
extern http_digest_info *http_digest_parse(char * , url * , int*);
extern void http_digest_deep_free(http_digest_info *);
extern httphdr *httphdr_parse(char *);
extern void httphdr_free(httphdr *);
extern char *_md5(unsigned char *);

#endif
