/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <string.h>
#include <stdio.h>
#include "config.h"
#include "uexit.h"
#include "tools.h"

int uexit_condition(urlp , size , date)
url *urlp;
int *size;
time_t date;
{
	char cmd[8192];
	char pom[2046];
	int i;
	char *urlstr;
	int retv;

	urlstr = url_to_urlstr(urlp , FALSE);
	sprintf(cmd , "%s -url '%s' " , cfg.condition.uexit , urlstr);
	_free(urlstr);

	for (i = 0 ; urlp->parent_url  && urlp->parent_url[i] ; i++)
	{
		urlstr = url_to_urlstr(urlp->parent_url[i] , FALSE);
		sprintf(pom , "-parent '%s' " , urlstr);
		_free(urlstr);
		strcat(cmd , pom);
	}

	sprintf(pom , "-level %d " , urlp->level);
	strcat(cmd , pom);

	if (size)
	{
		strcat(cmd , "-size ");
		sprintf(pom , "%d " , *size);
		strcat(cmd , pom);
	}

	if (date)
	{
		LOCK_TIME
		strftime(pom , sizeof(pom) , "-date %Y%m%d%H%M%S " , gmtime(&date));
		UNLOCK_TIME
		strcat(cmd , pom);
	}

	retv = system(cmd);

	if ((retv & 0x000f) < 0 || (retv & 0x000f) > 127) 
	{
		xperror(gettext("Error occured while executing user-exit script"));
		return -1;
	}

	return retv >> 8;
}

