/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <dirent.h>
#include <limits.h>
#include <utime.h>

#ifdef HAVE_SYS_MODE_H
#include <sys/mode.h>
#endif

#include "config.h"
#include "tools.h"
#include "url.h"
#include "doc.h"
#include "html.h"
#include "xinterface.h"

static void rewrite_links();

void update_links(dirname)
char *dirname;
{
	DIR *dir;
	struct dirent *dent;
	char next_dir[PATH_MAX];
	struct stat estat;

	xprintf(1 , gettext("Entering directory %s\n") , dirname);
	if (!(dir = opendir(dirname)))
	{
		xperror(dirname);
		return;
	}

	while((dent = readdir(dir)))
	{
		_Xt_Serve

		sprintf(next_dir , "%s/%s" , dirname , dent->d_name);
		if (!strcmp(dent->d_name , ".")) continue;
		if (!strcmp(dent->d_name , "..")) continue;		
		if (stat(next_dir , &estat))
		{
			xperror(next_dir);
			continue;
		}

		if (S_ISDIR(estat.st_mode))
		{
			if (!strcmp(dent->d_name , ".pavuk_info") && cfg.enable_info)
				continue;

			update_links(next_dir);
		}
		else if (file_is_html(next_dir))
		{
			xprintf(1 , gettext("Relocating %s\n") , next_dir);
			rewrite_links(next_dir);
		}
		else xprintf(1 , gettext("Omitting %s\n") , next_dir);
#ifdef I_FACE
		if (cfg.xi_face)
		{
			if (cfg.rbreak || cfg.stop)
			{
				closedir(dir);
				return;
			}
		}
#endif
	}

	closedir(dir);
	xprintf(1 , gettext("Leaving directory %s\n") , dirname);	
}

static void rewrite_links(fn)
char *fn;
{
	char pom[2048];
	char *savetmp,*p;
	int sock,len;
	doc pdoc;
	char *newcont;
        struct stat estat;
	struct utimbuf ut;
        url dum;

        if (stat(fn , &estat) == 0)
        {
                if (S_ISDIR(estat.st_mode))
                {
                        xprintf(1 , gettext("Can't open directory %s\n") , fn);
                        return ;
                }
        }

	ut.actime = estat.st_atime;
	ut.modtime = estat.st_mtime;

	memset(&dum , '\0' , sizeof(url));
	dum.type = URLT_FILE;
	dum.p.file.filename = fn;
	dum.status = 0;

	doc_init(&pdoc, &dum);

	doc_download(&pdoc , 1 , TRUE);

	_free(pdoc.mime);

	len = html_remote_to_local_links(&newcont , &pdoc , FALSE , FALSE);

	strcpy(pom , fn);
	p = strrchr(pom , '/');
	sprintf(p + 1 , "._lnkupd%d" , getpid());
	savetmp = new_string(pom);	
	rename(fn , savetmp);

	if ((sock = open(fn , O_BINARY | O_TRUNC | O_CREAT | O_WRONLY , S_IWUSR | S_IRUSR | S_IRGRP | S_IROTH)) < 0)
	{
		xperror(fn);
		rename(savetmp , fn);
		free(savetmp);
		free(newcont);
		free(pdoc.contents);
		doc_remove_lock(&pdoc);
		return;
	}
	if (write(sock , newcont , len) != len)
	{
		xperror(fn);
		close(sock);
		rename(savetmp , fn);
		free(savetmp);
		free(newcont);
		free(pdoc.contents);
		doc_remove_lock(&pdoc);
		return;
	}
	close(sock);
	utime(fn , &ut);
	unlink(savetmp);
	free(savetmp);
	free(newcont);
	free(pdoc.contents);
	doc_remove_lock(&pdoc);
}
