
//
//  support.c  --  support functions for gtk parts of program
//  -- created 5/23/00  updated 5/23/00
///////////////////////////////////////////////

#include "support.h"

extern Althea gAlthea;



guint chartoGDKKey (char c) {

  switch (c) {
    case 'a':
      return GDK_a;
      break;
    case 'b':
      return GDK_b;
      break;
    case 'c':
      return GDK_c;
      break;
    case 'd':
      return GDK_d;
      break;
    case 'e':
      return GDK_e;
      break;
    case 'f':
      return GDK_f;
      break;
    case 'g':
      return GDK_g;
      break;
    case 'h':
      return GDK_h;
      break;
    case 'i':
      return GDK_i;
      break;
    case 'j':
      return GDK_j;
      break;
    case 'k':
      return GDK_k;
      break;
    case 'l':
      return GDK_l;
      break;
    case 'm':
      return GDK_m;
      break;
    case 'n':
      return GDK_n;
      break;
    case 'o':
      return GDK_o;
      break;
    case 'p':
      return GDK_p;
      break;
    case 'q':
      return GDK_q;
      break;
    case 'r':
      return GDK_r;
      break;
    case 's':
      return GDK_s;
      break;
    case 't':
      return GDK_t;
      break;
    case 'u':
      return GDK_u;
      break;
    case 'v':
      return GDK_v;
      break;
    case 'w':
      return GDK_w;
      break;
    case 'x':
      return GDK_x;
      break;
    case 'y':
      return GDK_y;
      break;
    case 'z':
      return GDK_z;
      break;
    case '1':
      return GDK_1;
      break;
    case '2':
      return GDK_2;
      break;
    case '3':
      return GDK_3;
      break;
    case '4':
      return GDK_4;
      break;
    case '5':
      return GDK_5;
      break;
    case '6':
      return GDK_6;
      break;
    case '7':
      return GDK_7;
      break;
    case '8':
      return GDK_8;
      break;
    case '9':
      return GDK_9;
      break;
    case '0':
      return GDK_0;
      break;
    case '`':
      return GDK_0;
      break;
    case '-':
      return GDK_0;
      break;
    case '=':
      return GDK_0;
      break;
    case '[':
      return GDK_0;
      break;
    case ']':
      return GDK_0;
      break;
    case '\\':
      return GDK_0;
      break;
    case ';':
      return GDK_0;
      break;
    case '\'':
      return GDK_0;
      break;
    case ',':
      return GDK_0;
      break;
    case '.':
      return GDK_0;
      break;
    case '/':
      return GDK_0;
      break;

    
  }

  return 0;

}







// set_row_color sets a given row of clist to r,g,b (0-255)
////////////////////////////////////////////////////////////
void set_row_color( GtkCList *list, int row, int r, int g, int b ) {
  GdkColor *color = new_color( r, g, b );

  gtk_clist_set_foreground( GTK_CLIST (list), row, color );
}

// new_color returns a GdkColor based on r,g,b (which range from 0-255)
////////////////////////////////////////////////////////////////////////
GdkColor *new_color( int r, int g, int b ) {
  GdkColor *color = new GdkColor;

  if( r < 0 || r > 255 )
    r = 255;
  if( g < 0 || g > 255 )
    g = 255;
  if( b < 0 || b > 255 )
    b = 255;

  color->red = (guint16) (((float) r/255) * 65535.0);
  color->green = (guint16) (((float) g/255) * 65535.0);
  color->blue = (guint16) (((float) b/255) * 65535.0);

  return( color );
}

// create_new_server adds a server to the folder list and returns 
// that server's subtree as a widget
//////////////////////////////////////////////////////////////////////////////
GtkCTreeNode *create_new_server( Server *the_server, GtkCTree *folder_list ) {
  string server_name = the_server->get_Server_Name();
  GtkCTreeNode *node;
  //GtkWidget *main_window = gAlthea.get_main_window();
  //GtkWidget *pixmap = create_pixmap( main_window, "server.xpm" );
  //GtkWidget *label;
  //GtkWidget *hbox;

  char *the_text[1]= {(char *)server_name.c_str()};
  node = gtk_ctree_insert_node(folder_list, NULL, NULL,
				     the_text,                   
				     20, // spacing between pixmap and string
				     NULL, // pixmap closed
				     NULL, // mask closed
				     NULL, // pixmap opened
				     NULL, // mask opened
				     FALSE, // not a leaf
				     FALSE); // not expanded

  gtk_ctree_node_set_row_data     (folder_list,
				   node,
				   the_server);



  //  new_server = GTK_WIDGET(node);
  //  gtk_signal_connect( GTK_OBJECT (new_server), "select",
  //                      GTK_SIGNAL_FUNC (select_server), the_server );
  //  gtk_widget_show( new_server );
  return( node );
}

// create_folder_in_server adds a folder to the server in the folder
// list and returns that folder as a widget
//////////////////////////////////////////////////////////////////////
GtkCTreeNode *create_folder_in_server( Folder *the_folder, GtkCTreeNode *server ) {

  string folder_name = the_folder->get_Folder_Name();
  GtkCTreeNode *node;
  char *the_text[1]= {(char *)folder_name.c_str()};
  
  node = gtk_ctree_insert_node(GTK_CTREE(gAlthea.get_folder_list()),GTK_CTREE_NODE(server), NULL,
			       the_text,                   
			       20, // spacing between pixmap and string
			       NULL, // pixmap closed
			       NULL, // mask closed
			       NULL, // pixmap opened
			       NULL, // mask opened
			       TRUE, // a leaf
			       FALSE); // not expanded

  gtk_ctree_node_set_row_data     (GTK_CTREE(gAlthea.get_folder_list()),
				   node,
				   the_folder);

  /*  new_folder=GTK_WIDGET(node);
      
      
      gtk_signal_connect( GTK_OBJECT (new_folder), "select",
      GTK_SIGNAL_FUNC (select_folder), the_folder );
      
  */
  
  
  /*

    // Ethan playing with drag and drop.... 
    GtkTargetEntry *folder_list_target;
    folder_list_target=new GtkTargetEntry;
    folder_list_target->target="folder_list";
    gtk_drag_dest_set( new_folder,
    GTK_DEST_DEFAULT_ALL,
    folder_list_target,
    1,
    GDK_ACTION_MOVE );
  */  
  //  gtk_widget_show( new_folder );
  
  
  return( node );
}

// extract_text gets the text from the_widget and puts it into
// the_string
////////////////////////////////////////////////////////////////
string *extract_text( GtkText *the_widget ) {
  guint length = gtk_text_get_length( GTK_TEXT (the_widget) );
  guint i;
  char temp[length+1];

  for( i = 0; i < length; i++ )
    temp[i] = GTK_TEXT_INDEX( the_widget, i );

  temp[i] = '\0';

  return( new string( temp ) );
}

// extract entry gets the text from the GtkEntry widget and
// puts it into the_string
/////////////////////////////////////////////////////////////
string *extract_entry( GtkEntry *the_widget ) {
  return( new string( (char *) gtk_entry_get_text(the_widget) ) );
}


// error takes a string and displays it in an error window
///////////////////////////////////////////////////////////
void error( string error_string ) {
  GtkWidget *error_window = create_error_window( error_string );

  gtk_widget_show( error_window );
}


// create_error_window makes a new error window
////////////////////////////////////////////////
GtkWidget* create_error_window ( string error_string ) {
  GtkWidget *error_window;
  GtkWidget *dialog_vbox1;
  GtkWidget *error_label;
  GtkWidget *dialog_action_area1;
  GtkWidget *error_button;

  error_window = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (error_window), "error_window", error_window);
  gtk_container_set_border_width (GTK_CONTAINER (error_window), 4);
  gtk_window_set_title (GTK_WINDOW (error_window), "Error");
  gtk_window_set_default_size (GTK_WINDOW (error_window), 300, 100);
  gtk_window_set_policy (GTK_WINDOW (error_window), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (error_window)->vbox;
  gtk_object_set_data (GTK_OBJECT (error_window), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  // Set the label to have the appropriate text
  error_label = gtk_label_new( error_string.c_str() );
  gtk_widget_ref (error_label);
  gtk_object_set_data_full (GTK_OBJECT (error_window), "error_label", error_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (error_label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), error_label, TRUE, FALSE, 0);

  dialog_action_area1 = GTK_DIALOG (error_window)->action_area;
  gtk_object_set_data (GTK_OBJECT (error_window), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  error_button = gtk_button_new_with_label ("Ok");
  gtk_widget_ref (error_button);
  gtk_object_set_data_full (GTK_OBJECT (error_window), "error_button", error_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (error_button);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), error_button, FALSE, TRUE, 0);

  gtk_signal_connect_object( GTK_OBJECT (error_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (error_window) );

  return error_window;
}



/* This is an internally used function to check if a pixmap file exists. */
static gchar* check_file_exists        (const gchar     *directory,
                                        const gchar     *filename);

/* This is an internally used function to create pixmaps. */
static GtkWidget* create_dummy_pixmap  (GtkWidget       *widget);

GtkWidget*
lookup_widget                          (GtkWidget       *widget,
                                        const gchar     *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is a dummy pixmap we use when a pixmap can't be found. */
static char *dummy_pixmap_xpm[] = {
/* columns rows colors chars-per-pixel */
"1 1 1 1",
"  c None",
/* pixels */
" "
};

/* This is an internally used function to create pixmaps. */
static GtkWidget*
create_dummy_pixmap                    (GtkWidget       *widget)
{
  GdkColormap *colormap;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmap;

  colormap = gtk_widget_get_colormap (widget);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, colormap, &mask,
                                                     NULL, dummy_pixmap_xpm);
  if (gdkpixmap == NULL)
    g_error ("Couldn't create replacement pixmap.");
  pixmap = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);
  return pixmap;
}

static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void
add_pixmap_directory                   (const gchar     *directory)
{
  pixmaps_directories = g_list_prepend (pixmaps_directories,
                                        g_strdup (directory));
}

/* This is an internally used function to create pixmaps. */
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        const gchar     *filename)
{
  gchar *found_filename = NULL;
  GdkColormap *colormap;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmap;
  GList *elem;

  /* We first try any pixmaps directories set by the application. */
  elem = pixmaps_directories;
  while (elem)
    {
      found_filename = check_file_exists ((gchar*)elem->data, filename);
      if (found_filename)
        break;
      elem = elem->next;
    }

  /* If we haven't found the pixmap, try the source directory. */
  if (!found_filename)
    {
      found_filename = check_file_exists ("../pixmaps", filename);
    }

  if (!found_filename)
    {
      g_warning ("Couldn't find pixmap file: %s", filename);
      return create_dummy_pixmap (widget);
    }

  colormap = gtk_widget_get_colormap (widget);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask,
                                                   NULL, found_filename);
  if (gdkpixmap == NULL)
    {
      g_warning ("Error loading pixmap file: %s", found_filename);
      g_free (found_filename);
      return create_dummy_pixmap (widget);
    }
  g_free (found_filename);
  pixmap = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);
  return pixmap;
}

/* This is an internally used function to check if a pixmap file exists. */
gchar*
check_file_exists                      (const gchar     *directory,
                                        const gchar     *filename)
{
  gchar *full_filename;
  struct stat s;
  gint status;

  full_filename = (gchar*) g_malloc (strlen (directory) + 1
                                     + strlen (filename) + 1);
  strcpy (full_filename, directory);
  strcat (full_filename, G_DIR_SEPARATOR_S);
  strcat (full_filename, filename);

  status = stat (full_filename, &s);
  if (status == 0 && S_ISREG (s.st_mode))
    return full_filename;
  g_free (full_filename);
  return NULL;
}

