#ifndef __MDMYSQLCONFIG_H
#define __MDMYSQLCONFIG_H 1

#ifdef __cplusplus
extern "C" {
#endif

#define MYSQL_DEFAULT_PORT 3306
#define MYSQL_DEFAULT_SOCKET "/var/lib/mysql/mysql.sock"

#define MYSQL_DEFAULT_UID_FIELD "uid"
#define MYSQL_DEFAULT_UIDNUMBER_FIELD "uidnumber"
#define MYSQL_DEFAULT_GIDNUMBER_FIELD "gidnumber"
#define MYSQL_DEFAULT_MAILDIR_FIELD "maildir"
#define MYSQL_DEFAULT_HOMEDIRECTORY_FIELD "homedir"
#define MYSQL_DEFAULT_QUOTA_FIELD "quota"
#define MYSQL_DEFAULT_STATUS_FIELD "vmailstatus"
#define MYSQL_DEFAULT_WHERE_CLAUSE ""
#define MYSQL_DEFAULT_TIMEOUT 5

typedef struct {
  char *hostname;
  unsigned short port;
  char *socket;
  char *database;
  char *dbuser;
  char *dbpw;
  char *dbtable;

  char *uid_field;
  char *uidnumber_field;
  char *gidnumber_field;
  char *homedir_field;
  char *maildir_field;
  char *quota_field;
  char *mailstatus_field;
  char *where_clause;

  int default_uidnumber;
  int default_gidnumber;

  int timeout;
} mdmysqlconfig;

mdmysqlconfig *get_mysql_config(char *configfile);

#ifdef __cplusplus
}
#endif

#endif
