#include <stdlib.h>
#include <sys/time.h>
#include <libpq-fe.h>


int main(int argc, char* argv[]) {

  /* ExecStatusType status; */

  char conninfo[256];
  char query[1024];
  long n;
  long it;
  struct timeval inicio,fin, intermedio;
  struct timezone tz;
  double segs_inicio,segs_fin,segundos,segs_inter;

  int i,j,ntuples,nfields;
  char *campo;

  PGconn *conn;
  PGresult *res;

  if (argc<3) {

    printf("Usage: pgtest niterations port [query]\n");
    return -1;

  }
  
  if (argc==4) {

    strcpy(query,argv[3]);

  } else {

    strcpy(query,"SELECT TB_ONE.FIELD1, TB_ONE.FIELD2, TB_TWO.FIELD1 FROM TB_ONE,TB_TWO WHERE TB_ONE.FIELD2=TB_TWO.FIELD2");
		   
  }

  sprintf(conninfo,"user=daniel password=daniel host=localhost dbname=dbbalancer port=%s",argv[2]); 
//  sprintf(conninfo,"dbname=dbbalancer host=localhost port=%s",argv[2]);


  n=atoi(argv[1]);
  it=1;

  printf("\n\n");

  printf("Iterations      : %ld \n",n);
  printf("Server Port     : %s \n",argv[2]);
  printf("Query           : %s \n",query);

  
  printf("\n\n");
  

  tz.tz_minuteswest = 0;
  tz.tz_dsttime = 0;

  gettimeofday(&inicio, &tz);
  segs_inicio = inicio.tv_sec + inicio.tv_usec / 1000000;

  while (it<=n) {

    gettimeofday(&intermedio,&tz);
    segs_inter = intermedio.tv_sec + intermedio.tv_usec / 1000000;
    
    printf("\r%s -> request %ld: %03.2f req/s",argv[2],it,(it/(segs_inter-segs_inicio)));
    fflush(stdout);

    conn = PQconnectdb(conninfo);

    if (PQstatus(conn)==CONNECTION_BAD) {

      printf("Problem with the connection: %s\n ",PQerrorMessage(conn));
      PQfinish(conn);
      return 1;

    }

    res = PQexec(conn,query);

    switch (PQresultStatus(res)) {

    case PGRES_TUPLES_OK: /* Its a SELECT, retrieve data */
      
      ntuples = PQntuples(res);
      nfields = PQnfields(res);

      for (i=0; i<ntuples; i++) 
	for (j=0; j<nfields; j++) 
	  campo = PQgetvalue(res,i,j);
      
      break;

    case PGRES_COMMAND_OK: /* Its a INSERT, UPDATE or DELETE */

      break;

    default:
      
      printf("\nError executing query (%s): %s\n",query,PQresultErrorMessage(res));
    }

    PQclear(res);

    it++;

    PQfinish(conn);

  }
  gettimeofday(&fin, &tz);

  segs_fin = fin.tv_sec + fin.tv_usec / 1000000;

  segundos = segs_fin - segs_inicio;

  printf("\n");
  printf("------------------------------------------\n");
  printf(" Executed %ld requests. \n",n);
  printf(" In %f seconds. \n",segundos);
  printf("------------------------------------------\n");
  printf(" Result: %f requests/second. \n\n",(n/segundos));

  return 0;

}
