/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * main.cc
 *   Test program for database support.
 *
 * $Id: main.cc,v 1.12 2000/12/29 02:13:54 rex Exp $
 *
 * Copyright (c) 1999, 2000 Remi Lefebvre <remi@dhis.net>
 * Copyright (c) 1999, 2000 Benoit Joly <benoit@dhis.net>
 * Copyright (c) 1999, 2000 Luca Filipozzi <lfilipoz@dhis.net>
 *
 * Licensed under the GPLv2
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <opt.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "Exception.h"
#include "Logger.h"
#include "DdtManager.h"

#include "DbPsql.h"
#include "DnsNull.h"


int main (int argc, char **argv)
{

    Logger *log = Logger::Instance();
    log->setIdent("ddtdb");
    log->openSyslog(LOG_USER, LOG_DEBUG);

    Db *db = NULL;
    Dns *dns = NULL;
    DdtManager *manager = NULL;
    
    /* TEST: open database, dns and manager */
    try
    {
        db = new DbPsql(log, "ddtdb", "remi", "pjqA53");
        dns = new DnsNull(log);
    
        manager = new DdtManager(log, db, dns);
    }
    catch (DdtException& e)
    {
        cout << "Error: " << e.message() << endl;
	exit (1);
    }
    catch (...)
    {
        cout << "Unknown error" << endl;
    }
    
    cout << "Opened database connection" << endl;
    getchar();
    
    // account data structure
    userAccount ac1, ac2, ac3, ac4;
    
    // fill in the account information
    strncpy(ac1.adminPassword, "d41d8cd98f00b204e9800998ecf8427e",
            sizeof(ac1.adminPassword));
    strncpy(ac1.updatePassword, "d41d8cd98f00b204e9800998ecf8427e",
            sizeof(ac1.updatePassword));
    strcpy(ac1.contactName, "Remi Lefebvre");
    strcpy(ac1.contactEmail, "remi@debian.org");
    strcpy(ac1.arch, "i686");
    strcpy(ac1.os, "Linux");
    strncpy(ac1.fqdn, "new.dhis.net", sizeof(ac1.fqdn));
    strncpy(ac1.ipAddress, "1.2.3.4", sizeof(ac1.ipAddress));

    ac2 = ac3 = ac4 = ac1;
        
    strncpy(ac2.fqdn, "new2.dhis.net", sizeof(ac2.fqdn));
    strncpy(ac3.fqdn, "new3.dhis.net", sizeof(ac3.fqdn));
    strncpy(ac4.fqdn, "new4.dhis.net", sizeof(ac4.fqdn));

        
    int a1 = -1, a2 = -1, a3 = -1, a4 = -1;

    /* TEST: add 3 accounts, remove one and add one (last one should get
     *       the uid ac2 had */
    try
    {
        a1 = manager->addUserAccount(&ac1);
        cout << "Added account a1" << endl;
        getchar();
        a2 = manager->addUserAccount(&ac2);
        cout << "Added account a2" << endl;
        getchar();
        a3 = manager->addUserAccount(&ac3);
        cout << "Added account a3" << endl;
        getchar();
        manager->delUserAccount(a2);
        cout << "Removed account a2" << endl;
        getchar();
        a4 = manager->addUserAccount(&ac4);
        cout << "Added account a4" << endl;
        getchar();
    }
    catch (DdtException &e)
    {
        cout << "Error: " << e.message() << endl;
    }
    catch (...)
    {
        cout << "Unknown error" << endl;
    }


    // TEST: put everybody offline, then put an ac1 online
    try
    {
        manager->markOffline(a1);
        manager->markOffline(a2);
        manager->markOffline(a3);
        manager->markOffline(a4);
        cout << "All accounts offline" << endl;
        getchar();

        manager->markOnline(a1, inet_addr("2.3.4.5"));
        cout << "a1 online" << endl;
        getchar();
    }
    catch (DbError &e)
    {
        cout << "Database Error: " << e.message() << endl;
    }
    catch (DdtException &e)
    {
        cout << "Error: " << e.message() << endl;
    }
    catch (...)
    {
        cout << "Unknown error" << endl;
    }


    // TEST: add and remove CNAMEs
    try
    {
        manager->addDnsRecord(a1, "cname.dhis.net", CNAME, "new.dhis.net");
        cout << "added cname" << endl;
        getchar();
        manager->delDnsRecord(a1, "cname.dhis.net", CNAME, "new.dhis.net");
        cout << "removed cname" << endl;
        getchar();
    }
    catch (DdtException &e)
    {
        cout << "Error: " << e.message() << endl;
    }
    catch (...)
    {
        cout << "Unknown error" << endl;
    }

    // TEST: remove remaining three accounts
    try
    {
        manager->delUserAccount(a1);
        cout << "Removed account a1" << endl;
        getchar();
        manager->delUserAccount(a3);
        cout << "Removed account a3" << endl;
        getchar();
        manager->delUserAccount(a4);
        cout << "Removed account a4" << endl;
        getchar();
    }
    catch (DdtException &e)
    {
        cout << "Error: " << e.message() << endl;
    }
    catch (...)
    {
        cout << "Unknown error" << endl;
    }







    // clean up
    if (manager) delete manager;
    if (db) delete db;
    if (dns) delete dns;
    if (log) delete log;


/*
    char *host = argv[1];
    FQDN fqdn(domainName, cfgFileName);

    if (fqdn.validate(host) == -1)
    {
        cout << "hostname invalid: " << host << endl;
        if (ddtdb->delUserAccount(accountId) == -1)
        {
            log->debug("ddtdb::delUserAccount() failed");
            return 1;
        }
        return 0;
    }
*/

/*    
    if (ddtdb->addCNAMERecord(accountId, "www.dhis.net", host) == -1)
    {
        log->debug("ddtdb::addCNAMERecord() failed");
        return 1;
    }

    if (ddtdb->delCNAMERecord(accountId, "www.dhis.net") == -1)
    {
        log->debug("ddtdb::addCNAMERecord() failed");
        return 1;
    }


    if (ddtdb->pruneActiveAccount(func) == -1)
    {
        log->debug("ddtdb::pruneActiveAccount() failed");
        return 1;
    }

    cout << "TEST: for each active account" << endl;
    cout << "press [ENTER]" << endl;
    cout << endl;
    getchar();

    if (ddtdb->markOffline(accountId) == -1)
    {
        log->debug("ddtdb::markOffline() failed");
        return 1;
    }

    cout << "TEST: marked A record offline" << endl;
    cout << "press [ENTER]" << endl;
    cout << endl;
    getchar();

    if (ddtdb->delUserAccount(accountId) == -1)
    {
        log->debug("ddtdb::delUserAccount() failed");
        return 1;
    }

*/
    return 0;
}
