/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * $Id: DdtCipher.cc,v 1.1 2001/11/24 21:26:16 benoit Exp $
 *
 * Copyright (c) 2001 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */
#include "DdtCipher.h"
#include "string.h"

DdtCipher::DdtCipher(CipherAlgos algo, CipherModes mode)
{
    this->algo = algo;
    this->mode = mode;
  
    if(algo == ALGO_ROT13)
    {
        cipherHandle = NULL;
    }
    else
    {
        // create a cipher handle
        cipherHandle = gcry_cipher_open((gcry_cipher_algos)algo, (gcry_cipher_modes)mode, 0);  
        if(cipherHandle == NULL)
        {
            //logger->notice("cipherHandler is null");
        }
    }

}

DdtCipher::~DdtCipher()
{
    // close the cipherHandle
    gcry_cipher_close(cipherHandle);
}

void DdtCipher::setKey(unsigned char *key, int size)
{
    int result = gcry_cipher_ctl(cipherHandle, GCRYCTL_SET_KEY, key, size);
}

void DdtCipher::setIV(unsigned char *iv, int size)
{
    int result = gcry_cipher_ctl(cipherHandle, GCRYCTL_SET_IV, iv, size);
}

void DdtCipher::decrypt(unsigned char* inputBuf, int inputLength, unsigned char* outputBuf, int outputLength)
{
    
    int result = gcry_cipher_decrypt(cipherHandle, outputBuf, outputLength, inputBuf, inputLength);
}

void DdtCipher::encrypt(unsigned char* inputBuf, int inputLength, unsigned char* outputBuf, int outputLength)
{
    if(algo == ALGO_ROT13)
    {
        strRot13(inputBuf, inputLength, outputBuf, outputLength);
    }
    else
    {
        int result = gcry_cipher_encrypt(cipherHandle, outputBuf, outputLength, inputBuf, inputLength);
    }
}


#define N    26

/* Warning: this code assumes ASCII */
void DdtCipher::strRot13(unsigned char* inputBuf, int inputLength, unsigned char* outputBuf, int outputLength)
{
    strncpy((char*)outputBuf, (char*)inputBuf, outputLength);

    /* Strrot13 implementation cut/pasted from publib */
    char *s = (char*)outputBuf;

    while (*s != '\0')
    {
        if ((*s >= 'a' && *s <= 'm') || (*s >= 'A' && *s <= 'M'))
        {
            *s += 13;
        }
        else if ((*s >= 'n' && *s <= 'z') || (*s >= 'N' && *s <= 'Z'))
        {
            *s -= 13;
        }
        ++s;
    }
}
