/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * main.cc
 *   Test program for the DdtDB and all inherited classes.
 *
 * $Id: mkacct.cc,v 1.9 2001/11/24 21:11:50 benoit Exp $
 *
 * Copyright (c) 1999 Remi Lefebvre <remi@dhis.net>
 *                and Benoit Joly <benoit@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * Licensed under the GPLv2
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <opt.h>

#include "global.h"
#include "Logger.h"
#include "DbPsql.h"
#include "Packet.h"
#include "DdtMD.h"

int main (int argc, char **argv)
{
    optDefaultFile("main.opt");

    opt(&argc, &argv);

    Logger* log = Logger::Instance();
    log->setIdent(argv[0]);
    log->openSyslog(LOG_USER, LOG_DEBUG); 

    // login information for the database
    // will come from a config file or the command line
    const char dbname[] = "ddtdb";
    const char dbuser[] = "remi";
    const char dbpass[] = "pjqA53";

    // open the database
    Db* ddtdb = new DbPsql(log, dbname, dbuser, dbpass);
    
    // account data structure
    userAccount account;

    int md5Length = DdtMD::getAlgoDigestLength(DdtMD::MD_MD5);

    // fill in the account information
    char updatePassword[] = "wow12345";
    char adminPassword[]  = "wow67890";
    unsigned char digest[md5Length];

    DdtMD::digest(DdtMD::MD_MD5, (unsigned char*)updatePassword, strlen(updatePassword), digest, md5Length);
            
    for (int i = 0; i < md5Length; i++)
    {
        sprintf(&(account.updatePassword[i*2]), "%02x", digest[i]);
    }

    DdtMD::digest(DdtMD::MD_MD5, (unsigned char*)adminPassword, strlen(adminPassword), digest, md5Length);
            
    for (int i = 0; i < md5Length; i++)
    {
        sprintf(&(account.adminPassword[i*2]), "%02x", digest[i]);
    }

    strcpy (account.contactName, "Remi Lefebvre");
    strcpy (account.contactEmail, "remi@debian.org");
    strcpy (account.arch, "i686");
    strcpy (account.os, "Linux");
    strcpy (account.fqdn, "remi.dhis.net");
    strcpy (account.ipAddress, "169.254.0.0");
    account.hostStatus = OFFLINE;
    
    // add the account to the database, mark the host online, mark
    // the host offline and delete the account from the database
    printf("creating a user account\n");
    int accountId;
    if ((accountId = ddtdb->addUserAccount(&account)) == -1)
    {
        printf("ddtdb::addUserAccount() failed\n");
        exit(1);
    }

    return 0;
}
