#ifndef __htmlstreamh__
  #include "../htmlstream.h"
#endif

#ifndef __htmlh__
  #include "../html.h"
#endif

#ifndef __stringproch__
  #include "../stringproc.h"
#endif

#ifndef __pluginh__
  #include "../plugin.h"
#endif

#include <string>
#include <vector>
#include <cstdio>

class dsoEnglishMod :public Plugin{
public:
  dsoEnglishMod();
  virtual void Init();
private:
  static void DAYNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYSHORTNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHSHORTNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYABBREV(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHABBREV(const HTML& Cur,string& data,const vector<string>& params);
  static void ORDINAL(const HTML& Cur,string& data,const vector<string>& params);
};

static dsoEnglishMod initmodule;

static const string daynames[]={"Sunday","Monday","Tuesday","Wednesday",
  "Thursday","Friday","Saturday"};
static const string monthnames[]={"January","February","March","April","May",
  "June","July","August","September","October","November","December"};
static const string dayshortnames[]={"Sun","Mon","Tue","Wed","Thu","Fri",
  "Sat"};
static const string monthshortnames[]={"Jan","Feb","Mar","Apr","May","Jun",
  "Jul","Aug","Sep","Oct","Nov","Dec"};
static const string dayabbrevs[]={"Su","M","Tu","W","Th","F","Sa"};
static const string monthabbrevs[]={"Jan","Feb","Mar","Apr","May","Jun",
  "Jul","Aug","Sep","Oct","Nov","Dec"};

dsoEnglishMod::dsoEnglishMod() {
  RegisterPlugin(string("english"),1);
}

void dsoEnglishMod::Init(){
  SetNamespace("ENGLISH");
  RegisterFunction("DAYNAME",&dsoEnglishMod::DAYNAME);
  RegisterFunction("MONTHNAME",&dsoEnglishMod::MONTHNAME);
  RegisterFunction("DAYSHORTNAME",&dsoEnglishMod::DAYSHORTNAME);
  RegisterFunction("MONTHSHORTNAME",&dsoEnglishMod::MONTHSHORTNAME);
  RegisterFunction("DAYABBREV",&dsoEnglishMod::DAYABBREV);
  RegisterFunction("MONTHABBREV",&dsoEnglishMod::MONTHABBREV);
  RegisterFunction("ORDINAL",&dsoEnglishMod::ORDINAL);
}

void dsoEnglishMod::DAYNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYNAME",e_ParamNone);
  data=daynames[atoi(data.c_str())%7];
}

void dsoEnglishMod::MONTHNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"MONTHNAME",e_ParamNone);
  data=monthnames[(atoi(data.c_str())-1)%12];
}

void dsoEnglishMod::DAYSHORTNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYSHORTNAME",e_ParamNone);
  data=dayshortnames[atoi(data.c_str())%7];
}

void dsoEnglishMod::MONTHSHORTNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYABBREV",e_ParamNone);
  data=monthshortnames[(atoi(data.c_str())-1)%12];
}

void dsoEnglishMod::DAYABBREV(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=dayabbrevs[atoi(data.c_str())%7];
}

void dsoEnglishMod::MONTHABBREV(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=monthabbrevs[(atoi(data.c_str())-1)%12];
}

void dsoEnglishMod::ORDINAL(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  int num=atoi(data.c_str())%10;
  data="th";
  switch(num){
  case 1: data="st"; break;
  case 2: data="nd"; break;
  case 3: data="rd"; break;
  }
}
