=begin
= SSL

== SSL::SSLSocket

SSL::SSLSoclet is a class for crypto communication via SSL/TLS protocol.

==== Superclass

* Object

=== Included Module

* ((<Buffering>))

=== Class Methods

: new(io, cert_file=nil, key_file=nil)
    Creates an instance of SSL::SSLSocket.
    IO object must be specified for io, cert_file is a path of the
    X.509 certificate and key_file is a path of the private key.
    Hopefully both files are in PEM format.
    Key_file is not required if the certificate file bundles private key.

      sock = TCPSocket.new(hostname, port)
      ssl = SSL::SSLSocket.new(sock)
      ssl.connect
      ssl.print("GET / HTTP/1.0" + CRLF + CRLF)
      print ssl.read
      ssl.close
      sock.close

=== Instance Methods

: to_io
: io
    Retuen IO object which given in SSLSocket#new.

: cert_file = path
    Sets a path of the X.509 certificate file.

: cert_file
    Retuens a path set by cert_file=.

: key_file = path
    Sets a path of the private key file.

: key_file
    Retuens a path set by key_file=.

: verify_callback = proc
    Set Proc object. It is invoked when SSLSocket#connect or SSLSocket#accept
    is invoked in order to verify X.509 certificate presented from peer.
    Proc#call is invoked with two arguments: verification
    result of current certificate and a ((<SSL::X509_STORE_CTX>))
    object. 

    The callback routine of s_server of OpenSSL can be ported like this.

      verify_cb = Proc.new{ |ok, x509_store_ctx|
        x509 = x509_store_ctx.current_cert
        unless ok
          $stderr.print x509_store_ctx.error_message, "\n"
          if x509_store_ctx.error_depth >= YourSpecifiedDepth
            ok = true
          end 
        end
        case x509_store_ctx.error
        when SSL::X509::UNABLE_TO_GET_ISSUER_CERT
          $stderr.print "issuer=#{x509.issuer}\n"
        when SSL::X509::CERT_NOT_YET_VALID,
             SSL::X509::ERROR_IN_CERT_NOT_BEFORE_FIELD
          $stderr.print bio_err,"notBefore=#{x509.notBefore}\n"
        when SSL::X509::CERT_HAS_EXPIRED,
             SSL::X509::ERROR_IN_CERT_NOT_AFTER_FIELD
          $stderr.print(bio_err,"notAfter=#{x509.notAfter}\n"
        end
        return(ok);
      }
      SSL::SSLSocket.new(s, key, cert)
      s.verify_mode = SSL::VERIFY_PEER|SSL::VERIFY_FAIL_IF_NO_PEER_CERT
      ssl.verify_callback = verify_cb

: verify_callback
    Returns Proc object specified by verify_callback=.

: verify_mode = val
    Sets the verification mode flags: 

      * SSL::VERIFY_NONE

    or combination of follow bit flags.

      * SSL::VERIFY_PEER
      * SSL::VERIFY_FAIL_IF_NO_PEER_CERT
      * SSL::VERIFY_CLIENT_ONCE

    See SSL_CTX_set_verify(3) for more details.

: verify_mode
    Returns flags specified by verify_mode=.

: verify_depth = val
    Sets the maximum depth for the certification chain.

: verify_depth
    Returns the depth specified by verify_depth=.

: ca_file = path
    Sets the path of CA certification file in PEM format.
    The file can be included number of certifications.
    The file can be created by:

      $ cd /your/ca/certs/dir
      $ rm CAfile.pem
      $ for i in *.pem; do
      >   openssl x509 -in $i -text >> CAfile.pem
      > done

: ca_file
    Returns the path of CA certification specified by ca_file=.

: ca_path = path
    Sets the path of firectory which contains number of the CA
    certification files in PEM format. The directory must contains
    the symbolic links named hash value of the suject of the CA
    certifications. You can set up the directory by c_rehash utility
    bundled in OpenSSL package.

      $ cd /your/ca/certs/dir
      $ c_rehash .

: ca_path
    Returns the path of directory specified by ca_file=.

: cert
    Returns an ((<SSL::X509>)) object created from X.509 cetification
    used in current sssion.

: peer_cert
    Returns an ((<SSL::X509>)) object created from X.509 cetification
    sent from peer.

: ciphers = cipher_names
    Sets a list of the cipher names allow to use in SSL session.
    It is a colon separated form of String or an Array.

: ciphers
    Returns cipher information specified by ciphers=.

: cipher
    Returns the information of encryption algorythm of current session.
    It is an Array object including follows:
      * algorythm name
      * TLS/SSL version
      * effective number of bits in encryption
      * number of bits the algorytm supports

: state
    Returns the status of the session. This value is enabled after
    the session is initiated. If $VERBOSE is set it returns long format
    message.
    
: connect
    Start a SSL session as client.

: accept
    Start a SSL session as server.

: sysclose
    Shutdown the SSL session.
    IO object passed by SSLSocket.new will not be closed yet.

: syswrite(str)
    Similar to Socket#syswrite.
    If no SSL session was initiated, it will write from IO directly.

: sysread(str)
    Similar to Socket#sysread.
    It may return string have length not enough to ((|size|)).
    If no SSL session was initiated, it will read from IO directly.

== SSL::X509

SSL::X509 is a class for browsing information in X.509 certificates.

=== Superclass

* Object

=== Class Methods

: new(path)
    Creates an instance of SSL::X509.
    Path is a pathname of the certificate file in PEM format.

=== Instance Methods

: version
    Returns the version of the certificate. 
    Notice that version number in certificates is start by 0
    (0 indicates version 1).

: serialNumber
    Returns the serianl number of the certificate.

: sigAlgor
    Returns the name of signature algorithm of the signature.

: issuer
    Returns the issuer informatiosn of the certificate.

: notBefore
: notAfter
    Returns the validity of the certificate as string.
    ParseDate module can be used for parsing this string.

: subject
    Returns the subject informatiosn of the certificate.

: key_type
    Return string which indicates the type of public key.

: extension
    Returns the cetificate extension part as Array.
    Each elements contains:

     * object identifier
     * value

: to_s
    Returns X.509 certificate in PEM format.

: verify(cacert)
    Verifies certificate using the private key in cacert.
    An ((<SSL::X509>)) object or a path for the CA certificate
    in PRM format is assumed for cacert.

== SSL::X509_STORE_CTX

It wraps X509_STORE_CTX structure of C language. An instance of this class
is passed as 2nd argument of Proc which set by SSLSocket#verify_callback=.

=== Superclass

* Object

=== Instance Methods

: error
    Returns error code. Available error codes are follows.

    * SSL::X509::UNABLE_TO_GET_ISSUER_CERT
    * SSL::X509::UNABLE_TO_GET_CRL
    * SSL::X509::UNABLE_TO_DECRYPT_CERT_SIGNATURE
    * SSL::X509::UNABLE_TO_DECRYPT_CRL_SIGNATURE
    * SSL::X509::UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY
    * SSL::X509::CERT_SIGNATURE_FAILURE
    * SSL::X509::CRL_SIGNATURE_FAILURE
    * SSL::X509::CERT_NOT_YET_VALID
    * SSL::X509::CERT_HAS_EXPIRED
    * SSL::X509::CRL_NOT_YET_VALID
    * SSL::X509::CRL_HAS_EXPIRED
    * SSL::X509::ERROR_IN_CERT_NOT_BEFORE_FIELD
    * SSL::X509::ERROR_IN_CERT_NOT_AFTER_FIELD
    * SSL::X509::ERROR_IN_CRL_LAST_UPDATE_FIELD
    * SSL::X509::ERROR_IN_CRL_NEXT_UPDATE_FIELD
    * SSL::X509::OUT_OF_MEM
    * SSL::X509::DEPTH_ZERO_SELF_SIGNED_CERT
    * SSL::X509::SELF_SIGNED_CERT_IN_CHAIN
    * SSL::X509::UNABLE_TO_GET_ISSUER_CERT_LOCALLY
    * SSL::X509::UNABLE_TO_VERIFY_LEAF_SIGNATURE
    * SSL::X509::CERT_CHAIN_TOO_LONG
    * SSL::X509::CERT_REVOKED
    * SSL::X509::INVALID_CA
    * SSL::X509::PATH_LENGTH_EXCEEDED
    * SSL::X509::INVALID_PURPOSE
    * SSL::X509::CERT_UNTRUSTED
    * SSL::X509::CERT_REJECTED
    * SSL::X509::SUBJECT_ISSUER_MISMATCH
    * SSL::X509::AKID_SKID_MISMATCH
    * SSL::X509::AKID_ISSUER_SERIAL_MISMATCH
    * SSL::X509::KEYUSAGE_NO_CERTSIGN
    * SSL::X509::APPLICATION_VERIFICATION

: error_message
    Retuens a error message affiliated with X509_STORE_CTX#error.

: current_cert
    Returns X.509 certificate in the current verification process.

: error_depth
    Returns the depth of the current certificate chain.

= Buffering

Buffering is a mix-in module supplying methods like IO's.
It requires sysread() and syswrite() for fixed length I/O.
Sysread() is expected to raise EOFError at the end of input stream.
In order to flush write-buffer when close() is invoked, it calls 
sysclose() of base class.

Currently, this module have follow methods.

: read(size=nil)
: gets(eol=$/)
: getc
: ungetc(c)
: eof?
: each
: readlines
: write(s)
: puts(*args)
: print(*args)
: printf(s, *args)
: flush
: close

=end
