// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef   __decoder_mp3_h
#define   __decoder_mp3_h

class DecoderMP3;

#include "decoder.h"
#include "eqpreset.h"

#include <config.h>
#include <mhead.h>
#include <port.h>


#define FRAMES_FLAG     0x0001
#define BYTES_FLAG      0x0002
#define TOC_FLAG        0x0004
#define VBR_SCALE_FLAG  0x0008
#define FRAMES_AND_BYTES (FRAMES_FLAG | BYTES_FLAG)

typedef struct
{
    int h_id;       // from MPEG header, 0=MPEG2, 1=MPEG1
    int samprate;   // determined from MPEG header
    int flags;      // from Xing header data
    int frames;     // total bit stream frames from Xing header data
    int bytes;      // total bit stream bytes from Xing header data
    int vbr_scale;  // encoded vbr scale from Xing header data
    unsigned char *toc;  // pointer to unsigned char toc_buffer[100]
                         // may be NULL if toc not desired
} XHEADDATA;


class DecoderMP3 : public Decoder
{
public:
    DecoderMP3(DecoderFactory *, QIODevice *, Output *);
    virtual ~DecoderMP3();

    // standard decoder API
    bool initialize();
    double lengthInSeconds();
    void seek(double);
    void stop();

    // Equalizer
    bool isEQSupported() const { return TRUE; }
    void setEQEnabled(bool);
    void setEQ(const EqPreset &);

    static const int maxDecodeRetries;
    static const int maxFrameSize;
    static const int maxFrameCheck;
    static const int initialFrameSize;


private:
    // thread run function
    void run();

    // helper functions
    bool findHeader();
    bool findXingHeader();
    bool nextFrame();
    void fill();
    void flush(bool = FALSE);
    void deinit();
    void calcLength();
    long seekPoint(long, long);

    bool done, finish, almost_done, inited, user_stop, derror;
    int stat;
    int bks;
    long output_size;
    double seekTime, totalTime, msPerFrame;

    // file input buffer
    unsigned char *input_buf;
    long input_bytes, input_at, input_trigger;

    // output buffer
    unsigned char *output_buf;
    long output_bytes, output_at;

    // XingMP3 Decoder
    MPEG mpeg;
    MPEG_HEAD head;
    IN_OUT x;
    DEC_INFO decinfo;
    long fb;
    int br, vr, ly, bad_syncs;

    // Xing VBR header
    XHEADDATA *xingheader;
};


#endif // __decoder_mp3_h
