// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef __icons_h
#define __icons_h

#include <qiconset.h>
#include <qstringlist.h>
#include <qstring.h>


class IconLoader
{
public:
    static void addPath(const QString &);
    static void addPaths(const QStringList &);
    static void removePath(const QString &);
    static void clearPaths();
    static QStringList paths(bool = TRUE);

    static const QString &theme();
    static void setTheme(const QString &);
    static QStringList themes();

    static QIconSet load(const QString &);

    static void cleanup();
};


#endif // __icons_h
