/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _tools_h_
#define _tools_h_

#include <time.h>
#include <stdlib.h>
#include <stdarg.h>

#include "dllist.h"

typedef unsigned char bool_t;

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef MAX
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#endif

#ifndef MIN 
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif

#define NUM_ELEM(x)	((unsigned int) (sizeof(x) / sizeof(x[0])))

#define _free(ptr) if (ptr) {free(ptr); ptr = NULL;}

extern char *tl_strdup(char *);
extern char *tl_strndup(char *, int);
extern char **tl_str_split(char *, char *);
extern dllist *tl_numlist_split(char *, char *);
extern void tl_strv_free(char **);
extern int tl_strv_length(char **);
extern char *tl_str_append(char *, char *);
extern char *tl_str_nappend(char *, char *, int);
extern char *tl_str_concat(char *, ...);
extern char *tl_data_concat_data(int *, char *, int, char *);
extern char *tl_data_concat_str(int *, char *, ...);

extern void tl_msleep(unsigned int);
extern void tl_sleep(unsigned int);

extern char *tl_adjust_filename(char *);
extern int tl_filename_needs_adjust(char *);
extern int tl_is_dirname(char *);
extern char *tl_get_extension(char *);
extern char *tl_get_basename(char *);

extern int tl_flock(int *, char * , int , int);

extern int tl_mkstemp(char *);

extern char *tl_load_text_file(char *);
extern int tl_save_text_file(char *, char *, int);

extern void strip_nl(char *);
extern void omit_chars(char *, char *);
extern char *upperstr(char *);
extern char *lowerstr(char *);
extern int makealldirs(char *);
extern char *get_abs_file_path(char *);
extern char *get_abs_file_path_oss(char *);
extern char *get_relative_path(char *,char *);
extern bool_t is_in_list(char *, char **);
extern bool_t is_in_dllist(char *, dllist *);
extern bool_t is_in_pattern_list(char *, char **);
extern bool_t is_in_pattern_dllist(char *, dllist *);
extern char *get_1qstr(char *);
extern char *strtokc(char *, int);
extern char *strfindnchr(char *, int, int);
extern void *_malloc(int);
extern void *_realloc(void *, int);
extern int  get_line(char *, int, int);
extern bool_t file_is_html(char *);
extern bool_t ext_is_html(char *);
extern long int _atoi(char *);
extern double _atof(char *);
extern char * _strtrchr(char *, int, int);
extern void xprintf(int, char *, ...);
extern void xvaprintf(int, char *, va_list *);
extern void xdebug(int, char * , ...);
extern void xvadebug(int, char *, va_list *);
extern void xperror(char *);
extern void xherror(char *);
extern int unlink_recursive(char *);
extern unsigned int hash_func(char *, int);
extern int str_is_in_list(int, char *, ...);
extern int copy_fd_to_file(int, char *);
extern char *escape_str(char *, char *);

#ifdef __CYGWIN__
extern char *cvt_win32_to_unix_path(char *);
extern char *cvt_unix_to_win32_path(char *);
extern int tl_win32_system(char *);
#define tl_system(cmd)	tl_win32_system(cmd)
#else
#define tl_system(cmd)	system(cmd)
#endif

#ifdef NO_SETENV
extern int tl_setenv(char *, char *, int);
#define setenv		tl_setenv
#define unsetenv(var)	tl_setenv(var, "", 1)
#endif

#ifdef HAVE_FLOCK
#include <sys/file.h>
#define _flock(fd, fname, opt, blk)	tl_flock(&fd, fname, opt, blk)
#define _funlock(fd)			flock(fd, LOCK_UN)
#else
#ifdef HAVE_FCNTL_LOCK
extern int tl_funlock(int);
#define _flock(fd, fname, opt, blk)	tl_flock(&fd, fname, opt, blk)
#define _funlock(fd) 			tl_funlock(fd)
#else
#define _flock(fd, fname, opt, blk)	0
#define _funlock(fd)			0
#endif
#endif

#define new_string	tl_strdup
#define new_n_string	tl_strndup

#endif
