.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE FUNCTION" "l" "2002-01-30" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE FUNCTION \- define a new function
.SH SYNOPSIS
.sp
.nf
CREATE [ OR REPLACE ] FUNCTION \fIname\fR ( [ \fIargtype\fR [, ...] ] )
    RETURNS \fIrettype\fR
    AS '\fIdefinition\fR'
    LANGUAGE \fIlangname\fR
    [ WITH ( \fIattribute\fR [, ...] ) ]
CREATE [ OR REPLACE ] FUNCTION \fIname\fR ( [ \fIargtype\fR [, ...] ] )
    RETURNS \fIrettype\fR
    AS '\fIobj_file\fR', '\fIlink_symbol\fR'
    LANGUAGE \fIlangname\fR
    [ WITH ( \fIattribute\fR [, ...] ) ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE FUNCTION\fR defines a new function.
\fBCREATE OR REPLACE FUNCTION\fR will either create
a new function, or replace an existing definition.
"PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of a function to create. The name need not be unique,
because functions may be overloaded, but functions with the
same name must have different argument types.
.TP
\fB\fIargtype\fB\fR
The data type(s) of the function's arguments, if any. The
input types may be base or complex types,
opaque, or the same as the type of an
existing column. Opaque indicates
that the function accepts arguments of a non-SQL type such as
\fBchar *\fR.
The type of a column is indicated using \fItablename\fR.\fIcolumnname\fR%TYPE;
using this can sometimes help make a function independent from
changes to the definition of a table.
.TP
\fB\fIrettype\fB\fR
The return data type. The output type may be specified as a
base type, complex type, setof type,
opaque, or the same as the type of an
existing column.
The setof
modifier indicates that the function will return a set of
items, rather than a single item. Functions with a declared
return type of opaque do not return a value.
These cannot be called directly; trigger functions make use of
this feature.
.TP
\fB\fIdefinition\fB\fR
A string defining the function; the meaning depends on the
language. It may be an internal function name, the path to an
object file, an SQL query, or text in a procedural language.
.TP
\fB\fIobj_file\fB, \fIlink_symbol\fB\fR
This form of the AS clause is used for
dynamically linked C language functions when the function name
in the C language source code is not the same as the name of
the SQL function. The string \fIobj_file\fR is the name of the
file containing the dynamically loadable object, and
\fIlink_symbol\fR is the
object's link symbol, that is, the name of the function in the C
language source code.
.TP
\fB\fIlangname\fB\fR
May be SQL, C,
internal, or \fIplname\fR, where \fIplname\fR is the name of a
created procedural language. See
CREATE LANGUAGE [\fBcreate_language\fR(l)]
for details. For backward compatibility, the name may be
enclosed by single quotes.
.TP
\fB\fIattribute\fB\fR
An optional piece of information about the function, used for
optimization. See below for details.
.PP
.PP
The user that creates the function becomes the owner of the function.
.PP
The following attributes may appear in the WITH clause:
.TP
\fBiscachable\fR
\fBIscachable\fR indicates that the function always
returns the same result when given the same argument values (i.e.,
it does not do database lookups or otherwise use information not
directly present in its parameter list). The optimizer uses
\fBiscachable\fR to know whether it is safe to
pre-evaluate a call of the function.
.TP
\fBisstrict\fR
\fBisstrict\fR indicates that the function always
returns NULL whenever any of its arguments are NULL. If this
attribute is specified, the function is not executed when there
are NULL arguments; instead a NULL result is assumed automatically.
When \fBisstrict\fR is not specified, the function will
be called for NULL inputs. It is then the function author's
responsibility to check for NULLs if necessary and respond
appropriately.
.PP
.SH "NOTES"
.PP
Refer to the chapter in the
\fIPostgreSQL Programmer's Guide\fR
on the topic of extending
PostgreSQL via functions 
for further information on writing external functions.
.PP
The full SQL type syntax is allowed for
input arguments and return value. However, some details of the
type specification (e.g., the precision field for
\fBnumeric\fR types) are the responsibility of the
underlying function implementation and are silently swallowed
(i.e., not recognized or
enforced) by the \fBCREATE FUNCTION\fR command.
.PP
PostgreSQL allows function \fIoverloading\fR;
that is, the same name can be used for several different functions
so long as they have distinct argument types. This facility must
be used with caution for internal and C-language functions, however. 
.PP
Two internal
functions cannot have the same C name without causing
errors at link time. To get around that, give them different C names
(for example, use the argument types as part of the C names), then
specify those names in the AS clause of \fBCREATE FUNCTION\fR.
If the AS clause is left empty, then \fBCREATE FUNCTION\fR
assumes the C name of the function is the same as the SQL name.
.PP
Similarly, when overloading SQL function names with multiple C-language
functions, give
each C-language instance of the function a distinct name, then use
the alternative form of the \fBAS\fR clause in the
\fBCREATE FUNCTION\fR syntax to select the appropriate
C-language implementation of each overloaded SQL function.
.PP
When repeated \fBCREATE FUNCTION\fR calls refer to
the same object file, the file is only loaded once. To unload and
reload the file (perhaps during development), use the LOAD [\fBload\fR(l)] command.
.PP
Use \fBDROP FUNCTION\fR
to remove user-defined functions.
.PP
To update the definition of an existing function, use
\fBCREATE OR REPLACE FUNCTION\fR. Note that it is
not possible to change the name or argument types of a function
this way (if you tried, you'd just be creating a new, distinct
function). Also, \fBCREATE OR REPLACE FUNCTION\fR
will not let you change the return type of an existing function.
To do that, you must drop and re-create the function.
.PP
If you drop and then re-create a function, the new function is not
the same entity as the old; you will break existing rules, views,
triggers, etc that referred to the old function. Use 
\fBCREATE OR REPLACE FUNCTION\fR to change a function
definition without breaking objects that refer to the function.
.SH "EXAMPLES"
.PP
To create a simple SQL function:
.sp
.nf
CREATE FUNCTION one() RETURNS integer
    AS 'SELECT 1 AS RESULT;'
    LANGUAGE SQL;

SELECT one() AS answer;
 answer 
--------
      1
.sp
.fi
.PP
The next example creates a C function by calling a routine from a
user-created shared library named \fIfuncs.so\fR (the extension
may vary across platforms). The shared library file is sought in the
server's dynamic library search path. This particular routine calculates
a check digit and returns TRUE if the check digit in the function
parameters is correct. It is intended for use in a CHECK
constraint.
.sp
.nf
CREATE FUNCTION ean_checkdigit(char, char) RETURNS boolean
    AS 'funcs' LANGUAGE C;
    
CREATE TABLE product (
    id        char(8) PRIMARY KEY,
    eanprefix char(8) CHECK (eanprefix ~ '[0-9]{2}-[0-9]{5}')
                      REFERENCES brandname(ean_prefix),
    eancode   char(6) CHECK (eancode ~ '[0-9]{6}'),
    CONSTRAINT ean    CHECK (ean_checkdigit(eanprefix, eancode))
);
.sp
.fi
.PP
This example creates a function that does type conversion between the
user-defined type complex, and the internal type point. The
function is implemented by a dynamically loaded object that was
compiled from C source (we illustrate the now-deprecated alternative
of specifying the exact pathname to the shared object file).
For PostgreSQL to
find a type conversion function automatically, the SQL function has
to have the same name as the return type, and so overloading is
unavoidable. The function name is overloaded by using the second
form of the \fBAS\fR clause in the SQL definition:
.sp
.nf
CREATE FUNCTION point(complex) RETURNS point
    AS '/home/bernie/pgsql/lib/complex.so', 'complex_to_point'
    LANGUAGE C;
.sp
.fi
The C declaration of the function could be:
.sp
.nf
Point * complex_to_point (Complex *z)
{
	Point *p;

	p = (Point *) palloc(sizeof(Point));
	p->x = z->x;
	p->y = z->y;
		
	return p;
}
.sp
.fi
.SH "COMPATIBILITY"
.PP
A \fBCREATE FUNCTION\fR command is defined in SQL99.
The \fBPostgreSQL\fR version is similar but
not compatible. The attributes are not portable, neither are the
different available languages.
.SH "SEE ALSO"
.PP
\fBdrop_function\fR(l),
\fBload\fR(l),
\fIPostgreSQL Programmer's Guide\fR
