#!/usr/bin/env python
#ident "@(#) $Id: setup.py,v 1.13 2001/11/04 05:56:21 ballie01 Exp $"
#-----------------------------------------------------------------------+
# Name:		setup.py						|
#									|
# Synopsys:	python setup.py build	# Build the module.		|
#		python setup.py install	# Install the module.		|
#									|
#		See http://www.python.org/sigs/distutils-sig/doc/ for	|
#		more information on using distutils to install Python	|
#		programs and modules.					|
#									|
# Description:	Setup script (using the distutils framework) for	|
#		pyPgsql Version 2.0.					|
#									|
# Note:		This script requires the distutils package (standard in	|
#		Python 1.6 or later).  For earlier versions of Python,	|
#		you can download distutils from:			|
#		 http://www.python.org/sigs/distutils-sig/download.html |
#=======================================================================|
# Copyright 2001 by Gerhard Haering.					|
# All rights reserved.							|
#									|
# Permission to use, copy, modify, and distribute this software and its	|
# documentation for any purpose and without fee is hereby granted, pro-	|
# vided that the above copyright notice appear in all copies and that	|
# both that copyright notice and this permission notice appear in sup-	|
# porting documentation, and that the copyright owner's name not be	|
# used in advertising or publicity pertaining to distribution of the	|
# software without specific, written prior permission.			|
#									|
# THE AUTHOR(S) DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,	|
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS.  IN	|
# NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY SPECIAL, INDIRECT OR	|
# CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS	|
# OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE	|
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE	|
# USE OR PERFORMANCE OF THIS SOFTWARE.					|
#=======================================================================|
# People who have worked on this code.					|
#									|
# Ini Name								|
# --- ----------------------------------------------------------------- |
#  gh Gerhard Haering <gerhard@bigfoot.de>				|
# bga Billy G. Allie <bill.allie@mug.org>				|
#=======================================================================|
# Revision History:							|
#									|
# Date      Ini Description						|
# --------- --- ------------------------------------------------------- |
# 29AUG2001 gh  Reflected changed PostgreSQL win32 build process (Post- |
#               greSQL now built with mingw32)                          |
# 28AUG2001 bga Add include_dirs and lib_dirs for building on cygwin.	|
#		This change should allow pyPgSQL to build 'out of the	|
#		box' on MS Windows using the cygwin environment.	|
# 20AUG2001 bga Modified to include the new source files.		|
#	    --- Added code to determine any needed runtime library	|
#		search directories.					|
# 04AUG2001 gh  Modified to include the files pgversion.c,		|
#		pymemstrdup.c and strtok.c.				|
# 26JUL2001 bga Modified to use included strtoll.c and strtoull.c files.|
#	    --- Added this flower box and cleaned up file.		|
# 22JUL2001 gh  Modified to build win32 version.			|
# 01JUN2001 gh	Initial version created by Gerhard Haering.		|
#-----------------------------------------------------------------------+
import sys

from distutils.core import setup
from distutils.extension import Extension

__version__ = "2.0"

# Define the runtime library path for this module.  It starts out as None.

pypgsql_rt_dirs = None

# You may have to adjust include_dirs and library_dirs if they are differant
# on your system

include_dirs  = [ "/usr/local/pgsql/include" ]
# include_dirs  = [ "/usr/local/include/pgsql" ]	# Common alternative
# include_dirs  = [ "/usr/include/pgsql" ]		# Common alternative

library_dirs  = [ "/usr/local/pgsql/lib" ]		# Common alternative
# library_dirs  = [ "/usr/local/lib/pgsql" ]		# Common alternative
# library_dirs  = [ "/usr/lib/pgsql" ]

optional_libs = [ "pq" ]

sources = [ "libpqmodule.c",  "pgboolean.c",
	    "pgint2object.c", "pgint8object.c",
	    "pgversion.c",    "pglargeobject.c",
	    "pgnotify.c",     "pgconnection.c",
	    "pgresult.c",     "pymemstrdup.c" ]

if sys.platform == "win32":
    # This works with the PostgreSQL source tree, so it's a bit ugly ...
    # You will probably have to change win_pg_build_root for your system.

    win_pg_build_root = "h:/src/pgsql/"

    include_dirs = [ win_pg_build_root + "src/include",
		     win_pg_build_root + "/src/include/libpq",
		     win_pg_build_root + "src",
		     win_pg_build_root + "src/interfaces/libpq" ]

    library_dirs = [ win_pg_build_root + "src/interfaces/libpq/" ]

    optional_libs = [ "wsock32", "advapi32" ]
    optional_libs += [ "pqdll" ]    # [ "pq" ] for static linking

    data_files = [ "libpq.dll" ]    # [] for static linking

    sources = sources + [ "windows/strtoll.c",
			  "windows/strtoull.c",
			  "windows/strtok.c" ]

    modname="pyPgSQL.libpq.libpq"
else:
    if sys.platform[:6] == "cygwin":
	sources = sources + [ "windows/strtoll.c",
			      "windows/strtoull.c", 
			      "windows/strtok.c" ]
	include_dirs  = [ "/usr/include/postgresql" ]
	library_dirs  = [ "/usr/lib" ]

    # XXX: This is an ugly hack to make bdist_rpm find the include files.
    include_dirs.append("../" * 5)

    data_files = []
    pypgsql_rt_dirs = library_dirs

    modname="pyPgSQL.libpq.libpqmodule"

setup (
    name = "pyPgSQL",
    version = __version__,
    description = \
	"pyPgSQL - A Python DB-API 2.0 compliant interface to PostgreSQL.",
    author = "Billy G. Allie",
    author_email = "ballie01@sourceforge.net",
    url = "http://pypgsql.sourceforge.net/",
    licence = "Python",
    packages = [ "pyPgSQL", "pyPgSQL.libpq" ],
    ext_modules = [Extension(
        name=modname,
        sources = sources,
        include_dirs = include_dirs,
        library_dirs = library_dirs,
	runtime_library_dirs = pypgsql_rt_dirs,
        libraries = optional_libs
        )],
    data_files = data_files
)
