/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Die Sep  7 20:48:44 CEST 1999
    version              : $Id: main.cpp,v 1.9 2001/03/26 13:05:54 joerg_bemme Exp $
    copyright            : (C) 1999 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <qapplication.h>
/* uncomment it, if you want a Windows 95 look*/
//#include <qwindowsstyle.h>

#include "qttudo.h"
#include "sqlquerier.h"

int main( int argc, char ** argv ) {
	QString fileName = getenv("HOME");
  QApplication a( argc, argv );
	//a.setFont(QFont("helvetica",12));
	QPalette p = a.palette();

	fileName += "/.qttudo.conf";

	//p.setColor( QPalette::Active, QColorGroup::Base, QColor(200,255,200) );
	//p.setColor( QPalette::Inactive, QColorGroup::Base, QColor(255,150,150) );
	//p.setColor( QPalette::Disabled, QColorGroup::Base, QColor(255,150,150) );
	//p.setColor( QPalette::Active, QColorGroup::Text, QColor(255,100,100) );
	//p.setColor( QPalette::Inactive, QColorGroup::Text, QColor(255,100,100) );
	p.setColor( QPalette::Disabled, QColorGroup::Text, QColor(0,150,0) );
	//p.setColor( QPalette::Inactive, QColorGroup::Text, Qt::green );
	a.setPalette( p );
/* uncomment it, if you want a Windows 95 look*/
//  a.setStyle( new QWindowsStyle() );
    
  QtTudoApp *qttudo = new QtTudoApp();
  a.setMainWidget(qttudo);
 	qttudo->resize( 600, 140 );
  a.setMainWidget( qttudo );

	if ( argc == 2 ) // use argument as file name
		fileName = argv[1];

  QFile f( fileName );

  if ( f.open(IO_ReadOnly) ) {
		f.close();
	} else {
		fileName = "/etc/qttudo.conf";
		f.setName( fileName );
	  if ( f.open(IO_ReadOnly) ) {
			f.close();
		} else {
			QMessageBox::critical(qttudo,
			qttudo->ProgName->copy(),
			"Die Initialisierungsdatei 'qttudo.conf' wurde nicht gefunden.\n"
			"Legen Sie die Datei /etc/qttudo.conf oder ~/.qttudo.conf an,\n"
			"oder geben Sie den Pfad als Parameter an.");
			return 0;
		}
	}

  qttudo->show();

  if ( ConnectToDB( fileName.ascii() ) ) {
		Allgemein_Anmeldung *anmeldung =
			new Allgemein_Anmeldung( 0, 0, &Benutzer, true, qttudo->ProgName );
		anmeldung->show();
		if (!anmeldung->ok) {
			QMessageBox::critical(qttudo, "QtTudo", "Melden Sie sich erst an,\n"
				"bevor Sie mit dem Programm fortsetzen knnen.\n"
				"Die Datenbank mu unbedingt installiert sein\n"
				"und die Datei /etc/qttudo.conf mu auf ihre\n"
				"Datenbank verweisen." );
			return 0;
		}
  } else {
		QMessageBox::critical(qttudo,
			qttudo->ProgName->copy(),
			"Die Initialisierungsdatei 'qttudo.conf' wurde nicht gefunden.\n"
			"Legen Sie die Datei /etc/qttudo.conf oder ~/.qttudo.conf an,\n"
			"oder geben Sie den Pfad als Parameter an.");
		return 0;
	}
  return a.exec();
}
