/***************************************************************************
                          maskgenerator.cpp  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    version              : $Id: maskgenerator.cpp,v 1.9 2000/12/27 17:17:40 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qmessagebox.h>

#include "maskgenerator.h"

#define isNothing		0
#define isQWidget		1
#define isQLabel		2
#define isQLineEdit	3
#define isQGroupBox	4

MaskGenerator::MaskGenerator(QWidget *parent, const char *name,
		SQLQuerier *sql, SQLTable *table, const char *filename,
		QDBLineEdit *Feld[] )
: QFrame(parent,name)
{
	if (Feld == 0)
		QMessageBox::warning( 0, "QtTudo Maskengenerator",
			"Der bergabeparamter 'Feld' fehlt!" );
	else
		initDialog( sql, table, initPath+filename, Feld );
}

MaskGenerator::~MaskGenerator()
{
}

void MaskGenerator::initDialog(SQLQuerier *sql,
		SQLTable *table, const char *filename, QDBLineEdit *Feld[] )
{
	int i, breite, hoehe, x, y, special;
	int WidgetType = isNothing;
	QString s, VarName, Text, IsEnabled;
	bool bIsEnabled = false;
	int jumpPos = 1;

	// 999 fields are possible, but we use
	// only until 950.
	// From 951 until 998 are fields only on
	// screen, not in database.
	int scrField = 998;

	QLabel *l;
	QGroupBox *g;

	// We need a filename, otherwise return.
	if (filename == 0)
		return;

  QFile f( filename );

	// read the configuration file
  if ( f.open(IO_ReadOnly) ) {
    QTextStream t( &f );

		// make shure that all fields are NULL
		for (i=0; i < MAXFELDER; i++) {
			Feld[i] = 0;
		}

		breite = hoehe = x = y = special = 0;

		s = t.readLine();
		// loop through all lines of the kdevdlg-file
		while (!t.atEnd()) {
			// read a line
			s = t.readLine();

			// check strings
			if (s.find("item QWidget") != -1) {
				WidgetType = isQWidget;
				breite = hoehe = x = y = special = 0;
			}
			if (s.find("item QLabel") != -1) {
				WidgetType = isQLabel;
				breite = hoehe = x = y = special = 0;
			}
			if (s.find("item QLineEdit") != -1) {
				WidgetType = isQLineEdit;
				breite = hoehe = x = y = special = 0;
				bIsEnabled = true;
			}
			if (s.find("item QGroupBox") != -1) {
				WidgetType = isQGroupBox;
				breite = hoehe = x = y = special = 0;
			}

			// take a look what kind of line we have
			switch (WidgetType)
			{
				case isQWidget:
					if (strstr(s, " Width") != NULL) {
						breite = getValue( &s )->toInt();
					}
					if (strstr(s, " Height") != NULL) {
						hoehe = getValue( &s )->toInt();
					}
					if ((breite != 0) && (hoehe != 0)) {
						this->setFixedSize(breite,hoehe);
						breite = hoehe = x = y = special = 0;
						WidgetType = isNothing;
					}
					break;

				case isQLabel:
					if (strstr(s, " Width") != NULL) {
						breite = getValue( &s )->toInt();
					}
					if (strstr(s, " Height") != NULL) {
						hoehe = getValue( &s )->toInt();
					}
					if (strstr(s, " X=") != NULL) {
						x = getValue( &s )->toInt();
					}
					if (strstr(s, " Y=") != NULL) {
						y = getValue( &s )->toInt();
					}
					if (strstr(s, " Text") != NULL) {
						Text = getValue( &s )->copy();
						special = 1;
					}
					if ((breite != 0) && (hoehe != 0) && (special != 0)) {
						l = new QLabel(this);
						l->setGeometry(x,y,breite,hoehe);
						l->setText(Text.copy());
						breite = hoehe = x = y = special = 0;
						WidgetType = isNothing;
					}
					break;

				case isQLineEdit:
					if (strstr(s, " Width") != NULL) {
						breite = getValue( &s )->toInt();
					}
					if (strstr(s, " Height") != NULL) {
						hoehe = getValue( &s )->toInt();
					}
					if (strstr(s, " X=") != NULL) {
						x = getValue( &s )->toInt();
					}
					if (strstr(s, " Y=") != NULL) {
						y = getValue( &s )->toInt();
					}
					if (strstr(s, " VarName") != NULL) {
						VarName = getValue( &s )->copy();
						special = 1;
					}
					if (strstr(s, " IsEnabled") != NULL) {
						IsEnabled = getValue( &s )->copy();
						if ( strstr(IsEnabled,"false") != NULL )
							bIsEnabled = false;
					}
					if ((breite != 0) && (hoehe != 0) && (special != 0)) {
						if (table->fNumber(VarName) >= 0) {
							Feld[table->fNumber(VarName)]= new QDBLineEdit(this,VarName,sql,table);
							Feld[table->fNumber(VarName)]->setGeometry(x,y,breite,hoehe);
							Feld[table->fNumber(VarName)]->setEnabled( bIsEnabled );
							Feld[table->fNumber(VarName)]->screenNo = jumpPos;
						} else { // not in database
							Feld[scrField]= new QDBLineEdit(this,VarName,sql,table);
							Feld[scrField]->setGeometry(x,y,breite,hoehe);
							Feld[scrField]->setEnabled( bIsEnabled );
							Feld[scrField]->screenNo = jumpPos;
							scrField--;
						}
						breite = hoehe = x = y = special = 0;
						WidgetType = isNothing;
						jumpPos++;
					}
					break;

				case isQGroupBox:
					if (strstr(s, "Width") != NULL) {
						breite = getValue( &s )->toInt();
					}
					if (strstr(s, "Height") != NULL) {
						hoehe = getValue( &s )->toInt();
					}
					if (strstr(s, "X=") != NULL) {
						x = getValue( &s )->toInt();
					}
					if (strstr(s, "Y=") != NULL) {
						y = getValue( &s )->toInt();
					}
					if ((breite != 0) && (hoehe != 0)) {
						g = new QGroupBox(this);
						g->setGeometry(x,y,breite,hoehe);
						breite = hoehe = x = y = special = 0;
						WidgetType = isNothing;
					}
					break;

				default: break;
			} // switch
		} // while
    f.close();

		// Create all unvisible database fields. That's nesserary
		// for filling in values in fields, that the user don't see.
		// For example, transmitting data between different tables.
		for (i=0; i < table->getnFields(); i++) {
			if (Feld[i] == 0) {
				Feld[i]= new QDBLineEdit(0,table->fName(i),sql,table);
			}
		}

		return;
  }
  QMessageBox::warning( this, "QtTudo Maskengenerator",
			"Dialog-Konfigurationsdatei nicht gefunden.");
}

QString *MaskGenerator::getValue( QString *source )
{
	// Remove the string before and after the value.
	source->remove( 0, source->find('"')+1 );
	source->truncate( source->find('"') );
	return source;
}
