/*
 * jaZip for Linux  (c) 1996  Jarrod A. Smith
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <forms.h>
#include "jazip.h"
#include "help.h"

void	show_mesg();

void	show_mesg(FL_OBJECT *ob, char *str)
{
	FD_jazip		*zpf = ob->u_vdata;

	fl_addto_browser(zpf->msg_browser, str );
}

void	show_topic(FL_OBJECT *ob, char *str)
{
	FD_jazip_help	*zpf = ob->u_vdata;
	FILE	*fp;
	char	helpfile[256];

	fl_freeze_form (zpf->jazip_help);
	fl_clear_browser (ob);

	sprintf (helpfile, "%s/%s", DOCDIR, str);
	if ((fp = fopen (helpfile, "r")) == NULL) {
		sprintf (mesg, "Error : %s is not accessible.  No help for this topic.", helpfile);
		fl_add_browser_line (ob, mesg);
	} else {
		while (fgets (mesg, sizeof (mesg), fp)) {
			fl_add_browser_line (ob, mesg);
		}
		fclose (fp);
	}
	fl_unfreeze_form (zpf->jazip_help);
	return;
}
