/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import netscape.util.Deserializer;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Serializer;
import netscape.util.Sort;
import netscape.util.Vector;

public class FormattingSerializer
extends Serializer {
    private final int MAX_SIZE_FOR_SMALL_EXPRESSION = 80;
    private int indentationLength = 4;
    private int tabLevel = 0;
    private int nextCharIndex = 0;

    public FormattingSerializer(OutputStream outputStream) {
        super(outputStream);
    }

    public void setIndentationLength(int n) {
        this.indentationLength = n;
    }

    public int indentationLength() {
        return this.indentationLength;
    }

    public void writeComment(String string, boolean bl) throws IOException {
        int n;
        int n2 = string.length();
        if (n2 + (n = bl ? 7 : 4) <= 80 - this.nextCharIndex && string.indexOf(10) == -1) {
            if (bl) {
                this.writeCommentCharacter(47);
                this.writeCommentCharacter(42);
                this.writeCommentCharacter(32);
            } else {
                this.writeCommentCharacter(47);
                this.writeCommentCharacter(47);
                this.writeCommentCharacter(32);
            }
            int n3 = 0;
            while (n3 < n2) {
                this.writeCommentCharacter(string.charAt(n3));
                ++n3;
            }
            if (bl) {
                this.writeCommentCharacter(32);
                this.writeCommentCharacter(42);
                this.writeCommentCharacter(47);
                this.writeCommentCharacter(10);
                return;
            }
            this.writeCommentCharacter(10);
            return;
        }
        if (bl) {
            this.writeCommentCharacter(47);
            this.writeCommentCharacter(42);
            this.writeCommentCharacter(10);
            this.writeCommentCharacter(32);
            this.writeCommentCharacter(42);
            this.writeCommentCharacter(32);
        } else {
            this.writeCommentCharacter(47);
            this.writeCommentCharacter(47);
            this.writeCommentCharacter(32);
        }
        int n4 = 0;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c == '\n') {
                this.writeCommentCharacter(10);
                if (bl) {
                    this.writeCommentCharacter(32);
                    this.writeCommentCharacter(42);
                    this.writeCommentCharacter(32);
                } else {
                    this.writeCommentCharacter(47);
                    this.writeCommentCharacter(47);
                    this.writeCommentCharacter(32);
                }
            } else {
                this.writeCommentCharacter(c);
            }
            ++n4;
        }
        if (bl) {
            this.writeCommentCharacter(10);
            this.writeCommentCharacter(32);
            this.writeCommentCharacter(42);
            this.writeCommentCharacter(47);
            this.writeCommentCharacter(10);
            return;
        }
        this.writeCommentCharacter(10);
    }

    private final void increaseTabLevel() {
        ++this.tabLevel;
    }

    private final void decreaseTabLevel() {
        --this.tabLevel;
    }

    private final void insertNewLine() throws IOException {
        this.writeCharacter(10);
        int n = 0;
        int n2 = this.tabLevel * this.indentationLength();
        while (n < n2) {
            this.writeCharacter(32);
            ++n;
        }
    }

    private final void writeCharacter(int n) throws IOException {
        super.writeOutput(n);
        if (n == 10) {
            this.nextCharIndex = 0;
            return;
        }
        ++this.nextCharIndex;
    }

    private final void writeCommentCharacter(int n) throws IOException {
        if (n >= 32 && n < 127) {
            this.writeCharacter(n);
            return;
        }
        switch (n) {
            case 9: 
            case 10: 
            case 13: {
                this.writeCharacter(n);
            }
        }
    }

    private final int serializedStringFitsIn(String string, int n) {
        if (string == null || string.length() == 0) {
            return 2;
        }
        int n2 = string.length();
        if (n2 > n) {
            return n2;
        }
        int n3 = this.stringRequiresQuotes(string) ? 2 : 0;
        int n4 = 0;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c < '\u00ff') {
                if (c >= '#' && c <= '~' && c != '\\') {
                    ++n3;
                } else {
                    switch (c) {
                        case ' ': 
                        case '!': {
                            ++n3;
                            break;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case '\"': 
                        case '\\': {
                            n3 += 2;
                            break;
                        }
                        default: {
                            n3 += 4;
                            break;
                        }
                    }
                }
            } else {
                n3 += 6;
            }
            if (n3 > n) {
                return n3;
            }
            ++n4;
        }
        return n3;
    }

    private final int serializedHashtableFitsIn(Hashtable hashtable, int n) {
        int n2 = 2;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            ++n2;
            if ((n2 += this.serializedObjectFitsIn(object, n - n2)) > n) {
                return n2;
            }
            n2 += 3;
            n2 += this.serializedObjectFitsIn(hashtable.get(object), n - n2);
            if (++n2 <= n) continue;
            return n2;
        }
        return n2;
    }

    private final int serializedArrayFitsIn(Object[] objectArray, int n) {
        int n2 = 3;
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            ++n2;
            if ((n2 += this.serializedObjectFitsIn(objectArray[n3], n - n2)) > n) {
                return n2;
            }
            if (n3 < n4 - 1) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private final int serializedVectorFitsIn(Vector vector, int n) {
        int n2 = 3;
        int n3 = 0;
        int n4 = vector.count();
        while (n3 < n4) {
            ++n2;
            if ((n2 += this.serializedObjectFitsIn(vector.elementAt(n3), n - n2)) > n) {
                return n2;
            }
            if (n3 < n4 - 1) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private final int serializedNullFitsIn() {
        return 1;
    }

    private final int serializedObjectFitsIn(Object object, int n) {
        if (object instanceof String) {
            return this.serializedStringFitsIn((String)object, n);
        }
        if (object instanceof Hashtable) {
            return this.serializedHashtableFitsIn((Hashtable)object, n);
        }
        if (object instanceof Object[]) {
            return this.serializedArrayFitsIn((Object[])object, n);
        }
        if (object instanceof Vector) {
            return this.serializedVectorFitsIn((Vector)object, n);
        }
        if (object == null) {
            return this.serializedNullFitsIn();
        }
        return this.serializedStringFitsIn(object.toString(), n);
    }

    private final boolean canFitExpressionOnLine(Object object) {
        int n = 80 - this.nextCharIndex;
        return this.serializedObjectFitsIn(object, n) <= n;
    }

    private final void formatVector(Vector vector) throws IOException {
        int n = vector.count();
        if (this.canFitExpressionOnLine(vector)) {
            this.writeCharacter(40);
            int n2 = 0;
            while (n2 < n) {
                this.writeCharacter(32);
                this.formatObject(vector.elementAt(n2));
                if (n2 < n - 1) {
                    this.writeCharacter(44);
                }
                ++n2;
            }
            this.writeCharacter(32);
            this.writeCharacter(41);
            return;
        }
        this.writeCharacter(40);
        this.increaseTabLevel();
        int n3 = 0;
        while (n3 < n) {
            this.insertNewLine();
            this.formatObject(vector.elementAt(n3));
            if (n3 < n - 1) {
                this.writeCharacter(44);
            }
            ++n3;
        }
        this.decreaseTabLevel();
        this.insertNewLine();
        this.writeCharacter(41);
    }

    private final void formatArray(Object[] objectArray) throws IOException {
        int n = objectArray.length;
        if (this.canFitExpressionOnLine(objectArray)) {
            this.writeCharacter(91);
            int n2 = 0;
            while (n2 < n) {
                this.writeCharacter(32);
                this.formatObject(objectArray[n2]);
                if (n2 < n - 1) {
                    this.writeCharacter(44);
                }
                ++n2;
            }
            this.writeCharacter(32);
            this.writeCharacter(93);
            return;
        }
        this.writeCharacter(91);
        this.increaseTabLevel();
        int n3 = 0;
        while (n3 < n) {
            this.insertNewLine();
            this.formatObject(objectArray[n3]);
            if (n3 < n - 1) {
                this.writeCharacter(44);
            }
            ++n3;
        }
        this.decreaseTabLevel();
        this.insertNewLine();
        this.writeCharacter(93);
    }

    private final void formatHashtable(Hashtable hashtable) throws IOException {
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        int n2 = 0;
        int n3 = hashtable.count();
        Object[] objectArray = new String[n3];
        Object[] objectArray2 = new Object[n3];
        enumeration = hashtable.keys();
        int n4 = 0;
        while (n4 < n3) {
            Object object = enumeration.nextElement();
            if (object instanceof String) {
                objectArray[n2++] = (String)object;
            } else {
                objectArray2[n++] = object;
            }
            ++n4;
        }
        if (n2 > 0) {
            Sort.sortStrings(objectArray, 0, n2, true, false);
            System.arraycopy(objectArray, 0, objectArray2, n, n2);
        }
        if (this.canFitExpressionOnLine(hashtable)) {
            this.writeCharacter(123);
            n4 = 0;
            while (n4 < n3) {
                this.writeCharacter(32);
                Object object = objectArray2[n4];
                Object object2 = hashtable.get(object);
                this.formatObject(object);
                this.writeCharacter(32);
                this.writeCharacter(61);
                this.writeCharacter(32);
                this.formatObject(object2);
                this.writeCharacter(59);
                ++n4;
            }
            this.writeCharacter(125);
            return;
        }
        this.writeCharacter(123);
        this.increaseTabLevel();
        n4 = 0;
        while (n4 < n3) {
            Object object = objectArray2[n4];
            Object object3 = hashtable.get(object);
            this.insertNewLine();
            this.formatObject(object);
            this.writeCharacter(32);
            this.writeCharacter(61);
            this.writeCharacter(32);
            this.formatObject(object3);
            this.writeCharacter(59);
            ++n4;
        }
        this.decreaseTabLevel();
        this.insertNewLine();
        this.writeCharacter(125);
    }

    private final void formatObject(Object object) throws IOException {
        if (object instanceof String) {
            this.serializeString((String)object);
            return;
        }
        if (object instanceof Hashtable) {
            this.formatHashtable((Hashtable)object);
            return;
        }
        if (object instanceof Object[]) {
            this.formatArray((Object[])object);
            return;
        }
        if (object instanceof Vector) {
            this.formatVector((Vector)object);
            return;
        }
        if (object == null) {
            this.serializeNull();
            return;
        }
        this.serializeString(object.toString());
    }

    public void writeObject(Object object) throws IOException {
        this.formatObject(object);
    }

    public static String serializeObject(Object object) {
        String string = null;
        if (object == null) {
            string = null;
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            FormattingSerializer formattingSerializer = new FormattingSerializer(byteArrayOutputStream);
            try {
                formattingSerializer.writeObject(object);
                formattingSerializer.flush();
            }
            catch (IOException iOException) {}
            string = byteArrayOutputStream.toString();
            try {
                formattingSerializer.close();
                ((OutputStream)byteArrayOutputStream).close();
            }
            catch (IOException iOException) {}
            byteArrayOutputStream = null;
            formattingSerializer = null;
        }
        return string;
    }

    public static byte[] formatBytes(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Object object = Deserializer.readObject(byteArrayInputStream);
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FormattingSerializer formattingSerializer = new FormattingSerializer(byteArrayOutputStream);
            try {
                formattingSerializer.writeObject(object);
                formattingSerializer.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public static boolean writeObject(OutputStream outputStream, Object object) {
        try {
            FormattingSerializer formattingSerializer = new FormattingSerializer(outputStream);
            formattingSerializer.writeObject(object);
            formattingSerializer.flush();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

