// Copyright (c) 2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COURGETTE_ADJUSTMENT_METHOD_H_
#define COURGETTE_ADJUSTMENT_METHOD_H_

#include "base/basictypes.h"

namespace courgette {

class AssemblyProgram;

class AdjustmentMethod {
 public:
  // Factory methods for making adjusters.

  // Returns the adjustment method used in production.
  static AdjustmentMethod* MakeProductionAdjustmentMethod() {
    return MakeShingleAdjustmentMethod();
  }

  // Returns and adjustement method that makes no adjustments.
  static AdjustmentMethod* MakeNullAdjustmentMethod();

  // Returns the original adjustment method.
  static AdjustmentMethod* MakeTrieAdjustmentMethod();

  // Returns the new shingle tiling adjustment method.
  static AdjustmentMethod* MakeShingleAdjustmentMethod();

  // AdjustmentMethod interface:

  // Adjusts |program| to increase similarity to |model|.  |program| can be
  // changed in any way provided that it still produces the same output when
  // assembled.
  virtual bool Adjust(const AssemblyProgram& model,
                      AssemblyProgram* program) = 0;

  // Deletes 'this' adjustment method.
  virtual void Destroy();

 protected:
  AdjustmentMethod() {}
  virtual ~AdjustmentMethod() {}

  DISALLOW_COPY_AND_ASSIGN(AdjustmentMethod);
};

}  // namespace courgette
#endif  // COURGETTE_ADJUSTMENT_METHOD_H_
