/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXMimeTypeHeader.cpp,v 1.4.2.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "CHXMimeTypeHeader.h"
#include "CHXClientBuffer.h"
#include "hlxclib/string.h"

static const char* const kMimeTypePropertyName = "Content-Type";
static const char* const kPersistentVersionPropertyName = "PersistentVersion"; // Set in client/common/util/validatr.cpp's HXValidator::ValidateMetaFile()
static ULONG32 const kInvalidPersistentVersion = 0xFFFFFFFF;

CHXMimeTypeHeader::CHXMimeTypeHeader( const char* pMimeType )
	: m_lCount( 0 )
	, m_pIMimeTypeBuffer( NULL )
	, m_PersistentVersion( kInvalidPersistentVersion )
{
	if ( pMimeType && *pMimeType )
	{
		m_pIMimeTypeBuffer = new CHXClientBuffer;
		if ( m_pIMimeTypeBuffer )
		{
			m_pIMimeTypeBuffer->AddRef();
			m_pIMimeTypeBuffer->Set( ( const UCHAR* ) pMimeType, 1 + strlen( pMimeType ) );
		}
	}
}

CHXMimeTypeHeader::~CHXMimeTypeHeader( void )
{
	if ( m_pIMimeTypeBuffer )
	{
		m_pIMimeTypeBuffer->Release();
		m_pIMimeTypeBuffer = NULL;
	}
}

DEFINE_SINGLE_INTERFACE_COMPONENT( CHXMimeTypeHeader, IHXValues, m_lCount )

STDMETHODIMP
CHXMimeTypeHeader::SetPropertyULONG32( const char* pPropertyName, ULONG32 uPropertyValue )
{
	// Only supports a single ULONG32 with a given property name.
	if ( 0 == strcmp( pPropertyName, kPersistentVersionPropertyName ) )
	{
		m_PersistentVersion = uPropertyValue;
		return HXR_OK;
	}
	return HXR_FAIL;
}

STDMETHODIMP
CHXMimeTypeHeader::GetPropertyULONG32( const char* pPropertyName, REF( ULONG32 ) uPropertyValue )
{
	if ( ( kInvalidPersistentVersion != m_PersistentVersion ) && ( 0 == strcmp( pPropertyName, kPersistentVersionPropertyName ) ) )
	{
		uPropertyValue = m_PersistentVersion;
		return HXR_OK;
	}
	return HXR_FAIL;
}

STDMETHODIMP
CHXMimeTypeHeader::GetFirstPropertyULONG32( const char*& pPropertyName, REF( ULONG32 ) uPropertyValue )
{
	if ( kInvalidPersistentVersion != m_PersistentVersion )
	{
		pPropertyName = kPersistentVersionPropertyName;
		uPropertyValue = m_PersistentVersion;
		return HXR_OK;
	}
	return HXR_FAIL;
}

STDMETHODIMP
CHXMimeTypeHeader::GetNextPropertyULONG32( const char*& pPropertyName, REF( ULONG32 ) uPropertyValue )
{
	return HXR_FAIL; // There's only 1 item.
}

STDMETHODIMP
CHXMimeTypeHeader::SetPropertyBuffer( const char* pPropertyName, IHXBuffer* pPropertyValue )
{
	return HXR_FAIL; // Doesn't contain any buffers
}

STDMETHODIMP
CHXMimeTypeHeader::GetPropertyBuffer( const char* pPropertyName, REF( IHXBuffer* ) pPropertyValue )
{
	return HXR_FAIL; // Doesn't contain any buffers
}

STDMETHODIMP
CHXMimeTypeHeader::GetFirstPropertyBuffer( const char*& pPropertyName, REF( IHXBuffer* ) pPropertyValue )
{
	return HXR_FAIL; // Doesn't contain any buffers
}

STDMETHODIMP
CHXMimeTypeHeader::GetNextPropertyBuffer( const char*& pPropertyName, REF( IHXBuffer* ) pPropertyValue )
{
	return HXR_FAIL; // Doesn't contain any buffers
}

STDMETHODIMP
CHXMimeTypeHeader::SetPropertyCString( const char* pPropertyName, IHXBuffer* pPropertyValue )
{
	if ( !pPropertyValue ) return HXR_INVALID_PARAMETER;
	
	// Only supports a single C String with a given property name.
	if ( 0 == strcmp( pPropertyName, kMimeTypePropertyName ) )
	{
		if ( m_pIMimeTypeBuffer )
		{
			m_pIMimeTypeBuffer->Release();
			m_pIMimeTypeBuffer = NULL;
		}
		pPropertyValue->AddRef();
		m_pIMimeTypeBuffer = pPropertyValue;
		return HXR_OK;
	}
	return HXR_FAIL;
}

STDMETHODIMP
CHXMimeTypeHeader::GetPropertyCString( const char* pPropertyName, REF( IHXBuffer* ) pPropertyValue )
{
	if ( m_pIMimeTypeBuffer && ( 0 == strcmp( pPropertyName, kMimeTypePropertyName ) ) )
	{
		pPropertyValue = m_pIMimeTypeBuffer;
		pPropertyValue->AddRef();
		return HXR_OK;
	}
	return HXR_FAIL;
}

STDMETHODIMP
CHXMimeTypeHeader::GetFirstPropertyCString( const char*& pPropertyName, REF( IHXBuffer* ) pPropertyValue )
{
	if ( m_pIMimeTypeBuffer )
	{
		pPropertyName = kMimeTypePropertyName;
		pPropertyValue = m_pIMimeTypeBuffer;
		pPropertyValue->AddRef();
		return HXR_OK;
	}
	return HXR_FAIL;
}

STDMETHODIMP
CHXMimeTypeHeader::GetNextPropertyCString( const char*& pPropertyName, REF( IHXBuffer* ) pPropertyValue )
{
	return HXR_FAIL; // There's only 1 item.
}
