<?php
/**
 * @package Horde_Kolab
 *
 * $Horde: framework/Kolab/Kolab/XML/note.php,v 1.1.2.2 2008/01/02 11:30:38 jan Exp $
 */

/**
 * Kolab XML handler for note groupware objects
 *
 * $Horde: framework/Kolab/Kolab/XML/note.php,v 1.1.2.2 2008/01/02 11:30:38 jan Exp $
 *
 * Copyright 2007-2008 The Horde Project (http://www.horde.org/)
 *
 * @author  Thomas Jarosch <thomas.jarosch@intra2net.com>
 * @author  Gunnar Wrobel <wrobel@pardus.de>
 * @package Horde_Kolab
 */
class Horde_Kolab_XML_note extends Horde_Kolab_XML {
    /**
     * Specific data fields for the note object
     *
     * @var Kolab
     */
    var $_fields_specific;

    /**
     * Constructor
     */
    function Horde_Kolab_XML_note()
    {
        $this->_root_name = 'note';

        /** Specific note fields, in kolab format specification order
         */
        $this->_fields_specific = array(
            'summary' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_DEFAULT,
                'default' => '',
            ),
            'background-color' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_COLOR,
                'value'   => HORDE_KOLAB_XML_VALUE_DEFAULT,
                'default' => '#000000',
            ),
            'foreground-color' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_COLOR,
                'value'   => HORDE_KOLAB_XML_VALUE_DEFAULT,
                'default' => '#ffff00',
            ),
        );

        parent::Horde_Kolab_XML();
    }

    /**
     * Load the groupware object based on the specifc XML values.
     *
     * @param array $children An array of XML nodes
     *
     * @return array Array with data or PEAR error
     */
    function _load(&$children)
    {
        $object = $this->loadArray($children, $this->_fields_specific);

        $object['desc'] = $object['summary'];
        unset($object['summary']);

        return $object;
    }

    /**
     * Save the specific XML values.
     *
     * @param array $root     The XML document root
     * @param array $object   The resulting data array
     *
     * @return boolean True on success, a PEAR error otherwise
     */
    function _save($root, $object)
    {

        $object['summary'] = $object['desc'];
        unset($object['desc']);

        $result = $this->saveArray($root, $object, $this->_fields_specific);
        if (is_a($result, 'PEAR_Error')) {
            return $result;
        } 
    }
}
