/***************************************************************************
 *   Copyright Brian Ledbetter 2001-2003 <brian@shadowcom.net>             *
 *   Copyright Ravikiran Rajagopal 2003 <ravi@kde.org>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License (version 2) as   *
 *   published by the Free Software Foundation. (The original KSplash/ML   *
 *   codebase (upto version 0.95.3) is BSD-licensed.)                      *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kconfig.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kwin.h>

#include <qevent.h>
#include <qfile.h>
#include <qwidget.h>

#ifdef HAVE_XCURSOR
# include <X11/Xlib.h>
# include <X11/Xcursor/Xcursor.h>
#endif

#include "objkstheme.h"
#include "themeengine.h"
#include "themeengine.moc"

ThemeEngine::ThemeEngine( QWidget *, const char *, const QStringList& args )
  : QVBox( 0, "wndSplash", WStyle_Customize|WStyle_StaysOnTop|WStyle_NoBorder ), d(0)
{
  if (args.isEmpty())
    mTheme = new ObjKsTheme( "Default" );
  else
    mTheme = new ObjKsTheme( args.first() );
  mTheme->loadCmdLineArgs( KCmdLineArgs::parsedArgs() );

  KWin::setState( winId(), NET::StaysOnTop | NET::SkipTaskbar | NET::SkipPager );
  KWin::setOnDesktop( winId(), NET::OnAllDesktops );

#ifdef HAVE_XCURSOR
  KConfig *c = KGlobal::config();
  c->setGroup( "KDE" );
  QCString cursorTheme = QFile::encodeName( c->readEntry( "cursorTheme" ) );
  QCString size = c->readEntry( "cursorSize" ).local8Bit();

  if ( !cursorTheme.isEmpty() ) {
    XcursorSetTheme( x11Display(), cursorTheme.data() );

    if ( !size.isEmpty() )
      XcursorSetDefaultSize( x11Display(), size.toUInt() );

    Cursor handle = XcursorLibraryLoadCursor( x11Display(), "left_ptr" );
    XDefineCursor( x11Display(), winId(), handle );
    XDefineCursor( x11Display(), x11AppRootWindow(), handle );
    XFreeCursor( x11Display(), handle );
  }
#endif
}

ThemeEngine::~ThemeEngine()
{
}
