/*-
 * Copyright (c) 2005  Joseph Koshy
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef _DEV_HWPMC_PMC_EVENTS_H_
#define	_DEV_HWPMC_PMC_EVENTS_H_

/* 
 * Note: Documentation on adding events can be found both in
 * the source tree at src/share/doc/papers/hwpmc/hwpmc.ms
 * as well as on-line at:
 *
 * http://wiki.freebsd.org/PmcTools/PmcHardwareHowTo
 *
 * Please refer to those resources before you attempt to modify
 * this file or the hwpmc driver/subsystem.
 */

/* * PMC event codes.
 *
 * __PMC_EV(CLASS, SYMBOLIC-NAME)
 *
 */

/*
 * AMD K7 Events, from "The AMD Athlon(tm) Processor x86 Code
 * Optimization Guide" [Doc#22007K, Feb 2002]
 */

#define	__PMC_EV_K7()					\
__PMC_EV(K7, DC_ACCESSES)				\
__PMC_EV(K7, DC_MISSES)					\
__PMC_EV(K7, DC_REFILLS_FROM_L2)			\
__PMC_EV(K7, DC_REFILLS_FROM_SYSTEM)			\
__PMC_EV(K7, DC_WRITEBACKS)				\
__PMC_EV(K7, L1_DTLB_MISS_AND_L2_DTLB_HITS)		\
__PMC_EV(K7, L1_AND_L2_DTLB_MISSES)			\
__PMC_EV(K7, MISALIGNED_REFERENCES)			\
__PMC_EV(K7, IC_FETCHES)				\
__PMC_EV(K7, IC_MISSES)					\
__PMC_EV(K7, L1_ITLB_MISSES)				\
__PMC_EV(K7, L1_L2_ITLB_MISSES)				\
__PMC_EV(K7, RETIRED_INSTRUCTIONS)			\
__PMC_EV(K7, RETIRED_OPS)				\
__PMC_EV(K7, RETIRED_BRANCHES)				\
__PMC_EV(K7, RETIRED_BRANCHES_MISPREDICTED)		\
__PMC_EV(K7, RETIRED_TAKEN_BRANCHES)			\
__PMC_EV(K7, RETIRED_TAKEN_BRANCHES_MISPREDICTED)	\
__PMC_EV(K7, RETIRED_FAR_CONTROL_TRANSFERS)		\
__PMC_EV(K7, RETIRED_RESYNC_BRANCHES)			\
__PMC_EV(K7, INTERRUPTS_MASKED_CYCLES)			\
__PMC_EV(K7, INTERRUPTS_MASKED_WHILE_PENDING_CYCLES)	\
__PMC_EV(K7, HARDWARE_INTERRUPTS)

#define	PMC_EV_K7_FIRST	PMC_EV_K7_DC_ACCESSES
#define	PMC_EV_K7_LAST	PMC_EV_K7_HARDWARE_INTERRUPTS


/*
 * Intel P4 Events, from "IA-32 Intel(r) Architecture Software
 * Developer's Manual, Volume 3: System Programming Guide" [245472-012]
 */

#define	__PMC_EV_P4()				\
__PMC_EV(P4, TC_DELIVER_MODE)			\
__PMC_EV(P4, BPU_FETCH_REQUEST)			\
__PMC_EV(P4, ITLB_REFERENCE)			\
__PMC_EV(P4, MEMORY_CANCEL)			\
__PMC_EV(P4, MEMORY_COMPLETE)			\
__PMC_EV(P4, LOAD_PORT_REPLAY)			\
__PMC_EV(P4, STORE_PORT_REPLAY)			\
__PMC_EV(P4, MOB_LOAD_REPLAY)			\
__PMC_EV(P4, PAGE_WALK_TYPE)			\
__PMC_EV(P4, BSQ_CACHE_REFERENCE)		\
__PMC_EV(P4, IOQ_ALLOCATION)			\
__PMC_EV(P4, IOQ_ACTIVE_ENTRIES)		\
__PMC_EV(P4, FSB_DATA_ACTIVITY)			\
__PMC_EV(P4, BSQ_ALLOCATION)			\
__PMC_EV(P4, BSQ_ACTIVE_ENTRIES)		\
__PMC_EV(P4, SSE_INPUT_ASSIST)			\
__PMC_EV(P4, PACKED_SP_UOP)			\
__PMC_EV(P4, PACKED_DP_UOP)			\
__PMC_EV(P4, SCALAR_SP_UOP)			\
__PMC_EV(P4, SCALAR_DP_UOP)			\
__PMC_EV(P4, 64BIT_MMX_UOP)			\
__PMC_EV(P4, 128BIT_MMX_UOP)			\
__PMC_EV(P4, X87_FP_UOP)			\
__PMC_EV(P4, X87_SIMD_MOVES_UOP)		\
__PMC_EV(P4, GLOBAL_POWER_EVENTS)		\
__PMC_EV(P4, TC_MS_XFER)			\
__PMC_EV(P4, UOP_QUEUE_WRITES)			\
__PMC_EV(P4, RETIRED_MISPRED_BRANCH_TYPE)	\
__PMC_EV(P4, RETIRED_BRANCH_TYPE)		\
__PMC_EV(P4, RESOURCE_STALL)			\
__PMC_EV(P4, WC_BUFFER)				\
__PMC_EV(P4, B2B_CYCLES)			\
__PMC_EV(P4, BNR)				\
__PMC_EV(P4, SNOOP)				\
__PMC_EV(P4, RESPONSE)				\
__PMC_EV(P4, FRONT_END_EVENT)			\
__PMC_EV(P4, EXECUTION_EVENT)			\
__PMC_EV(P4, REPLAY_EVENT)			\
__PMC_EV(P4, INSTR_RETIRED)			\
__PMC_EV(P4, UOPS_RETIRED)			\
__PMC_EV(P4, UOP_TYPE)				\
__PMC_EV(P4, BRANCH_RETIRED)			\
__PMC_EV(P4, MISPRED_BRANCH_RETIRED)		\
__PMC_EV(P4, X87_ASSIST)			\
__PMC_EV(P4, MACHINE_CLEAR)

#define	PMC_EV_P4_FIRST PMC_EV_P4_TC_DELIVER_MODE
#define	PMC_EV_P4_LAST	PMC_EV_P4_MACHINE_CLEAR

/* Intel Pentium Pro, P-II, P-III and Pentium-M style events */

#define	__PMC_EV_P6()				\
__PMC_EV(P6, DATA_MEM_REFS)			\
__PMC_EV(P6, DCU_LINES_IN)			\
__PMC_EV(P6, DCU_M_LINES_IN)			\
__PMC_EV(P6, DCU_M_LINES_OUT)			\
__PMC_EV(P6, DCU_MISS_OUTSTANDING)		\
__PMC_EV(P6, IFU_FETCH)				\
__PMC_EV(P6, IFU_FETCH_MISS)			\
__PMC_EV(P6, ITLB_MISS)				\
__PMC_EV(P6, IFU_MEM_STALL)			\
__PMC_EV(P6, ILD_STALL)				\
__PMC_EV(P6, L2_IFETCH)				\
__PMC_EV(P6, L2_LD)				\
__PMC_EV(P6, L2_ST)				\
__PMC_EV(P6, L2_LINES_IN)			\
__PMC_EV(P6, L2_LINES_OUT)			\
__PMC_EV(P6, L2_M_LINES_INM)			\
__PMC_EV(P6, L2_M_LINES_OUTM)			\
__PMC_EV(P6, L2_RQSTS)				\
__PMC_EV(P6, L2_ADS)				\
__PMC_EV(P6, L2_DBUS_BUSY)			\
__PMC_EV(P6, L2_DBUS_BUSY_RD)			\
__PMC_EV(P6, BUS_DRDY_CLOCKS)			\
__PMC_EV(P6, BUS_LOCK_CLOCKS)			\
__PMC_EV(P6, BUS_REQ_OUTSTANDING)		\
__PMC_EV(P6, BUS_TRAN_BRD)			\
__PMC_EV(P6, BUS_TRAN_RFO)			\
__PMC_EV(P6, BUS_TRANS_WB)			\
__PMC_EV(P6, BUS_TRAN_IFETCH)			\
__PMC_EV(P6, BUS_TRAN_INVAL)			\
__PMC_EV(P6, BUS_TRAN_PWR)			\
__PMC_EV(P6, BUS_TRANS_P)			\
__PMC_EV(P6, BUS_TRANS_IO)			\
__PMC_EV(P6, BUS_TRAN_DEF)			\
__PMC_EV(P6, BUS_TRAN_BURST)			\
__PMC_EV(P6, BUS_TRAN_ANY)			\
__PMC_EV(P6, BUS_TRAN_MEM)			\
__PMC_EV(P6, BUS_DATA_RCV)			\
__PMC_EV(P6, BUS_BNR_DRV)			\
__PMC_EV(P6, BUS_HIT_DRV)			\
__PMC_EV(P6, BUS_HITM_DRV)			\
__PMC_EV(P6, BUS_SNOOP_STALL)			\
__PMC_EV(P6, FLOPS)				\
__PMC_EV(P6, FP_COMPS_OPS_EXE)			\
__PMC_EV(P6, FP_ASSIST)				\
__PMC_EV(P6, MUL)				\
__PMC_EV(P6, DIV)				\
__PMC_EV(P6, CYCLES_DIV_BUSY)			\
__PMC_EV(P6, LD_BLOCKS)				\
__PMC_EV(P6, SB_DRAINS)				\
__PMC_EV(P6, MISALIGN_MEM_REF)			\
__PMC_EV(P6, EMON_KNI_PREF_DISPATCHED)		\
__PMC_EV(P6, EMON_KNI_PREF_MISS)		\
__PMC_EV(P6, INST_RETIRED)			\
__PMC_EV(P6, UOPS_RETIRED)			\
__PMC_EV(P6, INST_DECODED)			\
__PMC_EV(P6, EMON_KNI_INST_RETIRED)		\
__PMC_EV(P6, EMON_KNI_COMP_INST_RET)		\
__PMC_EV(P6, HW_INT_RX)				\
__PMC_EV(P6, CYCLES_INT_MASKED)			\
__PMC_EV(P6, CYCLES_INT_PENDING_AND_MASKED)	\
__PMC_EV(P6, BR_INST_RETIRED)			\
__PMC_EV(P6, BR_MISS_PRED_RETIRED)		\
__PMC_EV(P6, BR_TAKEN_RETIRED)			\
__PMC_EV(P6, BR_MISS_PRED_TAKEN_RET)		\
__PMC_EV(P6, BR_INST_DECODED)			\
__PMC_EV(P6, BTB_MISSES)			\
__PMC_EV(P6, BR_BOGUS)				\
__PMC_EV(P6, BACLEARS)				\
__PMC_EV(P6, RESOURCE_STALLS)			\
__PMC_EV(P6, PARTIAL_RAT_STALLS)		\
__PMC_EV(P6, SEGMENT_REG_LOADS)			\
__PMC_EV(P6, CPU_CLK_UNHALTED)			\
__PMC_EV(P6, MMX_INSTR_EXEC)			\
__PMC_EV(P6, MMX_SAT_INSTR_EXEC)		\
__PMC_EV(P6, MMX_UOPS_EXEC)			\
__PMC_EV(P6, MMX_INSTR_TYPE_EXEC)		\
__PMC_EV(P6, FP_MMX_TRANS)			\
__PMC_EV(P6, MMX_ASSIST)			\
__PMC_EV(P6, MMX_INSTR_RET)			\
__PMC_EV(P6, SEG_RENAME_STALLS)			\
__PMC_EV(P6, SEG_REG_RENAMES)			\
__PMC_EV(P6, RET_SEG_RENAMES)			\
__PMC_EV(P6, EMON_EST_TRANS)			\
__PMC_EV(P6, EMON_THERMAL_TRIP)			\
__PMC_EV(P6, BR_INST_EXEC)			\
__PMC_EV(P6, BR_MISSP_EXEC)			\
__PMC_EV(P6, BR_BAC_MISSP_EXEC)			\
__PMC_EV(P6, BR_CND_EXEC)			\
__PMC_EV(P6, BR_CND_MISSP_EXEC)			\
__PMC_EV(P6, BR_IND_EXEC)			\
__PMC_EV(P6, BR_IND_MISSP_EXEC)			\
__PMC_EV(P6, BR_RET_EXEC)			\
__PMC_EV(P6, BR_RET_MISSP_EXEC)			\
__PMC_EV(P6, BR_RET_BAC_MISSP_EXEC)		\
__PMC_EV(P6, BR_CALL_EXEC)			\
__PMC_EV(P6, BR_CALL_MISSP_EXEC)		\
__PMC_EV(P6, BR_IND_CALL_EXEC)			\
__PMC_EV(P6, EMON_SIMD_INSTR_RETIRED)		\
__PMC_EV(P6, EMON_SYNCH_UOPS)			\
__PMC_EV(P6, EMON_ESP_UOPS)			\
__PMC_EV(P6, EMON_FUSED_UOPS_RET)		\
__PMC_EV(P6, EMON_UNFUSION)			\
__PMC_EV(P6, EMON_PREF_RQSTS_UP)		\
__PMC_EV(P6, EMON_PREF_RQSTS_DN)		\
__PMC_EV(P6, EMON_SSE_SSE2_INST_RETIRED)	\
__PMC_EV(P6, EMON_SSE_SSE2_COMP_INST_RETIRED)


#define	PMC_EV_P6_FIRST	PMC_EV_P6_DATA_MEM_REFS
#define	PMC_EV_P6_LAST	PMC_EV_P6_EMON_SSE_SSE2_COMP_INST_RETIRED

/* AMD K8 PMCs */

#define	__PMC_EV_K8()							\
__PMC_EV(K8, FP_DISPATCHED_FPU_OPS)					\
__PMC_EV(K8, FP_CYCLES_WITH_NO_FPU_OPS_RETIRED)				\
__PMC_EV(K8, FP_DISPATCHED_FPU_FAST_FLAG_OPS)				\
__PMC_EV(K8, LS_SEGMENT_REGISTER_LOAD)					\
__PMC_EV(K8, LS_MICROARCHITECTURAL_RESYNC_BY_SELF_MODIFYING_CODE)	\
__PMC_EV(K8, LS_MICROARCHITECTURAL_RESYNC_BY_SNOOP)			\
__PMC_EV(K8, LS_BUFFER2_FULL)						\
__PMC_EV(K8, LS_LOCKED_OPERATION)					\
__PMC_EV(K8, LS_MICROARCHITECTURAL_LATE_CANCEL)				\
__PMC_EV(K8, LS_RETIRED_CFLUSH_INSTRUCTIONS)				\
__PMC_EV(K8, LS_RETIRED_CPUID_INSTRUCTIONS)				\
__PMC_EV(K8, DC_ACCESS)							\
__PMC_EV(K8, DC_MISS)							\
__PMC_EV(K8, DC_REFILL_FROM_L2)						\
__PMC_EV(K8, DC_REFILL_FROM_SYSTEM)					\
__PMC_EV(K8, DC_COPYBACK)						\
__PMC_EV(K8, DC_L1_DTLB_MISS_AND_L2_DTLB_HIT)				\
__PMC_EV(K8, DC_L1_DTLB_MISS_AND_L2_DTLB_MISS)				\
__PMC_EV(K8, DC_MISALIGNED_DATA_REFERENCE)				\
__PMC_EV(K8, DC_MICROARCHITECTURAL_LATE_CANCEL)				\
__PMC_EV(K8, DC_MICROARCHITECTURAL_EARLY_CANCEL)			\
__PMC_EV(K8, DC_ONE_BIT_ECC_ERROR)					\
__PMC_EV(K8, DC_DISPATCHED_PREFETCH_INSTRUCTIONS)			\
__PMC_EV(K8, DC_DCACHE_ACCESSES_BY_LOCKS)				\
__PMC_EV(K8, BU_CPU_CLK_UNHALTED)					\
__PMC_EV(K8, BU_INTERNAL_L2_REQUEST)					\
__PMC_EV(K8, BU_FILL_REQUEST_L2_MISS)					\
__PMC_EV(K8, BU_FILL_INTO_L2)						\
__PMC_EV(K8, IC_FETCH)							\
__PMC_EV(K8, IC_MISS)							\
__PMC_EV(K8, IC_REFILL_FROM_L2)						\
__PMC_EV(K8, IC_REFILL_FROM_SYSTEM)					\
__PMC_EV(K8, IC_L1_ITLB_MISS_AND_L2_ITLB_HIT)				\
__PMC_EV(K8, IC_L1_ITLB_MISS_AND_L2_ITLB_MISS)				\
__PMC_EV(K8, IC_MICROARCHITECTURAL_RESYNC_BY_SNOOP)			\
__PMC_EV(K8, IC_INSTRUCTION_FETCH_STALL)				\
__PMC_EV(K8, IC_RETURN_STACK_HIT)					\
__PMC_EV(K8, IC_RETURN_STACK_OVERFLOW)					\
__PMC_EV(K8, FR_RETIRED_X86_INSTRUCTIONS)				\
__PMC_EV(K8, FR_RETIRED_UOPS)						\
__PMC_EV(K8, FR_RETIRED_BRANCHES)					\
__PMC_EV(K8, FR_RETIRED_BRANCHES_MISPREDICTED)				\
__PMC_EV(K8, FR_RETIRED_TAKEN_BRANCHES)					\
__PMC_EV(K8, FR_RETIRED_TAKEN_BRANCHES_MISPREDICTED)			\
__PMC_EV(K8, FR_RETIRED_FAR_CONTROL_TRANSFERS)				\
__PMC_EV(K8, FR_RETIRED_RESYNCS)					\
__PMC_EV(K8, FR_RETIRED_NEAR_RETURNS)					\
__PMC_EV(K8, FR_RETIRED_NEAR_RETURNS_MISPREDICTED)			\
__PMC_EV(K8, FR_RETIRED_TAKEN_BRANCHES_MISPREDICTED_BY_ADDR_MISCOMPARE)	\
__PMC_EV(K8, FR_RETIRED_FPU_INSTRUCTIONS)				\
__PMC_EV(K8, FR_RETIRED_FASTPATH_DOUBLE_OP_INSTRUCTIONS)		\
__PMC_EV(K8, FR_INTERRUPTS_MASKED_CYCLES)				\
__PMC_EV(K8, FR_INTERRUPTS_MASKED_WHILE_PENDING_CYCLES)			\
__PMC_EV(K8, FR_TAKEN_HARDWARE_INTERRUPTS)				\
__PMC_EV(K8, FR_DECODER_EMPTY)						\
__PMC_EV(K8, FR_DISPATCH_STALLS)					\
__PMC_EV(K8, FR_DISPATCH_STALL_FROM_BRANCH_ABORT_TO_RETIRE)		\
__PMC_EV(K8, FR_DISPATCH_STALL_FOR_SERIALIZATION)			\
__PMC_EV(K8, FR_DISPATCH_STALL_FOR_SEGMENT_LOAD)			\
__PMC_EV(K8, FR_DISPATCH_STALL_WHEN_REORDER_BUFFER_IS_FULL)		\
__PMC_EV(K8, FR_DISPATCH_STALL_WHEN_RESERVATION_STATIONS_ARE_FULL)	\
__PMC_EV(K8, FR_DISPATCH_STALL_WHEN_FPU_IS_FULL)			\
__PMC_EV(K8, FR_DISPATCH_STALL_WHEN_LS_IS_FULL)				\
__PMC_EV(K8, FR_DISPATCH_STALL_WHEN_WAITING_FOR_ALL_TO_BE_QUIET)	\
__PMC_EV(K8, FR_DISPATCH_STALL_WHEN_FAR_XFER_OR_RESYNC_BRANCH_PENDING)	\
__PMC_EV(K8, FR_FPU_EXCEPTIONS)						\
__PMC_EV(K8, FR_NUMBER_OF_BREAKPOINTS_FOR_DR0)				\
__PMC_EV(K8, FR_NUMBER_OF_BREAKPOINTS_FOR_DR1)				\
__PMC_EV(K8, FR_NUMBER_OF_BREAKPOINTS_FOR_DR2)				\
__PMC_EV(K8, FR_NUMBER_OF_BREAKPOINTS_FOR_DR3)				\
__PMC_EV(K8, NB_MEMORY_CONTROLLER_PAGE_ACCESS_EVENT)			\
__PMC_EV(K8, NB_MEMORY_CONTROLLER_PAGE_TABLE_OVERFLOW)			\
__PMC_EV(K8, NB_MEMORY_CONTROLLER_DRAM_COMMAND_SLOTS_MISSED)		\
__PMC_EV(K8, NB_MEMORY_CONTROLLER_TURNAROUND)				\
__PMC_EV(K8, NB_MEMORY_CONTROLLER_BYPASS_SATURATION)			\
__PMC_EV(K8, NB_SIZED_COMMANDS)						\
__PMC_EV(K8, NB_PROBE_RESULT)						\
__PMC_EV(K8, NB_HT_BUS0_BANDWIDTH)					\
__PMC_EV(K8, NB_HT_BUS1_BANDWIDTH)					\
__PMC_EV(K8, NB_HT_BUS2_BANDWIDTH)

#define	PMC_EV_K8_FIRST		PMC_EV_K8_FP_DISPATCHED_FPU_OPS
#define	PMC_EV_K8_LAST		PMC_EV_K8_NB_HT_BUS2_BANDWIDTH


/*
 * Intel Pentium and Pentium MMX events, from the "Intel 64 and IA-32
 * Architectures Software Developer's Manual, Volume 3B: System Programming
 * Guide, Part 2, August 2007".
 */
#define	__PMC_EV_P5()							\
__PMC_EV(P5, DATA_READ)							\
__PMC_EV(P5, DATA_WRITE)						\
__PMC_EV(P5, DATA_TLB_MISS)						\
__PMC_EV(P5, DATA_READ_MISS)						\
__PMC_EV(P5, DATA_WRITE_MISS)						\
__PMC_EV(P5, WRITE_HIT_TO_M_OR_E_STATE_LINES)				\
__PMC_EV(P5, DATA_CACHE_LINES_WRITTEN_BACK)				\
__PMC_EV(P5, EXTERNAL_SNOOPS)						\
__PMC_EV(P5, EXTERNAL_DATA_CACHE_SNOOP_HITS)				\
__PMC_EV(P5, MEMORY_ACCESSES_IN_BOTH_PIPES)				\
__PMC_EV(P5, BANK_CONFLICTS)						\
__PMC_EV(P5, MISALIGNED_DATA_OR_IO_REFERENCES)				\
__PMC_EV(P5, CODE_READ)							\
__PMC_EV(P5, CODE_TLB_MISS)						\
__PMC_EV(P5, CODE_CACHE_MISS)						\
__PMC_EV(P5, ANY_SEGMENT_REGISTER_LOADED)				\
__PMC_EV(P5, BRANCHES)							\
__PMC_EV(P5, BTB_HITS)							\
__PMC_EV(P5, TAKEN_BRANCH_OR_BTB_HIT)					\
__PMC_EV(P5, PIPELINE_FLUSHES)						\
__PMC_EV(P5, INSTRUCTIONS_EXECUTED)					\
__PMC_EV(P5, INSTRUCTIONS_EXECUTED_V_PIPE)				\
__PMC_EV(P5, BUS_CYCLE_DURATION)					\
__PMC_EV(P5, WRITE_BUFFER_FULL_STALL_DURATION)				\
__PMC_EV(P5, WAITING_FOR_DATA_MEMORY_READ_STALL_DURATION)		\
__PMC_EV(P5, STALL_ON_WRITE_TO_AN_E_OR_M_STATE_LINE)			\
__PMC_EV(P5, LOCKED_BUS_CYCLE)						\
__PMC_EV(P5, IO_READ_OR_WRITE_CYCLE)					\
__PMC_EV(P5, NONCACHEABLE_MEMORY_READS)					\
__PMC_EV(P5, PIPELINE_AGI_STALLS)					\
__PMC_EV(P5, FLOPS)							\
__PMC_EV(P5, BREAKPOINT_MATCH_ON_DR0_REGISTER)				\
__PMC_EV(P5, BREAKPOINT_MATCH_ON_DR1_REGISTER)				\
__PMC_EV(P5, BREAKPOINT_MATCH_ON_DR2_REGISTER)				\
__PMC_EV(P5, BREAKPOINT_MATCH_ON_DR3_REGISTER)				\
__PMC_EV(P5, HARDWARE_INTERRUPTS)					\
__PMC_EV(P5, DATA_READ_OR_WRITE)					\
__PMC_EV(P5, DATA_READ_MISS_OR_WRITE_MISS)				\
__PMC_EV(P5, BUS_OWNERSHIP_LATENCY)					\
__PMC_EV(P5, BUS_OWNERSHIP_TRANSFERS)					\
__PMC_EV(P5, MMX_INSTRUCTIONS_EXECUTED_U_PIPE)				\
__PMC_EV(P5, MMX_INSTRUCTIONS_EXECUTED_V_PIPE)				\
__PMC_EV(P5, CACHE_M_LINE_SHARING)					\
__PMC_EV(P5, CACHE_LINE_SHARING)					\
__PMC_EV(P5, EMMS_INSTRUCTIONS_EXECUTED)				\
__PMC_EV(P5, TRANSITIONS_BETWEEN_MMX_AND_FP_INSTRUCTIONS)		\
__PMC_EV(P5, BUS_UTILIZATION_DUE_TO_PROCESSOR_ACTIVITY)			\
__PMC_EV(P5, WRITES_TO_NONCACHEABLE_MEMORY)				\
__PMC_EV(P5, SATURATING_MMX_INSTRUCTIONS_EXECUTED)			\
__PMC_EV(P5, SATURATIONS_PERFORMED)					\
__PMC_EV(P5, NUMBER_OF_CYCLES_NOT_IN_HALT_STATE)			\
__PMC_EV(P5, DATA_CACHE_TLB_MISS_STALL_DURATION)			\
__PMC_EV(P5, MMX_INSTRUCTION_DATA_READS)				\
__PMC_EV(P5, MMX_INSTRUCTION_DATA_READ_MISSES)				\
__PMC_EV(P5, FLOATING_POINT_STALLS_DURATION)				\
__PMC_EV(P5, TAKEN_BRANCHES)						\
__PMC_EV(P5, D1_STARVATION_AND_FIFO_IS_EMPTY)				\
__PMC_EV(P5, D1_STARVATION_AND_ONLY_ONE_INSTRUCTION_IN_FIFO)		\
__PMC_EV(P5, MMX_INSTRUCTION_DATA_WRITES)				\
__PMC_EV(P5, MMX_INSTRUCTION_DATA_WRITE_MISSES)				\
__PMC_EV(P5, PIPELINE_FLUSHES_DUE_TO_WRONG_BRANCH_PREDICTIONS)		\
__PMC_EV(P5,								\
    PIPELINE_FLUSHES_DUE_TO_WRONG_BRANCH_PREDICTIONS_RESOLVED_IN_WB_STAGE) \
__PMC_EV(P5, MISALIGNED_DATA_MEMORY_REFERENCE_ON_MMX_INSTRUCTIONS)	\
__PMC_EV(P5, PIPELINE_STALL_FOR_MMX_INSTRUCTION_DATA_MEMORY_READS)	\
__PMC_EV(P5, MISPREDICTED_OR_UNPREDICTED_RETURNS)			\
__PMC_EV(P5, PREDICTED_RETURNS)						\
__PMC_EV(P5, MMX_MULTIPLY_UNIT_INTERLOCK)				\
__PMC_EV(P5, MOVD_MOVQ_STORE_STALL_DUE_TO_PREVIOUS_MMX_OPERATION)	\
__PMC_EV(P5, RETURNS)							\
__PMC_EV(P5, BTB_FALSE_ENTRIES)						\
__PMC_EV(P5, BTB_MISS_PREDICTION_ON_NOT_TAKEN_BRANCH)			\
__PMC_EV(P5,								\
    FULL_WRITE_BUFFER_STALL_DURATION_WHILE_EXECUTING_MMX_INSTRUCTIONS)	\
__PMC_EV(P5, STALL_ON_MMX_INSTRUCTION_WRITE_TO_E_OR_M_STATE_LINE)

#define	PMC_EV_P5_FIRST		PMC_EV_P5_DATA_READ
#define	PMC_EV_P5_LAST	        \
	PMC_EV_P5_STALL_ON_MMX_INSTRUCTION_WRITE_TO_E_OR_M_STATE_LINE

/*
 * Events supported by Intel architectural fixed function counters,
 * from the "Intel 64 and IA-32 Architectures Software Developer's
 * Manual Volume 3B: System Programming Guide, Part 2", July 2008.
 */
#define	__PMC_EV_IAF()							\
__PMC_EV(IAF, INSTR_RETIRED_ANY)					\
__PMC_EV(IAF, CPU_CLK_UNHALTED_CORE)					\
__PMC_EV(IAF, CPU_CLK_UNHALTED_REF)

#define	PMC_EV_IAF_FIRST	PMC_EV_IAF_INSTR_RETIRED_ANY
#define	PMC_EV_IAF_LAST		PMC_EV_IAF_CPU_CLK_UNHALTED_REF

#define	__PMC_EV_ALIAS_IAF()						\
__PMC_EV_ALIAS("instruction-retired",	IAF_INSTR_RETIRED_ANY)		\
__PMC_EV_ALIAS("unhalted-core-cycles",	IAF_CPU_CLK_UNHALTED_CORE)	\
__PMC_EV_ALIAS("unhalted-reference-cycles", IAF_CPU_CLK_UNHALTED_REF)

/*
 * Events supported by programmable function counters present in
 * Intel Atom, Core and Core2 CPUs, from the "Intel 64 and IA-32
 * Architectures Software Developer's Manual Volume 3B: System Programming
 * Guide, Part 2", July 2008.
 *
 * These PMCs select events with a combination of an event code and
 * unit mask.  Quirks that need to be taken care of include:
 * - The set of (event code, umask) combinations supported by a processor
 *   varies according to the processor model.
 * - A given (event code, umask) combination need not measure the same
 *   hardware event in all processor models.
 * - Event names in vendor documentation for an (event code, umask) pair
 *   may vary according to the CPU model.
 * - Identically named events can map to different (event code, umask)
 *   pairs on different CPUs.
 * - New (event code, umask) combinations continue to be added as CPUs
 *   evolve.  The interface between hwpmc(4) and libpmc(3) needs to be
 *   robust with respect to ABI changes.
 *
 * The IAP_EVENT_* symbols below define the ABI between userland and kernel.
 * New (event code, * umask) combinations used in new CPUs would be added
 * to the end of the list.  Vendor names for events are mapped to IAP_EVENT_*
 * symbols using aliases.  The final disambiguation of semantics based on
 * the CPU model happens inside hwpmc(4).
 */
#define	__PMC_EV_IAP()				\
__PMC_EV(IAP, EVENT_02H_01H)			\
__PMC_EV(IAP, EVENT_02H_81H)			\
__PMC_EV(IAP, EVENT_03H_00H)			\
__PMC_EV(IAP, EVENT_03H_01H)			\
__PMC_EV(IAP, EVENT_03H_02H)			\
__PMC_EV(IAP, EVENT_03H_04H)			\
__PMC_EV(IAP, EVENT_03H_08H)			\
__PMC_EV(IAP, EVENT_03H_10H)			\
__PMC_EV(IAP, EVENT_03H_20H)			\
__PMC_EV(IAP, EVENT_04H_00H)			\
__PMC_EV(IAP, EVENT_04H_01H)			\
__PMC_EV(IAP, EVENT_04H_02H)			\
__PMC_EV(IAP, EVENT_04H_07H)			\
__PMC_EV(IAP, EVENT_04H_08H)			\
__PMC_EV(IAP, EVENT_05H_00H)			\
__PMC_EV(IAP, EVENT_05H_01H)			\
__PMC_EV(IAP, EVENT_05H_02H)			\
__PMC_EV(IAP, EVENT_05H_03H)			\
__PMC_EV(IAP, EVENT_06H_00H)			\
__PMC_EV(IAP, EVENT_06H_01H)			\
__PMC_EV(IAP, EVENT_06H_02H)			\
__PMC_EV(IAP, EVENT_06H_04H)			\
__PMC_EV(IAP, EVENT_06H_08H)			\
__PMC_EV(IAP, EVENT_06H_0FH)			\
__PMC_EV(IAP, EVENT_07H_00H)			\
__PMC_EV(IAP, EVENT_07H_01H)			\
__PMC_EV(IAP, EVENT_07H_02H)			\
__PMC_EV(IAP, EVENT_07H_03H)			\
__PMC_EV(IAP, EVENT_07H_06H)			\
__PMC_EV(IAP, EVENT_07H_08H)			\
__PMC_EV(IAP, EVENT_08H_01H)			\
__PMC_EV(IAP, EVENT_08H_02H)			\
__PMC_EV(IAP, EVENT_08H_04H)			\
__PMC_EV(IAP, EVENT_08H_05H)			\
__PMC_EV(IAP, EVENT_08H_06H)			\
__PMC_EV(IAP, EVENT_08H_07H)			\
__PMC_EV(IAP, EVENT_08H_08H)			\
__PMC_EV(IAP, EVENT_08H_09H)			\
__PMC_EV(IAP, EVENT_08H_10H)			\
__PMC_EV(IAP, EVENT_08H_20H)			\
__PMC_EV(IAP, EVENT_08H_40H)			\
__PMC_EV(IAP, EVENT_08H_80H)			\
__PMC_EV(IAP, EVENT_09H_01H)			\
__PMC_EV(IAP, EVENT_09H_02H)			\
__PMC_EV(IAP, EVENT_09H_04H)			\
__PMC_EV(IAP, EVENT_09H_08H)			\
__PMC_EV(IAP, EVENT_0BH_01H)			\
__PMC_EV(IAP, EVENT_0BH_02H)			\
__PMC_EV(IAP, EVENT_0BH_10H)			\
__PMC_EV(IAP, EVENT_0CH_01H)			\
__PMC_EV(IAP, EVENT_0CH_02H)			\
__PMC_EV(IAP, EVENT_0CH_03H)			\
__PMC_EV(IAP, EVENT_0EH_01H)			\
__PMC_EV(IAP, EVENT_0EH_02H)			\
__PMC_EV(IAP, EVENT_0FH_01H)			\
__PMC_EV(IAP, EVENT_0FH_02H)			\
__PMC_EV(IAP, EVENT_0FH_08H)			\
__PMC_EV(IAP, EVENT_0FH_10H)			\
__PMC_EV(IAP, EVENT_0FH_20H)			\
__PMC_EV(IAP, EVENT_0FH_80H)			\
__PMC_EV(IAP, EVENT_10H_00H)			\
__PMC_EV(IAP, EVENT_10H_01H)			\
__PMC_EV(IAP, EVENT_10H_02H)			\
__PMC_EV(IAP, EVENT_10H_04H)			\
__PMC_EV(IAP, EVENT_10H_08H)			\
__PMC_EV(IAP, EVENT_10H_10H)			\
__PMC_EV(IAP, EVENT_10H_20H)			\
__PMC_EV(IAP, EVENT_10H_40H)			\
__PMC_EV(IAP, EVENT_10H_80H)			\
__PMC_EV(IAP, EVENT_10H_81H)			\
__PMC_EV(IAP, EVENT_11H_00H)			\
__PMC_EV(IAP, EVENT_11H_01H)			\
__PMC_EV(IAP, EVENT_11H_81H)			\
__PMC_EV(IAP, EVENT_12H_00H)			\
__PMC_EV(IAP, EVENT_12H_01H)			\
__PMC_EV(IAP, EVENT_12H_02H)			\
__PMC_EV(IAP, EVENT_12H_04H)			\
__PMC_EV(IAP, EVENT_12H_08H)			\
__PMC_EV(IAP, EVENT_12H_10H)			\
__PMC_EV(IAP, EVENT_12H_20H)			\
__PMC_EV(IAP, EVENT_12H_40H)			\
__PMC_EV(IAP, EVENT_12H_81H)			\
__PMC_EV(IAP, EVENT_13H_00H)			\
__PMC_EV(IAP, EVENT_13H_01H)			\
__PMC_EV(IAP, EVENT_13H_02H)			\
__PMC_EV(IAP, EVENT_13H_04H)			\
__PMC_EV(IAP, EVENT_13H_07H)			\
__PMC_EV(IAP, EVENT_13H_81H)			\
__PMC_EV(IAP, EVENT_14H_00H)			\
__PMC_EV(IAP, EVENT_14H_01H)			\
__PMC_EV(IAP, EVENT_14H_02H)			\
__PMC_EV(IAP, EVENT_17H_01H)			\
__PMC_EV(IAP, EVENT_18H_00H)			\
__PMC_EV(IAP, EVENT_18H_01H)			\
__PMC_EV(IAP, EVENT_19H_00H)			\
__PMC_EV(IAP, EVENT_19H_01H)			\
__PMC_EV(IAP, EVENT_19H_02H)			\
__PMC_EV(IAP, EVENT_1DH_01H)			\
__PMC_EV(IAP, EVENT_1DH_02H)			\
__PMC_EV(IAP, EVENT_1DH_04H)			\
__PMC_EV(IAP, EVENT_1EH_01H)			\
__PMC_EV(IAP, EVENT_20H_01H)			\
__PMC_EV(IAP, EVENT_21H)			\
__PMC_EV(IAP, EVENT_22H)			\
__PMC_EV(IAP, EVENT_23H)			\
__PMC_EV(IAP, EVENT_24H)			\
__PMC_EV(IAP, EVENT_24H_01H)			\
__PMC_EV(IAP, EVENT_24H_02H)			\
__PMC_EV(IAP, EVENT_24H_03H)			\
__PMC_EV(IAP, EVENT_24H_04H)			\
__PMC_EV(IAP, EVENT_24H_08H)			\
__PMC_EV(IAP, EVENT_24H_0CH)			\
__PMC_EV(IAP, EVENT_24H_10H)			\
__PMC_EV(IAP, EVENT_24H_20H)			\
__PMC_EV(IAP, EVENT_24H_30H)			\
__PMC_EV(IAP, EVENT_24H_40H)			\
__PMC_EV(IAP, EVENT_24H_80H)			\
__PMC_EV(IAP, EVENT_24H_AAH)			\
__PMC_EV(IAP, EVENT_24H_C0H)			\
__PMC_EV(IAP, EVENT_24H_FFH)			\
__PMC_EV(IAP, EVENT_25H)			\
__PMC_EV(IAP, EVENT_26H)			\
__PMC_EV(IAP, EVENT_26H_01H)			\
__PMC_EV(IAP, EVENT_26H_02H)			\
__PMC_EV(IAP, EVENT_26H_04H)			\
__PMC_EV(IAP, EVENT_26H_08H)			\
__PMC_EV(IAP, EVENT_26H_0FH)			\
__PMC_EV(IAP, EVENT_26H_10H)			\
__PMC_EV(IAP, EVENT_26H_20H)			\
__PMC_EV(IAP, EVENT_26H_40H)			\
__PMC_EV(IAP, EVENT_26H_80H)			\
__PMC_EV(IAP, EVENT_26H_F0H)			\
__PMC_EV(IAP, EVENT_26H_FFH)			\
__PMC_EV(IAP, EVENT_27H)			\
__PMC_EV(IAP, EVENT_27H_01H)			\
__PMC_EV(IAP, EVENT_27H_02H)			\
__PMC_EV(IAP, EVENT_27H_04H)			\
__PMC_EV(IAP, EVENT_27H_08H)			\
__PMC_EV(IAP, EVENT_27H_0EH)			\
__PMC_EV(IAP, EVENT_27H_0FH)			\
__PMC_EV(IAP, EVENT_27H_10H)			\
__PMC_EV(IAP, EVENT_27H_20H)			\
__PMC_EV(IAP, EVENT_27H_40H)			\
__PMC_EV(IAP, EVENT_27H_80H)			\
__PMC_EV(IAP, EVENT_27H_E0H)			\
__PMC_EV(IAP, EVENT_27H_F0H)			\
__PMC_EV(IAP, EVENT_28H)			\
__PMC_EV(IAP, EVENT_28H_01H)			\
__PMC_EV(IAP, EVENT_28H_02H)			\
__PMC_EV(IAP, EVENT_28H_04H)			\
__PMC_EV(IAP, EVENT_28H_08H)			\
__PMC_EV(IAP, EVENT_28H_0FH)			\
__PMC_EV(IAP, EVENT_29H)			\
__PMC_EV(IAP, EVENT_2AH)			\
__PMC_EV(IAP, EVENT_2BH)			\
__PMC_EV(IAP, EVENT_2EH)			\
__PMC_EV(IAP, EVENT_2EH_01H)			\
__PMC_EV(IAP, EVENT_2EH_02H)			\
__PMC_EV(IAP, EVENT_2EH_41H)			\
__PMC_EV(IAP, EVENT_2EH_4FH)			\
__PMC_EV(IAP, EVENT_30H)			\
__PMC_EV(IAP, EVENT_32H)			\
__PMC_EV(IAP, EVENT_3AH)			\
__PMC_EV(IAP, EVENT_3AH_00H)			\
__PMC_EV(IAP, EVENT_3BH_C0H)			\
__PMC_EV(IAP, EVENT_3CH_00H)			\
__PMC_EV(IAP, EVENT_3CH_01H)			\
__PMC_EV(IAP, EVENT_3CH_02H)			\
__PMC_EV(IAP, EVENT_3DH_01H)			\
__PMC_EV(IAP, EVENT_40H)			\
__PMC_EV(IAP, EVENT_40H_01H)			\
__PMC_EV(IAP, EVENT_40H_02H)			\
__PMC_EV(IAP, EVENT_40H_04H)			\
__PMC_EV(IAP, EVENT_40H_08H)			\
__PMC_EV(IAP, EVENT_40H_0FH)			\
__PMC_EV(IAP, EVENT_40H_21H)			\
__PMC_EV(IAP, EVENT_41H)			\
__PMC_EV(IAP, EVENT_41H_01H)			\
__PMC_EV(IAP, EVENT_41H_02H)			\
__PMC_EV(IAP, EVENT_41H_04H)			\
__PMC_EV(IAP, EVENT_41H_08H)			\
__PMC_EV(IAP, EVENT_41H_0FH)			\
__PMC_EV(IAP, EVENT_41H_22H)			\
__PMC_EV(IAP, EVENT_42H)			\
__PMC_EV(IAP, EVENT_42H_01H)			\
__PMC_EV(IAP, EVENT_42H_02H)			\
__PMC_EV(IAP, EVENT_42H_04H)			\
__PMC_EV(IAP, EVENT_42H_08H)			\
__PMC_EV(IAP, EVENT_42H_10H)			\
__PMC_EV(IAP, EVENT_43H_01H)			\
__PMC_EV(IAP, EVENT_43H_02H)			\
__PMC_EV(IAP, EVENT_44H_02H)			\
__PMC_EV(IAP, EVENT_45H_0FH)			\
__PMC_EV(IAP, EVENT_46H_00H)			\
__PMC_EV(IAP, EVENT_47H_00H)			\
__PMC_EV(IAP, EVENT_48H_00H)			\
__PMC_EV(IAP, EVENT_48H_02H)			\
__PMC_EV(IAP, EVENT_49H_00H)			\
__PMC_EV(IAP, EVENT_49H_01H)			\
__PMC_EV(IAP, EVENT_49H_02H)			\
__PMC_EV(IAP, EVENT_49H_04H)			\
__PMC_EV(IAP, EVENT_49H_10H)			\
__PMC_EV(IAP, EVENT_49H_20H)			\
__PMC_EV(IAP, EVENT_49H_40H)			\
__PMC_EV(IAP, EVENT_49H_80H)			\
__PMC_EV(IAP, EVENT_4BH_00H)			\
__PMC_EV(IAP, EVENT_4BH_01H)			\
__PMC_EV(IAP, EVENT_4BH_02H)			\
__PMC_EV(IAP, EVENT_4BH_03H)			\
__PMC_EV(IAP, EVENT_4BH_08H)			\
__PMC_EV(IAP, EVENT_4CH_00H)			\
__PMC_EV(IAP, EVENT_4CH_01H)			\
__PMC_EV(IAP, EVENT_4DH_01H)			\
__PMC_EV(IAP, EVENT_4EH_01H)			\
__PMC_EV(IAP, EVENT_4EH_02H)			\
__PMC_EV(IAP, EVENT_4EH_04H)			\
__PMC_EV(IAP, EVENT_4EH_10H)			\
__PMC_EV(IAP, EVENT_4FH_00H)			\
__PMC_EV(IAP, EVENT_4FH_02H)			\
__PMC_EV(IAP, EVENT_4FH_04H)			\
__PMC_EV(IAP, EVENT_4FH_08H)			\
__PMC_EV(IAP, EVENT_4FH_10H)			\
__PMC_EV(IAP, EVENT_51H_01H)			\
__PMC_EV(IAP, EVENT_51H_02H)			\
__PMC_EV(IAP, EVENT_51H_04H)			\
__PMC_EV(IAP, EVENT_51H_08H)			\
__PMC_EV(IAP, EVENT_52H_01H)			\
__PMC_EV(IAP, EVENT_53H_01H)			\
__PMC_EV(IAP, EVENT_60H)			\
__PMC_EV(IAP, EVENT_60H_01H)			\
__PMC_EV(IAP, EVENT_60H_02H)			\
__PMC_EV(IAP, EVENT_60H_04H)			\
__PMC_EV(IAP, EVENT_60H_08H)			\
__PMC_EV(IAP, EVENT_61H)			\
__PMC_EV(IAP, EVENT_61H_00H)			\
__PMC_EV(IAP, EVENT_62H)			\
__PMC_EV(IAP, EVENT_62H_00H)			\
__PMC_EV(IAP, EVENT_63H)			\
__PMC_EV(IAP, EVENT_63H_01H)			\
__PMC_EV(IAP, EVENT_63H_02H)			\
__PMC_EV(IAP, EVENT_64H)			\
__PMC_EV(IAP, EVENT_64H_40H)			\
__PMC_EV(IAP, EVENT_65H)			\
__PMC_EV(IAP, EVENT_66H)			\
__PMC_EV(IAP, EVENT_67H)			\
__PMC_EV(IAP, EVENT_68H)			\
__PMC_EV(IAP, EVENT_69H)			\
__PMC_EV(IAP, EVENT_6AH)			\
__PMC_EV(IAP, EVENT_6BH)			\
__PMC_EV(IAP, EVENT_6CH)			\
__PMC_EV(IAP, EVENT_6CH_01H)			\
__PMC_EV(IAP, EVENT_6DH)			\
__PMC_EV(IAP, EVENT_6EH)			\
__PMC_EV(IAP, EVENT_6FH)			\
__PMC_EV(IAP, EVENT_70H)			\
__PMC_EV(IAP, EVENT_77H)			\
__PMC_EV(IAP, EVENT_78H)			\
__PMC_EV(IAP, EVENT_7AH)			\
__PMC_EV(IAP, EVENT_7BH)			\
__PMC_EV(IAP, EVENT_7DH)			\
__PMC_EV(IAP, EVENT_7EH)			\
__PMC_EV(IAP, EVENT_7EH_00H)			\
__PMC_EV(IAP, EVENT_7FH)			\
__PMC_EV(IAP, EVENT_80H_00H)			\
__PMC_EV(IAP, EVENT_80H_01H)			\
__PMC_EV(IAP, EVENT_80H_02H)			\
__PMC_EV(IAP, EVENT_80H_03H)			\
__PMC_EV(IAP, EVENT_80H_04H)			\
__PMC_EV(IAP, EVENT_80H_10H)			\
__PMC_EV(IAP, EVENT_81H_00H)			\
__PMC_EV(IAP, EVENT_81H_01H)			\
__PMC_EV(IAP, EVENT_81H_02H)			\
__PMC_EV(IAP, EVENT_82H_01H)			\
__PMC_EV(IAP, EVENT_82H_02H)			\
__PMC_EV(IAP, EVENT_82H_04H)			\
__PMC_EV(IAP, EVENT_82H_10H)			\
__PMC_EV(IAP, EVENT_82H_12H)			\
__PMC_EV(IAP, EVENT_82H_40H)			\
__PMC_EV(IAP, EVENT_83H_01H)			\
__PMC_EV(IAP, EVENT_83H_02H)			\
__PMC_EV(IAP, EVENT_85H_00H)			\
__PMC_EV(IAP, EVENT_85H_01H)			\
__PMC_EV(IAP, EVENT_85H_02H)			\
__PMC_EV(IAP, EVENT_85H_04H)			\
__PMC_EV(IAP, EVENT_85H_10H)			\
__PMC_EV(IAP, EVENT_85H_20H)			\
__PMC_EV(IAP, EVENT_85H_40H)			\
__PMC_EV(IAP, EVENT_85H_80H)			\
__PMC_EV(IAP, EVENT_86H_00H)			\
__PMC_EV(IAP, EVENT_87H_00H)			\
__PMC_EV(IAP, EVENT_87H_01H)			\
__PMC_EV(IAP, EVENT_87H_02H)			\
__PMC_EV(IAP, EVENT_87H_04H)			\
__PMC_EV(IAP, EVENT_87H_08H)			\
__PMC_EV(IAP, EVENT_87H_0FH)			\
__PMC_EV(IAP, EVENT_88H_00H)			\
__PMC_EV(IAP, EVENT_88H_01H)			\
__PMC_EV(IAP, EVENT_88H_02H)			\
__PMC_EV(IAP, EVENT_88H_04H)			\
__PMC_EV(IAP, EVENT_88H_07H)			\
__PMC_EV(IAP, EVENT_88H_08H)			\
__PMC_EV(IAP, EVENT_88H_10H)			\
__PMC_EV(IAP, EVENT_88H_20H)			\
__PMC_EV(IAP, EVENT_88H_30H)			\
__PMC_EV(IAP, EVENT_88H_40H)			\
__PMC_EV(IAP, EVENT_88H_7FH)			\
__PMC_EV(IAP, EVENT_89H_00H)			\
__PMC_EV(IAP, EVENT_89H_01H)			\
__PMC_EV(IAP, EVENT_89H_02H)			\
__PMC_EV(IAP, EVENT_89H_04H)			\
__PMC_EV(IAP, EVENT_89H_07H)			\
__PMC_EV(IAP, EVENT_89H_08H)			\
__PMC_EV(IAP, EVENT_89H_10H)			\
__PMC_EV(IAP, EVENT_89H_20H)			\
__PMC_EV(IAP, EVENT_89H_30H)			\
__PMC_EV(IAP, EVENT_89H_40H)			\
__PMC_EV(IAP, EVENT_89H_7FH)			\
__PMC_EV(IAP, EVENT_8AH_00H)			\
__PMC_EV(IAP, EVENT_8BH_00H)			\
__PMC_EV(IAP, EVENT_8CH_00H)			\
__PMC_EV(IAP, EVENT_8DH_00H)			\
__PMC_EV(IAP, EVENT_8EH_00H)			\
__PMC_EV(IAP, EVENT_8FH_00H)			\
__PMC_EV(IAP, EVENT_90H_00H)			\
__PMC_EV(IAP, EVENT_91H_00H)			\
__PMC_EV(IAP, EVENT_92H_00H)			\
__PMC_EV(IAP, EVENT_93H_00H)			\
__PMC_EV(IAP, EVENT_94H_00H)			\
__PMC_EV(IAP, EVENT_97H_00H)			\
__PMC_EV(IAP, EVENT_98H_00H)			\
__PMC_EV(IAP, EVENT_A0H_00H)			\
__PMC_EV(IAP, EVENT_A1H_01H)			\
__PMC_EV(IAP, EVENT_A1H_02H)			\
__PMC_EV(IAP, EVENT_A1H_04H)			\
__PMC_EV(IAP, EVENT_A1H_08H)			\
__PMC_EV(IAP, EVENT_A1H_10H)			\
__PMC_EV(IAP, EVENT_A1H_20H)			\
__PMC_EV(IAP, EVENT_A2H_00H)			\
__PMC_EV(IAP, EVENT_A2H_01H)			\
__PMC_EV(IAP, EVENT_A2H_02H)			\
__PMC_EV(IAP, EVENT_A2H_04H)			\
__PMC_EV(IAP, EVENT_A2H_08H)			\
__PMC_EV(IAP, EVENT_A2H_10H)			\
__PMC_EV(IAP, EVENT_A2H_20H)			\
__PMC_EV(IAP, EVENT_A2H_40H)			\
__PMC_EV(IAP, EVENT_A2H_80H)			\
__PMC_EV(IAP, EVENT_A6H_01H)			\
__PMC_EV(IAP, EVENT_A7H_01H)			\
__PMC_EV(IAP, EVENT_A8H_01H)			\
__PMC_EV(IAP, EVENT_AAH_01H)			\
__PMC_EV(IAP, EVENT_AAH_02H)			\
__PMC_EV(IAP, EVENT_AAH_03H)			\
__PMC_EV(IAP, EVENT_AAH_08H)			\
__PMC_EV(IAP, EVENT_ABH_01H)			\
__PMC_EV(IAP, EVENT_ABH_02H)			\
__PMC_EV(IAP, EVENT_AEH_01H)			\
__PMC_EV(IAP, EVENT_B0H_00H)			\
__PMC_EV(IAP, EVENT_B0H_01H)			\
__PMC_EV(IAP, EVENT_B0H_02H)			\
__PMC_EV(IAP, EVENT_B0H_04H)			\
__PMC_EV(IAP, EVENT_B0H_08H)			\
__PMC_EV(IAP, EVENT_B0H_10H)			\
__PMC_EV(IAP, EVENT_B0H_20H)			\
__PMC_EV(IAP, EVENT_B0H_40H)			\
__PMC_EV(IAP, EVENT_B0H_80H)			\
__PMC_EV(IAP, EVENT_B1H_00H)			\
__PMC_EV(IAP, EVENT_B1H_01H)			\
__PMC_EV(IAP, EVENT_B1H_02H)			\
__PMC_EV(IAP, EVENT_B1H_04H)			\
__PMC_EV(IAP, EVENT_B1H_08H)			\
__PMC_EV(IAP, EVENT_B1H_10H)			\
__PMC_EV(IAP, EVENT_B1H_1FH)			\
__PMC_EV(IAP, EVENT_B1H_20H)			\
__PMC_EV(IAP, EVENT_B1H_3FH)			\
__PMC_EV(IAP, EVENT_B1H_40H)			\
__PMC_EV(IAP, EVENT_B1H_80H)			\
__PMC_EV(IAP, EVENT_B2H_01H)			\
__PMC_EV(IAP, EVENT_B3H_01H)			\
__PMC_EV(IAP, EVENT_B3H_02H)			\
__PMC_EV(IAP, EVENT_B3H_04H)			\
__PMC_EV(IAP, EVENT_B3H_08H)			\
__PMC_EV(IAP, EVENT_B3H_10H)			\
__PMC_EV(IAP, EVENT_B3H_20H)			\
__PMC_EV(IAP, EVENT_B3H_81H)			\
__PMC_EV(IAP, EVENT_B3H_82H)			\
__PMC_EV(IAP, EVENT_B3H_84H)			\
__PMC_EV(IAP, EVENT_B3H_88H)			\
__PMC_EV(IAP, EVENT_B3H_90H)			\
__PMC_EV(IAP, EVENT_B3H_A0H)			\
__PMC_EV(IAP, EVENT_B4H_01H)			\
__PMC_EV(IAP, EVENT_B4H_02H)			\
__PMC_EV(IAP, EVENT_B4H_04H)			\
__PMC_EV(IAP, EVENT_B7H_01H)			\
__PMC_EV(IAP, EVENT_B8H_01H)			\
__PMC_EV(IAP, EVENT_B8H_02H)			\
__PMC_EV(IAP, EVENT_B8H_04H)			\
__PMC_EV(IAP, EVENT_BAH_01H)			\
__PMC_EV(IAP, EVENT_BAH_02H)			\
__PMC_EV(IAP, EVENT_BBH_01H)			\
__PMC_EV(IAP, EVENT_C0H_00H)			\
__PMC_EV(IAP, EVENT_C0H_01H)			\
__PMC_EV(IAP, EVENT_C0H_02H)			\
__PMC_EV(IAP, EVENT_C0H_04H)			\
__PMC_EV(IAP, EVENT_C0H_08H)			\
__PMC_EV(IAP, EVENT_C1H_00H)			\
__PMC_EV(IAP, EVENT_C1H_01H)			\
__PMC_EV(IAP, EVENT_C1H_FEH)			\
__PMC_EV(IAP, EVENT_C2H_00H)			\
__PMC_EV(IAP, EVENT_C2H_01H)			\
__PMC_EV(IAP, EVENT_C2H_02H)			\
__PMC_EV(IAP, EVENT_C2H_04H)			\
__PMC_EV(IAP, EVENT_C2H_07H)			\
__PMC_EV(IAP, EVENT_C2H_08H)			\
__PMC_EV(IAP, EVENT_C2H_0FH)			\
__PMC_EV(IAP, EVENT_C2H_10H)			\
__PMC_EV(IAP, EVENT_C3H_00H)			\
__PMC_EV(IAP, EVENT_C3H_01H)			\
__PMC_EV(IAP, EVENT_C3H_02H)			\
__PMC_EV(IAP, EVENT_C3H_04H)			\
__PMC_EV(IAP, EVENT_C3H_10H)			\
__PMC_EV(IAP, EVENT_C4H_00H)			\
__PMC_EV(IAP, EVENT_C4H_01H)			\
__PMC_EV(IAP, EVENT_C4H_02H)			\
__PMC_EV(IAP, EVENT_C4H_04H)			\
__PMC_EV(IAP, EVENT_C4H_08H)			\
__PMC_EV(IAP, EVENT_C4H_0CH)			\
__PMC_EV(IAP, EVENT_C4H_0FH)			\
__PMC_EV(IAP, EVENT_C5H_00H)			\
__PMC_EV(IAP, EVENT_C5H_01H)			\
__PMC_EV(IAP, EVENT_C5H_02H)			\
__PMC_EV(IAP, EVENT_C5H_04H)			\
__PMC_EV(IAP, EVENT_C6H_00H)			\
__PMC_EV(IAP, EVENT_C6H_01H)			\
__PMC_EV(IAP, EVENT_C6H_02H)			\
__PMC_EV(IAP, EVENT_C7H_00H)			\
__PMC_EV(IAP, EVENT_C7H_01H)			\
__PMC_EV(IAP, EVENT_C7H_02H)			\
__PMC_EV(IAP, EVENT_C7H_04H)			\
__PMC_EV(IAP, EVENT_C7H_08H)			\
__PMC_EV(IAP, EVENT_C7H_10H)			\
__PMC_EV(IAP, EVENT_C7H_1FH)			\
__PMC_EV(IAP, EVENT_C8H_00H)			\
__PMC_EV(IAP, EVENT_C8H_20H)			\
__PMC_EV(IAP, EVENT_C9H_00H)			\
__PMC_EV(IAP, EVENT_CAH_00H)			\
__PMC_EV(IAP, EVENT_CAH_01H)			\
__PMC_EV(IAP, EVENT_CAH_02H)			\
__PMC_EV(IAP, EVENT_CAH_04H)			\
__PMC_EV(IAP, EVENT_CAH_08H)			\
__PMC_EV(IAP, EVENT_CBH_01H)			\
__PMC_EV(IAP, EVENT_CBH_02H)			\
__PMC_EV(IAP, EVENT_CBH_04H)			\
__PMC_EV(IAP, EVENT_CBH_08H)			\
__PMC_EV(IAP, EVENT_CBH_10H)			\
__PMC_EV(IAP, EVENT_CBH_40H)			\
__PMC_EV(IAP, EVENT_CBH_80H)			\
__PMC_EV(IAP, EVENT_CCH_00H)			\
__PMC_EV(IAP, EVENT_CCH_01H)			\
__PMC_EV(IAP, EVENT_CCH_02H)			\
__PMC_EV(IAP, EVENT_CCH_03H)			\
__PMC_EV(IAP, EVENT_CDH_00H)			\
__PMC_EV(IAP, EVENT_CEH_00H)			\
__PMC_EV(IAP, EVENT_CFH_00H)			\
__PMC_EV(IAP, EVENT_D0H_00H)			\
__PMC_EV(IAP, EVENT_D0H_01H)			\
__PMC_EV(IAP, EVENT_D1H_01H)			\
__PMC_EV(IAP, EVENT_D1H_02H)			\
__PMC_EV(IAP, EVENT_D1H_04H)			\
__PMC_EV(IAP, EVENT_D1H_08H)			\
__PMC_EV(IAP, EVENT_D2H_01H)			\
__PMC_EV(IAP, EVENT_D2H_02H)			\
__PMC_EV(IAP, EVENT_D2H_04H)			\
__PMC_EV(IAP, EVENT_D2H_08H)			\
__PMC_EV(IAP, EVENT_D2H_0FH)			\
__PMC_EV(IAP, EVENT_D2H_10H)			\
__PMC_EV(IAP, EVENT_D4H_01H)			\
__PMC_EV(IAP, EVENT_D4H_02H)			\
__PMC_EV(IAP, EVENT_D4H_04H)			\
__PMC_EV(IAP, EVENT_D4H_08H)			\
__PMC_EV(IAP, EVENT_D4H_0FH)			\
__PMC_EV(IAP, EVENT_D5H_01H)			\
__PMC_EV(IAP, EVENT_D5H_02H)			\
__PMC_EV(IAP, EVENT_D5H_04H)			\
__PMC_EV(IAP, EVENT_D5H_08H)			\
__PMC_EV(IAP, EVENT_D5H_0FH)			\
__PMC_EV(IAP, EVENT_D7H_00H)			\
__PMC_EV(IAP, EVENT_D8H_00H)			\
__PMC_EV(IAP, EVENT_D8H_01H)			\
__PMC_EV(IAP, EVENT_D8H_02H)			\
__PMC_EV(IAP, EVENT_D8H_03H)			\
__PMC_EV(IAP, EVENT_D8H_04H)			\
__PMC_EV(IAP, EVENT_D9H_00H)			\
__PMC_EV(IAP, EVENT_D9H_01H)			\
__PMC_EV(IAP, EVENT_D9H_02H)			\
__PMC_EV(IAP, EVENT_D9H_03H)			\
__PMC_EV(IAP, EVENT_DAH_00H)			\
__PMC_EV(IAP, EVENT_DAH_01H)			\
__PMC_EV(IAP, EVENT_DAH_02H)			\
__PMC_EV(IAP, EVENT_DBH_00H)			\
__PMC_EV(IAP, EVENT_DBH_01H)			\
__PMC_EV(IAP, EVENT_DCH_01H)			\
__PMC_EV(IAP, EVENT_DCH_02H)			\
__PMC_EV(IAP, EVENT_DCH_04H)			\
__PMC_EV(IAP, EVENT_DCH_08H)			\
__PMC_EV(IAP, EVENT_DCH_10H)			\
__PMC_EV(IAP, EVENT_DCH_1FH)			\
__PMC_EV(IAP, EVENT_E0H_00H)			\
__PMC_EV(IAP, EVENT_E0H_01H)			\
__PMC_EV(IAP, EVENT_E2H_00H)			\
__PMC_EV(IAP, EVENT_E4H_00H)			\
__PMC_EV(IAP, EVENT_E4H_01H)			\
__PMC_EV(IAP, EVENT_E5H_01H)			\
__PMC_EV(IAP, EVENT_E6H_00H)			\
__PMC_EV(IAP, EVENT_E6H_01H)			\
__PMC_EV(IAP, EVENT_E6H_02H)			\
__PMC_EV(IAP, EVENT_E8H_01H)			\
__PMC_EV(IAP, EVENT_E8H_02H)			\
__PMC_EV(IAP, EVENT_E8H_03H)			\
__PMC_EV(IAP, EVENT_ECH_01H)			\
__PMC_EV(IAP, EVENT_F0H_00H)			\
__PMC_EV(IAP, EVENT_F0H_01H)			\
__PMC_EV(IAP, EVENT_F0H_02H)			\
__PMC_EV(IAP, EVENT_F0H_04H)			\
__PMC_EV(IAP, EVENT_F0H_08H)			\
__PMC_EV(IAP, EVENT_F0H_10H)			\
__PMC_EV(IAP, EVENT_F0H_20H)			\
__PMC_EV(IAP, EVENT_F0H_40H)			\
__PMC_EV(IAP, EVENT_F0H_80H)			\
__PMC_EV(IAP, EVENT_F1H_02H)			\
__PMC_EV(IAP, EVENT_F1H_04H)			\
__PMC_EV(IAP, EVENT_F1H_07H)			\
__PMC_EV(IAP, EVENT_F2H_01H)			\
__PMC_EV(IAP, EVENT_F2H_02H)			\
__PMC_EV(IAP, EVENT_F2H_04H)			\
__PMC_EV(IAP, EVENT_F2H_08H)			\
__PMC_EV(IAP, EVENT_F2H_0FH)			\
__PMC_EV(IAP, EVENT_F3H_01H)			\
__PMC_EV(IAP, EVENT_F3H_02H)			\
__PMC_EV(IAP, EVENT_F3H_04H)			\
__PMC_EV(IAP, EVENT_F3H_08H)			\
__PMC_EV(IAP, EVENT_F3H_10H)			\
__PMC_EV(IAP, EVENT_F3H_20H)			\
__PMC_EV(IAP, EVENT_F4H_01H)			\
__PMC_EV(IAP, EVENT_F4H_02H)			\
__PMC_EV(IAP, EVENT_F4H_04H)			\
__PMC_EV(IAP, EVENT_F4H_08H)			\
__PMC_EV(IAP, EVENT_F4H_10H)			\
__PMC_EV(IAP, EVENT_F6H_01H)			\
__PMC_EV(IAP, EVENT_F7H_01H)			\
__PMC_EV(IAP, EVENT_F7H_02H)			\
__PMC_EV(IAP, EVENT_F7H_04H)			\
__PMC_EV(IAP, EVENT_F8H_00H)			\
__PMC_EV(IAP, EVENT_F8H_01H)			\
__PMC_EV(IAP, EVENT_FDH_01H)			\
__PMC_EV(IAP, EVENT_FDH_02H)			\
__PMC_EV(IAP, EVENT_FDH_04H)			\
__PMC_EV(IAP, EVENT_FDH_08H)			\
__PMC_EV(IAP, EVENT_FDH_10H)			\
__PMC_EV(IAP, EVENT_FDH_20H)			\
__PMC_EV(IAP, EVENT_FDH_40H)

#define	PMC_EV_IAP_FIRST	PMC_EV_IAP_EVENT_02H_01H
#define	PMC_EV_IAP_LAST		PMC_EV_IAP_EVENT_FDH_40H

/*
 * Map "architectural" event names to event ids.
 */
#define	__PMC_EV_ALIAS_INTEL_ARCHITECTURAL()				\
__PMC_EV_ALIAS("branch-instruction-retired",	IAP_EVENT_C4H_00H)	\
__PMC_EV_ALIAS("branch-misses-retired",		IAP_EVENT_C5H_00H)	\
__PMC_EV_ALIAS("instruction-retired",		IAP_EVENT_C0H_00H)	\
__PMC_EV_ALIAS("llc-misses",			IAP_EVENT_2EH_41H)	\
__PMC_EV_ALIAS("llc-reference",			IAP_EVENT_2EH_4FH)	\
__PMC_EV_ALIAS("unhalted-reference-cycles",	IAP_EVENT_3CH_01H)	\
__PMC_EV_ALIAS("unhalted-core-cycles",		IAP_EVENT_3CH_00H)

/*
 * Aliases for Atom PMCs.
 */
#define	__PMC_EV_ALIAS_ATOM()						\
__PMC_EV_ALIAS_INTEL_ARCHITECTURAL()					\
__PMC_EV_ALIAS("BACLEARS",			IAP_EVENT_E6H_01H)	\
__PMC_EV_ALIAS("BOGUS_BR",			IAP_EVENT_E4H_00H)	\
__PMC_EV_ALIAS("BR_BAC_MISSP_EXEC",		IAP_EVENT_8AH_00H)	\
__PMC_EV_ALIAS("BR_CALL_EXEC",			IAP_EVENT_92H_00H)	\
__PMC_EV_ALIAS("BR_CALL_MISSP_EXEC",		IAP_EVENT_93H_00H)	\
__PMC_EV_ALIAS("BR_CND_EXEC",			IAP_EVENT_8BH_00H)	\
__PMC_EV_ALIAS("BR_CND_MISSP_EXEC",		IAP_EVENT_8CH_00H)	\
__PMC_EV_ALIAS("BR_IND_CALL_EXEC",		IAP_EVENT_94H_00H)	\
__PMC_EV_ALIAS("BR_IND_EXEC",			IAP_EVENT_8DH_00H)	\
__PMC_EV_ALIAS("BR_IND_MISSP_EXEC",		IAP_EVENT_8EH_00H)	\
__PMC_EV_ALIAS("BR_INST_DECODED",		IAP_EVENT_E0H_01H)	\
__PMC_EV_ALIAS("BR_INST_EXEC",			IAP_EVENT_88H_00H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.ANY",		IAP_EVENT_C4H_00H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.ANY1",		IAP_EVENT_C4H_0FH)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.MISPRED",	IAP_EVENT_C5H_00H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.MISPRED_NOT_TAKEN",			\
    IAP_EVENT_C4H_02H)							\
__PMC_EV_ALIAS("BR_INST_RETIRED.MISPRED_TAKEN",	IAP_EVENT_C4H_08H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.PRED_NOT_TAKEN",IAP_EVENT_C4H_01H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.PRED_TAKEN",	IAP_EVENT_C4H_04H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.TAKEN",		IAP_EVENT_C4H_0CH)	\
__PMC_EV_ALIAS("BR_MISSP_EXEC",			IAP_EVENT_89H_00H)	\
__PMC_EV_ALIAS("BR_RET_BAC_MISSP_EXEC",		IAP_EVENT_91H_00H)	\
__PMC_EV_ALIAS("BR_RET_EXEC",			IAP_EVENT_8FH_00H)	\
__PMC_EV_ALIAS("BR_RET_MISSP_EXEC",		IAP_EVENT_90H_00H)	\
__PMC_EV_ALIAS("BR_TKN_BUBBLE_1",		IAP_EVENT_97H_00H)	\
__PMC_EV_ALIAS("BR_TKN_BUBBLE_2",		IAP_EVENT_98H_00H)	\
__PMC_EV_ALIAS("BUSQ_EMPTY",			IAP_EVENT_7DH)		\
__PMC_EV_ALIAS("BUS_BNR_DRV",			IAP_EVENT_61H)		\
__PMC_EV_ALIAS("BUS_DATA_RCV",			IAP_EVENT_64H)		\
__PMC_EV_ALIAS("BUS_DRDY_CLOCKS",		IAP_EVENT_62H)		\
__PMC_EV_ALIAS("BUS_HITM_DRV",			IAP_EVENT_7BH)		\
__PMC_EV_ALIAS("BUS_HIT_DRV",			IAP_EVENT_7AH)		\
__PMC_EV_ALIAS("BUS_IO_WAIT",			IAP_EVENT_7FH)		\
__PMC_EV_ALIAS("BUS_LOCK_CLOCKS",		IAP_EVENT_63H)		\
__PMC_EV_ALIAS("BUS_REQUEST_OUTSTANDING",	IAP_EVENT_60H)		\
__PMC_EV_ALIAS("BUS_TRANS_ANY",			IAP_EVENT_70H)		\
__PMC_EV_ALIAS("BUS_TRANS_BRD",			IAP_EVENT_65H)		\
__PMC_EV_ALIAS("BUS_TRANS_BURST",		IAP_EVENT_6EH)		\
__PMC_EV_ALIAS("BUS_TRANS_DEF",			IAP_EVENT_6DH)		\
__PMC_EV_ALIAS("BUS_TRANS_IFETCH",		IAP_EVENT_68H)		\
__PMC_EV_ALIAS("BUS_TRANS_INVAL",		IAP_EVENT_69H)		\
__PMC_EV_ALIAS("BUS_TRANS_IO",			IAP_EVENT_6CH)		\
__PMC_EV_ALIAS("BUS_TRANS_MEM",			IAP_EVENT_6FH)		\
__PMC_EV_ALIAS("BUS_TRANS_P",			IAP_EVENT_6BH)		\
__PMC_EV_ALIAS("BUS_TRANS_PWR",			IAP_EVENT_6AH)		\
__PMC_EV_ALIAS("BUS_TRANS_RFO",			IAP_EVENT_66H)		\
__PMC_EV_ALIAS("BUS_TRANS_WB",			IAP_EVENT_67H)		\
__PMC_EV_ALIAS("CMP_SNOOP",			IAP_EVENT_78H)		\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.BUS",		IAP_EVENT_3CH_01H)	\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.CORE_P",	IAP_EVENT_3CH_00H)	\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.NO_OTHER",	IAP_EVENT_3CH_02H)	\
__PMC_EV_ALIAS("CYCLES_DIV_BUSY",		IAP_EVENT_14H_01H)	\
__PMC_EV_ALIAS("CYCLES_INT_MASKED.CYCLES_INT_MASKED",			\
    IAP_EVENT_C6H_01H)							\
__PMC_EV_ALIAS("CYCLES_INT_MASKED.CYCLES_INT_PENDING_AND_MASKED",	\
    IAP_EVENT_C6H_02H)							\
__PMC_EV_ALIAS("CYCLES_L1I_MEM_STALLED",	IAP_EVENT_86H_00H)	\
__PMC_EV_ALIAS("DATA_TLB_MISSES.DTLB_MISS",	IAP_EVENT_08H_07H)	\
__PMC_EV_ALIAS("DATA_TLB_MISSES.DTLB_MISS_LD",	IAP_EVENT_08H_05H)	\
__PMC_EV_ALIAS("DATA_TLB_MISSES.DTLB_MISS_ST",	IAP_EVENT_08H_06H)	\
__PMC_EV_ALIAS("DATA_TLB_MISSES.UTLB_MISS_LD",	IAP_EVENT_08H_09H)	\
__PMC_EV_ALIAS("DELAYED_BYPASS.FP",		IAP_EVENT_19H_00H)	\
__PMC_EV_ALIAS("DELAYED_BYPASS.LOAD",		IAP_EVENT_19H_01H)	\
__PMC_EV_ALIAS("DELAYED_BYPASS.SIMD",		IAP_EVENT_19H_02H)	\
__PMC_EV_ALIAS("DIV",				IAP_EVENT_13H_00H)	\
__PMC_EV_ALIAS("DIV.AR",			IAP_EVENT_13H_81H)	\
__PMC_EV_ALIAS("DIV.S",				IAP_EVENT_13H_01H)	\
__PMC_EV_ALIAS("DTLB_MISSES.ANY",		IAP_EVENT_08H_01H)	\
__PMC_EV_ALIAS("DTLB_MISSES.L0_MISS_LD",	IAP_EVENT_08H_04H)	\
__PMC_EV_ALIAS("DTLB_MISSES.MISS_LD",		IAP_EVENT_08H_02H)	\
__PMC_EV_ALIAS("DTLB_MISSES.MISS_ST",		IAP_EVENT_08H_08H)	\
__PMC_EV_ALIAS("EIST_TRANS",			IAP_EVENT_3AH_00H)	\
__PMC_EV_ALIAS("ESP.ADDITIONS",			IAP_EVENT_ABH_02H)	\
__PMC_EV_ALIAS("ESP.SYNCH",			IAP_EVENT_ABH_01H)	\
__PMC_EV_ALIAS("EXT_SNOOP",			IAP_EVENT_77H)		\
__PMC_EV_ALIAS("FP_ASSIST",			IAP_EVENT_11H_01H)	\
__PMC_EV_ALIAS("FP_ASSIST.AR",			IAP_EVENT_11H_81H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE",		IAP_EVENT_10H_00H)	\
__PMC_EV_ALIAS("FP_MMX_TRANS_TO_FP",		IAP_EVENT_CCH_02H)	\
__PMC_EV_ALIAS("FP_MMX_TRANS_TO_MMX",		IAP_EVENT_CCH_01H)	\
__PMC_EV_ALIAS("HW_INT_RCV",			IAP_EVENT_C8H_00H)	\
__PMC_EV_ALIAS("ICACHE.ACCESSES",		IAP_EVENT_80H_03H)	\
__PMC_EV_ALIAS("ICACHE.MISSES",			IAP_EVENT_80H_02H)	\
__PMC_EV_ALIAS("IDLE_DURING_DIV",		IAP_EVENT_18H_00H)	\
__PMC_EV_ALIAS("ILD_STALL",			IAP_EVENT_87H_00H)	\
__PMC_EV_ALIAS("INST_QUEUE.FULL",		IAP_EVENT_83H_02H)	\
__PMC_EV_ALIAS("INST_RETIRED.ANY_P",		IAP_EVENT_C0H_00H)	\
__PMC_EV_ALIAS("INST_RETIRED.LOADS",		IAP_EVENT_C0H_01H)	\
__PMC_EV_ALIAS("INST_RETIRED.OTHER",		IAP_EVENT_C0H_04H)	\
__PMC_EV_ALIAS("INST_RETIRED.STORES",		IAP_EVENT_C0H_02H)	\
__PMC_EV_ALIAS("ITLB.FLUSH",			IAP_EVENT_82H_04H)	\
__PMC_EV_ALIAS("ITLB.LARGE_MISS",		IAP_EVENT_82H_10H)	\
__PMC_EV_ALIAS("ITLB.MISSES",			IAP_EVENT_82H_02H)	\
__PMC_EV_ALIAS("ITLB.SMALL_MISS",		IAP_EVENT_82H_02H)	\
__PMC_EV_ALIAS("ITLB_MISS_RETIRED",		IAP_EVENT_C9H_00H)	\
__PMC_EV_ALIAS("L1D_ALL_CACHE_REF",		IAP_EVENT_43H_02H)	\
__PMC_EV_ALIAS("L1D_ALL_REF",			IAP_EVENT_43H_01H)	\
__PMC_EV_ALIAS("L1D_CACHE.LD",			IAP_EVENT_40H_21H)	\
__PMC_EV_ALIAS("L1D_CACHE.ST",			IAP_EVENT_41H_22H)	\
__PMC_EV_ALIAS("L1D_CACHE_LOCK",		IAP_EVENT_42H)		\
__PMC_EV_ALIAS("L1D_CACHE_LOCK_DURATION",	IAP_EVENT_42H_10H)	\
__PMC_EV_ALIAS("L1D_M_EVICT",			IAP_EVENT_47H_00H)	\
__PMC_EV_ALIAS("L1D_M_REPL",			IAP_EVENT_46H_00H)	\
__PMC_EV_ALIAS("L1D_PEND_MISS",			IAP_EVENT_48H_00H)	\
__PMC_EV_ALIAS("L1D_PREFETCH.REQUESTS",		IAP_EVENT_4EH_10H)	\
__PMC_EV_ALIAS("L1D_REPL",			IAP_EVENT_45H_0FH)	\
__PMC_EV_ALIAS("L1D_SPLIT.LOADS",		IAP_EVENT_49H_01H)	\
__PMC_EV_ALIAS("L1D_SPLIT.STORES",		IAP_EVENT_49H_02H)	\
__PMC_EV_ALIAS("L1I_MISSES",			IAP_EVENT_81H_00H)	\
__PMC_EV_ALIAS("L1I_READS",			IAP_EVENT_80H_00H)	\
__PMC_EV_ALIAS("L2_ADS",			IAP_EVENT_21H)		\
__PMC_EV_ALIAS("L2_DBUS_BUSY_RD",		IAP_EVENT_23H)		\
__PMC_EV_ALIAS("L2_IFETCH",			IAP_EVENT_28H)		\
__PMC_EV_ALIAS("L2_LD",				IAP_EVENT_29H)		\
__PMC_EV_ALIAS("L2_LINES_IN",			IAP_EVENT_24H)		\
__PMC_EV_ALIAS("L2_LINES_OUT",			IAP_EVENT_26H)		\
__PMC_EV_ALIAS("L2_LOCK",			IAP_EVENT_2BH)		\
__PMC_EV_ALIAS("L2_M_LINES_IN",			IAP_EVENT_25H)		\
__PMC_EV_ALIAS("L2_M_LINES_OUT",		IAP_EVENT_27H)		\
__PMC_EV_ALIAS("L2_NO_REQ",			IAP_EVENT_32H)		\
__PMC_EV_ALIAS("L2_REJECT_BUSQ",		IAP_EVENT_30H)		\
__PMC_EV_ALIAS("L2_RQSTS",			IAP_EVENT_2EH)		\
__PMC_EV_ALIAS("L2_RQSTS.SELF.DEMAND.I_STATE",	IAP_EVENT_2EH_41H)	\
__PMC_EV_ALIAS("L2_RQSTS.SELF.DEMAND.MESI",	IAP_EVENT_2EH_4FH)	\
__PMC_EV_ALIAS("L2_ST",				IAP_EVENT_2AH)		\
__PMC_EV_ALIAS("LOAD_BLOCK.L1D",		IAP_EVENT_03H_20H)	\
__PMC_EV_ALIAS("LOAD_BLOCK.OVERLAP_STORE",	IAP_EVENT_03H_08H)	\
__PMC_EV_ALIAS("LOAD_BLOCK.STA",		IAP_EVENT_03H_02H)	\
__PMC_EV_ALIAS("LOAD_BLOCK.STD",		IAP_EVENT_03H_04H)	\
__PMC_EV_ALIAS("LOAD_BLOCK.UNTIL_RETIRE",	IAP_EVENT_03H_10H)	\
__PMC_EV_ALIAS("LOAD_HIT_PRE",			IAP_EVENT_4CH_00H)	\
__PMC_EV_ALIAS("MACHINE_CLEARS.SMC",		IAP_EVENT_C3H_01H)	\
__PMC_EV_ALIAS("MACHINE_NUKES.MEM_ORDER",	IAP_EVENT_C3H_04H)	\
__PMC_EV_ALIAS("MACRO_INSTS.ALL_DECODED",	IAP_EVENT_AAH_03H)	\
__PMC_EV_ALIAS("MACRO_INSTS.CISC_DECODED",	IAP_EVENT_AAH_02H)	\
__PMC_EV_ALIAS("MEMORY_DISAMBIGUATION.RESET",	IAP_EVENT_09H_01H)	\
__PMC_EV_ALIAS("MEMORY_DISAMBIGUATION.SUCCESS",	IAP_EVENT_09H_02H)	\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.DTLB_MISS",	IAP_EVENT_CBH_04H)	\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L2_HIT",	IAP_EVENT_CBH_01H)	\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L2_LINE_MISS",	IAP_EVENT_CBH_08H)	\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L2_MISS",	IAP_EVENT_CBH_02H)	\
__PMC_EV_ALIAS("MUL",				IAP_EVENT_12H_00H)	\
__PMC_EV_ALIAS("MUL.AR",			IAP_EVENT_12H_81H)	\
__PMC_EV_ALIAS("MUL.S",				IAP_EVENT_12H_01H)	\
__PMC_EV_ALIAS("PAGE_WALKS.CYCLES",		IAP_EVENT_0CH_03H)	\
__PMC_EV_ALIAS("PAGE_WALKS.WALKS",		IAP_EVENT_0CH_03H)	\
__PMC_EV_ALIAS("PREFETCH.PREFETCHNTA",		IAP_EVENT_07H_08H)	\
__PMC_EV_ALIAS("PREFETCH.PREFETCHT0",		IAP_EVENT_07H_01H)	\
__PMC_EV_ALIAS("PREFETCH.SW_L2",		IAP_EVENT_07H_06H)	\
__PMC_EV_ALIAS("PREF_RQSTS_DN",			IAP_EVENT_F8H_00H)	\
__PMC_EV_ALIAS("PREF_RQSTS_UP",			IAP_EVENT_F0H_00H)	\
__PMC_EV_ALIAS("RAT_STALLS.ANY",		IAP_EVENT_D2H_0FH)	\
__PMC_EV_ALIAS("RAT_STALLS.FLAGS",		IAP_EVENT_D2H_04H)	\
__PMC_EV_ALIAS("RAT_STALLS.FPSW",		IAP_EVENT_D2H_08H)	\
__PMC_EV_ALIAS("RAT_STALLS.PARTIAL_CYCLES",	IAP_EVENT_D2H_02H)	\
__PMC_EV_ALIAS("RAT_STALLS.ROB_READ_PORT",	IAP_EVENT_D2H_01H)	\
__PMC_EV_ALIAS("RESOURCE_STALLS.ANY",		IAP_EVENT_DCH_1FH)	\
__PMC_EV_ALIAS("RESOURCE_STALLS.BR_MISS_CLEAR",	IAP_EVENT_DCH_10H)	\
__PMC_EV_ALIAS("RESOURCE_STALLS.FPCW",		IAP_EVENT_DCH_08H)	\
__PMC_EV_ALIAS("RESOURCE_STALLS.LD_ST",		IAP_EVENT_DCH_04H)	\
__PMC_EV_ALIAS("RESOURCE_STALLS.ROB_FULL",	IAP_EVENT_DCH_01H)	\
__PMC_EV_ALIAS("RESOURCE_STALLS.RS_FULL",	IAP_EVENT_DCH_02H)	\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED",		IAP_EVENT_A0H_00H)	\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT0",	IAP_EVENT_A1H_01H)	\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT1",	IAP_EVENT_A1H_02H)	\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT2",	IAP_EVENT_A1H_04H)	\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT3",	IAP_EVENT_A1H_08H)	\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT4",	IAP_EVENT_A1H_10H)	\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT5",	IAP_EVENT_A1H_20H)	\
__PMC_EV_ALIAS("SB_DRAIN_CYCLES",		IAP_EVENT_04H_01H)	\
__PMC_EV_ALIAS("SEGMENT_REG_LOADS.ANY",		IAP_EVENT_06H_00H)	\
__PMC_EV_ALIAS("SEG_REG_RENAMES.ANY",		IAP_EVENT_D5H_0FH)	\
__PMC_EV_ALIAS("SEG_REG_RENAMES.DS",		IAP_EVENT_D5H_02H)	\
__PMC_EV_ALIAS("SEG_REG_RENAMES.ES",		IAP_EVENT_D5H_01H)	\
__PMC_EV_ALIAS("SEG_REG_RENAMES.FS",		IAP_EVENT_D5H_04H)	\
__PMC_EV_ALIAS("SEG_REG_RENAMES.GS",		IAP_EVENT_D5H_08H)	\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.ANY",		IAP_EVENT_D4H_0FH)	\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.DS",		IAP_EVENT_D4H_02H)	\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.ES",		IAP_EVENT_D4H_01H)	\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.FS",		IAP_EVENT_D4H_04H)	\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.GS",		IAP_EVENT_D4H_08H)	\
__PMC_EV_ALIAS("SIMD_ASSIST",			IAP_EVENT_CDH_00H)	\
__PMC_EV_ALIAS("SIMD_COMP_INST_RETIRED.PACKED_DOUBLE",			\
    IAP_EVENT_CAH_04H)							\
__PMC_EV_ALIAS("SIMD_COMP_INST_RETIRED.PACKED_SINGLE",			\
    IAP_EVENT_CAH_01H)							\
__PMC_EV_ALIAS("SIMD_COMP_INST_RETIRED.SCALAR_DOUBLE",			\
    IAP_EVENT_CAH_08H)							\
__PMC_EV_ALIAS("SIMD_COMP_INST_RETIRED.SCALAR_SINGLE",			\
    IAP_EVENT_CAH_02H)							\
__PMC_EV_ALIAS("SIMD_INSTR_RETIRED",		IAP_EVENT_CEH_00H)	\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.ANY",		IAP_EVENT_C7H_1FH)	\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.PACKED_DOUBLE", IAP_EVENT_C7H_04H)	\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.PACKED_SINGLE", IAP_EVENT_C7H_01H)	\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.SCALAR_DOUBLE", IAP_EVENT_C7H_08H)	\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.SCALAR_SINGLE", IAP_EVENT_C7H_02H)	\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.VECTOR",	IAP_EVENT_C7H_10H)	\
__PMC_EV_ALIAS("SIMD_SAT_INSTR_RETIRED",	IAP_EVENT_CFH_00H)	\
__PMC_EV_ALIAS("SIMD_SAT_UOP_EXEC.AR",		IAP_EVENT_B1H_80H)	\
__PMC_EV_ALIAS("SIMD_SAT_UOP_EXEC.S",		IAP_EVENT_B1H_00H)	\
__PMC_EV_ALIAS("SIMD_UOPS_EXEC.AR",		IAP_EVENT_B0H_80H)	\
__PMC_EV_ALIAS("SIMD_UOPS_EXEC.S",		IAP_EVENT_B0H_00H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.ARITHMETIC.AR", IAP_EVENT_B3H_A0H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.ARITHMETIC.S",  IAP_EVENT_B3H_20H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.LOGICAL.AR",	IAP_EVENT_B3H_90H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.LOGICAL.S",	IAP_EVENT_B3H_10H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.MUL.AR",	IAP_EVENT_B3H_81H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.MUL.S",	IAP_EVENT_B3H_01H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.PACK.AR",	IAP_EVENT_B3H_84H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.PACK.S",	IAP_EVENT_B3H_04H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.SHIFT.AR",	IAP_EVENT_B3H_82H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.SHIFT.S",	IAP_EVENT_B3H_02H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.UNPACK.AR",	IAP_EVENT_B3H_88H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.UNPACK.S",	IAP_EVENT_B3H_08H)	\
__PMC_EV_ALIAS("SNOOP_STALL_DRV",		IAP_EVENT_7EH)		\
__PMC_EV_ALIAS("SSE_PRE_EXEC.L2",		IAP_EVENT_07H_02H)	\
__PMC_EV_ALIAS("SSE_PRE_EXEC.STORES",		IAP_EVENT_07H_03H)	\
__PMC_EV_ALIAS("SSE_PRE_MISS.L1",		IAP_EVENT_4BH_01H)	\
__PMC_EV_ALIAS("SSE_PRE_MISS.L2",		IAP_EVENT_4BH_02H)	\
__PMC_EV_ALIAS("SSE_PRE_MISS.NTA",		IAP_EVENT_4BH_00H)	\
__PMC_EV_ALIAS("STORE_BLOCK.ORDER",		IAP_EVENT_04H_02H)	\
__PMC_EV_ALIAS("STORE_BLOCK.SNOOP",		IAP_EVENT_04H_08H)	\
__PMC_EV_ALIAS("STORE_FORWARDS.GOOD",		IAP_EVENT_02H_81H)	\
__PMC_EV_ALIAS("THERMAL_TRIP",			IAP_EVENT_3BH_C0H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.ANY",		IAP_EVENT_C2H_10H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.FUSED",		IAP_EVENT_C2H_07H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.LD_IND_BR",	IAP_EVENT_C2H_01H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.MACRO_FUSION",	IAP_EVENT_C2H_04H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.NON_FUSED",	IAP_EVENT_C2H_08H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.STD_STA",		IAP_EVENT_C2H_02H)	\
__PMC_EV_ALIAS("X87_COMP_OPS_EXE.ANY.AR",	IAP_EVENT_10H_81H)	\
__PMC_EV_ALIAS("X87_COMP_OPS_EXE.ANY.S",	IAP_EVENT_10H_01H)	\
__PMC_EV_ALIAS("X87_OPS_RETIRED.ANY",		IAP_EVENT_C1H_FEH)	\
__PMC_EV_ALIAS("X87_OPS_RETIRED.FXCH",		IAP_EVENT_C1H_01H)

/*
 * Aliases for Core PMC events.
 */
#define	__PMC_EV_ALIAS_CORE()					\
__PMC_EV_ALIAS_INTEL_ARCHITECTURAL()				\
__PMC_EV_ALIAS("BAClears",		IAP_EVENT_E6H_00H)	\
__PMC_EV_ALIAS("BTB_Misses",		IAP_EVENT_E2H_00H)	\
__PMC_EV_ALIAS("Br_BAC_Missp_Exec",	IAP_EVENT_8AH_00H)	\
__PMC_EV_ALIAS("Br_Bogus",		IAP_EVENT_E4H_00H)	\
__PMC_EV_ALIAS("Br_Call_Exec",		IAP_EVENT_92H_00H)	\
__PMC_EV_ALIAS("Br_Call_Missp_Exec",	IAP_EVENT_93H_00H)	\
__PMC_EV_ALIAS("Br_Cnd_Exec",		IAP_EVENT_8BH_00H)	\
__PMC_EV_ALIAS("Br_Cnd_Missp_Exec",	IAP_EVENT_8CH_00H)	\
__PMC_EV_ALIAS("Br_Ind_Call_Exec",	IAP_EVENT_94H_00H)	\
__PMC_EV_ALIAS("Br_Ind_Exec",		IAP_EVENT_8DH_00H)	\
__PMC_EV_ALIAS("Br_Ind_Missp_Exec",	IAP_EVENT_8EH_00H)	\
__PMC_EV_ALIAS("Br_Inst_Exec",		IAP_EVENT_88H_00H)	\
__PMC_EV_ALIAS("Br_Instr_Decoded",	IAP_EVENT_E0H_00H)	\
__PMC_EV_ALIAS("Br_Instr_Ret",		IAP_EVENT_C4H_00H)	\
__PMC_EV_ALIAS("Br_MisPred_Ret",	IAP_EVENT_C5H_00H)	\
__PMC_EV_ALIAS("Br_MisPred_Taken_Ret",	IAP_EVENT_CAH_00H)	\
__PMC_EV_ALIAS("Br_Missp_Exec",		IAP_EVENT_89H_00H)	\
__PMC_EV_ALIAS("Br_Ret_BAC_Missp_Exec",	IAP_EVENT_91H_00H)	\
__PMC_EV_ALIAS("Br_Ret_Exec",		IAP_EVENT_8FH_00H)	\
__PMC_EV_ALIAS("Br_Ret_Missp_Exec",	IAP_EVENT_90H_00H)	\
__PMC_EV_ALIAS("Br_Taken_Ret",		IAP_EVENT_C9H_00H)	\
__PMC_EV_ALIAS("Bus_BNR_Clocks",	IAP_EVENT_61H_00H)	\
__PMC_EV_ALIAS("Bus_DRDY_Clocks",	IAP_EVENT_62H_00H)	\
__PMC_EV_ALIAS("Bus_Data_Rcv",		IAP_EVENT_64H_40H)	\
__PMC_EV_ALIAS("Bus_Locks_Clocks",	IAP_EVENT_63H)		\
__PMC_EV_ALIAS("Bus_Not_In_Use",	IAP_EVENT_7DH)		\
__PMC_EV_ALIAS("Bus_Req_Outstanding",	IAP_EVENT_60H)		\
__PMC_EV_ALIAS("Bus_Snoop_Stall",	IAP_EVENT_7EH_00H)	\
__PMC_EV_ALIAS("Bus_Snoops",		IAP_EVENT_77H)		\
__PMC_EV_ALIAS("Bus_Trans_Any",		IAP_EVENT_70H)		\
__PMC_EV_ALIAS("Bus_Trans_Brd",		IAP_EVENT_65H)		\
__PMC_EV_ALIAS("Bus_Trans_Burst",	IAP_EVENT_6EH)		\
__PMC_EV_ALIAS("Bus_Trans_Def",		IAP_EVENT_6DH)		\
__PMC_EV_ALIAS("Bus_Trans_IO",		IAP_EVENT_6CH)		\
__PMC_EV_ALIAS("Bus_Trans_Ifetch",	IAP_EVENT_68H)		\
__PMC_EV_ALIAS("Bus_Trans_Inval",	IAP_EVENT_69H)		\
__PMC_EV_ALIAS("Bus_Trans_Mem",		IAP_EVENT_6FH)		\
__PMC_EV_ALIAS("Bus_Trans_P",		IAP_EVENT_6BH)		\
__PMC_EV_ALIAS("Bus_Trans_Pwr",		IAP_EVENT_6AH)		\
__PMC_EV_ALIAS("Bus_Trans_RFO",		IAP_EVENT_66H)		\
__PMC_EV_ALIAS("Bus_Trans_WB",		IAP_EVENT_67H)		\
__PMC_EV_ALIAS("Cycles_Div_Busy",	IAP_EVENT_14H_00H)	\
__PMC_EV_ALIAS("Cycles_Int_Masked",	IAP_EVENT_C6H_00H)	\
__PMC_EV_ALIAS("Cycles_Int_Pending_Masked", IAP_EVENT_C7H_00H)	\
__PMC_EV_ALIAS("DCU_Snoop_To_Share",	IAP_EVENT_78H)		\
__PMC_EV_ALIAS("DCache_Cache_LD",	IAP_EVENT_40H)		\
__PMC_EV_ALIAS("DCache_Cache_Lock",	IAP_EVENT_42H)		\
__PMC_EV_ALIAS("DCache_Cache_ST",	IAP_EVENT_41H)		\
__PMC_EV_ALIAS("DCache_M_Evict",	IAP_EVENT_47H_00H)	\
__PMC_EV_ALIAS("DCache_M_Repl",		IAP_EVENT_46H_00H)	\
__PMC_EV_ALIAS("DCache_Pend_Miss",	IAP_EVENT_48H_00H)	\
__PMC_EV_ALIAS("DCache_Repl",		IAP_EVENT_45H_0FH)	\
__PMC_EV_ALIAS("Data_Mem_Cache_Ref",	IAP_EVENT_44H_02H)	\
__PMC_EV_ALIAS("Data_Mem_Ref",		IAP_EVENT_43H_01H)	\
__PMC_EV_ALIAS("Dbus_Busy",		IAP_EVENT_22H)		\
__PMC_EV_ALIAS("Dbus_Busy_Rd",		IAP_EVENT_23H)		\
__PMC_EV_ALIAS("Div",			IAP_EVENT_13H_00H)	\
__PMC_EV_ALIAS("Dtlb_Miss",		IAP_EVENT_49H_00H)	\
__PMC_EV_ALIAS("ESP_Uops",		IAP_EVENT_D7H_00H)	\
__PMC_EV_ALIAS("EST_Trans",		IAP_EVENT_3AH)		\
__PMC_EV_ALIAS("FP_Assist",		IAP_EVENT_11H_00H)	\
__PMC_EV_ALIAS("FP_Comp_Instr_Ret",	IAP_EVENT_C1H_00H)	\
__PMC_EV_ALIAS("FP_Comps_Op_Exe",	IAP_EVENT_10H_00H)	\
__PMC_EV_ALIAS("FP_MMX_Trans",		IAP_EVENT_CCH_01H)	\
__PMC_EV_ALIAS("Fused_Ld_Uops_Ret",	IAP_EVENT_DAH_01H)	\
__PMC_EV_ALIAS("Fused_St_Uops_Ret",	IAP_EVENT_DAH_02H)	\
__PMC_EV_ALIAS("Fused_Uops_Ret",	IAP_EVENT_DAH_00H)	\
__PMC_EV_ALIAS("HW_Int_Rx",		IAP_EVENT_C8H_00H)	\
__PMC_EV_ALIAS("ICache_Misses",		IAP_EVENT_81H_00H)	\
__PMC_EV_ALIAS("ICache_Reads",		IAP_EVENT_80H_00H)	\
__PMC_EV_ALIAS("IFU_Mem_Stall",		IAP_EVENT_86H_00H)	\
__PMC_EV_ALIAS("ILD_Stall",		IAP_EVENT_87H_00H)	\
__PMC_EV_ALIAS("ITLB_Misses",		IAP_EVENT_85H_00H)	\
__PMC_EV_ALIAS("Instr_Decoded",		IAP_EVENT_D0H_00H)	\
__PMC_EV_ALIAS("Instr_Ret",		IAP_EVENT_C0H_00H)	\
__PMC_EV_ALIAS("L1_Pref_Req",		IAP_EVENT_4FH_00H)	\
__PMC_EV_ALIAS("L2_ADS",		IAP_EVENT_21H)		\
__PMC_EV_ALIAS("L2_IFetch",		IAP_EVENT_28H)		\
__PMC_EV_ALIAS("L2_LD",			IAP_EVENT_29H)		\
__PMC_EV_ALIAS("L2_Lines_In",		IAP_EVENT_24H)		\
__PMC_EV_ALIAS("L2_Lines_Out",		IAP_EVENT_26H)		\
__PMC_EV_ALIAS("L2_M_Lines_In",		IAP_EVENT_25H)		\
__PMC_EV_ALIAS("L2_M_Lines_Out",	IAP_EVENT_27H)		\
__PMC_EV_ALIAS("L2_No_Request_Cycles",	IAP_EVENT_32H)		\
__PMC_EV_ALIAS("L2_Reject_Cycles",	IAP_EVENT_30H)		\
__PMC_EV_ALIAS("L2_Rqsts",		IAP_EVENT_2EH)		\
__PMC_EV_ALIAS("L2_ST",			IAP_EVENT_2AH)		\
__PMC_EV_ALIAS("LD_Blocks",		IAP_EVENT_03H_00H)	\
__PMC_EV_ALIAS("LLC_Misses",		IAP_EVENT_2EH_41H)	\
__PMC_EV_ALIAS("LLC_Reference",		IAP_EVENT_2EH_4FH)	\
__PMC_EV_ALIAS("MMX_Assist",		IAP_EVENT_CDH_00H)	\
__PMC_EV_ALIAS("MMX_FP_Trans",		IAP_EVENT_CCH_00H)	\
__PMC_EV_ALIAS("MMX_Instr_Exec",	IAP_EVENT_B0H_00H)	\
__PMC_EV_ALIAS("MMX_Instr_Ret",		IAP_EVENT_CEH_00H)	\
__PMC_EV_ALIAS("Misalign_Mem_Ref",	IAP_EVENT_05H_00H)	\
__PMC_EV_ALIAS("Mul",			IAP_EVENT_12H_00H)	\
__PMC_EV_ALIAS("NonHlt_Ref_Cycles",	IAP_EVENT_3CH_01H)	\
__PMC_EV_ALIAS("Pref_Rqsts_Dn",		IAP_EVENT_F8H_00H)	\
__PMC_EV_ALIAS("Pref_Rqsts_Up",		IAP_EVENT_F0H_00H)	\
__PMC_EV_ALIAS("Resource_Stall",	IAP_EVENT_A2H_00H)	\
__PMC_EV_ALIAS("SD_Drains",		IAP_EVENT_04H_00H)	\
__PMC_EV_ALIAS("SIMD_FP_DP_P_Comp_Ret",	IAP_EVENT_D9H_02H)	\
__PMC_EV_ALIAS("SIMD_FP_DP_P_Ret",	IAP_EVENT_D8H_02H)	\
__PMC_EV_ALIAS("SIMD_FP_DP_S_Comp_Ret",	IAP_EVENT_D9H_03H)	\
__PMC_EV_ALIAS("SIMD_FP_DP_S_Ret",	IAP_EVENT_D8H_03H)	\
__PMC_EV_ALIAS("SIMD_FP_SP_P_Comp_Ret",	IAP_EVENT_D9H_00H)	\
__PMC_EV_ALIAS("SIMD_FP_SP_Ret",	IAP_EVENT_D8H_00H)	\
__PMC_EV_ALIAS("SIMD_FP_SP_S_Comp_Ret",	IAP_EVENT_D9H_01H)	\
__PMC_EV_ALIAS("SIMD_FP_SP_S_Ret",	IAP_EVENT_D8H_01H)	\
__PMC_EV_ALIAS("SIMD_Int_128_Ret",	IAP_EVENT_D8H_04H)	\
__PMC_EV_ALIAS("SIMD_Int_Pari_Exec",	IAP_EVENT_B3H_20H)	\
__PMC_EV_ALIAS("SIMD_Int_Pck_Exec",	IAP_EVENT_B3H_04H)	\
__PMC_EV_ALIAS("SIMD_Int_Plog_Exec",	IAP_EVENT_B3H_10H)	\
__PMC_EV_ALIAS("SIMD_Int_Pmul_Exec",	IAP_EVENT_B3H_01H)	\
__PMC_EV_ALIAS("SIMD_Int_Psft_Exec",	IAP_EVENT_B3H_02H)	\
__PMC_EV_ALIAS("SIMD_Int_Sat_Exec",	IAP_EVENT_B1H_00H)	\
__PMC_EV_ALIAS("SIMD_Int_Upck_Exec",	IAP_EVENT_B3H_08H)	\
__PMC_EV_ALIAS("SMC_Detected",		IAP_EVENT_C3H_00H)	\
__PMC_EV_ALIAS("SSE_NTStores_Miss",	IAP_EVENT_4BH_03H)	\
__PMC_EV_ALIAS("SSE_NTStores_Ret",	IAP_EVENT_07H_03H)	\
__PMC_EV_ALIAS("SSE_PrefNta_Miss",	IAP_EVENT_4BH_00H)	\
__PMC_EV_ALIAS("SSE_PrefNta_Ret",	IAP_EVENT_07H_00H)	\
__PMC_EV_ALIAS("SSE_PrefT1_Miss",	IAP_EVENT_4BH_01H)	\
__PMC_EV_ALIAS("SSE_PrefT1_Ret",	IAP_EVENT_07H_01H)	\
__PMC_EV_ALIAS("SSE_PrefT2_Miss",	IAP_EVENT_4BH_02H)	\
__PMC_EV_ALIAS("SSE_PrefT2_Ret",	IAP_EVENT_07H_02H)	\
__PMC_EV_ALIAS("Seg_Reg_Loads",		IAP_EVENT_06H_00H)	\
__PMC_EV_ALIAS("Serial_Execution_Cycles", IAP_EVENT_3CH_02H)	\
__PMC_EV_ALIAS("Thermal_Trip",		IAP_EVENT_3BH_C0H)	\
__PMC_EV_ALIAS("Unfusion",		IAP_EVENT_DBH_00H)	\
__PMC_EV_ALIAS("Unhalted_Core_Cycles",	IAP_EVENT_3CH_00H)	\
__PMC_EV_ALIAS("Uops_Ret",		IAP_EVENT_C2H_00H)

/*
 * Aliases for Core2 PMC events.
 */
#define	__PMC_EV_ALIAS_CORE2()						\
__PMC_EV_ALIAS_INTEL_ARCHITECTURAL()					\
__PMC_EV_ALIAS("BACLEARS",		IAP_EVENT_E6H_00H)		\
__PMC_EV_ALIAS("BOGUS_BR",		IAP_EVENT_E4H_00H)		\
__PMC_EV_ALIAS("BR_BAC_MISSP_EXEC",	IAP_EVENT_8AH_00H)		\
__PMC_EV_ALIAS("BR_CALL_EXEC",		IAP_EVENT_92H_00H)		\
__PMC_EV_ALIAS("BR_CALL_MISSP_EXEC",	IAP_EVENT_93H_00H)		\
__PMC_EV_ALIAS("BR_CND_EXEC",		IAP_EVENT_8BH_00H)		\
__PMC_EV_ALIAS("BR_CND_MISSP_EXEC",	IAP_EVENT_8CH_00H)		\
__PMC_EV_ALIAS("BR_IND_CALL_EXEC",	IAP_EVENT_94H_00H)		\
__PMC_EV_ALIAS("BR_IND_EXEC",		IAP_EVENT_8DH_00H)		\
__PMC_EV_ALIAS("BR_IND_MISSP_EXEC",	IAP_EVENT_8EH_00H)		\
__PMC_EV_ALIAS("BR_INST_DECODED",	IAP_EVENT_E0H_00H)		\
__PMC_EV_ALIAS("BR_INST_EXEC",		IAP_EVENT_88H_00H)		\
__PMC_EV_ALIAS("BR_INST_RETIRED.ANY",	IAP_EVENT_C4H_00H)		\
__PMC_EV_ALIAS("BR_INST_RETIRED.MISPRED", IAP_EVENT_C5H_00H)		\
__PMC_EV_ALIAS("BR_INST_RETIRED.MISPRED_NOT_TAKEN",			\
    IAP_EVENT_C4H_02H)							\
__PMC_EV_ALIAS("BR_INST_RETIRED.MISPRED_TAKEN",				\
    IAP_EVENT_C4H_08H)							\
__PMC_EV_ALIAS("BR_INST_RETIRED.PRED_NOT_TAKEN",			\
    IAP_EVENT_C4H_01H)							\
__PMC_EV_ALIAS("BR_INST_RETIRED.PRED_TAKEN",				\
    IAP_EVENT_C4H_04H)							\
__PMC_EV_ALIAS("BR_INST_RETIRED.TAKEN",	IAP_EVENT_C4H_0CH)		\
__PMC_EV_ALIAS("BR_MISSP_EXEC",		IAP_EVENT_89H_00H)		\
__PMC_EV_ALIAS("BR_RET_BAC_MISSP_EXEC",	IAP_EVENT_91H_00H)		\
__PMC_EV_ALIAS("BR_RET_EXEC",		IAP_EVENT_8FH_00H)		\
__PMC_EV_ALIAS("BR_RET_MISSP_EXEC",	IAP_EVENT_90H_00H)		\
__PMC_EV_ALIAS("BR_TKN_BUBBLE_1",	IAP_EVENT_97H_00H)		\
__PMC_EV_ALIAS("BR_TKN_BUBBLE_2",	IAP_EVENT_98H_00H)		\
__PMC_EV_ALIAS("BUSQ_EMPTY",		IAP_EVENT_7DH)			\
__PMC_EV_ALIAS("BUS_BNR_DRV",		IAP_EVENT_61H)			\
__PMC_EV_ALIAS("BUS_DATA_RCV",		IAP_EVENT_64H)			\
__PMC_EV_ALIAS("BUS_DRDY_CLOCKS",	IAP_EVENT_62H)			\
__PMC_EV_ALIAS("BUS_HITM_DRV",		IAP_EVENT_7BH)			\
__PMC_EV_ALIAS("BUS_HIT_DRV",		IAP_EVENT_7AH)			\
__PMC_EV_ALIAS("BUS_IO_WAIT",		IAP_EVENT_7FH)			\
__PMC_EV_ALIAS("BUS_LOCK_CLOCKS",	IAP_EVENT_63H)			\
__PMC_EV_ALIAS("BUS_REQUEST_OUTSTANDING",				\
    IAP_EVENT_60H)							\
__PMC_EV_ALIAS("BUS_TRANS_ANY",		IAP_EVENT_70H)			\
__PMC_EV_ALIAS("BUS_TRANS_BRD",		IAP_EVENT_65H)			\
__PMC_EV_ALIAS("BUS_TRANS_BURST",	IAP_EVENT_6EH)			\
__PMC_EV_ALIAS("BUS_TRANS_DEF",		IAP_EVENT_6DH)			\
__PMC_EV_ALIAS("BUS_TRANS_IFETCH",	IAP_EVENT_68H)			\
__PMC_EV_ALIAS("BUS_TRANS_INVAL",	IAP_EVENT_69H)			\
__PMC_EV_ALIAS("BUS_TRANS_IO",		IAP_EVENT_6CH)			\
__PMC_EV_ALIAS("BUS_TRANS_MEM",		IAP_EVENT_6FH)			\
__PMC_EV_ALIAS("BUS_TRANS_P",		IAP_EVENT_6BH)			\
__PMC_EV_ALIAS("BUS_TRANS_PWR",		IAP_EVENT_6AH)			\
__PMC_EV_ALIAS("BUS_TRANS_RFO",		IAP_EVENT_66H)			\
__PMC_EV_ALIAS("BUS_TRANS_WB",		IAP_EVENT_67H)			\
__PMC_EV_ALIAS("CMP_SNOOP",		IAP_EVENT_78H)			\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.BUS",	IAP_EVENT_3CH_01H)		\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.CORE_P",				\
    IAP_EVENT_3CH_00H)							\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.NO_OTHER",				\
    IAP_EVENT_3CH_02H)							\
__PMC_EV_ALIAS("CYCLES_DIV_BUSY",	IAP_EVENT_14H_00H)		\
__PMC_EV_ALIAS("CYCLES_INT_MASKED",	IAP_EVENT_C6H_01H)		\
__PMC_EV_ALIAS("CYCLES_INT_PENDING_AND_MASKED",				\
    IAP_EVENT_C6H_02H)							\
__PMC_EV_ALIAS("CYCLES_L1I_MEM_STALLED", IAP_EVENT_86H_00H)		\
__PMC_EV_ALIAS("DELAYED_BYPASS.FP",	IAP_EVENT_19H_00H)		\
__PMC_EV_ALIAS("DELAYED_BYPASS.LOAD",	IAP_EVENT_19H_01H)		\
__PMC_EV_ALIAS("DELAYED_BYPASS.SIMD",	IAP_EVENT_19H_02H)		\
__PMC_EV_ALIAS("DIV",			IAP_EVENT_13H_00H)		\
__PMC_EV_ALIAS("DTLB_MISSES.ANY",	IAP_EVENT_08H_01H)		\
__PMC_EV_ALIAS("DTLB_MISSES.L0_MISS_LD", IAP_EVENT_08H_04H)		\
__PMC_EV_ALIAS("DTLB_MISSES.MISS_LD",	IAP_EVENT_08H_02H)		\
__PMC_EV_ALIAS("DTLB_MISSES.MISS_ST",	IAP_EVENT_08H_08H)		\
__PMC_EV_ALIAS("EIST_TRANS",		IAP_EVENT_3AH_00H)		\
__PMC_EV_ALIAS("ESP.ADDITIONS",		IAP_EVENT_ABH_02H)		\
__PMC_EV_ALIAS("ESP.SYNCH",		IAP_EVENT_ABH_01H)		\
__PMC_EV_ALIAS("EXT_SNOOP",		IAP_EVENT_77H)			\
__PMC_EV_ALIAS("FP_ASSIST",		IAP_EVENT_11H_00H)		\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE",	IAP_EVENT_10H_00H)		\
__PMC_EV_ALIAS("FP_MMX_TRANS_TO_FP",	IAP_EVENT_CCH_02H)		\
__PMC_EV_ALIAS("FP_MMX_TRANS_TO_MMX",	IAP_EVENT_CCH_01H)		\
__PMC_EV_ALIAS("HW_INT_RCV",		IAP_EVENT_C8H_00H)		\
__PMC_EV_ALIAS("IDLE_DURING_DIV",	IAP_EVENT_18H_00H)		\
__PMC_EV_ALIAS("ILD_STALL",		IAP_EVENT_87H_00H)		\
__PMC_EV_ALIAS("INST_QUEUE.FULL",	IAP_EVENT_83H_02H)		\
__PMC_EV_ALIAS("INST_RETIRED.ANY_P",	IAP_EVENT_C0H_00H)		\
__PMC_EV_ALIAS("INST_RETIRED.LOADS",	IAP_EVENT_C0H_01H)		\
__PMC_EV_ALIAS("INST_RETIRED.OTHER",	IAP_EVENT_C0H_04H)		\
__PMC_EV_ALIAS("INST_RETIRED.STORES",	IAP_EVENT_C0H_02H)		\
__PMC_EV_ALIAS("INST_RETIRED.VM_H",	IAP_EVENT_C0H_08H)		\
__PMC_EV_ALIAS("ITLB.FLUSH",		IAP_EVENT_82H_40H)		\
__PMC_EV_ALIAS("ITLB.LARGE_MISS",	IAP_EVENT_82H_10H)		\
__PMC_EV_ALIAS("ITLB.MISSES",		IAP_EVENT_82H_12H)		\
__PMC_EV_ALIAS("ITLB.SMALL_MISS",	IAP_EVENT_82H_02H)		\
__PMC_EV_ALIAS("ITLB_MISS_RETIRED",	IAP_EVENT_C9H_00H)		\
__PMC_EV_ALIAS("L1D_ALL_CACHE_REF",	IAP_EVENT_43H_02H)		\
__PMC_EV_ALIAS("L1D_ALL_REF",		IAP_EVENT_43H_01H)		\
__PMC_EV_ALIAS("L1D_CACHE_LD",		IAP_EVENT_40H)			\
__PMC_EV_ALIAS("L1D_CACHE_LOCK",	IAP_EVENT_42H)			\
__PMC_EV_ALIAS("L1D_CACHE_LOCK_DURATION", IAP_EVENT_42H_10H)		\
__PMC_EV_ALIAS("L1D_CACHE_ST",		IAP_EVENT_41H)			\
__PMC_EV_ALIAS("L1D_M_EVICT",		IAP_EVENT_47H_00H)		\
__PMC_EV_ALIAS("L1D_M_REPL",		IAP_EVENT_46H_00H)		\
__PMC_EV_ALIAS("L1D_PEND_MISS",		IAP_EVENT_48H_00H)		\
__PMC_EV_ALIAS("L1D_PREFETCH.REQUESTS",	IAP_EVENT_4EH_10H)		\
__PMC_EV_ALIAS("L1D_REPL",		IAP_EVENT_45H_0FH)		\
__PMC_EV_ALIAS("L1D_SPLIT.LOADS",	IAP_EVENT_49H_01H)		\
__PMC_EV_ALIAS("L1D_SPLIT.STORES",	IAP_EVENT_49H_02H)		\
__PMC_EV_ALIAS("L1I_MISSES",		IAP_EVENT_81H_00H)		\
__PMC_EV_ALIAS("L1I_READS",		IAP_EVENT_80H_00H)		\
__PMC_EV_ALIAS("L2_ADS",		IAP_EVENT_21H)			\
__PMC_EV_ALIAS("L2_DBUS_BUSY_RD",	IAP_EVENT_23H)			\
__PMC_EV_ALIAS("L2_IFETCH",		IAP_EVENT_28H)			\
__PMC_EV_ALIAS("L2_LD",			IAP_EVENT_29H)			\
__PMC_EV_ALIAS("L2_LINES_IN",		IAP_EVENT_24H)			\
__PMC_EV_ALIAS("L2_LINES_OUT",		IAP_EVENT_26H)			\
__PMC_EV_ALIAS("L2_LOCK",		IAP_EVENT_2BH)			\
__PMC_EV_ALIAS("L2_M_LINES_IN",		IAP_EVENT_25H)			\
__PMC_EV_ALIAS("L2_M_LINES_OUT",	IAP_EVENT_27H)			\
__PMC_EV_ALIAS("L2_NO_REQ",		IAP_EVENT_32H)			\
__PMC_EV_ALIAS("L2_REJECT_BUSQ",	IAP_EVENT_30H)			\
__PMC_EV_ALIAS("L2_RQSTS",		IAP_EVENT_2EH)			\
__PMC_EV_ALIAS("L2_RQSTS.SELF.DEMAND.I_STATE",				\
    IAP_EVENT_2EH_41H)							\
__PMC_EV_ALIAS("L2_RQSTS.SELF.DEMAND.MESI",				\
    IAP_EVENT_2EH_4FH)							\
__PMC_EV_ALIAS("L2_ST",			IAP_EVENT_2AH)			\
__PMC_EV_ALIAS("LOAD_BLOCK.L1D",	IAP_EVENT_03H_20H)		\
__PMC_EV_ALIAS("LOAD_BLOCK.OVERLAP_STORE",				\
    IAP_EVENT_03H_08H)							\
__PMC_EV_ALIAS("LOAD_BLOCK.STA",	IAP_EVENT_03H_02H)		\
__PMC_EV_ALIAS("LOAD_BLOCK.STD",	IAP_EVENT_03H_04H)		\
__PMC_EV_ALIAS("LOAD_BLOCK.UNTIL_RETIRE", IAP_EVENT_03H_10H)		\
__PMC_EV_ALIAS("LOAD_HIT_PRE",		IAP_EVENT_4CH_00H)		\
__PMC_EV_ALIAS("MACHINE_NUKES.MEM_ORDER", IAP_EVENT_C3H_04H)		\
__PMC_EV_ALIAS("MACHINE_NUKES.SMC",	IAP_EVENT_C3H_01H)		\
__PMC_EV_ALIAS("MACRO_INSTS.CISC_DECODED", IAP_EVENT_AAH_08H)		\
__PMC_EV_ALIAS("MACRO_INSTS.DECODED",	IAP_EVENT_AAH_01H)		\
__PMC_EV_ALIAS("MEMORY_DISAMBIGUATION.RESET",				\
    IAP_EVENT_09H_01H)							\
__PMC_EV_ALIAS("MEMORY_DISAMBIGUATION.SUCCESS",				\
    IAP_EVENT_09H_02H)							\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.DTLB_MISS",				\
    IAP_EVENT_CBH_10H)							\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L1D_LINE_MISS",			\
    IAP_EVENT_CBH_02H)							\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L1D_MISS",				\
    IAP_EVENT_CBH_01H)							\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L2_LINE_MISS",				\
    IAP_EVENT_CBH_08H)							\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L2_MISS",				\
    IAP_EVENT_CBH_04H)							\
__PMC_EV_ALIAS("MUL",			IAP_EVENT_12H_00H)		\
__PMC_EV_ALIAS("PAGE_WALKS.COUNT",	IAP_EVENT_0CH_01H)		\
__PMC_EV_ALIAS("PAGE_WALKS.CYCLES",	IAP_EVENT_0CH_02H)		\
__PMC_EV_ALIAS("PREF_RQSTS_DN",		IAP_EVENT_F8H_00H)		\
__PMC_EV_ALIAS("PREF_RQSTS_UP",		IAP_EVENT_F0H_00H)		\
__PMC_EV_ALIAS("RAT_STALLS.ANY",	IAP_EVENT_D2H_0FH)		\
__PMC_EV_ALIAS("RAT_STALLS.FLAGS",	IAP_EVENT_D2H_04H)		\
__PMC_EV_ALIAS("RAT_STALLS.FPSW",	IAP_EVENT_D2H_08H)		\
__PMC_EV_ALIAS("RAT_STALLS.OTHER_SERIALIZATION_STALLS",			\
    IAP_EVENT_D2H_10H)							\
__PMC_EV_ALIAS("RAT_STALLS.PARTIAL_CYCLES",				\
    IAP_EVENT_D2H_02H)							\
__PMC_EV_ALIAS("RAT_STALLS.ROB_READ_PORT",				\
    IAP_EVENT_D2H_01H)							\
__PMC_EV_ALIAS("RESOURCE_STALLS.ANY",	IAP_EVENT_DCH_1FH)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.BR_MISS_CLEAR",				\
    IAP_EVENT_DCH_10H)							\
__PMC_EV_ALIAS("RESOURCE_STALLS.FPCW",	IAP_EVENT_DCH_08H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.LD_ST",	IAP_EVENT_DCH_04H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.ROB_FULL",				\
    IAP_EVENT_DCH_01H)							\
__PMC_EV_ALIAS("RESOURCE_STALLS.RS_FULL", IAP_EVENT_DCH_02H)		\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED",	IAP_EVENT_A0H_00H)		\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT0", IAP_EVENT_A1H_01H)		\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT1", IAP_EVENT_A1H_02H)		\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT2", IAP_EVENT_A1H_04H)		\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT3", IAP_EVENT_A1H_08H)		\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT4", IAP_EVENT_A1H_10H)		\
__PMC_EV_ALIAS("RS_UOPS_DISPATCHED.PORT5", IAP_EVENT_A1H_20H)		\
__PMC_EV_ALIAS("SB_DRAIN_CYCLES",	IAP_EVENT_04H_01H)		\
__PMC_EV_ALIAS("SEGMENT_REG_LOADS",	IAP_EVENT_06H_00H)		\
__PMC_EV_ALIAS("SEG_REG_RENAMES.ANY",	IAP_EVENT_D5H_0FH)		\
__PMC_EV_ALIAS("SEG_REG_RENAMES.DS",	IAP_EVENT_D5H_02H)		\
__PMC_EV_ALIAS("SEG_REG_RENAMES.ES",	IAP_EVENT_D5H_01H)		\
__PMC_EV_ALIAS("SEG_REG_RENAMES.FS",	IAP_EVENT_D5H_04H)		\
__PMC_EV_ALIAS("SEG_REG_RENAMES.GS",	IAP_EVENT_D5H_08H)		\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.ANY",	IAP_EVENT_D4H_0FH)		\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.DS",	IAP_EVENT_D4H_02H)		\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.ES",	IAP_EVENT_D4H_01H)		\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.FS",	IAP_EVENT_D4H_04H)		\
__PMC_EV_ALIAS("SEG_RENAME_STALLS.GS",	IAP_EVENT_D4H_08H)		\
__PMC_EV_ALIAS("SIMD_ASSIST",		IAP_EVENT_CDH_00H)		\
__PMC_EV_ALIAS("SIMD_COMP_INST_RETIRED.PACKED_DOUBLE",			\
    IAP_EVENT_CAH_04H)							\
__PMC_EV_ALIAS("SIMD_COMP_INST_RETIRED.PACKED_SINGLE",			\
    IAP_EVENT_CAH_01H)							\
__PMC_EV_ALIAS("SIMD_COMP_INST_RETIRED.SCALAR_DOUBLE",			\
    IAP_EVENT_CAH_08H)							\
__PMC_EV_ALIAS("SIMD_COMP_INST_RETIRED.SCALAR_SINGLE",			\
    IAP_EVENT_CAH_02H)							\
__PMC_EV_ALIAS("SIMD_INSTR_RETIRED",	IAP_EVENT_CEH_00H)		\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.ANY",	IAP_EVENT_C7H_1FH)		\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.PACKED_DOUBLE",			\
    IAP_EVENT_C7H_04H)							\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.PACKED_SINGLE",			\
    IAP_EVENT_C7H_01H)							\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.SCALAR_DOUBLE",			\
    IAP_EVENT_C7H_08H)							\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.SCALAR_SINGLE",			\
    IAP_EVENT_C7H_02H)							\
__PMC_EV_ALIAS("SIMD_INST_RETIRED.VECTOR",	IAP_EVENT_C7H_10H)	\
__PMC_EV_ALIAS("SIMD_SAT_INSTR_RETIRED",	IAP_EVENT_CFH_00H)	\
__PMC_EV_ALIAS("SIMD_SAT_UOP_EXEC",		IAP_EVENT_B1H_00H)	\
__PMC_EV_ALIAS("SIMD_UOPS_EXEC",		IAP_EVENT_B0H_00H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.ARITHMETIC",	IAP_EVENT_B3H_20H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.LOGICAL",	IAP_EVENT_B3H_10H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.MUL",	IAP_EVENT_B3H_01H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.PACK",	IAP_EVENT_B3H_04H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.SHIFT",	IAP_EVENT_B3H_02H)	\
__PMC_EV_ALIAS("SIMD_UOP_TYPE_EXEC.UNPACK",	IAP_EVENT_B3H_08H)	\
__PMC_EV_ALIAS("SNOOP_STALL_DRV",		IAP_EVENT_7EH)		\
__PMC_EV_ALIAS("SSE_PRE_EXEC.L1",		IAP_EVENT_07H_01H)	\
__PMC_EV_ALIAS("SSE_PRE_EXEC.L2",		IAP_EVENT_07H_02H)	\
__PMC_EV_ALIAS("SSE_PRE_EXEC.NTA",		IAP_EVENT_07H_00H)	\
__PMC_EV_ALIAS("SSE_PRE_EXEC.STORES",		IAP_EVENT_07H_03H)	\
__PMC_EV_ALIAS("SSE_PRE_MISS.L1",		IAP_EVENT_4BH_01H)	\
__PMC_EV_ALIAS("SSE_PRE_MISS.L2",		IAP_EVENT_4BH_02H)	\
__PMC_EV_ALIAS("SSE_PRE_MISS.NTA",		IAP_EVENT_4BH_00H)	\
__PMC_EV_ALIAS("STORE_BLOCK.ORDER",		IAP_EVENT_04H_02H)	\
__PMC_EV_ALIAS("STORE_BLOCK.SNOOP",		IAP_EVENT_04H_08H)	\
__PMC_EV_ALIAS("THERMAL_TRIP",			IAP_EVENT_3BH_C0H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.ANY",		IAP_EVENT_C2H_0FH)	\
__PMC_EV_ALIAS("UOPS_RETIRED.FUSED",		IAP_EVENT_C2H_07H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.LD_IND_BR",	IAP_EVENT_C2H_01H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.MACRO_FUSION",	IAP_EVENT_C2H_04H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.NON_FUSED",	IAP_EVENT_C2H_08H)	\
__PMC_EV_ALIAS("UOPS_RETIRED.STD_STA",		IAP_EVENT_C2H_02H)	\
__PMC_EV_ALIAS("X87_OPS_RETIRED.ANY",		IAP_EVENT_C1H_FEH)	\
__PMC_EV_ALIAS("X87_OPS_RETIRED.FXCH",		IAP_EVENT_C1H_01H)

/*
 * Core i7 and Xeon 5500 events removed between 253669-031US June 2009
 * and 253669-033US December 2009.
 */
#define	__PMC_EV_ALIAS_COREI7_OLD()					\
__PMC_EV_ALIAS("SB_FORWARD.ANY", IAP_EVENT_02H_01H)			\
__PMC_EV_ALIAS("LOAD_BLOCK.STD", IAP_EVENT_03H_01H)			\
__PMC_EV_ALIAS("LOAD_BLOCK.ADDRESS_OFFSET", IAP_EVENT_03H_04H)		\
__PMC_EV_ALIAS("SB_DRAIN.CYCLES", IAP_EVENT_04H_01H)			\
__PMC_EV_ALIAS("MISALIGN_MEM_REF.LOAD", IAP_EVENT_05H_01H)		\
__PMC_EV_ALIAS("MISALIGN_MEM_REF.STORE", IAP_EVENT_05H_02H)		\
__PMC_EV_ALIAS("MISALIGN_MEM_REF.ANY", IAP_EVENT_05H_03H)		\
__PMC_EV_ALIAS("STORE_BLOCKS.NOT_STA", IAP_EVENT_06H_01H)		\
__PMC_EV_ALIAS("STORE_BLOCKS.STA", IAP_EVENT_06H_02H)			\
__PMC_EV_ALIAS("STORE_BLOCKS.ANY", IAP_EVENT_06H_0FH)			\
__PMC_EV_ALIAS("MEMORY_DISAMBIGURATION.RESET", IAP_EVENT_09H_01H)	\
__PMC_EV_ALIAS("MEMORY_DISAMBIGURATION.SUCCESS", IAP_EVENT_09H_02H)	\
__PMC_EV_ALIAS("MEMORY_DISAMBIGURATION.WATCHDOG", IAP_EVENT_09H_04H)	\
__PMC_EV_ALIAS("MEMORY_DISAMBIGURATION.WATCH_CYCLES", IAP_EVENT_09H_08H)\
__PMC_EV_ALIAS("HW_INT.RCV", IAP_EVENT_1DH_01H)				\
__PMC_EV_ALIAS("HW_INT.CYCLES_MASKED", IAP_EVENT_1DH_02H)		\
__PMC_EV_ALIAS("HW_INT.CYCLES_PENDING_AND_MASKED", IAP_EVENT_1DH_04H)	\
__PMC_EV_ALIAS("L2_WRITE.RFO.E_STATE", IAP_EVENT_27H_04H)		\
__PMC_EV_ALIAS("UOPS_DECODED.DEC0", IAP_EVENT_3DH_01H)			\
__PMC_EV_ALIAS("L1D_CACHE_ST.I_STATE", IAP_EVENT_41H_01H)		\
__PMC_EV_ALIAS("L1D_CACHE_ST.MESI", IAP_EVENT_41H_0FH)			\
__PMC_EV_ALIAS("DTLB_MISSES.PDE_MISS", IAP_EVENT_49H_20H)		\
__PMC_EV_ALIAS("DTLB_MISSES.PDP_MISS", IAP_EVENT_49H_40H)		\
__PMC_EV_ALIAS("DTLB_MISSES.LARGE_WALK_COMPLETED", IAP_EVENT_49H_80H)	\
__PMC_EV_ALIAS("SSE_MEM_EXEC.NTA", IAP_EVENT_4BH_01H)			\
__PMC_EV_ALIAS("SSE_MEM_EXEC.STREAMING_STORES", IAP_EVENT_4BH_08H)	\
__PMC_EV_ALIAS("SFENCE_CYCLES", IAP_EVENT_4DH_01H)			\
__PMC_EV_ALIAS("EPT.EPDE_MISS", IAP_EVENT_4FH_02H)			\
__PMC_EV_ALIAS("EPT.EPDPE_HIT", IAP_EVENT_4FH_04H)			\
__PMC_EV_ALIAS("EPT.EPDPE_MISS", IAP_EVENT_4FH_08H)			\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_OUTSTANDING.DEMAND.READ_DATA",		\
    IAP_EVENT_60H_01H)							\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_OUTSTANDING.DEMAND.READ_CODE",		\
    IAP_EVENT_60H_02H)							\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_OUTSTANDING.DEMAND.RFO",		\
    IAP_EVENT_60H_04H)							\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_OUTSTANDING.ANY.READ",			\
    IAP_EVENT_60H_08H)							\
__PMC_EV_ALIAS("IFU_IVC.FULL", IAP_EVENT_81H_01H)			\
__PMC_EV_ALIAS("IFU_IVC.L1I_EVICTION", IAP_EVENT_81H_02H)		\
__PMC_EV_ALIAS("L1I_OPPORTUNISTIC_HITS", IAP_EVENT_83H_01H)		\
__PMC_EV_ALIAS("ITLB_MISSES.WALK_CYCLES", IAP_EVENT_85H_04H)		\
__PMC_EV_ALIAS("ITLB_MISSES.PMH_BUSY_CYCLES", IAP_EVENT_85H_04H)	\
__PMC_EV_ALIAS("ITLB_MISSES.STLB_HIT", IAP_EVENT_85H_10H)		\
__PMC_EV_ALIAS("ITLB_MISSES.PDE_MISS", IAP_EVENT_85H_20H)		\
__PMC_EV_ALIAS("ITLB_MISSES.PDP_MISS", IAP_EVENT_85H_40H)		\
__PMC_EV_ALIAS("ITLB_MISSES.LARGE_WALK_COMPLETED", IAP_EVENT_85H_80H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.DEMAND.READ_DATA", IAP_EVENT_B0H_01H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.DEMAND.READ_CODE", IAP_EVENT_B0H_02H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.DEMAND.RFO", IAP_EVENT_B0H_04H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.ANY.READ", IAP_EVENT_B0H_08H)		\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.ANY.RFO", IAP_EVENT_B0H_10H)		\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.UNCACHED_MEM", IAP_EVENT_B0H_20H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.ANY", IAP_EVENT_B0H_80H)		\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS_OUTSTANDING.DATA", IAP_EVENT_B3H_01H)	\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS_OUTSTANDING.INVALIDATE",		\
    IAP_EVENT_B3H_02H)							\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS_OUTSTANDING.CODE", IAP_EVENT_B3H_04H)	\
__PMC_EV_ALIAS("PIC_ACCESSES.TPR_READS", IAP_EVENT_BAH_01H)		\
__PMC_EV_ALIAS("PIC_ACCESSES.TPR_WRITES", IAP_EVENT_BAH_02H)		\
__PMC_EV_ALIAS("MACHINE_CLEARS.FUSION_ASSIST", IAP_EVENT_C3H_10H)	\
__PMC_EV_ALIAS("BOGUS_BR", IAP_EVENT_E4H_01H)				\
__PMC_EV_ALIAS("L2_HW_PREFETCH.HIT", IAP_EVENT_F3H_01H)			\
__PMC_EV_ALIAS("L2_HW_PREFETCH.ALLOC", IAP_EVENT_F3H_02H)		\
__PMC_EV_ALIAS("L2_HW_PREFETCH.DATA_TRIGGER", IAP_EVENT_F3H_04H)	\
__PMC_EV_ALIAS("L2_HW_PREFETCH.CODE_TRIGGER", IAP_EVENT_F3H_08H)	\
__PMC_EV_ALIAS("L2_HW_PREFETCH.DCA_TRIGGER", IAP_EVENT_F3H_10H)		\
__PMC_EV_ALIAS("L2_HW_PREFETCH.KICK_START", IAP_EVENT_F3H_20H)		\
__PMC_EV_ALIAS("SQ_MISC.PROMOTION", IAP_EVENT_F4H_01H)			\
__PMC_EV_ALIAS("SQ_MISC.PROMOTION_POST_GO", IAP_EVENT_F4H_02H)		\
__PMC_EV_ALIAS("SQ_MISC.LRU_HINTS", IAP_EVENT_F4H_04H)			\
__PMC_EV_ALIAS("SQ_MISC.FILL_DROPPED", IAP_EVENT_F4H_08H)		\
__PMC_EV_ALIAS("SEGMENT_REG_LOADS", IAP_EVENT_F8H_01H)

/*
 * Aliases for Core i7 and Xeon 5500 PMC events (253669-033US December 2009)
 */
#define	__PMC_EV_ALIAS_COREI7()						\
__PMC_EV_ALIAS_INTEL_ARCHITECTURAL()					\
__PMC_EV_ALIAS("SB_DRAIN.ANY", 	IAP_EVENT_04H_07H)			\
__PMC_EV_ALIAS("STORE_BLOCKS.AT_RET", IAP_EVENT_06H_04H)		\
__PMC_EV_ALIAS("STORE_BLOCKS.L1D_BLOCK", IAP_EVENT_06H_08H)		\
__PMC_EV_ALIAS("PARTIAL_ADDRESS_ALIAS", IAP_EVENT_07H_01H)		\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.ANY", IAP_EVENT_08H_01H)		\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.WALK_COMPLETED", IAP_EVENT_08H_02H)	\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.STLB_HIT", IAP_EVENT_08H_10H)		\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.PDE_MISS", IAP_EVENT_08H_20H)		\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.PDP_MISS", IAP_EVENT_08H_40H)		\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.LARGE_WALK_COMPLETED",			\
    IAP_EVENT_08H_80H) 							\
__PMC_EV_ALIAS("MEM_INST_RETIRED.LOADS", IAP_EVENT_0BH_01H)		\
__PMC_EV_ALIAS("MEM_INST_RETIRED.STORES", IAP_EVENT_0BH_02H)		\
__PMC_EV_ALIAS("MEM_INST_RETIRED.LATENCY_ABOVE_THRESHOLD",		\
    IAP_EVENT_0BH_10H) 							\
__PMC_EV_ALIAS("MEM_STORE_RETIRED.DTLB_MISS", IAP_EVENT_0CH_01H)	\
__PMC_EV_ALIAS("UOPS_ISSUED.ANY", IAP_EVENT_0EH_01H)			\
__PMC_EV_ALIAS("UOPS_ISSUED.STALLED_CYCLES", IAP_EVENT_0EH_01H)		\
__PMC_EV_ALIAS("UOPS_ISSUED.FUSED", IAP_EVENT_0EH_02H)			\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.L3_DATA_MISS_UNKNOWN",		\
    IAP_EVENT_0FH_01H)							\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.OTHER_CORE_L2_HITM",			\
    IAP_EVENT_0FH_02H)							\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.REMOTE_CACHE_LOCAL_HOME_HIT",	\
    IAP_EVENT_0FH_08H)							\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.REMOTE_DRAM",			\
    IAP_EVENT_0FH_10H)							\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.LOCAL_DRAM", IAP_EVENT_0FH_20H)	\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.UNCACHEABLE", IAP_EVENT_0FH_80H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.X87", IAP_EVENT_10H_01H)		\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.MMX", IAP_EVENT_10H_02H)		\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_FP", IAP_EVENT_10H_04H)		\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE2_INTEGER", IAP_EVENT_10H_08H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_FP_PACKED", IAP_EVENT_10H_10H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_FP_SCALAR", IAP_EVENT_10H_20H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_SINGLE_PRECISION",			\
    IAP_EVENT_10H_40H)							\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_DOUBLE_PRECISION",			\
    IAP_EVENT_10H_80H)							\
__PMC_EV_ALIAS("SIMD_INT_128.PACKED_MPY", IAP_EVENT_12H_01H)		\
__PMC_EV_ALIAS("SIMD_INT_128.PACKED_SHIFT", IAP_EVENT_12H_02H)		\
__PMC_EV_ALIAS("SIMD_INT_128.PACK", IAP_EVENT_12H_04H)			\
__PMC_EV_ALIAS("SIMD_INT_128.UNPACK", IAP_EVENT_12H_08H)		\
__PMC_EV_ALIAS("SIMD_INT_128.PACKED_LOGICAL", IAP_EVENT_12H_10H)	\
__PMC_EV_ALIAS("SIMD_INT_128.PACKED_ARITH", IAP_EVENT_12H_20H)		\
__PMC_EV_ALIAS("SIMD_INT_128.SHUFFLE_MOVE", IAP_EVENT_12H_40H)		\
__PMC_EV_ALIAS("LOAD_DISPATCH.RS", IAP_EVENT_13H_01H)			\
__PMC_EV_ALIAS("LOAD_DISPATCH.RS_DELAYED", IAP_EVENT_13H_02H)		\
__PMC_EV_ALIAS("LOAD_DISPATCH.MOB", IAP_EVENT_13H_04H)			\
__PMC_EV_ALIAS("LOAD_DISPATCH.ANY", IAP_EVENT_13H_07H)			\
__PMC_EV_ALIAS("ARITH.CYCLES_DIV_BUSY", IAP_EVENT_14H_01H)		\
__PMC_EV_ALIAS("ARITH.MUL", IAP_EVENT_14H_02H)				\
__PMC_EV_ALIAS("INST_QUEUE_WRITES", IAP_EVENT_17H_01H)			\
__PMC_EV_ALIAS("INST_DECODED.DEC0", IAP_EVENT_18H_01H)			\
__PMC_EV_ALIAS("TWO_UOP_INSTS_DECODED", IAP_EVENT_19H_01H)		\
__PMC_EV_ALIAS("INST_QUEUE_WRITE_CYCLES", IAP_EVENT_1EH_01H)		\
__PMC_EV_ALIAS("LSD_OVERFLOW", IAP_EVENT_20H_01H)			\
__PMC_EV_ALIAS("L2_RQSTS.LD_HIT", IAP_EVENT_24H_01H)			\
__PMC_EV_ALIAS("L2_RQSTS.LD_MISS", IAP_EVENT_24H_02H)			\
__PMC_EV_ALIAS("L2_RQSTS.LOADS", IAP_EVENT_24H_03H)			\
__PMC_EV_ALIAS("L2_RQSTS.RFO_HIT", IAP_EVENT_24H_04H)			\
__PMC_EV_ALIAS("L2_RQSTS.RFO_MISS", IAP_EVENT_24H_08H)			\
__PMC_EV_ALIAS("L2_RQSTS.RFOS", IAP_EVENT_24H_0CH)			\
__PMC_EV_ALIAS("L2_RQSTS.IFETCH_HIT", IAP_EVENT_24H_10H)		\
__PMC_EV_ALIAS("L2_RQSTS.IFETCH_MISS", IAP_EVENT_24H_20H)		\
__PMC_EV_ALIAS("L2_RQSTS.IFETCHES", IAP_EVENT_24H_30H)			\
__PMC_EV_ALIAS("L2_RQSTS.PREFETCH_HIT", IAP_EVENT_24H_40H)		\
__PMC_EV_ALIAS("L2_RQSTS.PREFETCH_MISS", IAP_EVENT_24H_80H)		\
__PMC_EV_ALIAS("L2_RQSTS.PREFETCHES", IAP_EVENT_24H_C0H)		\
__PMC_EV_ALIAS("L2_RQSTS.MISS", IAP_EVENT_24H_AAH)			\
__PMC_EV_ALIAS("L2_RQSTS.REFERENCES", IAP_EVENT_24H_FFH)		\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.I_STATE", IAP_EVENT_26H_01H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.S_STATE", IAP_EVENT_26H_02H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.E_STATE", IAP_EVENT_26H_04H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.M_STATE", IAP_EVENT_26H_08H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.MESI", IAP_EVENT_26H_0FH)		\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.I_STATE", IAP_EVENT_26H_10H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.S_STATE", IAP_EVENT_26H_20H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.E_STATE", IAP_EVENT_26H_40H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.M_STATE", IAP_EVENT_26H_80H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.MESI", IAP_EVENT_26H_F0H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.ANY", IAP_EVENT_26H_FFH)			\
__PMC_EV_ALIAS("L2_WRITE.RFO.I_STATE", IAP_EVENT_27H_01H)		\
__PMC_EV_ALIAS("L2_WRITE.RFO.S_STATE", IAP_EVENT_27H_02H)		\
__PMC_EV_ALIAS("L2_WRITE.RFO.M_STATE", IAP_EVENT_27H_08H)		\
__PMC_EV_ALIAS("L2_WRITE.RFO.HIT", IAP_EVENT_27H_0EH)			\
__PMC_EV_ALIAS("L2_WRITE.RFO.MESI", IAP_EVENT_27H_0FH)			\
__PMC_EV_ALIAS("L2_WRITE.LOCK.I_STATE", IAP_EVENT_27H_10H)		\
__PMC_EV_ALIAS("L2_WRITE.LOCK.S_STATE", IAP_EVENT_27H_20H)		\
__PMC_EV_ALIAS("L2_WRITE.LOCK.E_STATE", IAP_EVENT_27H_40H)		\
__PMC_EV_ALIAS("L2_WRITE.LOCK.M_STATE", IAP_EVENT_27H_80H)		\
__PMC_EV_ALIAS("L2_WRITE.LOCK.HIT", IAP_EVENT_27H_E0H)			\
__PMC_EV_ALIAS("L2_WRITE.LOCK.MESI", IAP_EVENT_27H_F0H)			\
__PMC_EV_ALIAS("L1D_WB_L2.I_STATE", IAP_EVENT_28H_01H)			\
__PMC_EV_ALIAS("L1D_WB_L2.S_STATE", IAP_EVENT_28H_02H)			\
__PMC_EV_ALIAS("L1D_WB_L2.E_STATE", IAP_EVENT_28H_04H)			\
__PMC_EV_ALIAS("L1D_WB_L2.M_STATE", IAP_EVENT_28H_08H)			\
__PMC_EV_ALIAS("L1D_WB_L2.MESI", IAP_EVENT_28H_0FH)			\
__PMC_EV_ALIAS("L3_LAT_CACHE.REFERENCE", IAP_EVENT_2EH_4FH)		\
__PMC_EV_ALIAS("L3_LAT_CACHE.MISS", IAP_EVENT_2EH_41H)			\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.THREAD_P", IAP_EVENT_3CH_00H)		\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.REF_P", IAP_EVENT_3CH_01H)		\
__PMC_EV_ALIAS("L1D_CACHE_LD.I_STATE", IAP_EVENT_40H_01H)		\
__PMC_EV_ALIAS("L1D_CACHE_LD.S_STATE", IAP_EVENT_40H_02H)		\
__PMC_EV_ALIAS("L1D_CACHE_LD.E_STATE", IAP_EVENT_40H_04H)		\
__PMC_EV_ALIAS("L1D_CACHE_LD.M_STATE", IAP_EVENT_40H_08H)		\
__PMC_EV_ALIAS("L1D_CACHE_LD.MESI", IAP_EVENT_40H_0FH)			\
__PMC_EV_ALIAS("L1D_CACHE_ST.S_STATE", IAP_EVENT_41H_02H)		\
__PMC_EV_ALIAS("L1D_CACHE_ST.E_STATE", IAP_EVENT_41H_04H)		\
__PMC_EV_ALIAS("L1D_CACHE_ST.M_STATE", IAP_EVENT_41H_08H)		\
__PMC_EV_ALIAS("L1D_CACHE_LOCK.HIT", IAP_EVENT_42H_01H)			\
__PMC_EV_ALIAS("L1D_CACHE_LOCK.S_STATE", IAP_EVENT_42H_02H)		\
__PMC_EV_ALIAS("L1D_CACHE_LOCK.E_STATE", IAP_EVENT_42H_04H)		\
__PMC_EV_ALIAS("L1D_CACHE_LOCK.M_STATE", IAP_EVENT_42H_08H)		\
__PMC_EV_ALIAS("L1D_ALL_REF.ANY", IAP_EVENT_43H_01H)			\
__PMC_EV_ALIAS("L1D_ALL_REF.CACHEABLE", IAP_EVENT_43H_02H)		\
__PMC_EV_ALIAS("L1D_PEND_MISS.LOAD_BUFFERS_FULL", IAP_EVENT_48H_02H)	\
__PMC_EV_ALIAS("DTLB_MISSES.ANY", IAP_EVENT_49H_01H)			\
__PMC_EV_ALIAS("DTLB_MISSES.WALK_COMPLETED", IAP_EVENT_49H_02H)		\
__PMC_EV_ALIAS("DTLB_MISSES.STLB_HIT", IAP_EVENT_49H_10H)		\
__PMC_EV_ALIAS("LOAD_HIT_PRE", IAP_EVENT_4CH_01H)			\
__PMC_EV_ALIAS("L1D_PREFETCH.REQUESTS", IAP_EVENT_4EH_01H)		\
__PMC_EV_ALIAS("L1D_PREFETCH.MISS", IAP_EVENT_4EH_02H)			\
__PMC_EV_ALIAS("L1D_PREFETCH.TRIGGERS", IAP_EVENT_4EH_04H)		\
__PMC_EV_ALIAS("L1D.REPL", IAP_EVENT_51H_01H)				\
__PMC_EV_ALIAS("L1D.M_REPL", IAP_EVENT_51H_02H)				\
__PMC_EV_ALIAS("L1D.M_EVICT", IAP_EVENT_51H_04H)			\
__PMC_EV_ALIAS("L1D.M_SNOOP_EVICT", IAP_EVENT_51H_08H)			\
__PMC_EV_ALIAS("L1D_CACHE_PREFETCH_LOCK_FB_HIT", IAP_EVENT_52H_01H)	\
__PMC_EV_ALIAS("L1D_CACHE_LOCK_FB_HIT", IAP_EVENT_53H_01H)		\
__PMC_EV_ALIAS("CACHE_LOCK_CYCLES.L1D_L2", IAP_EVENT_63H_01H)		\
__PMC_EV_ALIAS("CACHE_LOCK_CYCLES.L1D", IAP_EVENT_63H_02H)		\
__PMC_EV_ALIAS("IO_TRANSACTIONS", IAP_EVENT_6CH_01H)			\
__PMC_EV_ALIAS("L1I.HITS", IAP_EVENT_80H_01H)				\
__PMC_EV_ALIAS("L1I.MISSES", IAP_EVENT_80H_02H)				\
__PMC_EV_ALIAS("L1I.READS", IAP_EVENT_80H_03H)				\
__PMC_EV_ALIAS("L1I.CYCLES_STALLED", IAP_EVENT_80H_04H)			\
__PMC_EV_ALIAS("LARGE_ITLB.HIT", IAP_EVENT_82H_01H)			\
__PMC_EV_ALIAS("ITLB_MISSES.ANY", IAP_EVENT_85H_01H)			\
__PMC_EV_ALIAS("ITLB_MISSES.WALK_COMPLETED", IAP_EVENT_85H_02H)		\
__PMC_EV_ALIAS("ILD_STALL.LCP", IAP_EVENT_87H_01H)			\
__PMC_EV_ALIAS("ILD_STALL.MRU", IAP_EVENT_87H_02H)			\
__PMC_EV_ALIAS("ILD_STALL.IQ_FULL", IAP_EVENT_87H_04H)			\
__PMC_EV_ALIAS("ILD_STALL.REGEN", IAP_EVENT_87H_08H)			\
__PMC_EV_ALIAS("ILD_STALL.ANY", IAP_EVENT_87H_0FH)			\
__PMC_EV_ALIAS("BR_INST_EXEC.COND", IAP_EVENT_88H_01H)			\
__PMC_EV_ALIAS("BR_INST_EXEC.DIRECT", IAP_EVENT_88H_02H)		\
__PMC_EV_ALIAS("BR_INST_EXEC.INDIRECT_NON_CALL", IAP_EVENT_88H_04H)	\
__PMC_EV_ALIAS("BR_INST_EXEC.NON_CALLS", IAP_EVENT_88H_07H)		\
__PMC_EV_ALIAS("BR_INST_EXEC.RETURN_NEAR", IAP_EVENT_88H_08H)		\
__PMC_EV_ALIAS("BR_INST_EXEC.DIRECT_NEAR_CALL", IAP_EVENT_88H_10H)	\
__PMC_EV_ALIAS("BR_INST_EXEC.INDIRECT_NEAR_CALL", IAP_EVENT_88H_20H)	\
__PMC_EV_ALIAS("BR_INST_EXEC.NEAR_CALLS", IAP_EVENT_88H_30H)		\
__PMC_EV_ALIAS("BR_INST_EXEC.TAKEN", IAP_EVENT_88H_40H)			\
__PMC_EV_ALIAS("BR_INST_EXEC.ANY", IAP_EVENT_88H_7FH)			\
__PMC_EV_ALIAS("BR_MISP_EXEC.COND", IAP_EVENT_89H_01H)			\
__PMC_EV_ALIAS("BR_MISP_EXEC.DIRECT", IAP_EVENT_89H_02H)		\
__PMC_EV_ALIAS("BR_MISP_EXEC.INDIRECT_NON_CALL", IAP_EVENT_89H_04H)	\
__PMC_EV_ALIAS("BR_MISP_EXEC.NON_CALLS", IAP_EVENT_89H_07H)		\
__PMC_EV_ALIAS("BR_MISP_EXEC.RETURN_NEAR", IAP_EVENT_89H_08H)		\
__PMC_EV_ALIAS("BR_MISP_EXEC.DIRECT_NEAR_CALL", IAP_EVENT_89H_10H)	\
__PMC_EV_ALIAS("BR_MISP_EXEC.INDIRECT_NEAR_CALL", IAP_EVENT_89H_20H)	\
__PMC_EV_ALIAS("BR_MISP_EXEC.NEAR_CALLS", IAP_EVENT_89H_30H)		\
__PMC_EV_ALIAS("BR_MISP_EXEC.TAKEN", IAP_EVENT_89H_40H)			\
__PMC_EV_ALIAS("BR_MISP_EXEC.ANY", IAP_EVENT_89H_7FH)			\
__PMC_EV_ALIAS("RESOURCE_STALLS.ANY", IAP_EVENT_A2H_01H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.LOAD", IAP_EVENT_A2H_02H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.RS_FULL", IAP_EVENT_A2H_04H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.STORE", IAP_EVENT_A2H_08H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.ROB_FULL", IAP_EVENT_A2H_10H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.FPCW", IAP_EVENT_A2H_20H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.MXCSR", IAP_EVENT_A2H_40H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.OTHER", IAP_EVENT_A2H_80H)		\
__PMC_EV_ALIAS("MACRO_INSTS.FUSIONS_DECODED", IAP_EVENT_A6H_01H)	\
__PMC_EV_ALIAS("BACLEAR_FORCE_IQ", IAP_EVENT_A7H_01H)			\
__PMC_EV_ALIAS("LSD.UOPS", IAP_EVENT_A8H_01H)				\
__PMC_EV_ALIAS("ITLB_FLUSH", IAP_EVENT_AEH_01H)				\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.L1D_WRITEBACK", IAP_EVENT_B0H_40H)	\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT0", IAP_EVENT_B1H_01H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT1", IAP_EVENT_B1H_02H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT2_CORE", IAP_EVENT_B1H_04H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT3_CORE", IAP_EVENT_B1H_08H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT4_CORE", IAP_EVENT_B1H_10H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.CORE_ACTIVE_CYCLES_NO_PORT5",		\
    IAP_EVENT_B1H_1FH)							\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT5", IAP_EVENT_B1H_20H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.CORE_ACTIVE_CYCLES", IAP_EVENT_B1H_3FH)	\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT015", IAP_EVENT_B1H_40H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT234", IAP_EVENT_B1H_80H)		\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_SQ_FULL", IAP_EVENT_B2H_01H)		\
__PMC_EV_ALIAS("OFF_CORE_RESPONSE_0", IAP_EVENT_B7H_01H)		\
__PMC_EV_ALIAS("SNOOP_RESPONSE.HIT", IAP_EVENT_B8H_01H)			\
__PMC_EV_ALIAS("SNOOP_RESPONSE.HITE", IAP_EVENT_B8H_02H)		\
__PMC_EV_ALIAS("SNOOP_RESPONSE.HITM", IAP_EVENT_B8H_04H)		\
__PMC_EV_ALIAS("OFF_CORE_RESPONSE_1", IAP_EVENT_BBH_01H)		\
__PMC_EV_ALIAS("INST_RETIRED.ANY_P", IAP_EVENT_C0H_01H)			\
__PMC_EV_ALIAS("INST_RETIRED.X87", IAP_EVENT_C0H_02H)			\
__PMC_EV_ALIAS("INST_RETIRED.MMX", IAP_EVENT_C0H_04H)			\
__PMC_EV_ALIAS("UOPS_RETIRED.ANY", IAP_EVENT_C2H_01H)			\
__PMC_EV_ALIAS("UOPS_RETIRED.RETIRE_SLOTS", IAP_EVENT_C2H_02H)		\
__PMC_EV_ALIAS("UOPS_RETIRED.MACRO_FUSED", IAP_EVENT_C2H_04H)		\
__PMC_EV_ALIAS("MACHINE_CLEARS.CYCLES", IAP_EVENT_C3H_01H)		\
__PMC_EV_ALIAS("MACHINE_CLEARS.MEM_ORDER", IAP_EVENT_C3H_02H)		\
__PMC_EV_ALIAS("MACHINE_CLEARS.SMC", IAP_EVENT_C3H_04H)			\
__PMC_EV_ALIAS("BR_INST_RETIRED.ALL_BRANCHES", IAP_EVENT_C4H_00H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.CONDITIONAL", IAP_EVENT_C4H_01H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.NEAR_CALL", IAP_EVENT_C4H_02H)		\
__PMC_EV_ALIAS("BR_INST_RETIRED.ALL_BRANCHES", IAP_EVENT_C4H_04H)	\
__PMC_EV_ALIAS("BR_MISP_RETIRED.ALL_BRANCHES", IAP_EVENT_C5H_00H)	\
__PMC_EV_ALIAS("BR_MISP_RETIRED.NEAR_CALL", IAP_EVENT_C5H_02H)		\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.PACKED_SINGLE", IAP_EVENT_C7H_01H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.SCALAR_SINGLE", IAP_EVENT_C7H_02H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.PACKED_DOUBLE", IAP_EVENT_C7H_04H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.SCALAR_DOUBLE", IAP_EVENT_C7H_08H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.VECTOR_INTEGER", IAP_EVENT_C7H_10H)	\
__PMC_EV_ALIAS("ITLB_MISS_RETIRED", IAP_EVENT_C8H_20H)			\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L1D_HIT", IAP_EVENT_CBH_01H)		\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L2_HIT", IAP_EVENT_CBH_02H)		\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L3_UNSHARED_HIT", IAP_EVENT_CBH_04H)	\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.OTHER_CORE_L2_HIT_HITM",		\
    IAP_EVENT_CBH_08H)							\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L3_MISS", IAP_EVENT_CBH_10H)		\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.HIT_LFB", IAP_EVENT_CBH_40H)		\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.DTLB_MISS", IAP_EVENT_CBH_80H)		\
__PMC_EV_ALIAS("FP_MMX_TRANS.TO_FP", IAP_EVENT_CCH_01H)			\
__PMC_EV_ALIAS("FP_MMX_TRANS.TO_MMX", IAP_EVENT_CCH_02H)		\
__PMC_EV_ALIAS("FP_MMX_TRANS.ANY", IAP_EVENT_CCH_03H)			\
__PMC_EV_ALIAS("MACRO_INSTS.DECODED", IAP_EVENT_D0H_01H)		\
__PMC_EV_ALIAS("UOPS_DECODED.MS", IAP_EVENT_D1H_02H)			\
__PMC_EV_ALIAS("UOPS_DECODED.ESP_FOLDING", IAP_EVENT_D1H_04H)		\
__PMC_EV_ALIAS("UOPS_DECODED.ESP_SYNC", IAP_EVENT_D1H_08H)		\
__PMC_EV_ALIAS("RAT_STALLS.FLAGS", IAP_EVENT_D2H_01H)			\
__PMC_EV_ALIAS("RAT_STALLS.REGISTERS", IAP_EVENT_D2H_02H)		\
__PMC_EV_ALIAS("RAT_STALLS.ROB_READ_PORT", IAP_EVENT_D2H_04H)		\
__PMC_EV_ALIAS("RAT_STALLS.SCOREBOARD", IAP_EVENT_D2H_08H)		\
__PMC_EV_ALIAS("RAT_STALLS.ANY", IAP_EVENT_D2H_0FH)			\
__PMC_EV_ALIAS("SEG_RENAME_STALLS", IAP_EVENT_D4H_01H)			\
__PMC_EV_ALIAS("ES_REG_RENAMES", IAP_EVENT_D5H_01H)			\
__PMC_EV_ALIAS("UOP_UNFUSION", IAP_EVENT_DBH_01H)			\
__PMC_EV_ALIAS("BR_INST_DECODED", IAP_EVENT_E0H_01H)			\
__PMC_EV_ALIAS("BPU_MISSED_CALL_RET", IAP_EVENT_E5H_01H)		\
__PMC_EV_ALIAS("BACLEAR.CLEAR", IAP_EVENT_E6H_01H)			\
__PMC_EV_ALIAS("BACLEAR.BAD_TARGET", IAP_EVENT_E6H_02H)			\
__PMC_EV_ALIAS("BPU_CLEARS.EARLY", IAP_EVENT_E8H_01H)			\
__PMC_EV_ALIAS("BPU_CLEARS.LATE", IAP_EVENT_E8H_02H)			\
__PMC_EV_ALIAS("BPU_CLEARS.ANY", IAP_EVENT_E8H_03H)			\
__PMC_EV_ALIAS("L2_TRANSACTIONS.LOAD", IAP_EVENT_F0H_01H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.RFO", IAP_EVENT_F0H_02H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.IFETCH", IAP_EVENT_F0H_04H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.PREFETCH", IAP_EVENT_F0H_08H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.L1D_WB", IAP_EVENT_F0H_10H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.FILL", IAP_EVENT_F0H_20H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.WB", IAP_EVENT_F0H_40H)			\
__PMC_EV_ALIAS("L2_TRANSACTIONS.ANY", IAP_EVENT_F0H_80H)		\
__PMC_EV_ALIAS("L2_LINES_IN.S_STATE", IAP_EVENT_F1H_02H)		\
__PMC_EV_ALIAS("L2_LINES_IN.E_STATE", IAP_EVENT_F1H_04H)		\
__PMC_EV_ALIAS("L2_LINES_IN.ANY", IAP_EVENT_F1H_07H)			\
__PMC_EV_ALIAS("L2_LINES_OUT.DEMAND_CLEAN", IAP_EVENT_F2H_01H)		\
__PMC_EV_ALIAS("L2_LINES_OUT.DEMAND_DIRTY", IAP_EVENT_F2H_02H)		\
__PMC_EV_ALIAS("L2_LINES_OUT.PREFETCH_CLEAN", IAP_EVENT_F2H_04H)	\
__PMC_EV_ALIAS("L2_LINES_OUT.PREFETCH_DIRTY", IAP_EVENT_F2H_08H)	\
__PMC_EV_ALIAS("L2_LINES_OUT.ANY", IAP_EVENT_F2H_0FH)			\
__PMC_EV_ALIAS("SQ_MISC.SPLIT_LOCK", IAP_EVENT_F4H_10H)			\
__PMC_EV_ALIAS("SQ_FULL_STALL_CYCLES", IAP_EVENT_F6H_01H)		\
__PMC_EV_ALIAS("FP_ASSIST.ALL", IAP_EVENT_F7H_01H)			\
__PMC_EV_ALIAS("FP_ASSIST.OUTPUT", IAP_EVENT_F7H_02H)			\
__PMC_EV_ALIAS("FP_ASSIST.INPUT", IAP_EVENT_F7H_04H)			\
__PMC_EV_ALIAS("SIMD_INT_64.PACKED_MPY", IAP_EVENT_FDH_01H)		\
__PMC_EV_ALIAS("SIMD_INT_64.PACKED_SHIFT", IAP_EVENT_FDH_02H)		\
__PMC_EV_ALIAS("SIMD_INT_64.PACK", IAP_EVENT_FDH_04H)			\
__PMC_EV_ALIAS("SIMD_INT_64.UNPACK", IAP_EVENT_FDH_08H)			\
__PMC_EV_ALIAS("SIMD_INT_64.PACKED_LOGICAL", IAP_EVENT_FDH_10H)		\
__PMC_EV_ALIAS("SIMD_INT_64.PACKED_ARITH", IAP_EVENT_FDH_20H)		\
__PMC_EV_ALIAS("SIMD_INT_64.SHUFFLE_MOVE", IAP_EVENT_FDH_40H)		\
__PMC_EV_ALIAS_COREI7_OLD()

/*
 * Aliases for Westmere PMC events (253669-033US December 2009)
 */
#define	__PMC_EV_ALIAS_WESTMERE()					\
__PMC_EV_ALIAS_INTEL_ARCHITECTURAL()					\
__PMC_EV_ALIAS("LOAD_BLOCK.OVERLAP_STORE", IAP_EVENT_03H_02H)		\
__PMC_EV_ALIAS("SB_DRAIN.ANY", IAP_EVENT_04H_07H)			\
__PMC_EV_ALIAS("MISALIGN_MEMORY.STORE", IAP_EVENT_05H_02H)		\
__PMC_EV_ALIAS("STORE_BLOCKS.AT_RET", IAP_EVENT_06H_04H)		\
__PMC_EV_ALIAS("STORE_BLOCKS.L1D_BLOCK", IAP_EVENT_06H_08H)		\
__PMC_EV_ALIAS("PARTIAL_ADDRESS_ALIAS", IAP_EVENT_07H_01H)		\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.ANY", IAP_EVENT_08H_01H)		\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.WALK_COMPLETED", IAP_EVENT_08H_02H)	\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.WALK_CYCLES", IAP_EVENT_08H_04H)	\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.STLB_HIT", IAP_EVENT_08H_10H)		\
__PMC_EV_ALIAS("DTLB_LOAD_MISSES.PDE_MISS", IAP_EVENT_08H_20H)		\
__PMC_EV_ALIAS("MEM_INST_RETIRED.LOADS", IAP_EVENT_0BH_01H)		\
__PMC_EV_ALIAS("MEM_INST_RETIRED.STORES", IAP_EVENT_0BH_02H)		\
__PMC_EV_ALIAS("MEM_INST_RETIRED.LATENCY_ABOVE_THRESHOLD",		\
    IAP_EVENT_0BH_10H)							\
__PMC_EV_ALIAS("MEM_STORE_RETIRED.DTLB_MISS", IAP_EVENT_0CH_01H)	\
__PMC_EV_ALIAS("UOPS_ISSUED.ANY", IAP_EVENT_0EH_01H)			\
__PMC_EV_ALIAS("UOPS_ISSUED.STALLED_CYCLES", IAP_EVENT_0EH_01H)		\
__PMC_EV_ALIAS("UOPS_ISSUED.FUSED", IAP_EVENT_0EH_02H)			\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.LOCAL_HITM", IAP_EVENT_0FH_02H)	\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.LOCAL_DRAM_AND_REMOTE_CACHE_HIT",	\
    IAP_EVENT_0FH_08H)							\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.LOCAL_DRAM", IAP_EVENT_0FH_10H)	\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.REMOTE_DRAM", IAP_EVENT_0FH_20H)	\
__PMC_EV_ALIAS("MEM_UNCORE_RETIRED.UNCACHEABLE", IAP_EVENT_0FH_80H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.X87", IAP_EVENT_10H_01H)		\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.MMX", IAP_EVENT_10H_02H)		\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_FP", IAP_EVENT_10H_04H)		\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE2_INTEGER", IAP_EVENT_10H_08H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_FP_PACKED", IAP_EVENT_10H_10H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_FP_SCALAR", IAP_EVENT_10H_20H)	\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_SINGLE_PRECISION",			\
    IAP_EVENT_10H_40H) 							\
__PMC_EV_ALIAS("FP_COMP_OPS_EXE.SSE_DOUBLE_PRECISION",			\
    IAP_EVENT_10H_80H)							\
__PMC_EV_ALIAS("SIMD_INT_128.PACKED_MPY", IAP_EVENT_12H_01H)		\
__PMC_EV_ALIAS("SIMD_INT_128.PACKED_SHIFT", IAP_EVENT_12H_02H)		\
__PMC_EV_ALIAS("SIMD_INT_128.PACK", IAP_EVENT_12H_04H)			\
__PMC_EV_ALIAS("SIMD_INT_128.UNPACK", IAP_EVENT_12H_08H)		\
__PMC_EV_ALIAS("SIMD_INT_128.PACKED_LOGICAL", IAP_EVENT_12H_10H)	\
__PMC_EV_ALIAS("SIMD_INT_128.PACKED_ARITH", IAP_EVENT_12H_20H)		\
__PMC_EV_ALIAS("SIMD_INT_128.SHUFFLE_MOVE", IAP_EVENT_12H_40H)		\
__PMC_EV_ALIAS("LOAD_DISPATCH.RS", IAP_EVENT_13H_01H)			\
__PMC_EV_ALIAS("LOAD_DISPATCH.RS_DELAYED", IAP_EVENT_13H_02H)		\
__PMC_EV_ALIAS("LOAD_DISPATCH.MOB", IAP_EVENT_13H_04H)			\
__PMC_EV_ALIAS("LOAD_DISPATCH.ANY", IAP_EVENT_13H_07H)			\
__PMC_EV_ALIAS("ARITH.CYCLES_DIV_BUSY", IAP_EVENT_14H_01H)		\
__PMC_EV_ALIAS("ARITH.MUL", IAP_EVENT_14H_02H)				\
__PMC_EV_ALIAS("INST_QUEUE_WRITES", IAP_EVENT_17H_01H)			\
__PMC_EV_ALIAS("INST_DECODED.DEC0", IAP_EVENT_18H_01H)			\
__PMC_EV_ALIAS("TWO_UOP_INSTS_DECODED", IAP_EVENT_19H_01H)		\
__PMC_EV_ALIAS("INST_QUEUE_WRITE_CYCLES", IAP_EVENT_1EH_01H)		\
__PMC_EV_ALIAS("LSD_OVERFLOW", IAP_EVENT_20H_01H)			\
__PMC_EV_ALIAS("L2_RQSTS.LD_HIT", IAP_EVENT_24H_01H)			\
__PMC_EV_ALIAS("L2_RQSTS.LD_MISS", IAP_EVENT_24H_02H)			\
__PMC_EV_ALIAS("L2_RQSTS.LOADS", IAP_EVENT_24H_03H)			\
__PMC_EV_ALIAS("L2_RQSTS.RFO_HIT", IAP_EVENT_24H_04H)			\
__PMC_EV_ALIAS("L2_RQSTS.RFO_MISS", IAP_EVENT_24H_08H)			\
__PMC_EV_ALIAS("L2_RQSTS.RFOS", IAP_EVENT_24H_0CH)			\
__PMC_EV_ALIAS("L2_RQSTS.IFETCH_HIT", IAP_EVENT_24H_10H)		\
__PMC_EV_ALIAS("L2_RQSTS.IFETCH_MISS", IAP_EVENT_24H_20H)		\
__PMC_EV_ALIAS("L2_RQSTS.IFETCHES", IAP_EVENT_24H_30H)			\
__PMC_EV_ALIAS("L2_RQSTS.PREFETCH_HIT", IAP_EVENT_24H_40H)		\
__PMC_EV_ALIAS("L2_RQSTS.PREFETCH_MISS", IAP_EVENT_24H_80H)		\
__PMC_EV_ALIAS("L2_RQSTS.PREFETCHES", IAP_EVENT_24H_C0H)		\
__PMC_EV_ALIAS("L2_RQSTS.MISS", IAP_EVENT_24H_AAH)			\
__PMC_EV_ALIAS("L2_RQSTS.REFERENCES", IAP_EVENT_24H_FFH)		\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.I_STATE", IAP_EVENT_26H_01H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.S_STATE", IAP_EVENT_26H_02H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.E_STATE", IAP_EVENT_26H_04H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.M_STATE", IAP_EVENT_26H_08H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.DEMAND.MESI", IAP_EVENT_26H_0FH)		\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.I_STATE", IAP_EVENT_26H_10H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.S_STATE", IAP_EVENT_26H_20H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.E_STATE", IAP_EVENT_26H_40H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.M_STATE", IAP_EVENT_26H_80H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.PREFETCH.MESI", IAP_EVENT_26H_F0H)	\
__PMC_EV_ALIAS("L2_DATA_RQSTS.ANY", IAP_EVENT_26H_FFH)			\
__PMC_EV_ALIAS("L2_WRITE.RFO.I_STATE", IAP_EVENT_27H_01H)		\
__PMC_EV_ALIAS("L2_WRITE.RFO.S_STATE", IAP_EVENT_27H_02H)		\
__PMC_EV_ALIAS("L2_WRITE.RFO.M_STATE", IAP_EVENT_27H_08H)		\
__PMC_EV_ALIAS("L2_WRITE.RFO.HIT", IAP_EVENT_27H_0EH)			\
__PMC_EV_ALIAS("L2_WRITE.RFO.MESI", IAP_EVENT_27H_0FH)			\
__PMC_EV_ALIAS("L2_WRITE.LOCK.I_STATE", IAP_EVENT_27H_10H)		\
__PMC_EV_ALIAS("L2_WRITE.LOCK.S_STATE", IAP_EVENT_27H_20H)		\
__PMC_EV_ALIAS("L2_WRITE.LOCK.E_STATE", IAP_EVENT_27H_40H)		\
__PMC_EV_ALIAS("L2_WRITE.LOCK.M_STATE", IAP_EVENT_27H_80H)		\
__PMC_EV_ALIAS("L2_WRITE.LOCK.HIT", IAP_EVENT_27H_E0H)			\
__PMC_EV_ALIAS("L2_WRITE.LOCK.MESI", IAP_EVENT_27H_F0H)			\
__PMC_EV_ALIAS("L1D_WB_L2.I_STATE", IAP_EVENT_28H_01H)			\
__PMC_EV_ALIAS("L1D_WB_L2.S_STATE", IAP_EVENT_28H_02H)			\
__PMC_EV_ALIAS("L1D_WB_L2.E_STATE", IAP_EVENT_28H_04H)			\
__PMC_EV_ALIAS("L1D_WB_L2.M_STATE", IAP_EVENT_28H_08H)			\
__PMC_EV_ALIAS("L1D_WB_L2.MESI", IAP_EVENT_28H_0FH)			\
__PMC_EV_ALIAS("L3_LAT_CACHE.REFERENCE", IAP_EVENT_2EH_02H)		\
__PMC_EV_ALIAS("L3_LAT_CACHE.MISS", IAP_EVENT_2EH_01H)			\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.THREAD_P", IAP_EVENT_3CH_00H)		\
__PMC_EV_ALIAS("CPU_CLK_UNHALTED.REF_P", IAP_EVENT_3CH_01H)		\
__PMC_EV_ALIAS("DTLB_MISSES.ANY", IAP_EVENT_49H_01H)			\
__PMC_EV_ALIAS("DTLB_MISSES.WALK_COMPLETED", IAP_EVENT_49H_02H)		\
__PMC_EV_ALIAS("DTLB_MISSES.WALK_CYCLES", IAP_EVENT_49H_04H)		\
__PMC_EV_ALIAS("DTLB_MISSES.STLB_HIT", IAP_EVENT_49H_10H)		\
__PMC_EV_ALIAS("DTLB_MISSES.LARGE_WALK_COMPLETED", IAP_EVENT_49H_80H)	\
__PMC_EV_ALIAS("LOAD_HIT_PRE", IAP_EVENT_4CH_01H)			\
__PMC_EV_ALIAS("L1D_PREFETCH.REQUESTS", IAP_EVENT_4EH_01H)		\
__PMC_EV_ALIAS("L1D_PREFETCH.MISS", IAP_EVENT_4EH_02H)			\
__PMC_EV_ALIAS("L1D_PREFETCH.TRIGGERS", IAP_EVENT_4EH_04H)		\
__PMC_EV_ALIAS("EPT.WALK_CYCLES", IAP_EVENT_4FH_10H)			\
__PMC_EV_ALIAS("L1D.REPL", IAP_EVENT_51H_01H)				\
__PMC_EV_ALIAS("L1D.M_REPL", IAP_EVENT_51H_02H)				\
__PMC_EV_ALIAS("L1D.M_EVICT", IAP_EVENT_51H_04H)			\
__PMC_EV_ALIAS("L1D.M_SNOOP_EVICT", IAP_EVENT_51H_08H)			\
__PMC_EV_ALIAS("L1D_CACHE_PREFETCH_LOCK_FB_HIT", IAP_EVENT_52H_01H)	\
__PMC_EV_ALIAS("L1D_CACHE_LOCK_FB_HIT", IAP_EVENT_53H_01H)		\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_OUTSTANDING.DEMAND.READ_DATA",		\
    IAP_EVENT_60H_01H)							\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_OUTSTANDING.DEMAND.READ_CODE",		\
    IAP_EVENT_60H_02H)							\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_OUTSTANDING.DEMAND.RFO",		\
    IAP_EVENT_60H_04H)							\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_OUTSTANDING.ANY.READ",			\
    IAP_EVENT_60H_08H)							\
__PMC_EV_ALIAS("CACHE_LOCK_CYCLES.L1D_L2", IAP_EVENT_63H_01H)		\
__PMC_EV_ALIAS("CACHE_LOCK_CYCLES.L1D", IAP_EVENT_63H_02H)		\
__PMC_EV_ALIAS("IO_TRANSACTIONS", IAP_EVENT_6CH_01H)			\
__PMC_EV_ALIAS("L1I.HITS", IAP_EVENT_80H_01H)				\
__PMC_EV_ALIAS("L1I.MISSES", IAP_EVENT_80H_02H)				\
__PMC_EV_ALIAS("L1I.READS", IAP_EVENT_80H_03H)				\
__PMC_EV_ALIAS("L1I.CYCLES_STALLED", IAP_EVENT_80H_04H)			\
__PMC_EV_ALIAS("LARGE_ITLB.HIT", IAP_EVENT_82H_01H)			\
__PMC_EV_ALIAS("ITLB_MISSES.ANY", IAP_EVENT_85H_01H)			\
__PMC_EV_ALIAS("ITLB_MISSES.WALK_COMPLETED", IAP_EVENT_85H_02H)		\
__PMC_EV_ALIAS("ITLB_MISSES.WALK_CYCLES", IAP_EVENT_85H_04H)		\
__PMC_EV_ALIAS("ITLB_MISSES.LARGE_WALK_COMPLETED", IAP_EVENT_85H_80H)	\
__PMC_EV_ALIAS("ILD_STALL.LCP", IAP_EVENT_87H_01H)			\
__PMC_EV_ALIAS("ILD_STALL.MRU", IAP_EVENT_87H_02H)			\
__PMC_EV_ALIAS("ILD_STALL.IQ_FULL", IAP_EVENT_87H_04H)			\
__PMC_EV_ALIAS("ILD_STALL.REGEN", IAP_EVENT_87H_08H)			\
__PMC_EV_ALIAS("ILD_STALL.ANY", IAP_EVENT_87H_0FH)			\
__PMC_EV_ALIAS("BR_INST_EXEC.COND", IAP_EVENT_88H_01H)			\
__PMC_EV_ALIAS("BR_INST_EXEC.DIRECT", IAP_EVENT_88H_02H)		\
__PMC_EV_ALIAS("BR_INST_EXEC.INDIRECT_NON_CALL", IAP_EVENT_88H_04H)	\
__PMC_EV_ALIAS("BR_INST_EXEC.NON_CALLS", IAP_EVENT_88H_07H)		\
__PMC_EV_ALIAS("BR_INST_EXEC.RETURN_NEAR", IAP_EVENT_88H_08H)		\
__PMC_EV_ALIAS("BR_INST_EXEC.DIRECT_NEAR_CALL", IAP_EVENT_88H_10H)	\
__PMC_EV_ALIAS("BR_INST_EXEC.INDIRECT_NEAR_CALL", IAP_EVENT_88H_20H)	\
__PMC_EV_ALIAS("BR_INST_EXEC.NEAR_CALLS", IAP_EVENT_88H_30H)		\
__PMC_EV_ALIAS("BR_INST_EXEC.TAKEN", IAP_EVENT_88H_40H)			\
__PMC_EV_ALIAS("BR_INST_EXEC.ANY", IAP_EVENT_88H_7FH)			\
__PMC_EV_ALIAS("BR_MISP_EXEC.COND", IAP_EVENT_89H_01H)			\
__PMC_EV_ALIAS("BR_MISP_EXEC.DIRECT", IAP_EVENT_89H_02H)		\
__PMC_EV_ALIAS("BR_MISP_EXEC.INDIRECT_NON_CALL", IAP_EVENT_89H_04H)	\
__PMC_EV_ALIAS("BR_MISP_EXEC.NON_CALLS", IAP_EVENT_89H_07H)		\
__PMC_EV_ALIAS("BR_MISP_EXEC.RETURN_NEAR", IAP_EVENT_89H_08H)		\
__PMC_EV_ALIAS("BR_MISP_EXEC.DIRECT_NEAR_CALL", IAP_EVENT_89H_10H)	\
__PMC_EV_ALIAS("BR_MISP_EXEC.INDIRECT_NEAR_CALL", IAP_EVENT_89H_20H)	\
__PMC_EV_ALIAS("BR_MISP_EXEC.NEAR_CALLS", IAP_EVENT_89H_30H)		\
__PMC_EV_ALIAS("BR_MISP_EXEC.TAKEN", IAP_EVENT_89H_40H)			\
__PMC_EV_ALIAS("BR_MISP_EXEC.ANY", IAP_EVENT_89H_7FH)			\
__PMC_EV_ALIAS("RESOURCE_STALLS.ANY", IAP_EVENT_A2H_01H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.LOAD", IAP_EVENT_A2H_02H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.RS_FULL", IAP_EVENT_A2H_04H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.STORE", IAP_EVENT_A2H_08H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.ROB_FULL", IAP_EVENT_A2H_10H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.FPCW", IAP_EVENT_A2H_20H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.MXCSR", IAP_EVENT_A2H_40H)		\
__PMC_EV_ALIAS("RESOURCE_STALLS.OTHER", IAP_EVENT_A2H_80H)		\
__PMC_EV_ALIAS("MACRO_INSTS.FUSIONS_DECODED", IAP_EVENT_A6H_01H)	\
__PMC_EV_ALIAS("BACLEAR_FORCE_IQ", IAP_EVENT_A7H_01H)			\
__PMC_EV_ALIAS("LSD.UOPS", IAP_EVENT_A8H_01H)				\
__PMC_EV_ALIAS("ITLB_FLUSH", IAP_EVENT_AEH_01H)				\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.DEMAND.READ_DATA", IAP_EVENT_B0H_01H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.DEMAND.READ_CODE", IAP_EVENT_B0H_02H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.DEMAND.RFO", IAP_EVENT_B0H_04H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.ANY.READ", IAP_EVENT_B0H_08H)		\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.ANY.RFO", IAP_EVENT_B0H_10H)		\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.L1D_WRITEBACK", IAP_EVENT_B0H_40H)	\
__PMC_EV_ALIAS("OFFCORE_REQUESTS.ANY", IAP_EVENT_B0H_80H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT0", IAP_EVENT_B1H_01H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT1", IAP_EVENT_B1H_02H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT2_CORE", IAP_EVENT_B1H_04H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT3_CORE", IAP_EVENT_B1H_08H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT4_CORE", IAP_EVENT_B1H_10H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.CORE_ACTIVE_CYCLES_NO_PORT5",		\
    IAP_EVENT_B1H_1FH)							\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT5", IAP_EVENT_B1H_20H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.CORE_ACTIVE_CYCLES", IAP_EVENT_B1H_3FH)	\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT015", IAP_EVENT_B1H_40H)		\
__PMC_EV_ALIAS("UOPS_EXECUTED.PORT234", IAP_EVENT_B1H_80H)		\
__PMC_EV_ALIAS("OFFCORE_REQUESTS_SQ_FULL", IAP_EVENT_B2H_01H)		\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS_OUTSTANDING.DATA", IAP_EVENT_B3H_01H)	\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS_OUTSTANDING.INVALIDATE",		\
    IAP_EVENT_B3H_02H)							\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS_OUTSTANDING.CODE", IAP_EVENT_B3H_04H)	\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS.CODE", IAP_EVENT_B4H_01H)		\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS.DATA", IAP_EVENT_B4H_02H)		\
__PMC_EV_ALIAS("SNOOPQ_REQUESTS.INVALIDATE", IAP_EVENT_B4H_04H)		\
__PMC_EV_ALIAS("OFF_CORE_RESPONSE_0", IAP_EVENT_B7H_01H)		\
__PMC_EV_ALIAS("SNOOP_RESPONSE.HIT", IAP_EVENT_B8H_01H)			\
__PMC_EV_ALIAS("SNOOP_RESPONSE.HITE", IAP_EVENT_B8H_02H)		\
__PMC_EV_ALIAS("SNOOP_RESPONSE.HITM", IAP_EVENT_B8H_04H)		\
__PMC_EV_ALIAS("OFF_CORE_RESPONSE_1", IAP_EVENT_BBH_01H)		\
__PMC_EV_ALIAS("INST_RETIRED.ANY_P", IAP_EVENT_C0H_01H)			\
__PMC_EV_ALIAS("INST_RETIRED.X87", IAP_EVENT_C0H_02H)			\
__PMC_EV_ALIAS("INST_RETIRED.MMX", IAP_EVENT_C0H_04H)			\
__PMC_EV_ALIAS("UOPS_RETIRED.ANY", IAP_EVENT_C2H_01H)			\
__PMC_EV_ALIAS("UOPS_RETIRED.RETIRE_SLOTS", IAP_EVENT_C2H_02H)		\
__PMC_EV_ALIAS("UOPS_RETIRED.MACRO_FUSED", IAP_EVENT_C2H_04H)		\
__PMC_EV_ALIAS("MACHINE_CLEARS.CYCLES", IAP_EVENT_C3H_01H)		\
__PMC_EV_ALIAS("MACHINE_CLEARS.MEM_ORDER", IAP_EVENT_C3H_02H)		\
__PMC_EV_ALIAS("MACHINE_CLEARS.SMC", IAP_EVENT_C3H_04H)			\
__PMC_EV_ALIAS("BR_INST_RETIRED.ANY_P", IAP_EVENT_C4H_00H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.CONDITIONAL", IAP_EVENT_C4H_01H)	\
__PMC_EV_ALIAS("BR_INST_RETIRED.NEAR_CALL", IAP_EVENT_C4H_02H)		\
__PMC_EV_ALIAS("BR_INST_RETIRED.ALL_BRANCHES", IAP_EVENT_C4H_04H)	\
__PMC_EV_ALIAS("BR_MISP_RETIRED.ANY_P", IAP_EVENT_C5H_00H)	\
__PMC_EV_ALIAS("BR_MISP_RETIRED.CONDITIONAL", IAP_EVENT_C5H_01H)	\
__PMC_EV_ALIAS("BR_MISP_RETIRED.NEAR_CALL", IAP_EVENT_C5H_02H)		\
__PMC_EV_ALIAS("BR_MISP_RETIRED.ALL_BRANCHES", IAP_EVENT_C5H_04H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.PACKED_SINGLE", IAP_EVENT_C7H_01H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.SCALAR_SINGLE", IAP_EVENT_C7H_02H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.PACKED_DOUBLE", IAP_EVENT_C7H_04H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.SCALAR_DOUBLE", IAP_EVENT_C7H_08H)	\
__PMC_EV_ALIAS("SSEX_UOPS_RETIRED.VECTOR_INTEGER", IAP_EVENT_C7H_10H)	\
__PMC_EV_ALIAS("ITLB_MISS_RETIRED", IAP_EVENT_C8H_20H)			\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L1D_HIT", IAP_EVENT_CBH_01H)		\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L2_HIT", IAP_EVENT_CBH_02H)		\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L3_UNSHARED_HIT", IAP_EVENT_CBH_04H)	\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.OTHER_CORE_L2_HIT_HITM",		\
    IAP_EVENT_CBH_08H)							\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.L3_MISS", IAP_EVENT_CBH_10H)		\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.HIT_LFB", IAP_EVENT_CBH_40H)		\
__PMC_EV_ALIAS("MEM_LOAD_RETIRED.DTLB_MISS", IAP_EVENT_CBH_80H)		\
__PMC_EV_ALIAS("FP_MMX_TRANS.TO_FP", IAP_EVENT_CCH_01H)			\
__PMC_EV_ALIAS("FP_MMX_TRANS.TO_MMX", IAP_EVENT_CCH_02H)		\
__PMC_EV_ALIAS("FP_MMX_TRANS.ANY", IAP_EVENT_CCH_03H)			\
__PMC_EV_ALIAS("MACRO_INSTS.DECODED", IAP_EVENT_D0H_01H)		\
__PMC_EV_ALIAS("UOPS_DECODED.STALL_CYCLES", IAP_EVENT_D1H_01H)		\
__PMC_EV_ALIAS("UOPS_DECODED.MS", IAP_EVENT_D1H_02H)			\
__PMC_EV_ALIAS("UOPS_DECODED.ESP_FOLDING", IAP_EVENT_D1H_04H)		\
__PMC_EV_ALIAS("UOPS_DECODED.ESP_SYNC", IAP_EVENT_D1H_08H)		\
__PMC_EV_ALIAS("RAT_STALLS.FLAGS", IAP_EVENT_D2H_01H)			\
__PMC_EV_ALIAS("RAT_STALLS.REGISTERS", IAP_EVENT_D2H_02H)		\
__PMC_EV_ALIAS("RAT_STALLS.ROB_READ_PORT", IAP_EVENT_D2H_04H)		\
__PMC_EV_ALIAS("RAT_STALLS.SCOREBOARD", IAP_EVENT_D2H_08H)		\
__PMC_EV_ALIAS("RAT_STALLS.ANY", IAP_EVENT_D2H_0FH)			\
__PMC_EV_ALIAS("SEG_RENAME_STALLS", IAP_EVENT_D4H_01H)			\
__PMC_EV_ALIAS("ES_REG_RENAMES", IAP_EVENT_D5H_01H)			\
__PMC_EV_ALIAS("UOP_UNFUSION", IAP_EVENT_DBH_01H)			\
__PMC_EV_ALIAS("BR_INST_DECODED", IAP_EVENT_E0H_01H)			\
__PMC_EV_ALIAS("BPU_MISSED_CALL_RET", IAP_EVENT_E5H_01H)		\
__PMC_EV_ALIAS("BACLEAR.CLEAR", IAP_EVENT_E6H_01H)			\
__PMC_EV_ALIAS("BACLEAR.BAD_TARGET", IAP_EVENT_E6H_02H)			\
__PMC_EV_ALIAS("BPU_CLEARS.EARLY", IAP_EVENT_E8H_01H)			\
__PMC_EV_ALIAS("BPU_CLEARS.LATE", IAP_EVENT_E8H_02H)			\
__PMC_EV_ALIAS("THREAD_ACTIVE", IAP_EVENT_ECH_01H)			\
__PMC_EV_ALIAS("L2_TRANSACTIONS.LOAD", IAP_EVENT_F0H_01H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.RFO", IAP_EVENT_F0H_02H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.IFETCH", IAP_EVENT_F0H_04H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.PREFETCH", IAP_EVENT_F0H_08H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.L1D_WB", IAP_EVENT_F0H_10H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.FILL", IAP_EVENT_F0H_20H)		\
__PMC_EV_ALIAS("L2_TRANSACTIONS.WB", IAP_EVENT_F0H_40H)			\
__PMC_EV_ALIAS("L2_TRANSACTIONS.ANY", IAP_EVENT_F0H_80H)		\
__PMC_EV_ALIAS("L2_LINES_IN.S_STATE", IAP_EVENT_F1H_02H)		\
__PMC_EV_ALIAS("L2_LINES_IN.E_STATE", IAP_EVENT_F1H_04H)		\
__PMC_EV_ALIAS("L2_LINES_IN.ANY", IAP_EVENT_F1H_07H)			\
__PMC_EV_ALIAS("L2_LINES_OUT.DEMAND_CLEAN", IAP_EVENT_F2H_01H)		\
__PMC_EV_ALIAS("L2_LINES_OUT.DEMAND_DIRTY", IAP_EVENT_F2H_02H)		\
__PMC_EV_ALIAS("L2_LINES_OUT.PREFETCH_CLEAN", IAP_EVENT_F2H_04H)	\
__PMC_EV_ALIAS("L2_LINES_OUT.PREFETCH_DIRTY", IAP_EVENT_F2H_08H)	\
__PMC_EV_ALIAS("L2_LINES_OUT.ANY", IAP_EVENT_F2H_0FH)			\
__PMC_EV_ALIAS("SQ_MISC.LRU_HINTS", IAP_EVENT_F4H_04H)			\
__PMC_EV_ALIAS("SQ_MISC.SPLIT_LOCK", IAP_EVENT_F4H_10H)			\
__PMC_EV_ALIAS("SQ_FULL_STALL_CYCLES", IAP_EVENT_F6H_01H)		\
__PMC_EV_ALIAS("FP_ASSIST.ALL", IAP_EVENT_F7H_01H)			\
__PMC_EV_ALIAS("FP_ASSIST.OUTPUT", IAP_EVENT_F7H_02H)			\
__PMC_EV_ALIAS("FP_ASSIST.INPUT", IAP_EVENT_F7H_04H)			\
__PMC_EV_ALIAS("SIMD_INT_64.PACKED_MPY", IAP_EVENT_FDH_01H)		\
__PMC_EV_ALIAS("SIMD_INT_64.PACKED_SHIFT", IAP_EVENT_FDH_02H)		\
__PMC_EV_ALIAS("SIMD_INT_64.PACK", IAP_EVENT_FDH_04H)			\
__PMC_EV_ALIAS("SIMD_INT_64.UNPACK", IAP_EVENT_FDH_08H)			\
__PMC_EV_ALIAS("SIMD_INT_64.PACKED_LOGICAL", IAP_EVENT_FDH_10H)		\
__PMC_EV_ALIAS("SIMD_INT_64.PACKED_ARITH", IAP_EVENT_FDH_20H)		\
__PMC_EV_ALIAS("SIMD_INT_64.SHUFFLE_MOVE", IAP_EVENT_FDH_40H)

/* timestamp counters. */
#define	__PMC_EV_TSC()							\
	__PMC_EV(TSC, TSC)

#define	PMC_EV_TSC_FIRST	PMC_EV_TSC_TSC
#define	PMC_EV_TSC_LAST		PMC_EV_TSC_TSC

#define	__PMC_EV_UCF()				\
__PMC_EV(UCF, UCLOCK)

#define	PMC_EV_UCF_FIRST	PMC_EV_UCF_UCLOCK
#define	PMC_EV_UCF_LAST		PMC_EV_UCF_UCLOCK

#define	__PMC_EV_UCP()				\
__PMC_EV(UCP, EVENT_00H_01H)			\
__PMC_EV(UCP, EVENT_00H_02H)			\
__PMC_EV(UCP, EVENT_00H_04H)			\
__PMC_EV(UCP, EVENT_01H_01H)			\
__PMC_EV(UCP, EVENT_01H_02H)			\
__PMC_EV(UCP, EVENT_01H_04H)			\
__PMC_EV(UCP, EVENT_02H_01H)			\
__PMC_EV(UCP, EVENT_03H_01H)			\
__PMC_EV(UCP, EVENT_03H_02H)			\
__PMC_EV(UCP, EVENT_03H_04H)			\
__PMC_EV(UCP, EVENT_03H_08H)			\
__PMC_EV(UCP, EVENT_03H_10H)			\
__PMC_EV(UCP, EVENT_03H_20H)			\
__PMC_EV(UCP, EVENT_03H_40H)			\
__PMC_EV(UCP, EVENT_04H_01H)			\
__PMC_EV(UCP, EVENT_04H_02H)			\
__PMC_EV(UCP, EVENT_04H_04H)			\
__PMC_EV(UCP, EVENT_04H_08H)			\
__PMC_EV(UCP, EVENT_04H_10H)			\
__PMC_EV(UCP, EVENT_05H_01H)			\
__PMC_EV(UCP, EVENT_05H_02H)			\
__PMC_EV(UCP, EVENT_05H_04H)			\
__PMC_EV(UCP, EVENT_06H_01H)			\
__PMC_EV(UCP, EVENT_06H_02H)			\
__PMC_EV(UCP, EVENT_06H_04H)			\
__PMC_EV(UCP, EVENT_06H_08H)			\
__PMC_EV(UCP, EVENT_06H_10H)			\
__PMC_EV(UCP, EVENT_06H_20H)			\
__PMC_EV(UCP, EVENT_07H_01H)			\
__PMC_EV(UCP, EVENT_07H_02H)			\
__PMC_EV(UCP, EVENT_07H_04H)			\
__PMC_EV(UCP, EVENT_07H_08H)			\
__PMC_EV(UCP, EVENT_07H_10H)			\
__PMC_EV(UCP, EVENT_07H_20H)			\
__PMC_EV(UCP, EVENT_07H_24H)			\
__PMC_EV(UCP, EVENT_08H_01H)			\
__PMC_EV(UCP, EVENT_08H_02H)			\
__PMC_EV(UCP, EVENT_08H_04H)			\
__PMC_EV(UCP, EVENT_08H_03H)			\
__PMC_EV(UCP, EVENT_09H_01H)			\
__PMC_EV(UCP, EVENT_09H_02H)			\
__PMC_EV(UCP, EVENT_09H_04H)			\
__PMC_EV(UCP, EVENT_09H_03H)			\
__PMC_EV(UCP, EVENT_0AH_01H)			\
__PMC_EV(UCP, EVENT_0AH_02H)			\
__PMC_EV(UCP, EVENT_0AH_04H)			\
__PMC_EV(UCP, EVENT_0AH_08H)			\
__PMC_EV(UCP, EVENT_0AH_0FH)			\
__PMC_EV(UCP, EVENT_0BH_01H)			\
__PMC_EV(UCP, EVENT_0BH_02H)			\
__PMC_EV(UCP, EVENT_0BH_04H)			\
__PMC_EV(UCP, EVENT_0BH_08H)			\
__PMC_EV(UCP, EVENT_0BH_10H)			\
__PMC_EV(UCP, EVENT_0BH_1FH)			\
__PMC_EV(UCP, EVENT_0CH_01H)			\
__PMC_EV(UCP, EVENT_0CH_02H)			\
__PMC_EV(UCP, EVENT_0CH_04H)			\
__PMC_EV(UCP, EVENT_0CH_08H)			\
__PMC_EV(UCP, EVENT_20H_01H)			\
__PMC_EV(UCP, EVENT_20H_02H)			\
__PMC_EV(UCP, EVENT_20H_04H)			\
__PMC_EV(UCP, EVENT_20H_08H)			\
__PMC_EV(UCP, EVENT_20H_10H)			\
__PMC_EV(UCP, EVENT_20H_20H)			\
__PMC_EV(UCP, EVENT_21H_01H)			\
__PMC_EV(UCP, EVENT_21H_02H)			\
__PMC_EV(UCP, EVENT_21H_04H)			\
__PMC_EV(UCP, EVENT_22H_01H)			\
__PMC_EV(UCP, EVENT_22H_02H)			\
__PMC_EV(UCP, EVENT_22H_04H)			\
__PMC_EV(UCP, EVENT_23H_01H)			\
__PMC_EV(UCP, EVENT_23H_02H)			\
__PMC_EV(UCP, EVENT_23H_04H)			\
__PMC_EV(UCP, EVENT_24H_02H)			\
__PMC_EV(UCP, EVENT_24H_04H)			\
__PMC_EV(UCP, EVENT_25H_01H)			\
__PMC_EV(UCP, EVENT_25H_02H)			\
__PMC_EV(UCP, EVENT_25H_04H)			\
__PMC_EV(UCP, EVENT_26H_01H)			\
__PMC_EV(UCP, EVENT_27H_01H)			\
__PMC_EV(UCP, EVENT_27H_02H)			\
__PMC_EV(UCP, EVENT_27H_04H)			\
__PMC_EV(UCP, EVENT_27H_08H)			\
__PMC_EV(UCP, EVENT_27H_10H)			\
__PMC_EV(UCP, EVENT_27H_20H)			\
__PMC_EV(UCP, EVENT_28H_01H)			\
__PMC_EV(UCP, EVENT_28H_02H)			\
__PMC_EV(UCP, EVENT_28H_04H)			\
__PMC_EV(UCP, EVENT_28H_08H)			\
__PMC_EV(UCP, EVENT_28H_10H)			\
__PMC_EV(UCP, EVENT_28H_20H)			\
__PMC_EV(UCP, EVENT_29H_01H)			\
__PMC_EV(UCP, EVENT_29H_02H)			\
__PMC_EV(UCP, EVENT_29H_04H)			\
__PMC_EV(UCP, EVENT_29H_08H)			\
__PMC_EV(UCP, EVENT_29H_10H)			\
__PMC_EV(UCP, EVENT_29H_20H)			\
__PMC_EV(UCP, EVENT_2AH_01H)			\
__PMC_EV(UCP, EVENT_2AH_02H)			\
__PMC_EV(UCP, EVENT_2AH_04H)			\
__PMC_EV(UCP, EVENT_2AH_07H)			\
__PMC_EV(UCP, EVENT_2BH_01H)			\
__PMC_EV(UCP, EVENT_2BH_02H)			\
__PMC_EV(UCP, EVENT_2BH_04H)			\
__PMC_EV(UCP, EVENT_2BH_07H)			\
__PMC_EV(UCP, EVENT_2CH_01H)			\
__PMC_EV(UCP, EVENT_2CH_02H)			\
__PMC_EV(UCP, EVENT_2CH_04H)			\
__PMC_EV(UCP, EVENT_2CH_07H)			\
__PMC_EV(UCP, EVENT_2DH_01H)			\
__PMC_EV(UCP, EVENT_2DH_02H)			\
__PMC_EV(UCP, EVENT_2DH_04H)			\
__PMC_EV(UCP, EVENT_2DH_07H)			\
__PMC_EV(UCP, EVENT_2EH_01H)			\
__PMC_EV(UCP, EVENT_2EH_02H)			\
__PMC_EV(UCP, EVENT_2EH_04H)			\
__PMC_EV(UCP, EVENT_2EH_07H)			\
__PMC_EV(UCP, EVENT_2FH_01H)			\
__PMC_EV(UCP, EVENT_2FH_02H)			\
__PMC_EV(UCP, EVENT_2FH_04H)			\
__PMC_EV(UCP, EVENT_2FH_07H)			\
__PMC_EV(UCP, EVENT_2FH_08H)			\
__PMC_EV(UCP, EVENT_2FH_10H)			\
__PMC_EV(UCP, EVENT_2FH_20H)			\
__PMC_EV(UCP, EVENT_2FH_38H)			\
__PMC_EV(UCP, EVENT_30H_01H)			\
__PMC_EV(UCP, EVENT_30H_02H)			\
__PMC_EV(UCP, EVENT_30H_04H)			\
__PMC_EV(UCP, EVENT_30H_07H)			\
__PMC_EV(UCP, EVENT_31H_01H)			\
__PMC_EV(UCP, EVENT_31H_02H)			\
__PMC_EV(UCP, EVENT_31H_04H)			\
__PMC_EV(UCP, EVENT_31H_07H)			\
__PMC_EV(UCP, EVENT_32H_01H)			\
__PMC_EV(UCP, EVENT_32H_02H)			\
__PMC_EV(UCP, EVENT_32H_04H)			\
__PMC_EV(UCP, EVENT_32H_07H)			\
__PMC_EV(UCP, EVENT_33H_01H)			\
__PMC_EV(UCP, EVENT_33H_02H)			\
__PMC_EV(UCP, EVENT_33H_04H)			\
__PMC_EV(UCP, EVENT_33H_07H)			\
__PMC_EV(UCP, EVENT_34H_01H)			\
__PMC_EV(UCP, EVENT_34H_02H)			\
__PMC_EV(UCP, EVENT_34H_04H)			\
__PMC_EV(UCP, EVENT_34H_08H)			\
__PMC_EV(UCP, EVENT_34H_10H)			\
__PMC_EV(UCP, EVENT_34H_20H)			\
__PMC_EV(UCP, EVENT_35H_01H)			\
__PMC_EV(UCP, EVENT_35H_02H)			\
__PMC_EV(UCP, EVENT_35H_04H)			\
__PMC_EV(UCP, EVENT_40H_01H)			\
__PMC_EV(UCP, EVENT_40H_02H)			\
__PMC_EV(UCP, EVENT_40H_04H)			\
__PMC_EV(UCP, EVENT_40H_08H)			\
__PMC_EV(UCP, EVENT_40H_10H)			\
__PMC_EV(UCP, EVENT_40H_20H)			\
__PMC_EV(UCP, EVENT_40H_07H)			\
__PMC_EV(UCP, EVENT_40H_38H)			\
__PMC_EV(UCP, EVENT_41H_01H)			\
__PMC_EV(UCP, EVENT_41H_02H)			\
__PMC_EV(UCP, EVENT_41H_04H)			\
__PMC_EV(UCP, EVENT_41H_08H)			\
__PMC_EV(UCP, EVENT_41H_10H)			\
__PMC_EV(UCP, EVENT_41H_20H)			\
__PMC_EV(UCP, EVENT_41H_07H)			\
__PMC_EV(UCP, EVENT_41H_38H)			\
__PMC_EV(UCP, EVENT_42H_01H)			\
__PMC_EV(UCP, EVENT_42H_02H)			\
__PMC_EV(UCP, EVENT_42H_04H)			\
__PMC_EV(UCP, EVENT_42H_08H)			\
__PMC_EV(UCP, EVENT_43H_01H)			\
__PMC_EV(UCP, EVENT_43H_02H)			\
__PMC_EV(UCP, EVENT_60H_01H)			\
__PMC_EV(UCP, EVENT_60H_02H)			\
__PMC_EV(UCP, EVENT_60H_04H)			\
__PMC_EV(UCP, EVENT_61H_01H)			\
__PMC_EV(UCP, EVENT_61H_02H)			\
__PMC_EV(UCP, EVENT_61H_04H)			\
__PMC_EV(UCP, EVENT_62H_01H)			\
__PMC_EV(UCP, EVENT_62H_02H)			\
__PMC_EV(UCP, EVENT_62H_04H)			\
__PMC_EV(UCP, EVENT_63H_01H)			\
__PMC_EV(UCP, EVENT_63H_02H)			\
__PMC_EV(UCP, EVENT_63H_04H)			\
__PMC_EV(UCP, EVENT_63H_08H)			\
__PMC_EV(UCP, EVENT_63H_10H)			\
__PMC_EV(UCP, EVENT_63H_20H)			\
__PMC_EV(UCP, EVENT_64H_01H)			\
__PMC_EV(UCP, EVENT_64H_02H)			\
__PMC_EV(UCP, EVENT_64H_04H)			\
__PMC_EV(UCP, EVENT_64H_08H)			\
__PMC_EV(UCP, EVENT_64H_10H)			\
__PMC_EV(UCP, EVENT_64H_20H)			\
__PMC_EV(UCP, EVENT_65H_01H)			\
__PMC_EV(UCP, EVENT_65H_02H)			\
__PMC_EV(UCP, EVENT_65H_04H)			\
__PMC_EV(UCP, EVENT_66H_01H)			\
__PMC_EV(UCP, EVENT_66H_02H)			\
__PMC_EV(UCP, EVENT_66H_04H)			\
__PMC_EV(UCP, EVENT_67H_01H)			\
__PMC_EV(UCP, EVENT_80H_01H)			\
__PMC_EV(UCP, EVENT_80H_02H)			\
__PMC_EV(UCP, EVENT_80H_04H)			\
__PMC_EV(UCP, EVENT_80H_08H)			\
__PMC_EV(UCP, EVENT_81H_01H)			\
__PMC_EV(UCP, EVENT_81H_02H)			\
__PMC_EV(UCP, EVENT_81H_04H)			\
__PMC_EV(UCP, EVENT_81H_08H)			\
__PMC_EV(UCP, EVENT_82H_01H)			\
__PMC_EV(UCP, EVENT_83H_01H)			\
__PMC_EV(UCP, EVENT_83H_02H)			\
__PMC_EV(UCP, EVENT_83H_04H)			\
__PMC_EV(UCP, EVENT_83H_08H)			\
__PMC_EV(UCP, EVENT_84H_01H)			\
__PMC_EV(UCP, EVENT_84H_02H)			\
__PMC_EV(UCP, EVENT_84H_04H)			\
__PMC_EV(UCP, EVENT_84H_08H)			\
__PMC_EV(UCP, EVENT_85H_02H)			\
__PMC_EV(UCP, EVENT_86H_01H)

#define	PMC_EV_UCP_FIRST	PMC_EV_UCP_EVENT_00H_01H
#define	PMC_EV_UCP_LAST		PMC_EV_UCP_EVENT_86H_01H

#define	__PMC_EV_ALIAS_COREI7UC()					\
__PMC_EV_ALIAS("GQ_CYCLES_FULL.READ_TRACKER", UCP_EVENT_00H_01H)	\
__PMC_EV_ALIAS("GQ_CYCLES_FULL.WRITE_TRACKER", UCP_EVENT_00H_02H)	\
__PMC_EV_ALIAS("GQ_CYCLES_FULL.PEER_PROBE_TRACKER", UCP_EVENT_00H_04H)	\
__PMC_EV_ALIAS("GQ_CYCLES_NOT_EMPTY.READ_TRACKER", UCP_EVENT_01H_01H)	\
__PMC_EV_ALIAS("GQ_CYCLES_NOT_EMPTY.WRITE_TRACKER", UCP_EVENT_01H_02H)	\
__PMC_EV_ALIAS("GQ_CYCLES_NOT_EMPTY.PEER_PROBE_TRACKER", UCP_EVENT_01H_04H)	\
__PMC_EV_ALIAS("GQ_ALLOC.READ_TRACKER", UCP_EVENT_03H_01H)	\
__PMC_EV_ALIAS("GQ_ALLOC.RT_L3_MISS", UCP_EVENT_03H_02H)	\
__PMC_EV_ALIAS("GQ_ALLOC.RT_TO_L3_RESP", UCP_EVENT_03H_04H)	\
__PMC_EV_ALIAS("GQ_ALLOC.RT_TO_RTID_ACQUIRED", UCP_EVENT_03H_08H)	\
__PMC_EV_ALIAS("GQ_ALLOC.WT_TO_RTID_ACQUIRED", UCP_EVENT_03H_10H)	\
__PMC_EV_ALIAS("GQ_ALLOC.WRITE_TRACKER", UCP_EVENT_03H_20H)	\
__PMC_EV_ALIAS("GQ_ALLOC.PEER_PROBE_TRACKER", UCP_EVENT_03H_40H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_QPI", UCP_EVENT_04H_01H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_QMC", UCP_EVENT_04H_02H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_L3", UCP_EVENT_04H_04H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_CORES_02", UCP_EVENT_04H_08H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_CORES_13", UCP_EVENT_04H_10H)	\
__PMC_EV_ALIAS("GQ_DATA.TO_QPI_QMC", UCP_EVENT_05H_01H)	\
__PMC_EV_ALIAS("GQ_DATA.TO_L3", UCP_EVENT_05H_02H)	\
__PMC_EV_ALIAS("GQ_DATA.TO_CORES", UCP_EVENT_05H_04H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.I_STATE", UCP_EVENT_06H_01H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.S_STATE", UCP_EVENT_06H_02H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.FWD_S_STATE", UCP_EVENT_06H_04H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.FWD_I_STATE", UCP_EVENT_06H_08H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.CONFLICT", UCP_EVENT_06H_10H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.WB", UCP_EVENT_06H_20H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.I_STATE", UCP_EVENT_07H_01H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.S_STATE", UCP_EVENT_07H_02H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.FWD_S_STATE", UCP_EVENT_07H_04H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.FWD_I_STATE", UCP_EVENT_07H_08H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.CONFLICT", UCP_EVENT_07H_10H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.WB", UCP_EVENT_07H_20H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.HITM", UCP_EVENT_07H_24H)	\
__PMC_EV_ALIAS("L3_HITS.READ", UCP_EVENT_08H_01H)	\
__PMC_EV_ALIAS("L3_HITS.WRITE", UCP_EVENT_08H_02H)	\
__PMC_EV_ALIAS("L3_HITS.PROBE", UCP_EVENT_08H_04H)	\
__PMC_EV_ALIAS("L3_HITS.ANY", UCP_EVENT_08H_03H)	\
__PMC_EV_ALIAS("L3_MISS.READ", UCP_EVENT_09H_01H)	\
__PMC_EV_ALIAS("L3_MISS.WRITE", UCP_EVENT_09H_02H)	\
__PMC_EV_ALIAS("L3_MISS.PROBE", UCP_EVENT_09H_04H)	\
__PMC_EV_ALIAS("L3_MISS.ANY", UCP_EVENT_09H_03H)	\
__PMC_EV_ALIAS("L3_LINES_IN.M_STATE", UCP_EVENT_0AH_01H)	\
__PMC_EV_ALIAS("L3_LINES_IN.E_STATE", UCP_EVENT_0AH_02H)	\
__PMC_EV_ALIAS("L3_LINES_IN.S_STATE", UCP_EVENT_0AH_04H)	\
__PMC_EV_ALIAS("L3_LINES_IN.F_STATE", UCP_EVENT_0AH_08H)	\
__PMC_EV_ALIAS("L3_LINES_IN.ANY", UCP_EVENT_0AH_0FH)	\
__PMC_EV_ALIAS("L3_LINES_OUT.M_STATE", UCP_EVENT_0BH_01H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.E_STATE", UCP_EVENT_0BH_02H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.S_STATE", UCP_EVENT_0BH_04H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.I_STATE", UCP_EVENT_0BH_08H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.F_STATE", UCP_EVENT_0BH_10H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.ANY", UCP_EVENT_0BH_1FH)	\
__PMC_EV_ALIAS("QHL_REQUESTS.IOH_READS", UCP_EVENT_20H_01H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.IOH_WRITES", UCP_EVENT_20H_02H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.REMOTE_READS", UCP_EVENT_20H_04H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.REMOTE_WRITES", UCP_EVENT_20H_08H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.LOCAL_READS", UCP_EVENT_20H_10H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.LOCAL_WRITES", UCP_EVENT_20H_20H)	\
__PMC_EV_ALIAS("QHL_CYCLES_FULL.IOH", UCP_EVENT_21H_01H)	\
__PMC_EV_ALIAS("QHL_CYCLES_FULL.REMOTE", UCP_EVENT_21H_02H)	\
__PMC_EV_ALIAS("QHL_CYCLES_FULL.LOCAL", UCP_EVENT_21H_04H)	\
__PMC_EV_ALIAS("QHL_CYCLES_NOT_EMPTY.IOH", UCP_EVENT_22H_01H)	\
__PMC_EV_ALIAS("QHL_CYCLES_NOT_EMPTY.REMOTE", UCP_EVENT_22H_02H)	\
__PMC_EV_ALIAS("QHL_CYCLES_NOT_EMPTY.LOCAL", UCP_EVENT_22H_04H)	\
__PMC_EV_ALIAS("QHL_OCCUPANCY.IOH", UCP_EVENT_23H_01H)	\
__PMC_EV_ALIAS("QHL_OCCUPANCY.REMOTE", UCP_EVENT_23H_02H)	\
__PMC_EV_ALIAS("QHL_OCCUPANCY.LOCAL", UCP_EVENT_23H_04H)	\
__PMC_EV_ALIAS("QHL_ADDRESS_CONFLICTS.2WAY", UCP_EVENT_24H_02H)	\
__PMC_EV_ALIAS("QHL_ADDRESS_CONFLICTS.3WAY", UCP_EVENT_24H_04H)	\
__PMC_EV_ALIAS("QHL_CONFLICT_CYCLES.IOH", UCP_EVENT_25H_01H)	\
__PMC_EV_ALIAS("QHL_CONFLICT_CYCLES.REMOTE", UCP_EVENT_25H_02H)	\
__PMC_EV_ALIAS("QHL_CONFLICT_CYCLES.LOCAL", UCP_EVENT_25H_04H)	\
__PMC_EV_ALIAS("QHL_TO_QMC_BYPASS", UCP_EVENT_26H_01H)	\
__PMC_EV_ALIAS("QMC_NORMAL_FULL.READ.CH0", UCP_EVENT_27H_01H)	\
__PMC_EV_ALIAS("QMC_NORMAL_FULL.READ.CH1", UCP_EVENT_27H_02H)	\
__PMC_EV_ALIAS("QMC_NORMAL_FULL.READ.CH2", UCP_EVENT_27H_04H)	\
__PMC_EV_ALIAS("QMC_NORMAL_FULL.WRITE.CH0", UCP_EVENT_27H_08H)	\
__PMC_EV_ALIAS("QMC_NORMAL_FULL.WRITE.CH1", UCP_EVENT_27H_10H)	\
__PMC_EV_ALIAS("QMC_NORMAL_FULL.WRITE.CH2", UCP_EVENT_27H_20H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.READ.CH0", UCP_EVENT_28H_01H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.READ.CH1", UCP_EVENT_28H_02H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.READ.CH2", UCP_EVENT_28H_04H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.WRITE.CH0", UCP_EVENT_28H_08H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.WRITE.CH1", UCP_EVENT_28H_10H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.WRITE.CH2", UCP_EVENT_28H_20H)	\
__PMC_EV_ALIAS("QMC_BUSY.READ.CH0", UCP_EVENT_29H_01H)	\
__PMC_EV_ALIAS("QMC_BUSY.READ.CH1", UCP_EVENT_29H_02H)	\
__PMC_EV_ALIAS("QMC_BUSY.READ.CH2", UCP_EVENT_29H_04H)	\
__PMC_EV_ALIAS("QMC_BUSY.WRITE.CH0", UCP_EVENT_29H_08H)	\
__PMC_EV_ALIAS("QMC_BUSY.WRITE.CH1", UCP_EVENT_29H_10H)	\
__PMC_EV_ALIAS("QMC_BUSY.WRITE.CH2", UCP_EVENT_29H_20H)	\
__PMC_EV_ALIAS("QMC_OCCUPANCY.CH0", UCP_EVENT_2AH_01H)	\
__PMC_EV_ALIAS("QMC_OCCUPANCY.CH1", UCP_EVENT_2AH_02H)	\
__PMC_EV_ALIAS("QMC_OCCUPANCY.CH2", UCP_EVENT_2AH_04H)	\
__PMC_EV_ALIAS("QMC_ISSOC_OCCUPANCY.CH0", UCP_EVENT_2BH_01H)	\
__PMC_EV_ALIAS("QMC_ISSOC_OCCUPANCY.CH1", UCP_EVENT_2BH_02H)	\
__PMC_EV_ALIAS("QMC_ISSOC_OCCUPANCY.CH2", UCP_EVENT_2BH_04H)	\
__PMC_EV_ALIAS("QMC_ISSOC_READS.ANY", UCP_EVENT_2BH_07H)	\
__PMC_EV_ALIAS("QMC_NORMAL_READS.CH0", UCP_EVENT_2CH_01H)	\
__PMC_EV_ALIAS("QMC_NORMAL_READS.CH1", UCP_EVENT_2CH_02H)	\
__PMC_EV_ALIAS("QMC_NORMAL_READS.CH2", UCP_EVENT_2CH_04H)	\
__PMC_EV_ALIAS("QMC_NORMAL_READS.ANY", UCP_EVENT_2CH_07H)	\
__PMC_EV_ALIAS("QMC_HIGH_PRIORITY_READS.CH0", UCP_EVENT_2DH_01H)	\
__PMC_EV_ALIAS("QMC_HIGH_PRIORITY_READS.CH1", UCP_EVENT_2DH_02H)	\
__PMC_EV_ALIAS("QMC_HIGH_PRIORITY_READS.CH2", UCP_EVENT_2DH_04H)	\
__PMC_EV_ALIAS("QMC_HIGH_PRIORITY_READS.ANY", UCP_EVENT_2DH_07H)	\
__PMC_EV_ALIAS("QMC_CRITICAL_PRIORITY_READS.CH0", UCP_EVENT_2EH_01H)	\
__PMC_EV_ALIAS("QMC_CRITICAL_PRIORITY_READS.CH1", UCP_EVENT_2EH_02H)	\
__PMC_EV_ALIAS("QMC_CRITICAL_PRIORITY_READS.CH2", UCP_EVENT_2EH_04H)	\
__PMC_EV_ALIAS("QMC_CRITICAL_PRIORITY_READS.ANY", UCP_EVENT_2EH_07H)	\
__PMC_EV_ALIAS("QMC_WRITES.FULL.CH0", UCP_EVENT_2FH_01H)	\
__PMC_EV_ALIAS("QMC_WRITES.FULL.CH1", UCP_EVENT_2FH_02H)	\
__PMC_EV_ALIAS("QMC_WRITES.FULL.CH2", UCP_EVENT_2FH_04H)	\
__PMC_EV_ALIAS("QMC_WRITES.FULL.ANY", UCP_EVENT_2FH_07H)	\
__PMC_EV_ALIAS("QMC_WRITES.PARTIAL.CH0", UCP_EVENT_2FH_08H)	\
__PMC_EV_ALIAS("QMC_WRITES.PARTIAL.CH1", UCP_EVENT_2FH_10H)	\
__PMC_EV_ALIAS("QMC_WRITES.PARTIAL.CH2", UCP_EVENT_2FH_20H)	\
__PMC_EV_ALIAS("QMC_WRITES.PARTIAL.ANY", UCP_EVENT_2FH_38H)	\
__PMC_EV_ALIAS("QMC_CANCEL.CH0", UCP_EVENT_30H_01H)	\
__PMC_EV_ALIAS("QMC_CANCEL.CH1", UCP_EVENT_30H_02H)	\
__PMC_EV_ALIAS("QMC_CANCEL.CH2", UCP_EVENT_30H_04H)	\
__PMC_EV_ALIAS("QMC_CANCEL.ANY", UCP_EVENT_30H_07H)	\
__PMC_EV_ALIAS("QMC_PRIORITY_UPDATES.CH0", UCP_EVENT_31H_01H)	\
__PMC_EV_ALIAS("QMC_PRIORITY_UPDATES.CH1", UCP_EVENT_31H_02H)	\
__PMC_EV_ALIAS("QMC_PRIORITY_UPDATES.CH2", UCP_EVENT_31H_04H)	\
__PMC_EV_ALIAS("QMC_PRIORITY_UPDATES.ANY", UCP_EVENT_31H_07H)	\
__PMC_EV_ALIAS("QHL_FRC_ACK_CNFLTS.LOCAL", UCP_EVENT_33H_04H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.HOME.LINK_0", UCP_EVENT_40H_01H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.SNOOP.LINK_0", UCP_EVENT_40H_02H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.NDR.LINK_0", UCP_EVENT_40H_04H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.HOME.LINK_1", UCP_EVENT_40H_08H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.SNOOP.LINK_1", UCP_EVENT_40H_10H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.NDR.LINK_1", UCP_EVENT_40H_20H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.LINK_0", UCP_EVENT_40H_07H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.LINK_1", UCP_EVENT_40H_38H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.DRS.LINK_0", UCP_EVENT_41H_01H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.NCB.LINK_0", UCP_EVENT_41H_02H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.NCS.LINK_0", UCP_EVENT_41H_04H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.DRS.LINK_1", UCP_EVENT_41H_08H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.NCB.LINK_1", UCP_EVENT_41H_10H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.NCS.LINK_1", UCP_EVENT_41H_20H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.LINK_0", UCP_EVENT_41H_07H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.LINK_1", UCP_EVENT_41H_38H)	\
__PMC_EV_ALIAS("QPI_TX_HEADER.BUSY.LINK_0", UCP_EVENT_42H_02H)	\
__PMC_EV_ALIAS("QPI_TX_HEADER.BUSY.LINK_1", UCP_EVENT_42H_08H)	\
__PMC_EV_ALIAS("QPI_RX_NO_PPT_CREDIT.STALLS.LINK_0", UCP_EVENT_43H_01H)	\
__PMC_EV_ALIAS("QPI_RX_NO_PPT_CREDIT.STALLS.LINK_1", UCP_EVENT_43H_02H)	\
__PMC_EV_ALIAS("DRAM_OPEN.CH0", UCP_EVENT_60H_01H)	\
__PMC_EV_ALIAS("DRAM_OPEN.CH1", UCP_EVENT_60H_02H)	\
__PMC_EV_ALIAS("DRAM_OPEN.CH2", UCP_EVENT_60H_04H)	\
__PMC_EV_ALIAS("DRAM_PAGE_CLOSE.CH0", UCP_EVENT_61H_01H)	\
__PMC_EV_ALIAS("DRAM_PAGE_CLOSE.CH1", UCP_EVENT_61H_02H)	\
__PMC_EV_ALIAS("DRAM_PAGE_CLOSE.CH2", UCP_EVENT_61H_04H)	\
__PMC_EV_ALIAS("DRAM_PAGE_MISS.CH0", UCP_EVENT_62H_01H)	\
__PMC_EV_ALIAS("DRAM_PAGE_MISS.CH1", UCP_EVENT_62H_02H)	\
__PMC_EV_ALIAS("DRAM_PAGE_MISS.CH2", UCP_EVENT_62H_04H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.CH0", UCP_EVENT_63H_01H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.AUTOPRE_CH0", UCP_EVENT_63H_02H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.CH1", UCP_EVENT_63H_04H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.AUTOPRE_CH1", UCP_EVENT_63H_08H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.CH2", UCP_EVENT_63H_10H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.AUTOPRE_CH2", UCP_EVENT_63H_20H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.CH0", UCP_EVENT_64H_01H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.AUTOPRE_CH0", UCP_EVENT_64H_02H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.CH1", UCP_EVENT_64H_04H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.AUTOPRE_CH1", UCP_EVENT_64H_08H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.CH2", UCP_EVENT_64H_10H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.AUTOPRE_CH2", UCP_EVENT_64H_20H)	\
__PMC_EV_ALIAS("DRAM_REFRESH.CH0", UCP_EVENT_65H_01H)	\
__PMC_EV_ALIAS("DRAM_REFRESH.CH1", UCP_EVENT_65H_02H)	\
__PMC_EV_ALIAS("DRAM_REFRESH.CH2", UCP_EVENT_65H_04H)	\
__PMC_EV_ALIAS("DRAM_PRE_ALL.CH0", UCP_EVENT_66H_01H)	\
__PMC_EV_ALIAS("DRAM_PRE_ALL.CH1", UCP_EVENT_66H_02H)	\
__PMC_EV_ALIAS("DRAM_PRE_ALL.CH2", UCP_EVENT_66H_04H)

#define	__PMC_EV_ALIAS_WESTMEREUC()					\
__PMC_EV_ALIAS("GQ_CYCLES_FULL.READ_TRACKER", UCP_EVENT_00H_01H)	\
__PMC_EV_ALIAS("GQ_CYCLES_FULL.WRITE_TRACKER", UCP_EVENT_00H_02H)	\
__PMC_EV_ALIAS("GQ_CYCLES_FULL.PEER_PROBE_TRACKER", UCP_EVENT_00H_04H)	\
__PMC_EV_ALIAS("GQ_CYCLES_NOT_EMPTY.READ_TRACKER", UCP_EVENT_01H_01H)	\
__PMC_EV_ALIAS("GQ_CYCLES_NOT_EMPTY.WRITE_TRACKER", UCP_EVENT_01H_02H)	\
__PMC_EV_ALIAS("GQ_CYCLES_NOT_EMPTY.PEER_PROBE_TRACKER", UCP_EVENT_01H_04H)	\
__PMC_EV_ALIAS("GQ_OCCUPANCY.READ_TRACKER", UCP_EVENT_02H_01H)	\
__PMC_EV_ALIAS("GQ_ALLOC.READ_TRACKER", UCP_EVENT_03H_01H)	\
__PMC_EV_ALIAS("GQ_ALLOC.RT_L3_MISS", UCP_EVENT_03H_02H)	\
__PMC_EV_ALIAS("GQ_ALLOC.RT_TO_L3_RESP", UCP_EVENT_03H_04H)	\
__PMC_EV_ALIAS("GQ_ALLOC.RT_TO_RTID_ACQUIRED", UCP_EVENT_03H_08H)	\
__PMC_EV_ALIAS("GQ_ALLOC.WT_TO_RTID_ACQUIRED", UCP_EVENT_03H_10H)	\
__PMC_EV_ALIAS("GQ_ALLOC.WRITE_TRACKER", UCP_EVENT_03H_20H)	\
__PMC_EV_ALIAS("GQ_ALLOC.PEER_PROBE_TRACKER", UCP_EVENT_03H_40H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_QPI", UCP_EVENT_04H_01H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_QMC", UCP_EVENT_04H_02H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_L3", UCP_EVENT_04H_04H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_CORES_02", UCP_EVENT_04H_08H)	\
__PMC_EV_ALIAS("GQ_DATA.FROM_CORES_13", UCP_EVENT_04H_10H)	\
__PMC_EV_ALIAS("GQ_DATA.TO_QPI_QMC", UCP_EVENT_05H_01H)	\
__PMC_EV_ALIAS("GQ_DATA.TO_L3", UCP_EVENT_05H_02H)	\
__PMC_EV_ALIAS("GQ_DATA.TO_CORES", UCP_EVENT_05H_04H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.I_STATE", UCP_EVENT_06H_01H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.S_STATE", UCP_EVENT_06H_02H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.FWD_S_STATE", UCP_EVENT_06H_04H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.FWD_I_STATE", UCP_EVENT_06H_08H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.CONFLICT", UCP_EVENT_06H_10H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_LOCAL_HOME.WB", UCP_EVENT_06H_20H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.I_STATE", UCP_EVENT_07H_01H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.S_STATE", UCP_EVENT_07H_02H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.FWD_S_STATE", UCP_EVENT_07H_04H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.FWD_I_STATE", UCP_EVENT_07H_08H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.CONFLICT", UCP_EVENT_07H_10H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.WB", UCP_EVENT_07H_20H)	\
__PMC_EV_ALIAS("SNP_RESP_TO_REMOTE_HOME.HITM", UCP_EVENT_07H_24H)	\
__PMC_EV_ALIAS("L3_HITS.READ", UCP_EVENT_08H_01H)	\
__PMC_EV_ALIAS("L3_HITS.WRITE", UCP_EVENT_08H_02H)	\
__PMC_EV_ALIAS("L3_HITS.PROBE", UCP_EVENT_08H_04H)	\
__PMC_EV_ALIAS("L3_HITS.ANY", UCP_EVENT_08H_03H)	\
__PMC_EV_ALIAS("L3_MISS.READ", UCP_EVENT_09H_01H)	\
__PMC_EV_ALIAS("L3_MISS.WRITE", UCP_EVENT_09H_02H)	\
__PMC_EV_ALIAS("L3_MISS.PROBE", UCP_EVENT_09H_04H)	\
__PMC_EV_ALIAS("L3_MISS.ANY", UCP_EVENT_09H_03H)	\
__PMC_EV_ALIAS("L3_LINES_IN.M_STATE", UCP_EVENT_0AH_01H)	\
__PMC_EV_ALIAS("L3_LINES_IN.E_STATE", UCP_EVENT_0AH_02H)	\
__PMC_EV_ALIAS("L3_LINES_IN.S_STATE", UCP_EVENT_0AH_04H)	\
__PMC_EV_ALIAS("L3_LINES_IN.F_STATE", UCP_EVENT_0AH_08H)	\
__PMC_EV_ALIAS("L3_LINES_IN.ANY", UCP_EVENT_0AH_0FH)	\
__PMC_EV_ALIAS("L3_LINES_OUT.M_STATE", UCP_EVENT_0BH_01H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.E_STATE", UCP_EVENT_0BH_02H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.S_STATE", UCP_EVENT_0BH_04H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.I_STATE", UCP_EVENT_0BH_08H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.F_STATE", UCP_EVENT_0BH_10H)	\
__PMC_EV_ALIAS("L3_LINES_OUT.ANY", UCP_EVENT_0BH_1FH)	\
__PMC_EV_ALIAS("GQ_SNOOP.GOTO_S", UCP_EVENT_0CH_01H)	\
__PMC_EV_ALIAS("GQ_SNOOP.GOTO_I", UCP_EVENT_0CH_02H)	\
__PMC_EV_ALIAS("GQ_SNOOP.GOTO_S_HIT", UCP_EVENT_0CH_04H)	\
__PMC_EV_ALIAS("GQ_SNOOP.GOTO_I_HIT", UCP_EVENT_0CH_08H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.IOH_READS", UCP_EVENT_20H_01H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.IOH_WRITES", UCP_EVENT_20H_02H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.REMOTE_READS", UCP_EVENT_20H_04H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.REMOTE_WRITES", UCP_EVENT_20H_08H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.LOCAL_READS", UCP_EVENT_20H_10H)	\
__PMC_EV_ALIAS("QHL_REQUESTS.LOCAL_WRITES", UCP_EVENT_20H_20H)	\
__PMC_EV_ALIAS("QHL_CYCLES_FULL.IOH", UCP_EVENT_21H_01H)	\
__PMC_EV_ALIAS("QHL_CYCLES_FULL.REMOTE", UCP_EVENT_21H_02H)	\
__PMC_EV_ALIAS("QHL_CYCLES_FULL.LOCAL", UCP_EVENT_21H_04H)	\
__PMC_EV_ALIAS("QHL_CYCLES_NOT_EMPTY.IOH", UCP_EVENT_22H_01H)	\
__PMC_EV_ALIAS("QHL_CYCLES_NOT_EMPTY.REMOTE", UCP_EVENT_22H_02H)	\
__PMC_EV_ALIAS("QHL_CYCLES_NOT_EMPTY.LOCAL", UCP_EVENT_22H_04H)	\
__PMC_EV_ALIAS("QHL_OCCUPANCY.IOH", UCP_EVENT_23H_01H)	\
__PMC_EV_ALIAS("QHL_OCCUPANCY.REMOTE", UCP_EVENT_23H_02H)	\
__PMC_EV_ALIAS("QHL_OCCUPANCY.LOCAL", UCP_EVENT_23H_04H)	\
__PMC_EV_ALIAS("QHL_ADDRESS_CONFLICTS.2WAY", UCP_EVENT_24H_02H)	\
__PMC_EV_ALIAS("QHL_ADDRESS_CONFLICTS.3WAY", UCP_EVENT_24H_04H)	\
__PMC_EV_ALIAS("QHL_CONFLICT_CYCLES.IOH", UCP_EVENT_25H_01H)	\
__PMC_EV_ALIAS("QHL_CONFLICT_CYCLES.REMOTE", UCP_EVENT_25H_02H)	\
__PMC_EV_ALIAS("QHL_CONFLICT_CYCLES.LOCAL", UCP_EVENT_25H_04H)	\
__PMC_EV_ALIAS("QHL_TO_QMC_BYPASS", UCP_EVENT_26H_01H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.READ.CH0", UCP_EVENT_28H_01H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.READ.CH1", UCP_EVENT_28H_02H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.READ.CH2", UCP_EVENT_28H_04H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.WRITE.CH0", UCP_EVENT_28H_08H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.WRITE.CH1", UCP_EVENT_28H_10H)	\
__PMC_EV_ALIAS("QMC_ISOC_FULL.WRITE.CH2", UCP_EVENT_28H_20H)	\
__PMC_EV_ALIAS("QMC_BUSY.READ.CH0", UCP_EVENT_29H_01H)	\
__PMC_EV_ALIAS("QMC_BUSY.READ.CH1", UCP_EVENT_29H_02H)	\
__PMC_EV_ALIAS("QMC_BUSY.READ.CH2", UCP_EVENT_29H_04H)	\
__PMC_EV_ALIAS("QMC_BUSY.WRITE.CH0", UCP_EVENT_29H_08H)	\
__PMC_EV_ALIAS("QMC_BUSY.WRITE.CH1", UCP_EVENT_29H_10H)	\
__PMC_EV_ALIAS("QMC_BUSY.WRITE.CH2", UCP_EVENT_29H_20H)	\
__PMC_EV_ALIAS("QMC_OCCUPANCY.CH0", UCP_EVENT_2AH_01H)	\
__PMC_EV_ALIAS("QMC_OCCUPANCY.CH1", UCP_EVENT_2AH_02H)	\
__PMC_EV_ALIAS("QMC_OCCUPANCY.CH2", UCP_EVENT_2AH_04H)	\
__PMC_EV_ALIAS("QMC_OCCUPANCY.ANY", UCP_EVENT_2AH_07H)	\
__PMC_EV_ALIAS("QMC_ISSOC_OCCUPANCY.CH0", UCP_EVENT_2BH_01H)	\
__PMC_EV_ALIAS("QMC_ISSOC_OCCUPANCY.CH1", UCP_EVENT_2BH_02H)	\
__PMC_EV_ALIAS("QMC_ISSOC_OCCUPANCY.CH2", UCP_EVENT_2BH_04H)	\
__PMC_EV_ALIAS("QMC_ISSOC_READS.ANY", UCP_EVENT_2BH_07H)	\
__PMC_EV_ALIAS("QMC_NORMAL_READS.CH0", UCP_EVENT_2CH_01H)	\
__PMC_EV_ALIAS("QMC_NORMAL_READS.CH1", UCP_EVENT_2CH_02H)	\
__PMC_EV_ALIAS("QMC_NORMAL_READS.CH2", UCP_EVENT_2CH_04H)	\
__PMC_EV_ALIAS("QMC_NORMAL_READS.ANY", UCP_EVENT_2CH_07H)	\
__PMC_EV_ALIAS("QMC_HIGH_PRIORITY_READS.CH0", UCP_EVENT_2DH_01H)	\
__PMC_EV_ALIAS("QMC_HIGH_PRIORITY_READS.CH1", UCP_EVENT_2DH_02H)	\
__PMC_EV_ALIAS("QMC_HIGH_PRIORITY_READS.CH2", UCP_EVENT_2DH_04H)	\
__PMC_EV_ALIAS("QMC_HIGH_PRIORITY_READS.ANY", UCP_EVENT_2DH_07H)	\
__PMC_EV_ALIAS("QMC_CRITICAL_PRIORITY_READS.CH0", UCP_EVENT_2EH_01H)	\
__PMC_EV_ALIAS("QMC_CRITICAL_PRIORITY_READS.CH1", UCP_EVENT_2EH_02H)	\
__PMC_EV_ALIAS("QMC_CRITICAL_PRIORITY_READS.CH2", UCP_EVENT_2EH_04H)	\
__PMC_EV_ALIAS("QMC_CRITICAL_PRIORITY_READS.ANY", UCP_EVENT_2EH_07H)	\
__PMC_EV_ALIAS("QMC_WRITES.FULL.CH0", UCP_EVENT_2FH_01H)	\
__PMC_EV_ALIAS("QMC_WRITES.FULL.CH1", UCP_EVENT_2FH_02H)	\
__PMC_EV_ALIAS("QMC_WRITES.FULL.CH2", UCP_EVENT_2FH_04H)	\
__PMC_EV_ALIAS("QMC_WRITES.FULL.ANY", UCP_EVENT_2FH_07H)	\
__PMC_EV_ALIAS("QMC_WRITES.PARTIAL.CH0", UCP_EVENT_2FH_08H)	\
__PMC_EV_ALIAS("QMC_WRITES.PARTIAL.CH1", UCP_EVENT_2FH_10H)	\
__PMC_EV_ALIAS("QMC_WRITES.PARTIAL.CH2", UCP_EVENT_2FH_20H)	\
__PMC_EV_ALIAS("QMC_WRITES.PARTIAL.ANY", UCP_EVENT_2FH_38H)	\
__PMC_EV_ALIAS("QMC_CANCEL.CH0", UCP_EVENT_30H_01H)	\
__PMC_EV_ALIAS("QMC_CANCEL.CH1", UCP_EVENT_30H_02H)	\
__PMC_EV_ALIAS("QMC_CANCEL.CH2", UCP_EVENT_30H_04H)	\
__PMC_EV_ALIAS("QMC_CANCEL.ANY", UCP_EVENT_30H_07H)	\
__PMC_EV_ALIAS("QMC_PRIORITY_UPDATES.CH0", UCP_EVENT_31H_01H)	\
__PMC_EV_ALIAS("QMC_PRIORITY_UPDATES.CH1", UCP_EVENT_31H_02H)	\
__PMC_EV_ALIAS("QMC_PRIORITY_UPDATES.CH2", UCP_EVENT_31H_04H)	\
__PMC_EV_ALIAS("QMC_PRIORITY_UPDATES.ANY", UCP_EVENT_31H_07H)	\
__PMC_EV_ALIAS("IMC_RETRY.CH0", UCP_EVENT_32H_01H)	\
__PMC_EV_ALIAS("IMC_RETRY.CH1", UCP_EVENT_32H_02H)	\
__PMC_EV_ALIAS("IMC_RETRY.CH2", UCP_EVENT_32H_04H)	\
__PMC_EV_ALIAS("IMC_RETRY.ANY", UCP_EVENT_32H_07H)	\
__PMC_EV_ALIAS("QHL_FRC_ACK_CNFLTS.IOH", UCP_EVENT_33H_01H)	\
__PMC_EV_ALIAS("QHL_FRC_ACK_CNFLTS.REMOTE", UCP_EVENT_33H_02H)	\
__PMC_EV_ALIAS("QHL_FRC_ACK_CNFLTS.LOCAL", UCP_EVENT_33H_04H)	\
__PMC_EV_ALIAS("QHL_FRC_ACK_CNFLTS.ANY", UCP_EVENT_33H_07H)	\
__PMC_EV_ALIAS("QHL_SLEEPS.IOH_ORDER", UCP_EVENT_34H_01H)	\
__PMC_EV_ALIAS("QHL_SLEEPS.REMOTE_ORDER", UCP_EVENT_34H_02H)	\
__PMC_EV_ALIAS("QHL_SLEEPS.LOCAL_ORDER", UCP_EVENT_34H_04H)	\
__PMC_EV_ALIAS("QHL_SLEEPS.IOH_CONFLICT", UCP_EVENT_34H_08H)	\
__PMC_EV_ALIAS("QHL_SLEEPS.REMOTE_CONFLICT", UCP_EVENT_34H_10H)	\
__PMC_EV_ALIAS("QHL_SLEEPS.LOCAL_CONFLICT", UCP_EVENT_34H_20H)	\
__PMC_EV_ALIAS("ADDR_OPCODE_MATCH.IOH", UCP_EVENT_35H_01H)	\
__PMC_EV_ALIAS("ADDR_OPCODE_MATCH.REMOTE", UCP_EVENT_35H_02H)	\
__PMC_EV_ALIAS("ADDR_OPCODE_MATCH.LOCAL", UCP_EVENT_35H_04H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.HOME.LINK_0", UCP_EVENT_40H_01H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.SNOOP.LINK_0", UCP_EVENT_40H_02H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.NDR.LINK_0", UCP_EVENT_40H_04H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.HOME.LINK_1", UCP_EVENT_40H_08H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.SNOOP.LINK_1", UCP_EVENT_40H_10H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.NDR.LINK_1", UCP_EVENT_40H_20H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.LINK_0", UCP_EVENT_40H_07H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_SINGLE_FLIT.LINK_1", UCP_EVENT_40H_38H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.DRS.LINK_0", UCP_EVENT_41H_01H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.NCB.LINK_0", UCP_EVENT_41H_02H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.NCS.LINK_0", UCP_EVENT_41H_04H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.DRS.LINK_1", UCP_EVENT_41H_08H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.NCB.LINK_1", UCP_EVENT_41H_10H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.NCS.LINK_1", UCP_EVENT_41H_20H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.LINK_0", UCP_EVENT_41H_07H)	\
__PMC_EV_ALIAS("QPI_TX_STALLED_MULTI_FLIT.LINK_1", UCP_EVENT_41H_38H)	\
__PMC_EV_ALIAS("QPI_TX_HEADER.FULL.LINK_0", UCP_EVENT_42H_01H)	\
__PMC_EV_ALIAS("QPI_TX_HEADER.BUSY.LINK_0", UCP_EVENT_42H_02H)	\
__PMC_EV_ALIAS("QPI_TX_HEADER.FULL.LINK_1", UCP_EVENT_42H_04H)	\
__PMC_EV_ALIAS("QPI_TX_HEADER.BUSY.LINK_1", UCP_EVENT_42H_08H)	\
__PMC_EV_ALIAS("QPI_RX_NO_PPT_CREDIT.STALLS.LINK_0", UCP_EVENT_43H_01H)	\
__PMC_EV_ALIAS("QPI_RX_NO_PPT_CREDIT.STALLS.LINK_1", UCP_EVENT_43H_02H)	\
__PMC_EV_ALIAS("DRAM_OPEN.CH0", UCP_EVENT_60H_01H)	\
__PMC_EV_ALIAS("DRAM_OPEN.CH1", UCP_EVENT_60H_02H)	\
__PMC_EV_ALIAS("DRAM_OPEN.CH2", UCP_EVENT_60H_04H)	\
__PMC_EV_ALIAS("DRAM_PAGE_CLOSE.CH0", UCP_EVENT_61H_01H)	\
__PMC_EV_ALIAS("DRAM_PAGE_CLOSE.CH1", UCP_EVENT_61H_02H)	\
__PMC_EV_ALIAS("DRAM_PAGE_CLOSE.CH2", UCP_EVENT_61H_04H)	\
__PMC_EV_ALIAS("DRAM_PAGE_MISS.CH0", UCP_EVENT_62H_01H)	\
__PMC_EV_ALIAS("DRAM_PAGE_MISS.CH1", UCP_EVENT_62H_02H)	\
__PMC_EV_ALIAS("DRAM_PAGE_MISS.CH2", UCP_EVENT_62H_04H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.CH0", UCP_EVENT_63H_01H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.AUTOPRE_CH0", UCP_EVENT_63H_02H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.CH1", UCP_EVENT_63H_04H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.AUTOPRE_CH1", UCP_EVENT_63H_08H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.CH2", UCP_EVENT_63H_10H)	\
__PMC_EV_ALIAS("DRAM_READ_CAS.AUTOPRE_CH2", UCP_EVENT_63H_20H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.CH0", UCP_EVENT_64H_01H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.AUTOPRE_CH0", UCP_EVENT_64H_02H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.CH1", UCP_EVENT_64H_04H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.AUTOPRE_CH1", UCP_EVENT_64H_08H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.CH2", UCP_EVENT_64H_10H)	\
__PMC_EV_ALIAS("DRAM_WRITE_CAS.AUTOPRE_CH2", UCP_EVENT_64H_20H)	\
__PMC_EV_ALIAS("DRAM_REFRESH.CH0", UCP_EVENT_65H_01H)	\
__PMC_EV_ALIAS("DRAM_REFRESH.CH1", UCP_EVENT_65H_02H)	\
__PMC_EV_ALIAS("DRAM_REFRESH.CH2", UCP_EVENT_65H_04H)	\
__PMC_EV_ALIAS("DRAM_PRE_ALL.CH0", UCP_EVENT_66H_01H)	\
__PMC_EV_ALIAS("DRAM_PRE_ALL.CH1", UCP_EVENT_66H_02H)	\
__PMC_EV_ALIAS("DRAM_PRE_ALL.CH2", UCP_EVENT_66H_04H)	\
__PMC_EV_ALIAS("DRAM_THERMAL_THROTTLED", UCP_EVENT_67H_01H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLING_TEMP.CORE_0", UCP_EVENT_80H_01H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLING_TEMP.CORE_1", UCP_EVENT_80H_02H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLING_TEMP.CORE_2", UCP_EVENT_80H_04H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLING_TEMP.CORE_3", UCP_EVENT_80H_08H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLED_TEMP.CORE_0", UCP_EVENT_81H_01H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLED_TEMP.CORE_1", UCP_EVENT_81H_02H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLED_TEMP.CORE_2", UCP_EVENT_81H_04H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLED_TEMP.CORE_3", UCP_EVENT_81H_08H)	\
__PMC_EV_ALIAS("PROCHOT_ASSERTION", UCP_EVENT_82H_01H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLING_PROCHOT.CORE_0", UCP_EVENT_83H_01H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLING_PROCHOT.CORE_1", UCP_EVENT_83H_02H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLING_PROCHOT.CORE_2", UCP_EVENT_83H_04H)	\
__PMC_EV_ALIAS("THERMAL_THROTTLING_PROCHOT.CORE_3", UCP_EVENT_83H_08H)	\
__PMC_EV_ALIAS("TURBO_MODE.CORE_0", UCP_EVENT_84H_01H)	\
__PMC_EV_ALIAS("TURBO_MODE.CORE_1", UCP_EVENT_84H_02H)	\
__PMC_EV_ALIAS("TURBO_MODE.CORE_2", UCP_EVENT_84H_04H)	\
__PMC_EV_ALIAS("TURBO_MODE.CORE_3", UCP_EVENT_84H_08H)	\
__PMC_EV_ALIAS("CYCLES_UNHALTED_L3_FLL_ENABLE", UCP_EVENT_85H_02H)	\
__PMC_EV_ALIAS("CYCLES_UNHALTED_L3_FLL_DISABLE", UCP_EVENT_86H_01H)

/*
 * Intel XScale events from:
 *
 * Intel XScale Core Developer's Manual
 * January, 2004, #27347302
 *
 * 3rd Generation Intel XScale Microarchitecture
 * Developer's Manual
 * May 2007, #31628302
 *
 * First 14 events are for 1st and 2nd Generation Intel XScale cores. The
 * remaining are available only on 3rd Generation Intel XScale cores.
 */
#define	__PMC_EV_XSCALE()				\
	__PMC_EV(XSCALE, IC_FETCH)			\
	__PMC_EV(XSCALE, IC_MISS)			\
	__PMC_EV(XSCALE, DATA_DEPENDENCY_STALLED)	\
	__PMC_EV(XSCALE, ITLB_MISS)			\
	__PMC_EV(XSCALE, DTLB_MISS)			\
	__PMC_EV(XSCALE, BRANCH_RETIRED)		\
	__PMC_EV(XSCALE, BRANCH_MISPRED)		\
	__PMC_EV(XSCALE, INSTR_RETIRED)			\
	__PMC_EV(XSCALE, DC_FULL_CYCLE)			\
	__PMC_EV(XSCALE, DC_FULL_CONTIG)		\
	__PMC_EV(XSCALE, DC_ACCESS)			\
	__PMC_EV(XSCALE, DC_MISS)			\
	__PMC_EV(XSCALE, DC_WRITEBACK)			\
	__PMC_EV(XSCALE, PC_CHANGE)			\
	__PMC_EV(XSCALE, BRANCH_RETIRED_ALL)		\
	__PMC_EV(XSCALE, INSTR_CYCLE)			\
	__PMC_EV(XSCALE, CP_STALL)			\
	__PMC_EV(XSCALE, PC_CHANGE_ALL)			\
	__PMC_EV(XSCALE, PIPELINE_FLUSH)		\
	__PMC_EV(XSCALE, BACKEND_STALL)			\
	__PMC_EV(XSCALE, MULTIPLIER_USE)		\
	__PMC_EV(XSCALE, MULTIPLIER_STALLED)		\
	__PMC_EV(XSCALE, DATA_CACHE_STALLED)		\
	__PMC_EV(XSCALE, L2_CACHE_REQ)			\
	__PMC_EV(XSCALE, L2_CACHE_MISS)			\
	__PMC_EV(XSCALE, ADDRESS_BUS_TRANS)		\
	__PMC_EV(XSCALE, SELF_ADDRESS_BUS_TRANS)	\
	__PMC_EV(XSCALE, DATA_BUS_TRANS)

#define	PMC_EV_XSCALE_FIRST	PMC_EV_XSCALE_IC_FETCH
#define	PMC_EV_XSCALE_LAST	PMC_EV_XSCALE_DATA_BUS_TRANS

/*
 * MIPS Events from "Programming the MIPS32 24K Core Family",
 * Document Number: MD00355 Revision 04.63 December 19, 2008
 * These events are kept in the order found in Table 7.4.
 * For counters which are different between the left hand
 * column (0/2) and the right hand column (1/3) the left
 * hand is given first, e.g. BRANCH_COMPLETED and BRANCH_MISPRED
 * in the definition below.
 */

#define __PMC_EV_MIPS24K()                         \
	__PMC_EV(MIPS24K, CYCLE)                   \
	__PMC_EV(MIPS24K, INSTR_EXECUTED)          \
	__PMC_EV(MIPS24K, BRANCH_COMPLETED)        \
	__PMC_EV(MIPS24K, BRANCH_MISPRED)          \
	__PMC_EV(MIPS24K, RETURN)                  \
	__PMC_EV(MIPS24K, RETURN_MISPRED)          \
	__PMC_EV(MIPS24K, RETURN_NOT_31)           \
	__PMC_EV(MIPS24K, RETURN_NOTPRED)          \
	__PMC_EV(MIPS24K, ITLB_ACCESS)             \
	__PMC_EV(MIPS24K, ITLB_MISS)               \
	__PMC_EV(MIPS24K, DTLB_ACCESS)             \
	__PMC_EV(MIPS24K, DTLB_MISS)               \
	__PMC_EV(MIPS24K, JTLB_IACCESS)            \
	__PMC_EV(MIPS24K, JTLB_IMISS)              \
	__PMC_EV(MIPS24K, JTLB_DACCESS)            \
	__PMC_EV(MIPS24K, JTLB_DMISS)              \
	__PMC_EV(MIPS24K, IC_FETCH)                \
	__PMC_EV(MIPS24K, IC_MISS)                 \
	__PMC_EV(MIPS24K, DC_LOADSTORE)            \
	__PMC_EV(MIPS24K, DC_WRITEBACK)            \
	__PMC_EV(MIPS24K, DC_MISS)                 \
	__PMC_EV(MIPS24K, STORE_MISS)              \
	__PMC_EV(MIPS24K, LOAD_MISS)               \
	__PMC_EV(MIPS24K, INTEGER_COMPLETED)       \
	__PMC_EV(MIPS24K, FP_COMPLETED)            \
	__PMC_EV(MIPS24K, LOAD_COMPLETED)          \
	__PMC_EV(MIPS24K, STORE_COMPLETED)         \
	__PMC_EV(MIPS24K, BARRIER_COMPLETED)       \
	__PMC_EV(MIPS24K, MIPS16_COMPLETED)        \
	__PMC_EV(MIPS24K, NOP_COMPLETED)           \
	__PMC_EV(MIPS24K, INTEGER_MULDIV_COMPLETED)\
	__PMC_EV(MIPS24K, RF_STALL)                \
	__PMC_EV(MIPS24K, INSTR_REFETCH)           \
	__PMC_EV(MIPS24K, STORE_COND_COMPLETED)    \
	__PMC_EV(MIPS24K, STORE_COND_FAILED)       \
	__PMC_EV(MIPS24K, ICACHE_REQUESTS)         \
	__PMC_EV(MIPS24K, ICACHE_HIT)              \
	__PMC_EV(MIPS24K, L2_WRITEBACK)            \
	__PMC_EV(MIPS24K, L2_ACCESS)               \
	__PMC_EV(MIPS24K, L2_MISS)                 \
	__PMC_EV(MIPS24K, L2_ERR_CORRECTED)        \
	__PMC_EV(MIPS24K, EXCEPTIONS)              \
	__PMC_EV(MIPS24K, RF_CYCLES_STALLED)       \
	__PMC_EV(MIPS24K, IFU_CYCLES_STALLED)      \
	__PMC_EV(MIPS24K, ALU_CYCLES_STALLED)      \
	__PMC_EV(MIPS24K, UNCACHED_LOAD)           \
	__PMC_EV(MIPS24K, UNCACHED_STORE)          \
	__PMC_EV(MIPS24K, CP2_REG_TO_REG_COMPLETED)\
	__PMC_EV(MIPS24K, MFTC_COMPLETED)          \
	__PMC_EV(MIPS24K, IC_BLOCKED_CYCLES)       \
	__PMC_EV(MIPS24K, DC_BLOCKED_CYCLES)       \
	__PMC_EV(MIPS24K, L2_IMISS_STALL_CYCLES)   \
	__PMC_EV(MIPS24K, L2_DMISS_STALL_CYCLES)   \
	__PMC_EV(MIPS24K, DMISS_CYCLES)            \
	__PMC_EV(MIPS24K, L2_MISS_CYCLES)          \
	__PMC_EV(MIPS24K, UNCACHED_BLOCK_CYCLES)   \
	__PMC_EV(MIPS24K, MDU_STALL_CYCLES)        \
	__PMC_EV(MIPS24K, FPU_STALL_CYCLES)        \
	__PMC_EV(MIPS24K, CP2_STALL_CYCLES)        \
	__PMC_EV(MIPS24K, COREXTEND_STALL_CYCLES)  \
	__PMC_EV(MIPS24K, ISPRAM_STALL_CYCLES)     \
	__PMC_EV(MIPS24K, DSPRAM_STALL_CYCLES)     \
	__PMC_EV(MIPS24K, CACHE_STALL_CYCLES)      \
	__PMC_EV(MIPS24K, LOAD_TO_USE_STALLS)      \
	__PMC_EV(MIPS24K, BASE_MISPRED_STALLS)     \
	__PMC_EV(MIPS24K, CPO_READ_STALLS)         \
	__PMC_EV(MIPS24K, BRANCH_MISPRED_CYCLES)   \
	__PMC_EV(MIPS24K, IFETCH_BUFFER_FULL)      \
	__PMC_EV(MIPS24K, FETCH_BUFFER_ALLOCATED)  \
	__PMC_EV(MIPS24K, EJTAG_ITRIGGER)          \
	__PMC_EV(MIPS24K, EJTAG_DTRIGGER)          \
	__PMC_EV(MIPS24K, FSB_LT_QUARTER)          \
	__PMC_EV(MIPS24K, FSB_QUARTER_TO_HALF)     \
	__PMC_EV(MIPS24K, FSB_GT_HALF)             \
	__PMC_EV(MIPS24K, FSB_FULL_PIPELINE_STALLS)\
	__PMC_EV(MIPS24K, LDQ_LT_QUARTER)          \
	__PMC_EV(MIPS24K, LDQ_QUARTER_TO_HALF)     \
	__PMC_EV(MIPS24K, LDQ_GT_HALF)             \
	__PMC_EV(MIPS24K, LDQ_FULL_PIPELINE_STALLS)\
	__PMC_EV(MIPS24K, WBB_LT_QUARTER)          \
	__PMC_EV(MIPS24K, WBB_QUARTER_TO_HALF)     \
	__PMC_EV(MIPS24K, WBB_GT_HALF)             \
	__PMC_EV(MIPS24K, WBB_FULL_PIPELINE_STALLS) \
	__PMC_EV(MIPS24K, REQUEST_LATENCY)         \
	__PMC_EV(MIPS24K, REQUEST_COUNT)

#define	PMC_EV_MIPS24K_FIRST	PMC_EV_MIPS24K_CYCLE
#define	PMC_EV_MIPS24K_LAST	PMC_EV_MIPS24K_WBB_FULL_PIPELINE_STALLS

/*
 * All known PMC events.
 *
 * PMC event numbers are allocated sparsely to allow new PMC events to
 * be added to a PMC class without breaking ABI compatibility.  The
 * current allocation scheme is:
 *
 * START	#EVENTS		DESCRIPTION
 * 0		0x1000		Reserved
 * 0x1000	0x0001		TSC
 * 0x2000	0x0080		AMD K7 events
 * 0x2080	0x0100		AMD K8 events
 * 0x10000	0x0080		INTEL architectural fixed-function events
 * 0x10080	0x0F80		INTEL architectural programmable events
 * 0x11000	0x0080		INTEL Pentium 4 events
 * 0x11080	0x0080		INTEL Pentium MMX events
 * 0x11100	0x0100		INTEL Pentium Pro/P-II/P-III/Pentium-M events
 * 0x11200	0x00FF		INTEL XScale events
 * 0x11300      0x00FF          MIPS 24K events
 */
#define	__PMC_EVENTS()				\
	__PMC_EV_BLOCK(TSC,	0x01000)	\
	__PMC_EV_TSC()				\
	__PMC_EV_BLOCK(K7,	0x2000)		\
	__PMC_EV_K7()				\
	__PMC_EV_BLOCK(K8,	0x2080)		\
	__PMC_EV_K8()				\
	__PMC_EV_BLOCK(IAF,	0x10000)	\
	__PMC_EV_IAF()				\
	__PMC_EV_BLOCK(IAP,	0x10080)	\
	__PMC_EV_IAP()				\
	__PMC_EV_BLOCK(P4,	0x11000)	\
	__PMC_EV_P4()				\
	__PMC_EV_BLOCK(P5,	0x11080)	\
	__PMC_EV_P5()				\
	__PMC_EV_BLOCK(P6,	0x11100)	\
	__PMC_EV_P6()				\
	__PMC_EV_BLOCK(XSCALE,	0x11200)	\
	__PMC_EV_XSCALE()                       \
	__PMC_EV_BLOCK(MIPS24K,	0x11300)	\
	__PMC_EV_MIPS24K()			\
	__PMC_EV_BLOCK(UCF,	0x12000)	\
	__PMC_EV_UCF()				\
	__PMC_EV_BLOCK(UCP,	0x12080)	\
	__PMC_EV_UCP()				\

#define	PMC_EVENT_FIRST	PMC_EV_TSC_TSC
#define	PMC_EVENT_LAST	PMC_EV_UCP_LAST

#endif /* _DEV_HWPMC_PMC_EVENTS_H_ */
