/***************************************************************************
                          misc.h  -  description
                             -------------------
    begin                : Thu Sep 6 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __MISC_H
#define __MISC_H

/*
====================================================================
Vector
====================================================================
*/
typedef struct {
    float   x, y;
} Vector;
/*
====================================================================
Line
====================================================================
*/
typedef Vector Coord;
typedef struct {
    float x; /* position if vertical line */
    int vertical; /* if this is set monotony is not computed */
    float m; /* monotony */
    float n; /* y_offset */
} Line;

/*
====================================================================
Target of a shot or a ball.
====================================================================
*/
enum { SIDE_UNDEFINED = -1, SIDE_TOP = 0, SIDE_RIGHT, SIDE_BOTTOM, SIDE_LEFT, 
							CORNER_UPPER_LEFT, CORNER_UPPER_RIGHT, 
							CORNER_LOWER_LEFT, CORNER_LOWER_RIGHT };
typedef struct {
    int     exists; /* is there a target */
    int     mx, my; /* position in map */
    float   x, y; /* reset position of ball */
    int     time; /* time till contact */
    int     cur_tm; /* current time */
    Vector  perp_vector; /* reflection vector */
    int     side; /* side/corner of brick hit */
} Target;

/*
====================================================================
Load background according to id and draw background to offscreen.
Return Value: loaded background surface
====================================================================
*/
SDL_Surface* bkgnd_draw( int id );
/*
====================================================================
Confirm request. Darkens screen a bit and display text.
Return Value: True if successful
====================================================================
*/
enum{ CONFIRM_YES_NO, CONFIRM_ANY_KEY, CONFIRM_PAUSE };
int confirm( Font *font, char *str, int type );
/*
====================================================================
Create shadow surface for specified region in surface.
Return Value: Shadow surface
====================================================================
*/
SDL_Surface* create_shadow( SDL_Surface *surf, int x, int y, int w, int h );

/*
====================================================================
Return vector struct with the specified coordinates.
====================================================================
*/
Vector vector_get( float x, float y );
/*
====================================================================
Give vector the normed length of 1.
====================================================================
*/
void vector_norm( Vector *v );
/*
====================================================================
Return monotony of vector. If vertical return 0
====================================================================
*/
float vector_monotony( Vector v );

/*
====================================================================
Initiate a line struct.
====================================================================
*/
void line_set( Line *line, float x, float y, float m );
void line_set_vert( Line *line, float x );
void line_set_hori( Line *line, float y );
void line_set_pts( Line *line, float x, float y, float x2, float y2 );
void line_set_affin( Line *line, Vector p, Vector v );
/*
====================================================================
Intersect lines and set 'pos' to intersecting point.
Return Value: True if lines intersect.
====================================================================
*/
int line_intersect( Line *line, Line *target, Coord *pos );
/*
====================================================================
Return f(x)
====================================================================
*/
float line_y( Line *line, float x );

/*
====================================================================
Intersect line pos+t*v with circle (x+m)=r
Important length of v MUST be 1.
Return Value: True if intersecting, Intersecting points
====================================================================
*/
int circle_intersect( Vector m, int r, Vector pos, Vector v, Vector *t1, Vector *t2 );

/*
====================================================================
Enter a string and return True if ENTER received and False
if ESCAPE received.
====================================================================
*/
int enter_string( Font *font, char *caption, char *edit, int limit );

#endif
