/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/


package com.sap.dbtech.rte.comm;

import java.util.Properties;

import com.sap.dbtech.util.*;

/**
 *
 */
public class NativeComm
    extends JdbcCommunication
{
    private byte [] nativeStruct;
    private String host;
    private String dbname;

    public final static JdbcCommFactory factory = new JdbcCommFactory () {
        public JdbcCommunication open(String host, String dbname, Properties property) throws RTEException  {
            return new NativeComm (host, dbname);
        }

            public JdbcCommunication xopen(String host,
                                           String db,
                                           String dbroot,
                                           String pgm,
                                           Properties properties)
                throws RTEException
            {
                return null; // todo: Throw Exception
            }
            
    };
    /**
     * creates a new NativeComm
     */
    public
    NativeComm (
        String host,
        String dbname)
    throws RTEException
    {
        this.host = host;
        this.dbname = dbname;
        this.connect ();
    }
    /**
     *
     */
    public native void
    connect ()
    throws RTEException;
    /**
     * cancels a pending request.
     */
    public native void cancel () throws java.sql.SQLException;
    /**
     * gets a new request packet.
     * @return StructuredMem
     */
    public native StructuredMem getRequestPacket ();
    /**
     * test whether the connection is still valid.
     * @return boolean
     */
    public native boolean isConnected ();
    /**
     * blocks while waiting for a reply
     * @return StructuredMem
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    public native StructuredMem receive () throws RTEException;
    /**
     * tries to reconnect after a timeout.
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    public native void reconnect () throws RTEException;
    /**
     * closes the connection.
     */
    public native void release ();
    /**
     * send a new request to the server.
     * @param userPacket StructuredMem
     * @param len int
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    public void request (StructuredMem userPacket, int len)
    throws RTEException
    {
        this.rawRequest (userPacket. getBytes (0, len), len);
    }
    /**
     * send a new request to the server.
     * @param userPacket byte []
     * @param len int
     * @exception com.sap.dbtech.rte.comm.RTEException.
     */
    public native void rawRequest (byte [] userPacket, int len) throws RTEException;
    /**
     *
     */
    public void
    finalize ()
    {
        this.release ();
    }
}
