Summary: A program that creates emergency boot disks/CDs using your kernel, tools and modules.
Name: mindi
Version: 0.58
Release: 5
Copyright: GPL
Group: System/Kernel and hardware
Url: http://www.microwerks.net/~hugo/mindi/index.html
Source: /usr/src/RPM/SOURCES/mindi-%{version}.tgz
Packager: Hugo Rabson <hugo@firstlinux.net>
BuildRoot: /tmp/%{name}-%{version}
BuildArch: i386
Requires: afio, bzip2 >= 0.9, mkisofs, ncurses, lilo

%description
Mindi takes your kernel, modules, tools and libraries, and puts them on N
bootable disks (or 1 bootable CD image). You may then boot from the disks/CD
and do system maintenance - e.g. format partitions, backup/restore data,
verify packages, etc.

%prep
%setup
%build
%install

rm -rf $RPM_BUILD_ROOT
MINDIDIR=$RPM_BUILD_ROOT%{_datadir}/mindi
mkdir -p $MINDIDIR $RPM_BUILD_ROOT%{_sbindir}
cp -a * $MINDIDIR
#
# These are installed twice if not removed here
( cd $MINDIDIR
rm -f CHANGES INSTALL LICENSE README TODO
)
cd $RPM_BUILD_ROOT%{_sbindir}
ln -sf %{_datadir}/mindi/mindi .
ln -sf %{_datadir}/mindi/analyze-my-lvm .

%clean
rm -rf $RPM_BUILD_ROOT

%files
%config
%defattr(-,root,root)
%doc CHANGES INSTALL LICENSE README TODO

%{_sbindir}/mindi
%{_datadir}/mindi
#%{_datadir}/mindi/mindi
%{_sbindir}/analyze-my-lvm
#%{_datadir}/mindi/analyze-my-lvm


%changelog
* Sun Feb 24 2002 Hugo Rabson <hugo@firstlinux.net> 0.58-5
- pathname problem fixed (Fred Feirtag)
- patch to Debianize mindi a bit (Hctor Garca lvarez)
- removed mondo-manual.html
- moved /dev/{cciss,ida,rd} from rootfs.tgz to aux-tools.tgz
- cleaned up the refs to analyze-my-lvm a bit (Hugo)
- sped up disk-creation by 20-30%
- make sure mondo-restore.cfg is on data disk as well as boot disk
- added support for -C (cdstream) mode

* Mon Feb 18 2002 Hugo Rabson <hugo@firstlinux.net> 0.58-4
- quash error if /opt not found
- use /tmp/groovy-stuff instead of /mnt/groovy-stuff for
  handling data disks and their contents, for tape users

* Sun Feb 17 2002 Hugo Rabson <hugo@firstlinux.net> 0.58-3
- misc enhancements
- uses self-resizing ramdisk (tmpfs) for /tmp
- allows Mondo to exclude certain devices from mountlist
- replaced &> /dev/null with > /dev/null 2> /dev/null
- incorporated .spec patch (Ian Kent)
- added vi to busybox again

* Mon Feb 11 2002 Hugo Rabson <hugo@firstlinux.net> 0.58-2
- fixed errant tar warning
- replaced libc5 with uClibc
- compiled busybox and open against uClibc
- moved minor scripts+tools from rootfs.tgz to aux-tools.tgz
- Mindi can now accommodate a kernel of up to 1290KB in size
- no longer insists on cdrecord being present

* Sun Feb 10 2002 Hugo Rabson <hugo@firstlinux.net> 0.58-1
- more pointed error messages
- fixed silly 'cp' error (Markus Marquardt)
- use type C's embleer file for type B Windows partitions
- increased EXTRA_SPACE from 4096 to 8192
- cosmetic bugfixes
- nfs users boot into nfs options by default

* Wed Feb 05 2002 Hugo Rabson <hugo@firstlinux.net> 0.57-1
- abort if mounted partition is specified as an imagedev
- understand 'FAILSAFE' as kernel alternative
- added analyze-my-lvm to tools available thru PATH
- better discovery of locale and keymap file (Claude Mah)
- compatible with 1.2x and the new 1.38+ stuff
- better 'bug-me' script (Troff)

* Fri Feb 01 2002 Hugo Rabson <hugo@firstlinux.net> 0.56-1
- compatible with Mondo v1.5x devel branch
- mindi's softlink now goes in /usr/sbin; was /usr/bin
- include nfs.o, nfsd.o, lockd.o and sunrpc.o on data disks if available
- patched .spec file to make it easier to change installdir (Ian Mortimer)
- updated README
- moved many global vars to start of script
- better at finding US kbd maps
- migrating to a single configuration file, /tmp/mondo-restore.cfg, for
  Mondo users; file is not in use yet but is there for future expansion

* Mon Jan 28 2002 Hugo Rabson <hugo@firstlinux.net> 0.55-1
- MINDI_HOME and MONDO_HOME defined at start of each source file, making
  it easier to relocate Mindi and Mondo if desired
- tries to mount /dev/hd[a-h] at boot-time, looking for CD-ROM; was hd[a-d]
- re-enabled msg asking user to upgrade LILO if v21.6
- Lin/Win users are much, _much_ less likely to run out of disk space now
  when restoring from backups (Carlos Molina)
- patch from Andrej Borsenkow to help w/Mandrake 8.1
- disabled ramdisk free space checker (some distros don't like it)

* Fri Jan 25 2002 Hugo Rabson <hugo@firstlinux.net> 0.54-1
- don't abort if kernel is too big for 1.72MB floppy
- better handling of eccentric distros and their keybd layouts
- added gawk and awk to deplist
- added LILO to .spec file
- changed a couple of FatalError()'s to Die()'s
- better TurboLinux 7 / LVM compatibility

* Sun Jan 20 2002 Hugo Rabson <hugo@firstlinux.net> 0.53-1
- better support of non-Red Hat, non-Debian keyboard resource files
- cleaned up /sbin/init's output
- replaced libc5 mount with user's own 'mount'
- updated embleer.C.bz2
- missing /dev/hdb2 found & replaced (Troff)
- populated /dev/rd and /dev/ida on ramdisk (Michael Eisenberg)
- improved SizeOfPartition() function
- improved TryToFindKernelPath() function
- don't offer NFS users Nuke Mode
- finds and uses lilo.real if user is using Debian, a distro which
  installs a shell script where the lilo executable should go
- improved support for XFS users who opt to use failsafe kernel
- uses user's lsmod, depmod, insmod, etc.
- fixed freeze-up resulting from missing 'cat $mappath' command
- mount tmpfs at /tmp/tmpfs for mondo-restore's benefit
- try to create /dev/fd0u1722 if it is missing from /dev
- added .spec file to tarball

* Thu Jan 10 2002 Hugo Rabson <hugo@firstlinux.net> 0.52-2
- fixed a bug in the handling of non-English keyboard maps
- force failsafe kernel to provide reiserfs.o, xfs.o, jfs.o, ext2.o,
  ext3.o and loop.o at boot-time, just in case
- added /dev/sr[0-3] devices
- copy LAST_FILELIST_NUMBER to /tmp, for compatibility with Mondo v1.3x
- incorporates NFS-related settings, if supplied by Mondo v1.3x
- replace busybox's mount with standard libc5 mount ater restoring
  tools from floppies: NFS mounting requires full mount
- always make mindi.iso
 
* Sun Jan 06 2002 Hugo Rabson <hugo@firstlinux.net> 0.52-1
- ramdisk's size has been tweaked
- if script 'bootstrap' is found at boot-time then execute it
- use tty8 to show mondo's output log
- use tty7 to offer a game of Petris (if it exists on disk)
- be sure to use i386-only keymaps
- if keyboard mapping dir (usu. /lib/kbd or /usr/lib/kbd) cannot be
  found then don't abort; simply tell the user the default keyboard
  mapping will be used
- added /dev/hd[a,b,c,d][17-24] to the rootfs tarball
- if LILO's "/tmp/dev.0" error occurs then abort & tell user to reboot
- losetup /dev/loop0 -d before calling LILO (Norm Crowfoot)
- /sbin and /usr/sbin added temporarily to PATH when Mindi runs
- if Mondo asks then force LILO to run in backward-compatible mode
- if Mondo's tmpdir has post-nuke.tgz in it then extract it and
  incorporate its files in the data disks
- Mindi now lives in /usr/local/mindi
- don't use LILO's optimizations when creating boot floppy; however,
  optimizations are used on CD unless --broken-bios in call to Mondo
- don't write data disks to start of tape; let Mondo do that
- tweaked how Mindi moves all.tar.gz around, to make it more Mondo-friendly
- tweaked Mindi's disk-splitter
- user must unmount /dev/loop0 before calling Mindi: LILO insists...
- added NFS-related entries to deplist.txt
- if not called by Mondo then don't let user choose Interactive/Nuke/
  whatever; just offer Expert

* Tue Dec 25 2001 Hugo Rabson <hugo@firstlinux.net> 0.51-1
- removed libm.* from rootfs.tgz
- replaced sh with busybox's ash
- upgraded busybox to 0.60-2; pared it down, too
- include tape-related modules on boot disk, if backing up to tape
- creates a tape-friendly tarball containing tools+modules
- reassembly of tools+libraries is more reliable now
- streamlined deplist.txt
- give user their localized keyboard layout at boot-time
- fix some cosmetic bugs

* Wed Dec 19 2001 Hugo Rabson <hugo@firstlinux.net> 0.50-4
- log Mindi's version# in the event of a fatal error
- make Mindi's boot-time output more esthetically pleasing
- if filesystem is 'image' according to Mondo then set its partition type
  to the hexadecimal string used by fdisk to describe it

* Sat Dec 15 2001 Hugo Rabson <hugo@firstlinux.net> 0.50-2
- support for newer features in Mondo v1.3x

* Wed Dec 12 2001 Hugo Rabson <hugo@firstlinux.net> 0.50-1
- correctly lists RAID constituent partitions in mountlist
- breaks compatibility with Mondo v1.2x
- ignore any weird lines in /etc/fstab: don't abort
- cleaned up /sbin/init and /sbin/post-init

* Sun Dec 09 2001 Hugo Rabson <hugo@firstlinux.net> 0.48-2
- locate root-dir modules on ramdisk more effectively
- if RAID controller(s) detected then pause for 10s to let it/them initialize
- cleaned up /sbin/init and /sbin/post-init
- better detection of and compatibility with SCSI CD-ROM drives
- chopsize is 64KB; was 128KB
- cleaned up mindi's logging

* Sat Dec 08 2001 Hugo Rabson <hugo@firstlinux.net> 0.48-1
- better logging of find-and-mount-cdrom's progress (to /tmp/mondo-restore.log)
- excluded lilo and lilo.conf from deplist.txt again; somehow it crept back in
- added 'linear' to list of modules Mindi always backs up
- if called by Mondo then record the name & device of the user's boot loader
- try to mount CD-ROM drive after booting from floppies, just in case
- added fix to make sure /root/images/mindi is created (Charlie Root)
- aware of 'iso' and 'nfs' boot modes now, for future expansion

* Tue Dec 04 2001 Hugo Rabson <hugo@firstlinux.net> 0.47-1
- added /dev/cdrom/cdrom[1-4] to the list of devices excluded from mountlist
- added '-f-' to most calls to tar, to fix a Debian-related bug
- added network-related dependencies to deplist.txt
- added mondo-restore to deplist.txt
- do not write floppy images to disks if Mondo called me; let Mondo do it
- finally managed to make klogd squelch echoing of kernel msgs to console

* Tue Nov 27 2001 Hugo Rabson <hugo@firstlinux.net> 0.46-1
- cosmetic changes and minor bugfixes
- excluded lilo and lilo.conf from deplist.txt; use user's copies instead
- handles bad RAID devices in fstab/raidtab more sensibly now
- fixed a bug in bug-me (heh, how ironic)

* Thu Nov 15 2001 Hugo Rabson <hugo@firstlinux.net> 0.45-4
- added md5sum to deplist.txt
- added pico->vi softlink to ramdisk
- in ramdisk's /etc/bashrc, add /usr/local/bin,sbin to PATH= command
- tweaked max data disk size and data disk formatting command
- removed lzop.* from aux-tools; should come from user's distro anyway
- disabled fsck.* in deplist.txt

* Mon Nov 12 2001 Hugo Rabson <hugo@firstlinux.net> 0.45-2
- added md5sum->busybox softlink
- improved the README / FAQ file

* Sun Nov 11 2001 Hugo Rabson <hugo@firstlinux.net> 0.45-1
- now lets Mondo ask for failsafe kernel - annoying bug finally fixed
- expanded busybox's facilities; dropped some files from deplist.txt
- busybox now makes 'vi' available to user
- no longer include lzop in tarball/RPM; user must install it themselves
- restructured /sbin/post-init's calls that initialize LVM and RAID
- cache added to speed up execution (Jean-David Marrow)
- tested with Red Hat 7.2 and Linux-Mandrake 8.0

* Sun Oct 28 2001 Hugo Rabson <hugo@firstlinux.net> 0.44-1
- activate LV's at boot-time if they exist
- re-enabled 'fsck.*' entries in deplist.txt
- analyze-my-lvm

* Sat Oct 20 2001 Hugo Rabson <hugo@firstlinux.net> 0.43-3
- works with Red Hat 6.2 now

* Wed Oct 17 2001 Hugo Rabson <hugo@firstlinux.net> 0.43-2
- fixed module-processing bug

* Sun Oct 14 2001 Hugo Rabson <hugo@firstlinux.net> 0.43-1
- removed losetup from 'Requires'
- updated failsafe kernel to 2.4.12+modules (inc. JFS, XFS and SCSI)

* Wed Oct 10 2001 Hugo Rabson <hugo@firstlinux.net> 0.42-2

* Sat Oct 06 2001 Hugo Rabson <hugo@firstlinux.net> 0.42-1
- added dev.tgz and aux-tools.tgz

* Fri Sep 28 2001 Hugo Rabson <hugo@firstlinux.net> 0.41-5

* Fri Sep 21 2001 Hugo Rabson <hugo@firstlinux.net> 0.41-2

* Sun Sep 16 2001 Hugo Rabson <hugo@firstlinux.net> 0.40-5

* Sat Sep 08 2001 Hugo Rabson <hugo@firstlinux.net> 0.39-9
- replaced stock kernel with a 586-compatible 2.4.9
- added mondo-manual.html

* Sat Aug 18 2001 Hugo Rabson <hugo@firstlinux.net> 0.38
- added stock 2.4.7 kernel & modules

* Sun Aug 12 2001 Hugo Rabson <hugo@firstlinux.net> 0.37

* Thu Aug 02 2001 Hugo Rabson <hugo@firstlinux.net> 0.36

* Mon Jul 30 2001 Hugo Rabson <hugo@firstlinux.net> 0.35
- removed lilo and boot-txt.b from package

* Sat Jul 28 2001 Hugo Rabson <hugo@firstlinux.net> 0.34

* Sun Jul 22 2001 Hugo Rabson <hugo@firstlinux.net> 0.33

* Thu Jul 19 2001 Hugo Rabson <hugo@firstlinux.net> 0.32

* Mon Jul 16 2001 Hugo Rabson <hugo@firstlinux.net> 0.31
- includes DoJ's devfs patch

* Sun Jul 15 2001 Hugo Rabson <hugo@firstlinux.net> 0.30

* Sat Jul 14 2001 Hugo Rabson <hugo@firstlinux.net> 0.29
- removed libncurses5 from the 'required' RPM list
- Mondo's restore scripts now live in Mondo

* Fri Jul 06 2001 Hugo Rabson <hugo@firstlinux.net> 0.28
- can handle Red Hat's /etc/issue.net file now
- can handle modules whose filenames don't end in '.o'

* Thu Jul 05 2001 Hugo Rabson <hugo@firstlinux.net> 0.27
- first release of a Mindi RPM

































































