/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.minicalc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jmc.CellAttributes;
import jmc.CellDescriptor;
import jmc.JMCException;
import jmc.Workbook;
import jmc.Worksheet;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetEncoder;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.IntArrayList;

final class MinicalcEncoder
extends SpreadsheetEncoder {
    private Workbook wb;
    private Worksheet ws;
    private static final int pixelsPerChar = 6;
    private static final int minWidth = 10;
    private static final int maxWidth = 80;

    MinicalcEncoder(String string, String string2) throws IOException {
        super(string, string2);
        try {
            this.wb = new Workbook(string, string2);
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("new Workbook threw exception:" + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
    }

    public void addCell(int n, int n2, Format format, String string) throws IOException {
        CellAttributes cellAttributes = new CellAttributes(this.getFormat(format), format.getForeground(), format.getBackground());
        if (string.startsWith("=")) {
            string = this.parseFormula(string);
            Debug.log((int)1, (String)("YAHOO Found Formula" + string));
        }
        CellDescriptor cellDescriptor = new CellDescriptor(n, n2, cellAttributes, string);
        try {
            this.ws.putCell(cellDescriptor);
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("ws.putCell threw exception: " + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
    }

    private long clearCellFormatType(long l) {
        return l &= 0xFFFFFFFFFFFFFF00L;
    }

    public void createWorksheet(String string) throws IOException {
        try {
            this.ws = this.wb.createWorksheet(string);
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("wb.createWorksheet threw exception:" + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
    }

    private long getFormat(Format format) {
        String string = format.getCategory();
        if (string.equalsIgnoreCase("boolean")) {
            return this.setFormatBoolean(0L);
        }
        if (string.equalsIgnoreCase("currency")) {
            return this.setFormatCurrency(0L, format.getDecimalPlaces());
        }
        if (string.equalsIgnoreCase("date")) {
            return this.setFormatDate(0L);
        }
        if (string.equalsIgnoreCase("float")) {
            return this.setFormatFloat(0L, format.getDecimalPlaces());
        }
        if (string.equalsIgnoreCase("percentage")) {
            return this.setFormatPercent(0L, format.getDecimalPlaces());
        }
        if (string.equalsIgnoreCase("string")) {
            return this.setFormatString(0L);
        }
        if (string.equalsIgnoreCase("time")) {
            return this.setFormatTime(0L);
        }
        System.out.println("XXXXX Formatting information not found");
        return 0L;
    }

    public int getNumberOfSheets() {
        int n = this.wb.getNumberOfSheets();
        return n;
    }

    public Record[] getRecords(int n) throws IOException {
        this.ws = this.wb.getWorksheet(n);
        try {
            this.ws.initWrite();
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("ws.initWrite in getRecords:" + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
        int n2 = this.ws.getNumberOfRecords();
        Record[] recordArray = new Record[n2];
        try {
            int n3 = 0;
            while (n3 < recordArray.length) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n4 = this.ws.writeNextRecord((OutputStream)byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                recordArray[n3] = new Record(byArray);
                ++n3;
            }
        }
        catch (Exception exception) {
            Debug.log((int)2, (String)("ws.writeNextRecord in getRecords:" + exception.getMessage()));
            throw new IOException(exception.getMessage());
        }
        return recordArray;
    }

    public String getSheetName(int n) {
        return this.wb.getWorksheet(n).getName();
    }

    protected String parseFormula(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            switch (stringBuffer.charAt(n2)) {
                case '[': {
                    bl = true;
                    bl2 = true;
                    break;
                }
                case ']': {
                    bl = false;
                    break;
                }
                case ':': {
                    if (bl) {
                        bl3 = true;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n2));
                    break;
                }
                case '.': {
                    if (bl) {
                        if (!bl2 && !bl3) {
                            stringBuffer2.append('!');
                            break;
                        }
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n2));
                    break;
                }
                case ';': {
                    stringBuffer2.append(',');
                    break;
                }
                default: {
                    stringBuffer2.append(stringBuffer.charAt(n2));
                    bl2 = false;
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer2.toString();
    }

    public void setCellFormat(int n, int n2, Format format) {
    }

    public void setColumnWidths(IntArrayList intArrayList) throws IOException {
        int n = intArrayList.size();
        if (n == 0) {
            return;
        }
        long l = 0x200000L;
        CellAttributes cellAttributes = new CellAttributes(l);
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3 = intArrayList.get(n2) * 6;
                if (n3 < 10) {
                    n3 = 10;
                } else if (n3 > 80) {
                    n3 = 80;
                }
                this.ws.putColumn(n2 + 1, n3, cellAttributes);
                ++n2;
            }
        }
        catch (JMCException jMCException) {
            Debug.log((int)2, (String)("ws.putColumn threw exception: " + jMCException.getMessage()));
            throw new IOException(jMCException.getMessage());
        }
    }

    private long setFormatBoolean(long l) {
        l = this.clearCellFormatType(l);
        return l;
    }

    private long setFormatCurrency(long l, int n) {
        l = this.clearCellFormatType(l);
        l = l | 0x40L | (long)n;
        return l;
    }

    private long setFormatDate(long l) {
        l = this.clearCellFormatType(l);
        return l |= 0x20L;
    }

    private long setFormatFloat(long l, int n) {
        l = this.clearCellFormatType(l);
        l = l | 0x10L | (long)n;
        return l;
    }

    private long setFormatPercent(long l, int n) {
        l = this.clearCellFormatType(l);
        l = l | 0x50L | (long)n;
        return l;
    }

    private long setFormatString(long l) {
        l = this.clearCellFormatType(l);
        return l;
    }

    private long setFormatTime(long l) {
        l = this.clearCellFormatType(l);
        return l |= 0x30L;
    }
}

