/*************************************************************************
 *
 *  $RCSfile: pkgchk_unorc.cxx,v $
 *
 *  $Revision: 1.6.72.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 16:43:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#include <vector>

#include "pkgchk_misc.h"
#include "pkgchk_unorc.h"
#include "rtl/strbuf.hxx"
#include "rtl/byteseq.hxx"
#include "osl/process.h"
#include "osl/thread.h"

#include "com/sun/star/uno/RuntimeException.hpp"


using namespace ::std;
using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star;

namespace pkgchk
{

//==============================================================================
void check_unorc( rtlBootstrapHandle * p_unorc, bool patch, bool verbose )
{
    OUString unorc_path(
        path_concat(
            path_get_executable(),
            RTL_CONSTASCII_STRINGPARAM(SAL_CONFIGFILE("uno")) ) );
    if (0 == *p_unorc)
    {
        *p_unorc = rtl_bootstrap_args_open( unorc_path.pData );
        if (0 == *p_unorc)
        {
            throw RuntimeException(
                OUSTR("cannot open ") + unorc_path, Reference< XInterface >() );
        }
    }
    Bootstrap const & unorc = *reinterpret_cast< Bootstrap const * >( p_unorc );
    
    vector< OString > to_be_added;
    to_be_added.reserve( 4 );
    OUString val;
    
    // shared cache path
    if (unorc.getFrom( OUSTR(UNO_SHARED_PACKAGES), val ))
    {
        if (! unorc.getFrom( OUSTR(UNO_SHARED_PACKAGES_CACHE), val ))
        {
            to_be_added.push_back(
                OString(UNO_SHARED_PACKAGES_CACHE "=$" UNO_SHARED_PACKAGES
                        "/cache") );
            val = path_concat( val, RTL_CONSTASCII_STRINGPARAM("cache") );
        }
    }
    else
    {
        // ensure no UNO_SHARED_PACKAGES_CACHE is given
        if (unorc.getFrom( OUSTR(UNO_SHARED_PACKAGES_CACHE), val ))
        {
            throw RuntimeException(
                OUSTR(UNO_SHARED_PACKAGES_CACHE " defined, but not "
                      UNO_SHARED_PACKAGES),
                Reference< XInterface >() );
        }
        // write defaults
        to_be_added.push_back(
            OString(UNO_SHARED_PACKAGES "=" RC_SHARED_INSTPATH_MACRO
                    "/share/uno_packages") );
        to_be_added.push_back(
            OString(UNO_SHARED_PACKAGES_CACHE "=$" UNO_SHARED_PACKAGES
                    "/cache") );
        val = OUSTR(RC_SHARED_INSTPATH_MACRO "/share/uno_packages");
        unorc.expandMacrosFrom( val );
        val = path_concat( val, RTL_CONSTASCII_STRINGPARAM("cache") );
    }
    OUString shared_path( path_make_absolute( val ) );
    // user cache path
    if (unorc.getFrom( OUSTR(UNO_USER_PACKAGES), val ))
    {
        if (! unorc.getFrom( OUSTR(UNO_USER_PACKAGES_CACHE), val ))
        {
            to_be_added.push_back(
                OString(UNO_USER_PACKAGES_CACHE "=$" UNO_USER_PACKAGES
                        "/cache") );
            val = path_concat( val, RTL_CONSTASCII_STRINGPARAM("cache") );
        }
    }
    else
    {
        // ensure no UNO_USER_PACKAGES_CACHE is given
        if (unorc.getFrom( OUSTR(UNO_USER_PACKAGES_CACHE), val ))
        {
            throw RuntimeException(
                OUSTR(UNO_USER_PACKAGES_CACHE " defined, but not "
                      UNO_USER_PACKAGES),
                Reference< XInterface >() );
        }
        // write defaults
        to_be_added.push_back(
            OString(UNO_USER_PACKAGES "=" RC_USER_INSTPATH_MACRO
                    "/user/uno_packages") );
        to_be_added.push_back(
            OString(UNO_USER_PACKAGES_CACHE "=$" UNO_USER_PACKAGES "/cache") );
        val = OUSTR("$" RC_USER_INSTPATH_MACRO "/user/uno_packages");
        unorc.expandMacrosFrom( val );
        val = path_concat( val, RTL_CONSTASCII_STRINGPARAM("cache") );
    }
    OUString user_path( path_make_absolute( val ) );
    // wanted ones for UNO_SERVICES, UNO_TYPES
    OUString shared_services(
        path_concat(
            shared_path,
            RTL_CONSTASCII_STRINGPARAM("services.rdb") ) );
    OUString shared_types(
        path_concat(
            shared_path,
            RTL_CONSTASCII_STRINGPARAM("types.rdb") ) );
    OUString user_services(
        path_concat(
            user_path,
            RTL_CONSTASCII_STRINGPARAM("services.rdb") ) );
    OUString user_types(
        path_concat(
            user_path,
            RTL_CONSTASCII_STRINGPARAM("types.rdb") ) );
    
    // check whether types/ services are in
    sal_Int32 nUserTypes = -1, nSharedTypes = -1;
    sal_Int32 nUserServices = -1, nSharedServices = -1;
    sal_Int32 nPos = 0, nIndex = 0;
    // types
    OUString uno_types( get_from_bootstrap( OUSTR("UNO_TYPES"), unorc ) );
    do
    {
        OUString token( uno_types.getToken( 0, ' ', nIndex ).trim() );
        if (token.getLength())
        {
            OUString rdb(
                path_make_absolute(
                    '?' == token[ 0 ] ? token.copy( 1 ) : token ) );
            if (rdb.equalsIgnoreAsciiCase( user_types ))
                nUserTypes = nPos;
            else if (rdb.equalsIgnoreAsciiCase( shared_types ))
                nSharedTypes = nPos;
            ++nPos;
        }
    }
    while (nIndex >= 0);
    // services
    nPos = 0; nIndex = 0;
    OUString uno_services( get_from_bootstrap( OUSTR("UNO_SERVICES"), unorc ) );
    do
    {
        OUString token( uno_services.getToken( 0, ' ', nIndex ).trim() );
        if (token.getLength())
        {
            OUString rdb(
                path_make_absolute(
                    '?' == token[ 0 ] ? token.copy( 1 ) : token ) );
            if (rdb.equalsIgnoreAsciiCase( user_services ))
                nUserServices = nPos;
            else if (rdb.equalsIgnoreAsciiCase( shared_services ))
                nSharedServices = nPos;
            ++nPos;
        }
    }
    while (nIndex >= 0);

    // everything ok?
    if (to_be_added.empty() &&
        nUserTypes >= 0 && nUserServices >= 0 &&
        nSharedTypes >= 0 && nSharedServices >= 0)
    {
        if (verbose)
        {
            OString str(
                OUStringToOString( unorc_path, osl_getThreadTextEncoding() ) );
            printf( "%s is checked; no patch needed.\n", str.getStr() );
        }
        return;
    }
    if (! patch)
    {
        if (verbose)
        {
            OString str(
                OUStringToOString( unorc_path, osl_getThreadTextEncoding() ) );
            fprintf(
                stderr,
                "> warning: %s needs patch, but is explicitly left "
                "unpatched!\n",
                str.getStr() );
        }
        return;
    }
    
    // missing at least one => patch file
    File file( unorc_path );
    if (File::E_None != file.open( OpenFlag_Read ))
	{
        throw RuntimeException(
            OUSTR("cannot read ") + unorc_path, Reference< XInterface >() );
	}
    
    ByteSequence seq;
    sal_uInt64 nSize = file_get_size( file );
    vector< OString > lines;
    lines.reserve( 8 );
    
    while (true)
    {
        sal_uInt64 nPos;
        if (File::E_None != file.getPos( nPos ) || nPos >= nSize)
            break;
        if (File::E_None != file.readLine( seq ))
            break;
        
        OString line( (sal_Char const *) seq.getConstArray(), seq.getLength() );
        
// nUserTypes = -1, nSharedTypes = -1,
// nUserServices = -1, nSharedServices = -1;
        
        if ((nUserServices < 0 || nSharedServices < 0) &&
            0 == rtl_str_shortenedCompare_WithLength(
                line.getStr(), line.getLength(),
                "UNO_SERVICES=",
                sizeof("UNO_SERVICES=")-1, sizeof("UNO_SERVICES=")-1 ))
        {
            // insert missing lines
            if (! to_be_added.empty())
            {
                for ( size_t nPos = 0; nPos < to_be_added.size(); ++nPos )
                    lines.push_back( to_be_added[ nPos ] );
                to_be_added.clear();
            }
            // merge in services
            OString val( line.copy( sizeof("UNO_SERVICES=") -1 ) );
            OStringBuffer buf( 128 );
            buf.append( RTL_CONSTASCII_STRINGPARAM("UNO_SERVICES=") );
            // prepend user services
            if (nUserServices < 0) // no user services
            {
                buf.append(
                    RTL_CONSTASCII_STRINGPARAM("?$" UNO_USER_PACKAGES_CACHE
                                               "/services.rdb ") );
                if (nSharedServices < 0) // no shared services
                {
                    buf.append( RTL_CONSTASCII_STRINGPARAM(
                                    "?$" UNO_SHARED_PACKAGES_CACHE
                                    "/services.rdb ") );
                }
                buf.append( val );
            }
            else // if (nSharedServices < 0)
            {
                // insert shared services after user services
                sal_Int32 nIndex = 0, nPos = 0;
                do
                {
                    OString token( val.getToken( 0, ' ', nIndex ).trim() );
                    if (token.getLength())
                    {
                        if (nPos)
                            buf.append( ' ' );
                        if (nPos == nUserServices)
                        {
                            buf.append( token ); // user services
                            buf.append( ' ' );
                            buf.append( RTL_CONSTASCII_STRINGPARAM(
                                            "?$" UNO_SHARED_PACKAGES_CACHE
                                            "/services.rdb ") );
                        }
                        else
                        {
                            buf.append( token );
                        }
                        ++nPos;
                    }
                }
                while (nIndex >= 0);
            }
            line = buf.makeStringAndClear();
        }
        
        else if ((nUserTypes < 0 || nSharedTypes < 0) &&
                 0 == rtl_str_shortenedCompare_WithLength(
                     line.getStr(), line.getLength(),
                     "UNO_TYPES=",
                     sizeof("UNO_TYPES=")-1, sizeof("UNO_TYPES=")-1 ))
        {
            // insert missing lines
            if (! to_be_added.empty())
            {
                for ( size_t nPos = 0; nPos < to_be_added.size(); ++nPos )
                    lines.push_back( to_be_added[ nPos ] );
                to_be_added.clear();
            }
            // merge in types
            OString val( line.copy( sizeof("UNO_TYPES=") -1 ) );
            OStringBuffer buf( 128 );
            buf.append( RTL_CONSTASCII_STRINGPARAM("UNO_TYPES=") );

            if (nUserTypes < 0) // no user types
            {
                buf.append( val );
                buf.append( ' ' );
                if (nSharedTypes < 0) // no shared types
                {
                    buf.append(
                        RTL_CONSTASCII_STRINGPARAM(
                            "?$" UNO_SHARED_PACKAGES_CACHE "/types.rdb ") );
                }
                buf.append(
                    RTL_CONSTASCII_STRINGPARAM(
                        "?$" UNO_USER_PACKAGES_CACHE "/types.rdb ") );
            }
            else // if (nSharedTypes < 0)
            {
                // insert shared types before user types
                sal_Int32 nIndex = 0, nPos = 0;
                do
                {
                    OString token( val.getToken( 0, ' ', nIndex ).trim() );
                    if (token.getLength())
                    {
                        if (nPos)
                            buf.append( ' ' );
                        if (nPos == nUserTypes)
                        {
                            buf.append( RTL_CONSTASCII_STRINGPARAM(
                                            "?$" UNO_SHARED_PACKAGES_CACHE
                                            "/types.rdb ") );
                        }
                        buf.append( token ); // user types
                        ++nPos;
                    }
                }
                while (nIndex >= 0);
            }
            line = buf.makeStringAndClear();
        }
            
        lines.push_back( line );
    }
    file.close();
    
    // write to unorc
    if (File::E_None != file.open( OpenFlag_Write ))
    {
        throw RuntimeException(
            OUSTR("cannot open ") + unorc_path + OUSTR(" for writing"),
            Reference< XInterface >() );
    }
    // remove any content
    if (file.setSize( 0 ) != File::E_None)
    {
        throw RuntimeException(
            OUSTR("cannot set file size of ") + unorc_path + OUSTR(" to 0"),
            Reference< XInterface >() );
    }
    
    for ( size_t n = 0; n < lines.size(); ++n )
    {
        OString const & line = lines[ n ];
        file_write( file, line, unorc_path );
        file_write( file, LF, unorc_path );
	}
    file.close();
    
    if (verbose)
    {
        OString str(
            OUStringToOString( unorc_path, osl_getThreadTextEncoding() ) );
        printf( "%s successfully patched.\n", str.getStr() );
    }
    
    // re-reading unorc
    rtl_bootstrap_args_close( *p_unorc );
    *p_unorc = rtl_bootstrap_args_open( unorc_path.pData );
    if (! *p_unorc)
    {
        throw RuntimeException(
            OUSTR("cannot open ") + unorc_path, Reference< XInterface >() );
    }
}

}
