/*************************************************************************
 *
 *  $RCSfile: parser.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if STLPORT_VERSION<321
#include <tools/presys.h>
#include <vector.h>
#include <tools/postsys.h>
#else
#include <vector>
#endif

#include <propset.hxx>
#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANCELLEDEXCEPTION_HXX_
#include <smart/com/sun/star/address/CancelledException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKSOURCEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookSourceDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTYVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredPropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPROPERTYPARAMETERINFO_HXX_
#include <smart/com/sun/star/address/AddressBookPropertyParameterInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XSYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XSynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENTTYPE_HXX_
#include <smart/com/sun/star/address/JobEventType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYFUNCTION_HXX_
#include <smart/com/sun/star/address/AddressBookQueryFunction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKSCHEMATASUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookSchemataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOB_HXX_
#include <smart/com/sun/star/address/XJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYPARSER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryParser.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASEFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKJOBFACTORYSUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookJobFactorySupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBLISTENER_HXX_
#include <smart/com/sun/star/address/XJobListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRECORDCONTAINER_HXX_
#include <smart/com/sun/star/address/XAddressBookRecordContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEFIELD_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableField.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYWRITER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryWriter.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENT_HXX_
#include <smart/com/sun/star/address/JobEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XASYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XAsynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTY_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredProperty.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASESCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYTERM_HXX_
#include <smart/com/sun/star/address/AddressBookQueryTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSORTINFO_HXX_
#include <smart/com/sun/star/address/AddressBookSortInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANTCONNECTEXCEPTION_HXX_
#include <smart/com/sun/star/address/CantConnectException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCOPE_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPScope.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRESULTSETDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/address/XAddressBookResultSetDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBFACTORY_HXX_
#include <smart/com/sun/star/address/XJobFactory.hxx>
#endif

void yyerror( const char* s )
{
}

static const sal_Unicode* pCurChar;
static AddressBookQueryTerm* pTerm = 0;

sal_Unicode getChar()
{
	return *pCurChar++;
}

int yylex();

void parseSubstrings( const sal_Unicode* pStr, vector<UString>& rStrings )
{
	vector<sal_Unicode> aCur;
	sal_Unicode aChar;
	while( aChar = *pStr++ )
	{
		if( aChar == L'\\' && *pStr == L'*' )
		{
			aCur.push_back( L'*' );
			continue;
		}
		if( aChar == L'*' )
		{
			sal_Unicode* pCur = new sal_Unicode[ aCur.size() + 1 ];
			pCur[ aCur.size() ] = 0;
			copy( aCur.begin(), aCur.end(), pCur );
			rStrings.push_back( UString( pCur ) );
			delete[] pCur;
			aCur.erase( aCur.begin(), aCur.end() );
		}
		else aCur.push_back( aChar );
	}
	sal_Unicode* pCur = new sal_Unicode[ aCur.size() + 1 ];
	pCur[ aCur.size() ] = 0;
	copy( aCur.begin(), aCur.end(), pCur );
	rStrings.push_back( UString( pCur ) );
	delete[] pCur;
}

//#define YYDEBUG 1
#include "rscyacc.yxx"

AddressBookQueryTerm* parseQuery( const UString& rQuery )
{
	pCurChar = (const sal_Unicode*)rQuery;
	if( !yyparse() ) return pTerm;
	else return 0;
}

int yylex()
{
//	yydebug = 1;
	vector<sal_Unicode> aToken;
	BOOL            bEscaping = FALSE;
	static BOOL     bInValue = FALSE;
	sal_Unicode         wChar;
	static sal_Unicode  wNextChar = 0;

	BOOL bWasInValue = bInValue;
	while( wChar = wNextChar ? wNextChar : getChar() )
	{
		wNextChar = 0;
		if( bEscaping ) 
		{
			bEscaping = FALSE;
			if(wChar == L'(' || wChar == L')' )
			{
				aToken.push_back( wChar );
				continue;
			}
		}
		switch( wChar )
		{
			case L'=': 
			case L'<':
			case L'>':
			case L'~':
			case L'&':
			case L'|':
			case L'*':
			case L'!':
			case L'(':
				if( !bInValue )
				{
					if( aToken.size() )
					{
						wNextChar = wChar;
						yylval.m_pString = new sal_Unicode[ aToken.size() + 1];
						copy( aToken.begin(), aToken.end(), yylval.m_pString );
						yylval.m_pString[ aToken.size() ] = 0;
						aToken.erase( aToken.begin(), aToken.end() );
						return attrib;
					}
					else 
					{
						if( wChar == L'=' ) bInValue = TRUE;
						return wChar;
					}
				}
				else aToken.push_back( wChar );
				break;
				
			case L')': bInValue = FALSE;
				if( aToken.size() )
				{
					yylval.m_pString = new sal_Unicode[ aToken.size() + 1];
					copy( aToken.begin(), aToken.end(), yylval.m_pString );
					yylval.m_pString[ aToken.size() ] = 0;
					bInValue = FALSE;
					aToken.erase( aToken.begin(), aToken.end() );
					wNextChar = wChar;
					return bWasInValue ? value : attrib;
				}
				else return wChar;
			default:
				aToken.push_back( wChar );
		}
	}
	if( aToken.size() )
	{
		yylval.m_pString = new sal_Unicode[ aToken.size() + 1];
		copy( aToken.begin(), aToken.end(), yylval.m_pString );
		yylval.m_pString[ aToken.size() ] = 0;
		aToken.erase( aToken.begin(), aToken.end() );
		return bWasInValue ? value : attrib;
	}
	return 0;
}


main()
{
	parseQuery( L"(&(objectClass=Person)(|(sn=Jensen)(cn=Babs J*)))" );
}

