/*
 * OOServiceCreateIterator.java
 *
 * Created on 26. Oktober 2001
 *
 */

package org.netbeans.modules.openoffice.wizard;

import java.awt.Component;

import javax.swing.event.ChangeListener;
import javax.swing.JComponent;

import java.io.IOException;

import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;

import org.netbeans.modules.openoffice.OOIDLGlobalSettings;
import org.netbeans.modules.openoffice.OOTools;
import org.netbeans.modules.openoffice.wizard.panels.service.OOServiceClassPanel;
import org.netbeans.modules.openoffice.wizard.panels.service.NewTypesPanel;
import org.netbeans.modules.openoffice.wizard.panels.service.ServiceSelectionPanel;
import org.netbeans.modules.openoffice.wizard.panels.service.LanguageSelectionPanel;

import org.openide.cookies.OpenCookie;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.NotifyDescriptor;
import org.openide.src.ClassElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.WizardDescriptor;

/**
 *
 * @author  Michael Bohn, Bertram Nolte
 *
 */


public class OOServiceCreateIterator implements TemplateWizard.Iterator {
    
    private static OOServiceCreateIterator instance;
    private transient OOServiceData myData;
    private MethodElement TypeMethode;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient TemplateWizard wiz;
    
    
    public static synchronized OOServiceCreateIterator singleton() {
        if(instance == null)
            instance = new OOServiceCreateIterator();
        return instance;
    }
    
    
    
    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[] {
            // Assuming you want to keep the default 2nd panel:
            wiz.targetChooser(),
            new OOServiceClassPanel(myData),
//            new NewTypesPanel(),
//            new ServiceSelectionPanel(),
//            new LanguageSelectionPanel()
            /* --> EDIT ME <--
            new MyPanel2 ()
             */
            
        };
    }
    
    // And the list of step names:
    
    protected String[] createSteps() {
        return new String[] {
            null,
            NbBundle.getMessage(OOServiceCreateIterator.class, "LBL_step_1"),
//            NbBundle.getMessage(OOServiceCreateIterator.class, "LBL_step_2"),
//            NbBundle.getMessage(OOServiceCreateIterator.class, "LBL_step_3"),
//            NbBundle.getMessage(OOServiceCreateIterator.class, "LBL_step_4")
            /* --> EDIT ME <--
            NbBundle.getMessage (OOServiceCreateIterator.class, "LBL_step_2")
             */
        };
    }
    
    
    public Set instantiate(TemplateWizard wiz) throws IOException/*, IllegalStateException*/ {
        String name = wiz.getTargetName();
        DataFolder targetFolder = wiz.getTargetFolder();
        DataObject template = wiz.getTemplate();
        DataObject result;
        
        if (name == null) {
            result = template.createFromTemplate(targetFolder);
        } else {
            result = template.createFromTemplate(targetFolder, name);
        }
        
        SourceCookie sourcecookie = (SourceCookie)result.getCookie(SourceCookie.class);
        if(sourcecookie == null) {
            //what should we do if the template does not contain a class
            return Collections.singleton(result);
        }
        //here we get the outer class
        ClassElement aclasselement[] = sourcecookie.getSource().getClasses();
        try {
            
            sourcecookie.getSource().addImports(myData.getImports());
            sourcecookie.getSource().removeClass(aclasselement[0]);
            sourcecookie.getSource().addClass(myData.getOuterClass());
            
            // Create a manifest.
            OOTools.writeManifest(
            targetFolder.getPrimaryFile().getFileSystem().getSystemName(),
            myData.getPackage()
            + ( ( myData.getPackage().equals( "" ) ) ? ( "" ) : ( "." ) )
            + myData.getClassName() );
            
            // Create Basic code for registering the service in the office.
            OOTools.writeBasicCode(
            targetFolder.getPrimaryFile().getFileSystem().getSystemName(),
            myData.getServiceName(),
            myData.getClassName() );
            
            //            TopManager.getDefault().notify(
            //            new NotifyDescriptor.Message(
            //            "Start creating the jar content..." ) );
            
            // Create jar content with necessary files.
            OOTools.createJarContent( myData,
            targetFolder.getPrimaryFile().getFileSystem().getSystemName(),
            targetFolder.getPrimaryFile().getFileSystem() );
            
            //            TopManager.getDefault().notify(
            //            new NotifyDescriptor.Message(
            //            "Finished creating the jar content." ) );
            
            // Create a ANT build file for the component.
            OOTools.writeANTFile( myData,
            targetFolder.getPrimaryFile().getFileSystem().getSystemName() );
        }
        catch(SourceException sourceexception) {
            result.delete();
            throw new IOException(sourceexception.getLocalizedMessage());
        }
        OpenCookie open = (OpenCookie) result.getCookie(OpenCookie.class);
        if (open != null) {
            open.open();
        }
        OOTools.installFiles( 
        OOIDLGlobalSettings.getDefault().getSDKDirectory(),
        OOIDLGlobalSettings.getDefault().getOfficeDirectory() );
        return Collections.singleton(result);
    }
    
    
    public void initialize(TemplateWizard wiz) {
        this.wiz = wiz;
        myData = new OOServiceData();
        index = 0;
        panels = createPanels();
        String[] steps = createSteps();
        for (int i = 0; i < panels.length; i++) {
            Component c = panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (c instanceof JComponent) { // assume Swing components
                JComponent jc = (JComponent) c;
                // Step #.
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i)); // NOI18N
                // Step name (actually the whole list for reference).
                jc.putClientProperty("WizardPanel_contentData", steps); // NOI18N
            }
        }
    }
    
    public void uninitialize(TemplateWizard wiz) {
        this.wiz = null;
        panels = null;
        myData = null;
    }
    
    public String name() {
        return NbBundle.getMessage(OOServiceCreateIterator.class, "TITLE_x_of_y",
        new Integer(index + 1), new Integer(panels.length));
    }
    
    public boolean hasNext() {
        return index < panels.length - 1;
    }
    
    public boolean hasPrevious() {
        return index > 0;
    }
    
    public void nextPanel() {
        if (! hasNext()) throw new NoSuchElementException();
        index++;
    }
    
    public void previousPanel() {
        if (! hasPrevious()) throw new NoSuchElementException();
        index--;
    }
    
    public org.openide.WizardDescriptor$Panel current() {
        return panels[index];
    }
    
    public final void addChangeListener(ChangeListener l) {}
    public final void removeChangeListener(ChangeListener l) {}
    
    
}
