# // generiert aus der GECAP Resource ein File entsprechend scfkenus.src,
# // allerdings ohne Zeilen zusammenzufuegen
# // sofern GECAP keine Blanks in [xxx] haut oder so..
# // Format muss sein: "Text [xxx] = "
BEGIN {
	badexit = 0
	syntax = "gawk -f regensrc.awk generate.src Language-ID outfile.src"
	if ( ARGC < 3 )
	{
		print "Syntax: " syntax
		print "z.B.: gawk -f regensrc.awk generate.src english_us g_enus.src"
		badexit = 1
		exit
	}
	outf = ARGV[ARGC-1]
	--ARGC
	lang = toupper(ARGV[ARGC-1])
	--ARGC
	DoesContinue = 0
	Search = "Text \\[" lang "\\] = "
	SearchOthers = "Text \\[.+\\] = "
	printf("") >outf
	print "// " syntax >>outf
	print "// from GECAP translation generated resource file" >>outf
	print "// Language-ID: " lang >>outf
	printf("\n") >>outf
}

{
	if ( DoesContinue )
	{									# // Fortsetzung der vorherigen Zeile
		if ( IsMyLang )
			print >>outf
		if ( substr( $NF, length( $NF ), 1 ) == ";" )
			DoesContinue = 0
	}
	else if ( $1 " " toupper($2) " " $3 " " ~ Search )
	{									# // gesuchte Sprache gefunden
		IsMyLang = 1
		$2 = toupper($2)
		sub( Search, "" )
		print >>outf
		if ( substr( $NF, length( $NF ), 1 ) != ";" )
			DoesContinue = 1
	}
	else if ( $1 " " $2 " " $3 " " ~ SearchOthers )
	{									# // andere Sprachen uninteressant
		IsMyLang = 0
		if ( substr( $NF, length( $NF ), 1 ) != ";" )
			DoesContinue = 1
	}
	else
	{									# // alles andere rausschreiben
		print >>outf
	}
}

END {
	exit(badexit)
}

