/*************************************************************************
 *
 *  $RCSfile: sihelp.cxx,v $
 *
 *  $Revision: 1.36 $
 *
 *  last change: $Author: vg $ $Date: 2003/06/12 09:55:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _REGISTRY_REGISTRY_HXX_
#include <registry/registry.hxx>
#endif

#ifndef _VOS_SECURITY_HXX_
#include <vos/security.hxx>
#endif
#ifndef _VOS_PIPE_HXX_
#include <vos/pipe.hxx>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif
#ifndef _CPPUHELPER_BOOTSTRAP_HXX_
#include <cppuhelper/bootstrap.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XIMPLEMENTATIONREGISTRATION_HPP_
#include <com/sun/star/registry/XImplementationRegistration.hpp>
#endif
#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _RTL_DIGEST_H_
#include <rtl/digest.h>
#endif

#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif

#include <rtl/ustring.hxx>

using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;

#include "action.hxx"
#include "script.hxx"
#include "decltor.hxx"
#include "environ.hxx"
#include "os.hxx"
#include "sistream.hxx"
#include "fields.hxx"
#include "zipfile.hxx"

#include "sihelp.hxx"
#include "pages.hrc"

RegistryLoader* static_pRegLoader = NULL;

SiHelpImpl* SiHelp::pHelpImpl = NULL;

struct SiHelpImpl
{
	Reference< XMultiServiceFactory >			xSMgr;
	Reference< XSimpleRegistry >				xReg;
	Reference< XImplementationRegistration >	xImplRegistration;

	SiHelpImpl()
	{
		xSMgr = Reference< XMultiServiceFactory >(::cppu::createServiceFactory());
		if( !xSMgr.is() ) return;

		::rtl::OUString aService(UniString::CreateFromAscii("com.sun.star.registry.SimpleRegistry"));
		xReg = Reference< XSimpleRegistry >(
				xSMgr->createInstance(aService), UNO_QUERY);
		if( !xReg.is() ) return;

		aService = UniString::CreateFromAscii("com.sun.star.registry.ImplementationRegistration");
		xImplRegistration = Reference< XImplementationRegistration >(
				xSMgr->createInstance(aService), UNO_QUERY);
	}

	~SiHelpImpl()
	{
        // try to dispose component context
        Reference< beans::XPropertySet > xProps( xSMgr, UNO_QUERY );
        if (xProps.is())
        {
            try
            {
                Reference< lang::XComponent > xComp;
                if (xProps->getPropertyValue( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("DefaultContext") ) ) >>= xComp)
                {
                    xComp->dispose();
                }
            }
            catch (beans::UnknownPropertyException &)
            {
            }
        }
	}
};
// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
//	UI-Pages Name <--> ResId zuordnung

struct _UiPage {
	char	cPageName[50];
	USHORT	nId;
};

#define MAX_PAGES 38

static const _UiPage aUiPages[MAX_PAGES] = {
	{ "PAGE_WELCOME",				RESID_PAGE_PAGEWELCOME 					},
	{ "PAGE_LICENSE",				RESID_PAGE_PAGELICENSE 					},
	{ "PAGE_SERIALNUMBER",			RESID_PAGE_PAGESERIALNUMBER 			},
	{ "PAGE_INSTALLMODE",			RESID_PAGE_PAGEINSTALLMODE 				},
	{ "PAGE_INSTPATH",				RESID_PAGE_PAGEINSTPATH 				},
	{ "PAGE_USERDEFINED",			RESID_PAGE_PAGEUSERDEFINED 				},
	{ "PAGE_READYGO",				RESID_PAGE_PAGEREADYGO 					},
	{ "PAGE_README",				RESID_PAGE_PAGEREADME 					},
	{ "PAGE_ADDRESS",				RESID_PAGE_PAGEADDRESS 					},
	{ "PAGE_HAVEFUN",				RESID_PAGE_PAGEHAVEFUN 					},
	{ "PAGE_WRONGSETUP",			RESID_PAGE_PAGEWRONGSETUP 				},
	{ "PAGE_REINSTALLATION",		RESID_PAGE_PAGEREINSTALLATION 			},
	{ "PAGE_UNINSTALL",				RESID_PAGE_PAGEUNINSTALL 				},
	{ "PAGE_RECOVER",				RESID_PAGE_PAGERECOVER 					},
	{ "PAGE_TOPLEVEL",				RESID_PAGE_PAGETOPLEVEL 				},
	{ "PAGE_CRCCHECK",				RESID_PAGE_PAGECRCCHECK 				},
	{ "PAGE_LANGUAGE",				RESID_PAGE_PAGELANGUAGE 				},
	{ "PAGE_UPDATEINSTALL",		 	RESID_PAGE_PAGEUPDATEINSTALL			},
	{ "PAGE_ASRV_REINSTALLATION",	RESID_PAGE_PAGEASRV_REINSTALLATION		},
	{ "PAGE_ASRV_UNINSTALL",		RESID_PAGE_PAGETOPLEVEL 				},
	{ "PAGE_TOPLEVEL",				RESID_PAGE_PAGEASRV_UNINSTALL 			},
	{ "PAGE_ASRV_START",			RESID_PAGE_PAGEASRV_START 				},
	{ "PAGE_ASRV_USERNAME",			RESID_PAGE_PAGEASRV_USERNAME 			},
	{ "PAGE_ASRV_USERPATH",			RESID_PAGE_PAGEASRV_USERPATH 			},
	{ "PAGE_ASRV_SERVERPATH",		RESID_PAGE_PAGEASRV_SERVERPATH 			},
	{ "PAGE_ASRV_REMEMBER",			RESID_PAGE_PAGEASRV_REMEMBER 			},
	{ "PAGE_ASRV_START",			RESID_PAGE_PAGEASRV_START 				},
	{ "PAGE_USERREGISTRATION",		RESID_PAGE_PAGEUSERREGISTRATION 		},
	{ "PAGE_WARNADDRESS",			RESID_PAGE_PAGEWARNADDRESS		 		},
	{ "PAGE_REPAIR",				RESID_PAGE_PAGEREPAIR		   			},
	{ "PAGE_PAGESCRIPTNOTFOUND",	RESID_PAGE_PAGESCRIPTNOTFOUND			},
	{ "PAGE_MIGRATION",				RESID_PAGE_PAGEMIGRATION				},
	{ "PAGE_PROFILE",				RESID_PAGE_PAGEPROFILE				    },
	{ "PAGE_CONFIGSERVER",			RESID_PAGE_PAGECONFIGSERVER				},
	{ "PAGE_RSPWIZARD",				RESID_PAGE_PAGERSPWIZARD				},
	{ "PAGE_MODULES",				RESID_PAGE_PAGEMODULES				    },
	{ "PAGE_ASRV_SERVEREXISTS",		RESID_PAGE_PAGEASRV_SERVEREXISTS		},
	{ "PAGE_PATCH",				    RESID_PAGE_PATCH				        },
};

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
//		ISO 3166 - Country Codes

struct _CountryCode {
	char	iso2Digit[3];
	char	iso3Digit[4];
};

#define MAX_COUNTRYS 122

static const _CountryCode CountryCode[MAX_COUNTRYS] = {
	/* AEGYPTEN 1 */							{ "EG",	"EGY" },
	/* ALBANIEN 2 */							{ "AL",	"ALB" },
	/* ALGERIEN 3 */                            { "DZ", "DZA" },
	/* ANDORRA 4 */                             { "AD", "AND" },
	/* ANTIGUA_UND_BARBUDA 5 */                 { "AG", "ATG" },
	/* ARGENTINIEN 6 */                         { "AR", "ARG" },
	/* ARMENIEN 7 */                            { "AM", "ARM" },
	/* AUSTRALIEN 8 */                          { "AU", "AUS" },
	/* BAHAMAS 9 */                             { "BS", "BHS" },
	/* BARBADOS 10 */                           { "BB", "BRB" },
	/* BELGIEN 11 */                            { "BE", "BEL" },
	/* BERMUDA 12 */                            { "BM", "BMU" },
	/* BOLIVIEN 13 */                           { "BO", "BOL" },
	/* BOSNIENHERZEGOWINA 14 */                 { "BA", "BIH" },
	/* BRASILIEN 15 */                          { "BR", "BRA" },
	/* BULGARIEN 16 */                          { "BG", "BGR" },
	/* BUNDESREPUBLIK_DEUTSCHLAND 17 */         { "DE", "DEU" },
	/* CHILE 18 */                              { "CL", "CHL" },
	/* CHINA 19 */                              { "CN", "CHN" },
	/* COSTA_RICA 21 */                         { "CR", "CRI" },
	/* DOMINIKANISCHE_REPUBLIK 22 */            { "DO", "DOM" },
	/* DAENEMARK 23 */                          { "DK", "DNK" },
	/* ECUADOR 24 */                            { "EC", "ECU" },
	/* EL_SALVADOR 25 */                        { "SV", "SLV" },
	/* ELFENBEINKUESTE 26 */                    { "CI", "CIV" },
	/* ESTLAND 27 */                            { "EE", "EST" },
	/* FINNLAND 28 */                           { "FI", "FIN" },
	/* FRANKREICH 29 */                         { "FR", "FRA" },
	/* FAEROEER 30 */                           { "FO", "FRO" },
	/* FUERSTENTUM_LIECHTENSTEIN 31 */          { "LI", "LIE" },
	/* GEMEINSCHAFT_UNABHAENGIGER_STAATEN 32 */ { "", "" },
	/* GEORGIEN 33 */                           { "GE", "GEO" },
	/* GRENADA 34 */                            { "GD", "GRD" },
	/* GRIECHENLAND 35 */                       { "GR", "GRC" },
	/* GROSSBRITANNIEN 36 */                    { "GB", "GBR" },
	/* GUADELOUPE 37 */                         { "GP", "GLP" },
	/* GUATEMALA 38 */                          { "GT", "GTM" },
	/* GUYANA 39 */                             { "GY", "GUY" },
	/* HAITI 40 */                              { "HT", "HTI" },
	/* HONDURAS 41 */                           { "HN", "HND" },
	/* HONGKONG 42 */                           { "HK", "HKG" },
	/* INDIEN 43 */                             { "IN", "IND" },
	/* INDONESIEN 44 */                         { "ID", "IDN" },
	/* IRAN 45 */                               { "IQ", "IRQ" },
	/* IRLAND 46 */                             { "IE", "IRL" },
	/* ISLAND 47 */                             { "IS", "ISL" },
	/* ISRAEL 48 */                             { "IL", "ISR" },
	/* ITALIEN 49 */                            { "IT", "ITA" },
	/* JAMAIKA_BRITISCHE_ANTILLEN 50 */         { "JM", "JAM" },
	/* JAPAN 51 */                              { "JP", "JPN" },
	/* JORDANIEN 52 */                          { "JO", "JOR" },
	/* JUGOSLAVIEN 53 */                        { "YU", "YUG" },
	/* KAIMANINSELN 54 */                       { "KY", "CYM" },
	/* KAMERUN 55 */                            { "CM", "CMR" },
	/* KANADA 56 */                             { "CA", "CAN" },
	/* KOLUMBIEN 57 */                          { "CO", "COL" },
	/* KROATIEN 58 */                           { "HR", "HRV" },
	/* KUBA 59 */                               { "CU", "CUB" },
	/* KUWAIT 60 */                             { "KW", "KWT" },
	/* LIBANON 61 */                            { "LY", "LBY" },
	/* LITAUEN 62 */                            { "LT", "LTU" },
	/* LUXEMBURG 63 */                          { "LU", "LUX" },
	/* MALAYSIA 64 */                           { "MY", "MYS" },
	/* MALTA 65 */                              { "MT", "MLT" },
	/* MAROKKO 66 */                            { "MA", "MAR" },
	/* MAURITIUS 67 */                          { "MU", "MUS" },
	/* MAZEDONIEN 68 */                         { "MK", "MKD" },
	/* MEXIKO 69 */                             { "MX", "MEX" },
	/* MONACO 70 */                             { "MC", "MCO" },
	/* NAMIBIA 71 */                            { "NA", "NAM" },
	/* NEPAL 72 */                              { "NP", "NAM" },
	/* NEUSEELAND 73 */                         { "NZ", "NZL" },
	/* NICARAGUA 74 */                          { "NI", "NIC" },
	/* NIEDERLANDE 75 */                        { "NL", "NLD" },
	/* NIEDERLAENDISCHE_ANTILLEN_CURACAO 76 */  { "AN", "ANT" },
	/* NIGERIA 77 */                            { "NG", "NGA" },
	/* NORWEGEN 78 */                           { "NO", "NOR" },
	/* OESTERREICH 79 */                        { "AT", "AUT" },
	/* PAKISTAN 80 */                           { "PK", "PAK" },
	/* PANAMA 81 */                             { "PA", "PAN" },
	/* PAPUANEUGUINEA 82 */                     { "PG", "PNG" },
	/* PARAGUAY 83 */                           { "PY", "PRY" },
	/* PERU 84 */                               { "PE", "PER" },
	/* PHILIPPINEN 85 */                        { "PH", "PHL" },
	/* POLEN 86 */                              { "PL", "POL" },
	/* PORTUGAL 87 */                           { "PT", "PRT" },
	/* PUERTO_RICO 88 */                        { "PR", "PRI" },
	/* REPUBLIK_KASACHSTAN 89 */                { "KZ", "KAZ" },
	/* REPUBLIK_LETTLAND 90 */                  { "LV", "LVA" },
	/* REPUBLIK_MOLDAWIEN 91 */                 { "MD", "MDA" },
	/* REPUBLIK_SUEDAFRIKA 92 */                { "ZA", "ZAF" },
	/* REPUBLIK_USBEKISTAN 93 */                { "UZ", "UZB" },
	/* REPUBLIK_WEISSRUSSLAND 94 */             { "BY", "BLR" },
	/* REPUBLIK_ZENTRALAFRIKA 95 */             { "CF", "CAF" },
	/* RUMAENIEN 96 */                          { "RO", "ROM" },
	/* RUSSISCHE_FOEDERATION 97 */              { "RU", "RUS" },
	/* SAUDI_ARABIEN 98 */                      { "SA", "SAU" },
	/* SCHWEDEN 99 */                           { "SE", "SWE" },
	/* SCHWEIZ 100 */                           { "CH", "CHE" },
	/* SINGAPUR 101 */                          { "SG", "SGP" },
	/* SLOWAKEI 102 */                          { "SK", "SVK" },
	/* SLOWENIEN 103 */                         { "SI", "SVN" },
	/* SPANIEN 104 */                           { "ES", "ESP" },
	/* SRI_LANKA 105 */                         { "LK", "LKA" },
	/* SWASILAND 106 */                         { "SZ", "SWZ" },
	/* SUED_KOREA_REPUBLIK 107 */               { "KR", "KOR" },
	/* TADSCHIKISTAN 108 */                     { "TJ", "TJK" },
	/* TAIWAN_REPUBLIK_CHINA 109 */             { "TW", "TWN" },
	/* THAILAND 110 */                          { "TH", "THA" },
	/* TRINIDAD_UND_TOBAGO 111 */               { "TT", "TTO" },
	/* TSCHECHIEN 112 */                        { "CZ", "CZE" },
	/* TUNESIEN 113 */                          { "TN", "TUN" },
	/* TURKMENISTAN 114 */                      { "TM", "TKM" },
	/* TUERKEI 115 */                           { "TR", "TUR" },
	/* UKRAINE 116 */                           { "UA", "UKR" },
	/* UNGARN 117 */                            { "HU", "HUN" },
	/* URUGUAY 118 */                           { "UY", "URY" },
	/* VENEZUELA 119 */                         { "VE", "VEN" },
	/* VEREINIGTE_ARABISCHE_EMIRATE 120 */      { "AE", "ARE" },
	/* VEREINIGTE_STAATEN_VON_AMERIKA 121 */    { "US", "USA" },
	/* VIETNAM 122 */                           { "VN", "VNM" },
	/* ZYPERN 123 */                            { "CY", "CYP" }
};

// ----------------------------------------------------------------------
// GetUIPageIdByName

USHORT SiHelp::GetUIPageIdByName(const ByteString& rName)
{
    BOOL        bIsWorkstation = FALSE;
    BOOL        bIsNetwork = FALSE;
    USHORT      nIndex = 0;
    xub_StrLen  nLen = rName.Len(); 

    if ( nLen >= 4 )
    {
        ByteString aEnd = rName.Copy( nLen - 4 );
        if ( aEnd.CompareIgnoreCaseToAscii( "_WKS" ) == COMPARE_EQUAL )
        {
            bIsWorkstation = TRUE;
            nLen -= 4;
        }
        else if ( aEnd.CompareIgnoreCaseToAscii( "_NET" ) == COMPARE_EQUAL )
        {
            bIsNetwork = TRUE;
            nLen -= 4;
        }
    }

    if ( nLen )
    {
        for( USHORT i = 0; i < MAX_PAGES; ++i )
        {
            if( rName.CompareIgnoreCaseToAscii(aUiPages[i].cPageName, nLen) == COMPARE_EQUAL )
            {
                nIndex = aUiPages[i].nId;
                break;
            }
        }
    }

    if ( nIndex )
    {
        if ( bIsWorkstation )
            nIndex += WKS_OFFSET;
        else if ( bIsNetwork )
            nIndex += NET_OFFSET;
    }

    return nIndex;
}

// ----------------------------------------------------------------------
// GetUIPageByteStringById

ByteString SiHelp::GetUIPageByteStringById(USHORT nId)
{
	ByteString aRet;
    BOOL bIsWorkstation = FALSE;
    BOOL bIsNetwork = FALSE;

	if ( nId > RC_AGENTDLG_END + WKS_OFFSET )
    {
        nId -= NET_OFFSET;
        bIsNetwork = TRUE;
    }
    else if ( nId > RC_AGENTDLG_END )
    {
        nId -= WKS_OFFSET;
        bIsWorkstation = TRUE;
    }

    DBG_ASSERT( nId < RC_AGENTDLG_END, "Wrong ID in SiHelp::GetUIPageByteStringById() ?" );

    for( USHORT i = 0; i < MAX_PAGES; ++i )
    {
		if( nId == aUiPages[i].nId )
        {
			aRet = aUiPages[i].cPageName;
            break;
        }
    }

    if ( bIsNetwork )
        aRet += "_NET";
    else if ( bIsWorkstation )
        aRet += "_WKS";

	return aRet;
}

// -----------------------------------------------------------------------------
namespace
{
	OUString getFileURLFromSystemPathAsOUString(ByteString const& _sFilePath)
	{
		// #90348#
		// if we start with file:// it could be a file url instead of a system path.

		OUString sBack;

		UniString suFilePath(_sFilePath, osl_getThreadTextEncoding());
		rtl::OUString suFilePathAsOUString(suFilePath);
		rtl::OUString suFileURL;
		if (osl_File_E_None == osl::FileBase::getFileURLFromSystemPath( suFilePathAsOUString, suFileURL ))
		{
			// if conversion is done, it was a system path and it's now a file url
			sBack = suFileURL;
		}
		else
		{
			// conversion failed, we assume, it's already a file url
			sBack = UniString(_sFilePath, osl_getThreadTextEncoding());
		}
		return sBack;
	}

	// -----------------------------------------------------------------------------
	ByteString getFileURLFromSystemPath(ByteString const& _sFilePath)
	{
		UniString aFileURL(getFileURLFromSystemPathAsOUString(_sFilePath));
		return ByteString(aFileURL, osl_getThreadTextEncoding());
	}

	// -----------------------------------------------------------------------------
	ByteString convertSiDirEntryToByteString(SiDirEntry const& _aDirEntry)
	{
		return _aDirEntry.GetFull().GetBuffer();
	}
	// -----------------------------------------------------------------------------
	OUString convertSiDirEntryToOUString(SiDirEntry const& _aDirEntry)
	{
		return OStringToOUString(_aDirEntry.GetFull().GetBuffer(), osl_getThreadTextEncoding());
	}
}

// ----------------------------------------------------------------------
// FindInstallation
ByteString SiHelp::FindInstallation( SiProfileItem const* pItem, ByteString const& aKey )
{
	SiDirEntry anIniPath( pItem->GetProfile()->GetDirectory()->GetName() );
	anIniPath += pItem->GetProfile()->GetName();

	Config anIni( anIniPath.GetFullUni() );
	anIni.SetGroup( pItem->GetSection() );

	ByteString aValue = anIni.ReadKey(aKey.Len() != 0 ? aKey : pItem->GetKey());

#if defined(WNT) || defined(OS2)
	if( !aValue.Len() )
	{
		anIniPath = OS::GetGUIPath();
		anIniPath += pItem->GetProfile()->GetName();

		Config aSystemCfg( anIniPath.GetFullUni() );
		aSystemCfg.SetGroup( pItem->GetSection() );
		aValue = aSystemCfg.ReadKey(aKey.Len() != 0 ? aKey : pItem->GetKey());
	}
#endif

	if( aValue.Len() )
	{
		aValue = getFileURLFromSystemPath(aValue);

		SiDirEntry aDir = aValue;
		if( !aDir.Exists() )
			aValue.Erase();
	}
	return aValue;
}

// ----------------------------------------------------------------------
// FindModuleSetByName

SiModuleSet* SiHelp::FindModuleSetByName(SiEnvironment* pEnv, const ByteString& rName)
{
	SiModuleSet* pReturn = NULL;
	SiModuleSetList& rLst = pEnv->GetModuleSetList();
	for( USHORT i = 0; i < rLst.Count(); ++i )
		if( rLst.GetObject(i)->Name().CompareIgnoreCaseToAscii(rName) == COMPARE_EQUAL )
			return rLst.GetObject(i);
	return NULL;
}

// ----------------------------------------------------------------------
// FindModuleByName

SiModule* SiHelp::FindModuleByID(SiModule* pRoot, const ByteString& rID)
{
	if( pRoot->GetID().CompareIgnoreCaseToAscii(rID) == COMPARE_EQUAL )
		return pRoot;

	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		SiModule* pReturn = FindModuleByID( pModuleList->GetObject(x), rID );
		if( pReturn )
			return pReturn;
	}
	return NULL;
}

SiModule* SiHelp::FindModuleByName(SiModule* pRoot, const ByteString& rName, const ByteString* pParentName)
{
	if( pRoot->GetName().CompareIgnoreCaseToAscii(rName) == COMPARE_EQUAL )
		if( !pParentName )
			return pRoot;
		else
		if( pRoot->GetParent() &&
			pRoot->GetParent()->GetName().CompareIgnoreCaseToAscii(*pParentName) == COMPARE_EQUAL )
			return pRoot;

	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		SiModule* pReturn = FindModuleByName( pModuleList->GetObject(x), rName, pParentName );
		if( pReturn )
			return pReturn;
	}
	return NULL;
}

// ----------------------------------------------------------------------
// FindModuleByFileName

SiModule* SiHelp::FindModuleByFileName(SiModule* pRoot, const ByteString& rFileName)
{
	const SiFileList& rFLst = pRoot->GetFileList();
	for( USHORT i = 0; i < rFLst.Count(); ++i )
	{
		SiFile* pFile = rFLst.GetObject(i);
		if( pFile->GetName().CompareIgnoreCaseToAscii(rFileName) == COMPARE_EQUAL )
			return pRoot;
	}

	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		SiModule* pReturn = FindModuleByFileName( pModuleList->GetObject(x), rFileName );
		if( pReturn )
			return pReturn;
	}
	return NULL;
}

// ----------------------------------------------------------------------
// FindDirectoryByName

SiDirectory* SiHelp::FindDirectoryByName(SiModule* pRoot, const ByteString& rName)
{
	const SiDirList& rLst = pRoot->GetDirList();
	for( USHORT i = 0; i < rLst.Count(); ++i )
	{
		SiDirectory* pDir = rLst.GetObject(i);
		if( pDir->GetSingleName().CompareIgnoreCaseToAscii(rName) == COMPARE_EQUAL )
			return pDir;
	}

	// Dir haengt event. an einem File
	const SiFileList& rFLst = pRoot->GetFileList();
	for( USHORT n = 0; n < rFLst.Count(); ++n )
	{
		SiDirectory* pDir = (SiDirectory*) (rFLst.GetObject(n)->GetDirectory());
		if( pDir->GetSingleName().CompareIgnoreCaseToAscii(rName) == COMPARE_EQUAL )
			return pDir;
	}

	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		SiDirectory* pReturn = FindDirectoryByName( pModuleList->GetObject(x), rName );
		if( pReturn )
			return pReturn;
	}
	return NULL;
}

// ----------------------------------------------------------------------
// FindFileByName

SiFile* SiHelp::FindFileByName(SiModule* pRoot, const ByteString& rName)
{
	const SiFileList& rFLst = pRoot->GetFileList();
	for( USHORT n = 0; n < rFLst.Count(); ++n )
	{
		SiFile* pFile = (SiFile*) rFLst.GetObject(n);
		if( pFile->GetName().CompareIgnoreCaseToAscii(rName) == COMPARE_EQUAL )
			return pFile;
	}

	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		SiFile* pReturn = FindFileByName( pModuleList->GetObject(x), rName );
		if( pReturn )
			return pReturn;
	}
	return NULL;
}

// ----------------------------------------------------------------------
// FindRegistryByName

SiStarRegistry* SiHelp::FindRegistryByName(SiModule* pRoot, const ByteString& rName)
{
	const SiStarRegistryItemList& rRLst = pRoot->GetStarRegistryItemList();
	for( USHORT n = 0; n < rRLst.Count(); ++n )
	{
		SiStarRegistry* pReg = rRLst.GetObject(n)->GetRegistry();
		if( pReg->GetName() == rName )
			return pReg;
	}

	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		SiStarRegistry* pReturn = FindRegistryByName( pModuleList->GetObject(x), rName );
		if( pReturn )
			return pReturn;
	}
	return NULL;
}

// ----------------------------------------------------------------------
// GetSelectedModuleCount

USHORT SiHelp::GetSelectedModuleCount( SiModule* pRoot )
{
	USHORT nReturn = 0;
	const SiModuleList* pModuleList = pRoot->GetModuleList();
	USHORT nCnt = (USHORT)pModuleList->Count();

	if( !nCnt &&
		(pRoot->IsInstalled() || pRoot->IsSelected()) &&
		!(pRoot->IsInstalled() && pRoot->IsSelected()) )
		nReturn += 1;

	for( USHORT x = 0; x < (ULONG)nCnt; ++x )
		nReturn += GetSelectedModuleCount( pModuleList->GetObject(x) );

	return nReturn;
}

// ----------------------------------------------------------------------
// SelectAllDontSelectByUser

void SiHelp::SelectAllDontSelectByUser( SiModule* pMod )
{
	const SiModuleList* pModuleList = pMod->GetModuleList();
	ULONG nCnt = pModuleList->Count();

	if( !nCnt && pMod->DontSelectByUser() )
		pMod->Select( SiModule::THIS_SEL );

	for( ULONG x = 0; x < nCnt; ++x )
		SelectAllDontSelectByUser( pModuleList->GetObject(x) );
}

// ----------------------------------------------------------------------
// TransferSelection

void SiHelp::TransferSelection( SiModule* pSrc, SiModule* pDest )
{
	const SiModuleList* pModuleList = pSrc->GetModuleList();
	ULONG nCnt = pModuleList->Count();
	if( !nCnt && pSrc->IsInstalled() || pSrc->IsSelected() )
	{
        SiModule* pFnd = FindModuleByID(pDest, pSrc->GetID() );

#ifdef DBG_UTIL
		SiModule* pTest = FindModuleByName( pDest, pSrc->GetName(), pSrc->GetParent()?
                                     &(pSrc->GetParent()->GetName()) : NULL );
        if ( pTest && ( pTest != pFnd ) )
        {
            DBG_ERRORFILE( "Find mismatch in TransferSelection!" );
        }
#endif
        if( pFnd )
            pFnd->Select( SiModule::THIS_SEL );
	}

	for( ULONG x = 0; x < nCnt; ++x )
		TransferSelection( pModuleList->GetObject(x), pDest );
}

// ----------------------------------------------------------------------
// SelectNewAdded : This function selects all modules in pNew that are
//                  not part of pOld

void SiHelp::SelectNewAdded( SiModule* pNew, SiModule* pOld )
{
    const SiModuleList* pModuleList = pNew->GetModuleList();
    ULONG nCnt = pModuleList->Count();

    if( nCnt )
    {
        for( ULONG x = 0; x < nCnt; ++x )
            SelectNewAdded( pModuleList->GetObject(x), pOld );
    }
    else
    {
        SiModule* pFnd = FindModuleByID( pOld, pNew->GetID() );

        if( !pFnd && pNew->IsDefault() )
            pNew->Select( SiModule::THIS_SEL );
	}
}

// ----------------------------------------------------------------------
// CountInstalledRefs

USHORT SiHelp::CountInstalledRefs(SiModule* pRoot, const ByteString& rFileName)
{
	USHORT nReturn = 0;

	if( pRoot->IsInstalled() )
	{
		const SiFileList& rFLst = pRoot->GetFileList();
		for( USHORT i = 0; i < rFLst.Count(); ++i )
		{
			SiFile* pFile = rFLst.GetObject(i);
			if( pFile->GetName().CompareIgnoreCaseToAscii(rFileName) == COMPARE_EQUAL )
				nReturn += 1;
		}
	}

	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		nReturn += CountInstalledRefs( pModuleList->GetObject(x), rFileName );
	}

	return nReturn;
}

// ----------------------------------------------------------------------
// CountAllFiles

ULONG SiHelp::CountAllFiles(SiModule* pRoot)
{
	ULONG nReturn = pRoot->GetFileList().Count();
	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( ULONG x = 0; x < pModuleList->Count(); ++x )
		nReturn += CountAllFiles( pModuleList->GetObject(x) );
	return nReturn;
}

// ----------------------------------------------------------------------
// Get all Files, which have a spezial style
/*
void SiHelp::GetAllFilesWithStyleScpzipReplace(SiModule* pRoot, rtl::OUString& _suFiles)
{
	const SiFileList& rFLst = pRoot->GetFileList();
	for( USHORT i = 0; i < rFLst.Count(); ++i )
	{
		SiFile* pFile = rFLst.GetObject(i);
		if (pFile->IsScpzipReplace())
		{
			if (_suFiles.getLength() > 0)
			{
				_suFiles += rtl::OUString::createFromAscii(",");
			}
			_suFiles += rtl::OStringToOUString(pFile->GetName(), osl_getThreadTextEncoding());
		}
	}

	const SiModuleList* pModuleList = pRoot->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
	{
		GetAllFilesWithStyleScpzipReplace( pModuleList->GetObject(x), _suFiles );
	}
}
*/

// ----------------------------------------------------------------------
// GetMigrationPlugin
SiCustom* SiHelp::GetMigrationPlugin(SiModule* pModule)
{
	for( USHORT i = 0; i < pModule->GetCustomList().Count(); ++i )
	{
		SiCustom* pItem = pModule->GetCustomList().GetObject(i);
		if( pItem->IsMigration() )
			return pItem;
	}
	return NULL;
}

// ----------------------------------------------------------------------
// InitMigration
void SiHelp::InitMigration(SiCompiledScript* pCS, SiEnvironment* pEnv)
{
	// migration plugin
	if( pEnv->IsFirstInstallation() && pEnv->IsLocal() )
	{
		SiCustom* pMigPlugin = SiHelp::GetMigrationPlugin( pCS->GetRootModule() );
	 	SiDirEntry aSVersion = pCS->GetInstallInfo()->GetProfile()->GetDirectory()->GetName();
		aSVersion += pCS->GetInstallInfo()->GetProfile()->GetName();
#if defined(WNT) || defined(OS2)
		if( !aSVersion.Exists() )
		{
			// also try to search in system path
			aSVersion = OS::GetGUIPath();
			aSVersion += pCS->GetInstallInfo()->GetProfile()->GetName();
		}
#endif

		if( aSVersion.Exists() && pMigPlugin )
		{
			Config aCfg( aSVersion.GetFullUni() );
			aCfg.SetGroup( pCS->GetInstallInfo()->GetSection() );

			SiCustomAction* pAction = new SiCustomAction( NULL,
							pCS->GetRootModule(),
							pMigPlugin->GetDllName(),
							pEnv->GetStartPath(),
							FALSE,
							FALSE,
							pMigPlugin,
                            pCS );

			pAction->SetKeepAlive();
			pAction->Execute( *pEnv );

			for( USHORT i = 0; i < aCfg.GetKeyCount(); ++i )
			{
				ByteString aKey( aCfg.GetKeyName(i) );
				ByteString aValue( aCfg.ReadKey(i) );
				SiDirEntry aPath( aValue );
				SiDirEntry aSofficeINI( aPath );
				aSofficeINI += ByteString("user");
			#ifdef UNX
				aSofficeINI += ByteString("sofficerc");
			#else
				aSofficeINI += ByteString("soffice.ini");
			#endif

				if( aPath.Exists() && aSofficeINI.Exists() )
				{
					BOOL bSupportVersion = pAction->GetCustomFnc().fncSupportVersion(aKey);
					if( bSupportVersion )
					{
						pEnv->SetMigrationAvailable( TRUE );
						pEnv->SetMigration( TRUE );
						pEnv->SetMigrationPath( aPath.GetFull() );
                        pEnv->SetLicenseKey( aKey );
					}
				}
			}

			pAction->SetKeepAlive(FALSE);
			if( !pAction->InternalError() ) pAction->GetCustomFnc().fncKill();
			delete pAction;
		}
	}
}

// ----------------------------------------------------------------------
// IsVersionAlreadyInstalled

BOOL SiHelp::IsVersionAlreadyInstalled(ByteString& rPath, SiCompiledScript* pCS, SiEnvironment* pEnv)
{
	if( pEnv->IsFirstInstallation() &&
        ( pEnv->IsLocal() || ( pEnv->GetInstallMode() == IM_PATCH ) ) &&
		( pCS->GetInstallInfo() != NULL ) )
	{
		SiInstallation* pInstObj = pCS->GetInstallation();
		ByteString aInstalledPath = SiHelp::FindInstallation( pCS->GetInstallInfo() );
		SiDirEntry aInstalledDir( aInstalledPath );
		BOOL bUpdateForSameVersion = FALSE;

        ::rtl::OUString aInstallURL = UniString( aInstalledPath, osl_getThreadTextEncoding() );
        ::rtl::OUString aInstallDir;

        FileBase::getSystemPathFromFileURL( aInstallURL, aInstallDir );
        aInstalledPath = ByteString( UniString( aInstallDir ), osl_getThreadTextEncoding() );

/*		if( pInstObj != NULL && pInstObj->GetUpdateFor() == pCS->GetInstallInfo()->GetKey() )
			bUpdateForSameVersion = TRUE;
*/
		if( aInstalledPath.Len() != 0 && aInstalledDir.Exists() && !bUpdateForSameVersion  )
		{
			rPath = aInstalledPath;
			return TRUE;
		}
	}

	return FALSE;
}

// ----------------------------------------------------------------------
// GetClusterSizeForFirstFreeVolume

ULONG SiHelp::GetClusterSizeForFirstFreeVolume( ULONG nSize, BOOL& bIsFat )
{
	Dir aDir( SiDirEntry( "*" ), FSYS_KIND_BLOCK);
	BOOL bFound = FALSE;
	bIsFat = FALSE;

	for (USHORT i = 0; i < aDir.Count(); i++)
	{
		// Application::Reschedule();
		ByteString sFull( aDir[i].GetFull(), osl_getThreadTextEncoding());
		sFull.ToLowerAscii();

		if ((sFull.GetChar(0) == 'a' || sFull.GetChar(0) == 'b' ))
			continue;

		FileStat aStat(aDir[i]);

		if ( aStat.IsKind (FSYS_KIND_FIXED)  || aStat.IsKind (FSYS_KIND_REMOTE) )
		{
			ULONG nDrvSize = OS::GetDriveSize(aDir[i]);
			if( nDrvSize > nSize / 1024 )
			{
				#ifdef OS2
				bIsFat = Os2OS::IsFATFileSystem(aDir[i].GetFull());
				#endif

				return OS::GetClusterSize(aDir[i]);
			}
		}
	}
	return 0;
}

// ----------------------------------------------------------------------
// CorrectToFirstFreeVolume

BOOL SiHelp::CorrectToFirstFreeVolume( SiCompiledScript* pCS, SiEnvironment* pEnv )
{
	#if defined(WIN) || defined(OS2) || defined(WNT)
	BOOL bScanRemoveableDisks = FALSE;
	BOOL bFound = FALSE;
	Dir aDir( SiDirEntry( "*" ), FSYS_KIND_BLOCK);
	ByteString sFull;

	for( USHORT i = 0; i < aDir.Count(); i++ )
	{
		FileStat aStat( aDir[i] );

		sFull = ByteString( aDir[i].GetFull(), osl_getThreadTextEncoding());
		sFull.ToUpperAscii();

		if( sFull.GetChar(0) != 'A'	&&
			sFull.GetChar(0) != 'B' &&
			(aStat.IsKind(FSYS_KIND_FIXED)  ||
			 aStat.IsKind(FSYS_KIND_REMOTE) ||
			(aStat.IsKind(FSYS_KIND_REMOVEABLE) && bScanRemoveableDisks)) )
		{
			BOOL bIsFat = FALSE;
			#ifdef OS2
			bIsFat = Os2OS::IsFATFileSystem(sFull);
			#endif

			SiModule* pRoot 	= pCS->GetRootModule();
			ULONG lClusterSize 	= OS::GetClusterSize( aDir[i] );
			ULONG lUsedSize 	= pRoot->CalculateSize( *pEnv, SiModule::INSTALL,
								  lClusterSize, FALSE, pEnv->GetInstallType() == IT_WORKSTATION,
								  bIsFat );
			ULONG lTempSize		= pRoot->CalculateSize( *pEnv, SiModule::TEMP, lClusterSize,
								  FALSE, pEnv->GetInstallType() == IT_WORKSTATION, bIsFat );

			if( OS::GetDriveSize(aDir[i]) > ((lUsedSize + lTempSize) / 1024) )
			{
				bFound = TRUE;
				break;
			}
		}
	}

	if( bFound )
	{
		ByteString aInstPath( pEnv->GetDestPath() );
		aInstPath.Erase( 0, 2 );
		aInstPath.Insert( sFull, 0 );
		pEnv->SetDestPath( aInstPath );
		return TRUE;
	}

	return FALSE;
	#else
	return TRUE;
	#endif
}

// ----------------------------------------------------------------------
// CheckInstallationSize

BOOL SiHelp::CheckInstallationSize( SiCompiledScript* pCS, SiEnvironment* pEnv,
                                    const SiDirEntry& rDestPath,
                                    ULONG *pSysVol, ULONG *pDestVol )
{
    SiModule* pRoot = pCS->GetRootModule();
    ULONG lClusterSize = OS::GetClusterSize( rDestPath );
    ULONG lClusterSizeSys = OS::GetClusterSize( SiDirEntry(OS::GetGUIPath()) );

	BOOL bIsFat = FALSE;
    BOOL bIsSysFat = FALSE;

	#ifdef OS2
    bIsFat		= Os2OS::IsFATFileSystem(rDestPath.GetFull());
    bIsSysFat	= Os2OS::IsFATFileSystem(OS::GetGUIPath());
	#endif

    ULONG lUsedSize = pRoot->CalculateSize( *pEnv, SiModule::INSTALL, lClusterSize,
                            FALSE, pEnv->GetInstallType() == IT_WORKSTATION, bIsFat );

    if ( pEnv->GetInstallMode() == IM_PATCH )
        lUsedSize += (lUsedSize / 2);

    lUsedSize += pEnv->GetMigrationSize();

    ULONG lSystemSize = pRoot->CalculateSize( *pEnv, SiModule::INSTALL_SYSTEM, lClusterSizeSys,
                                    TRUE, pEnv->GetInstallType() == IT_WORKSTATION, bIsSysFat );

    ULONG lTempSize = pRoot->CalculateSize( *pEnv, SiModule::TEMP, lClusterSize, FALSE,
                                    pEnv->GetInstallType() == IT_WORKSTATION, bIsFat );

    SiInstallation*	pInst = pCS->GetInstallation();
    ByteString aDestVol( rDestPath.GetFull() );
    ByteString aGUIVol( OS::GetGUIPath() );

    aDestVol.ToLowerAscii();
    aGUIVol.ToLowerAscii();

    if ( pDestVol ) *pDestVol = 0;
    if ( pSysVol )  *pSysVol = 0;

    if( aDestVol.GetChar(0) != aGUIVol.GetChar(0) && pInst->GetInstallMode() != IM_NETWORK )
    {
        // Ziellaufwerk != Systemlaufwerk Pruefung aufteilen
        if( OS::GetDriveSize(rDestPath) < ((lUsedSize + lTempSize)/1024) )
        {
            if ( pDestVol )
                *pDestVol = ((lUsedSize + lTempSize)/1024) - OS::GetDriveSize(rDestPath);
            return FALSE;
        }
        else if( OS::GetDriveSize(SiDirEntry(OS::GetSystemPath())) < (lSystemSize/1024) )
        {
            if ( pSysVol )
                *pSysVol = (lSystemSize/1024) - OS::GetDriveSize(SiDirEntry(OS::GetSystemPath()));
            return FALSE;
        }
    }
	else if( OS::GetDriveSize(rDestPath) < ((lUsedSize+lTempSize+lSystemSize) /1024) )
    {
        if ( pDestVol )
            *pDestVol = ((lUsedSize+lTempSize+lSystemSize)/1024) - OS::GetDriveSize(rDestPath);
		return FALSE;
    }

	return TRUE;
}

namespace 
{
	// Direct copy from bootstrap.cxx
	// #101731#
	static 
	bool implNormalizeURL(OUString & _sURL, osl::DirectoryItem& aDirItem)
	{
		using namespace osl;
		
		OSL_PRECOND(aDirItem.is(), "Opened DirItem required");
		
		static const sal_uInt32 cFileStatusMask = FileStatusMask_FileURL;

		FileStatus aFileStatus(cFileStatusMask);

		if (aDirItem.getFileStatus(aFileStatus) != DirectoryItem::E_None)
			return false;

		OUString aNormalizedURL = aFileStatus.getFileURL();

		if (aNormalizedURL.getLength() == 0)
			return false;

		_sURL = aNormalizedURL;
		return true;
	}

	// -----------------------------------------------------------------------------
	rtl::OUString normalizeFileURL(OUString const& _suFileURL)
	{
		osl::DirectoryItem	aItem;
		osl::FileBase::RC	nResult = osl::DirectoryItem::get( _suFileURL, aItem );
		rtl::OUString suURL;

		if ( nResult == osl::FileBase::E_None )
		{
			if (implNormalizeURL(suURL, aItem))
			{
				return suURL;
			}
		}
		return rtl::OUString();
	}
	
	rtl::OUString CreateMD5FromString( const OUString& aMsg )
	{
		// PRE: aStr "file"
		// BACK: Str "ababab....0f" Hexcode String

		rtlDigest handle = rtl_digest_create( rtl_Digest_AlgorithmMD5 );
		if ( handle > 0 )
		{
			const sal_uInt8* pData = (const sal_uInt8*)aMsg.getStr();
			sal_uInt32		 nSize = ( aMsg.getLength() * sizeof( sal_Unicode ));
			sal_uInt32		 nMD5KeyLen = rtl_digest_queryLength( handle );
			sal_uInt8*		 pMD5KeyBuffer = new sal_uInt8[ nMD5KeyLen ];
			
			rtl_digest_init( handle, pData, nSize );
			rtl_digest_update( handle, pData, nSize );
			rtl_digest_get( handle, pMD5KeyBuffer, nMD5KeyLen );
			rtl_digest_destroy( handle );
			
			// Create hex-value string from the MD5 value to keep the string size minimal
			OUStringBuffer aBuffer( nMD5KeyLen * 2 + 1 );
			for ( sal_uInt32 i = 0; i < nMD5KeyLen; i++ )
				aBuffer.append( (sal_Int32)pMD5KeyBuffer[i], 16 );

			delete [] pMD5KeyBuffer;
			return aBuffer.makeStringAndClear();
		}
		return rtl::OUString();
	}
}

BOOL SiHelp::IsOfficeRunning( const ByteString& rInstalledPath, BOOL bIsLocalInst )
{
	if (rInstalledPath.Len() == 0) // No office found
		return FALSE;

	SiDirEntry aEntry( rInstalledPath );
	// aEntryaEntry += ByteString( "user" );

	OSecurity maSecurity;

	OUString aPipename	= OUString( RTL_CONSTASCII_USTRINGPARAM( "SingleOfficeIPC_" ) );
	// UniString aUserPath( ByteString(aEntry.GetFull()), osl_getThreadTextEncoding() );
	OUString aOU_UserPath;
	// FileBase::getFileURLFromSystemPath( aUserPath, aOU_UserPath );
	aOU_UserPath = getFileURLFromSystemPathAsOUString(convertSiDirEntryToByteString(aEntry));

	vos::OPipe aPipe;
	// aPipename = aPipename + OUString::valueOf( (sal_Int32) aOU_UserPath.hashCode() );
	
	rtl::OUString suDirectoryURL(normalizeFileURL(aOU_UserPath));
	if (suDirectoryURL.getLength() > 0)
	{
		rtl::OUString suDirectoryAbsolutePath;
		osl::File::getAbsoluteFileURL(rtl::OUString(), suDirectoryURL, suDirectoryAbsolutePath);

		aPipename = aPipename + CreateMD5FromString(suDirectoryAbsolutePath);
		if( aPipe.create( aPipename.getStr(), OPipe::TOption_Open, maSecurity ) )
			return TRUE;
	}
#ifdef WNT
    if ( ! bIsLocalInst )
        return WinOS::IsOfficeRunning( rInstalledPath );
#endif
	return FALSE;
}

// ----------------------------------------------------------------------
// _ModuleDump
// ModuleDump

void SiHelp::_ModuleDump( SiModule* pMod, SiFileStream& rStrm, USHORT nLevel )
{
	ByteString aLine;
	aLine += "<TR VALIGN=TOP><TD WIDTH=73%><P>";
	if( !pMod->HasObjects() )
		aLine += "<B>";

	USHORT i;
	for( i = 0; i < nLevel; ++i )
		aLine += "<DL>";
	aLine += "<DD>";
	aLine += pMod->GetName();
	for( i; i > 0; --i )
		aLine += "</DL>";

	aLine += "</TD><TD WIDTH=12%><P>";
	aLine += pMod->GetID();
	aLine += "</TD><TH WIDTH=7%><P>";
	aLine += ByteString::CreateFromInt32( pMod->GetFileList().Count() );
	aLine += "<BR></TH><TH WIDTH=7%><P>";
	SiEnvironment aEmptyEnv;
	ULONG nSz = pMod->CalculateSize( aEmptyEnv, SiModule::ALL, 1 );
	aLine += ByteString::CreateFromInt32( nSz / 1024 );
	aLine += " KB";
	aLine += "<BR></TH>";

	if( !pMod->HasObjects() )
		aLine += "</B>";
	aLine += "</TR>\n";

	aLine.ConvertLineEnd();
	rStrm << aLine;

	const SiModuleList* pModuleList = pMod->GetModuleList();
	for( USHORT x = 0; x < pModuleList->Count(); ++x )
		_ModuleDump( pModuleList->GetObject(x), rStrm, nLevel + 1 );
}

BOOL SiHelp::ModuleDump( SiModule* pRoot, const ByteString& rFileName )
{
	SiDirEntry aEntry( rFileName );
	if( aEntry.Exists() )
		aEntry.Kill();

	SiFileStream aStrm;
	aStrm.Open( UniString::CreateFromAscii(rFileName.GetBuffer()), STREAM_STD_WRITE );
	if( !aStrm.IsOpen() )
		return FALSE;

	ByteString aHtml;
	aHtml += "<HTML><BODY>";
	aHtml += "<TABLE WIDTH=100% BORDER=1 CELLPADDING=4 CELLSPACING=3><COL WIDTH=187*><COL WIDTH=32*><COL WIDTH=18*><COL WIDTH=19*>";

	aHtml.ConvertLineEnd();
	aStrm << aHtml;

	_ModuleDump( pRoot, aStrm, 0 );

	aHtml = "</TABLE></BODY></HTML>";
	aHtml.ConvertLineEnd();
	aStrm << aHtml;

	return TRUE;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
RegistryLoader* SiHelp::GetStaticRegistryLoader(const SiEnvironment& rEnv)
{
	if( !static_pRegLoader )
	{
		SiDirEntry aCurDir;
		SiDirEntry aNewDir( rEnv.GetStartPath() );
		aNewDir.SetCWD();

		static_pRegLoader = new RegistryLoader();
		if( !static_pRegLoader->isLoaded() )
		{
			aCurDir.SetCWD();
			delete static_pRegLoader;
			static_pRegLoader = NULL;
			return static_pRegLoader;
		}
		aCurDir.SetCWD();
	}
	return static_pRegLoader;
}

void SiHelp::DisposeUNOImpl()
{
	if( pHelpImpl ) {
		delete pHelpImpl;
		pHelpImpl = NULL;
	}
}

// ----------------------------------------------------------------------

BOOL SiHelp::RawRegister( const UniString aFilename, const UniString& rAbsRegistryname, ByteString& rErrMsg, BOOL bRegister )
{
	::rtl::OUString loaderName( UniString::CreateFromAscii("com.sun.star.loader.SharedLibrary") );
	BOOL bSuccess = TRUE;

	if( !pHelpImpl )
		pHelpImpl = new SiHelpImpl;
	if( !pHelpImpl->xReg.is() || !pHelpImpl->xImplRegistration.is() )
		return FALSE;

	try
	{
		pHelpImpl->xReg->open( rAbsRegistryname, sal_False, sal_False);
		if (!pHelpImpl->xReg->isValid()) {
			rErrMsg = "registry not found";
			bSuccess = FALSE;
		}
	}
	catch( InvalidRegistryException& e )
	{
		::rtl::OString oStr = ::rtl::OUStringToOString( e.Message, osl_getThreadTextEncoding() );
		rErrMsg = oStr.getStr();
		bSuccess = FALSE;
	}

	#ifdef OS2
	SiDirEntry aOS2Name( aFilename );
	aOS2Name.CutExtension();
	ByteString aServiceURL(aOS2Name.GetName());
	#else
	ByteString aServiceURL( ByteString(aFilename, osl_getThreadTextEncoding()) );
	#endif

	::rtl::OUString compName = ::rtl::OStringToOUString( aServiceURL.GetBuffer(), osl_getThreadTextEncoding() );
	try
	{
		if (bRegister)
		{
			pHelpImpl->xImplRegistration->registerImplementation( loaderName, compName, pHelpImpl->xReg );
		}
		else
		{
			bSuccess = pHelpImpl->xImplRegistration->revokeImplementation( compName, pHelpImpl->xReg );
		}
	}
	catch( CannotRegisterImplementationException& e)
	{
		::rtl::OString oStr = ::rtl::OUStringToOString( e.Message, osl_getThreadTextEncoding() );
		rErrMsg = oStr.getStr();
		bSuccess = FALSE;
	}
	catch( RuntimeException& e)
	{
		::rtl::OString oStr = ::rtl::OUStringToOString( e.Message, osl_getThreadTextEncoding() );
		rErrMsg = oStr.getStr();
		bSuccess = FALSE;
	}

	return bSuccess;
}

BOOL SiHelp::RegisterUnoComponent( const ByteString& rFilename, BOOL bRegister )
{
	::vos::OGuard aGuard( ::vos::OMutex::getGlobalMutex() );

	SiDirEntry aAbsReg( "." );
	aAbsReg += UniString::CreateFromAscii("services.rdb");
	aAbsReg.ToAbs();

	SiDirEntry aAbsFile( rFilename );
	if( !aAbsFile.Exists() ) return FALSE;
	aAbsFile.GetPath().SetCWD();

	::rtl::OUString regName;
	// FileBase::getFileURLFromSystemPath( ::rtl::OStringToOUString( aAbsReg.GetFull().GetBuffer(),
	//				osl_getThreadTextEncoding() ), regName );
	regName = getFileURLFromSystemPathAsOUString(convertSiDirEntryToByteString(aAbsReg));
	ByteString aErrMsg;
	BOOL bSuccess = SiHelp::RawRegister( aAbsFile.GetNameUni(), regName, aErrMsg, bRegister );

	aAbsReg.GetPath().SetCWD();

	return bSuccess;
}

BOOL SiHelp::RegisterUnoComponent( SiFile* pFile, const SiEnvironment& rEnv, BOOL bRegister, ByteString& rErrMsg )
{
	::vos::OGuard aGuard( ::vos::OMutex::getGlobalMutex() );

	BOOL 	 bSuccess = TRUE;
	SiDirEntry aCurDir;
	SiDirEntry aStartDir( rEnv.GetStartPath() );
	SiDirEntry aCWDir( rEnv.GetDestPath() );
	aCWDir += pFile->GetDirectory()->GetName();

	aCWDir.SetCWD();

	if( !pHelpImpl )
		pHelpImpl = new SiHelpImpl;
	if( !pHelpImpl->xReg.is() || !pHelpImpl->xImplRegistration.is() )
		return FALSE;

	const SiStarRegistryList* pLst = pFile->GetRegistryList();
	for( USHORT i = 0; i < pLst->Count(); ++i )
	{
		SiStarRegistry* pRegistry = pLst->GetObject(i);
		if( !pRegistry ) continue;

		SiDirEntry aAbsRegName( rEnv.GetDestPath() );
		aAbsRegName += pRegistry->GetDir()->GetName();
		aAbsRegName += pRegistry->GetName();
		aAbsRegName.ToAbs();

		::rtl::OUString regName;
		// FileBase::getFileURLFromSystemPath( ::rtl::OStringToOUString( aAbsRegName.GetFull().GetBuffer(),
		//			osl_getThreadTextEncoding() ), regName );
		regName = getFileURLFromSystemPathAsOUString(convertSiDirEntryToByteString(aAbsRegName));

		bSuccess = SiHelp::RawRegister( UniString(pFile->GetName(), osl_getThreadTextEncoding()),
						regName, rErrMsg, bRegister );
		if( !bSuccess ) break;
	}

	aCurDir.SetCWD();
	return bSuccess;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

ByteString SiHelp::GetReadmeFilename( USHORT nLanguage, USHORT nType )
{
	ByteString aPostFilename = ByteString::CreateFromInt32( nLanguage );
	if( aPostFilename.Len() == 1 )
		aPostFilename.Insert( '0', 0 );

	USHORT nPos;
	ByteString aFilename( nType==1? README_FILE_NAME : LICENSE_FILE_NAME );
	if( (nPos = aFilename.Search(".")) != STRING_NOTFOUND )
		aFilename.Insert( aPostFilename, nPos );
	else
		aFilename += aPostFilename;
	return aFilename;
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

void SiHelp::MakeOffice_AuthFile(SiCompiledScript* pCS, SiEnvironment* pEnv)
{
	if( !pCS->GetOfficeINI() )          // testen ob's das office ist
		return ;

	SiDirectory* pConfigDir = SiHelp::FindDirectoryByName( pCS->GetRootModule(), "config" );
	if( !pConfigDir )
		return ;

	SiProfile* pIni = new SiProfile(ByteString("AUTH_INI"), NULL);
	#if defined(UNX)
	pIni->SetProperty( PROPERTY_NAME,			"authrc" );
	#else
	pIni->SetProperty( PROPERTY_NAME,			"auth.ini" );
	#endif
	pIni->SetProperty( PROPERTY_DIR,			pConfigDir );
	pIni->SetProperty( PROPERTY_MODULEID,	   	pCS->GetRootModule() );


	ByteString aTmpB( ProductVersion::GetSystemID(), osl_getThreadTextEncoding() );

	ByteString aSectionName( "Keys" );
	aSectionName += "_";
	aSectionName += aTmpB;

	SiProfileItem* pPLKItem = new SiProfileItem( SiIdentifier("AUTH_KEY"), NULL );
	pPLKItem->SetProperty( PROPERTY_PROFILEID,	pIni );
	pPLKItem->SetProperty( PROPERTY_MODULEID,	pCS->GetRootModule() );
	pPLKItem->SetProperty( PROPERTY_SECTION,	aSectionName );
	if( pEnv->GetLicenseKey().Len() == 28 )
		pPLKItem->SetProperty( PROPERTY_KEY,   	ByteString("PALK") );
	else
		pPLKItem->SetProperty( PROPERTY_KEY,   	ByteString("PLK") );
	pPLKItem->SetProperty( PROPERTY_VALUE,		pEnv->GetLicenseKey() );

	pCS->GetRootModule()->Add( pIni );
	pCS->GetRootModule()->Add( pPLKItem );
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------
//		Country Codes

ByteString SiHelp::Get2AlphaCountryCode(USHORT nIdx)
{
	ByteString aCode;
	if( nIdx <= MAX_COUNTRYS )
		aCode = CountryCode[nIdx].iso2Digit;
	return aCode;
}

ByteString SiHelp::Get3AlphaCountryCode(USHORT nIdx)
{
	ByteString aCode;
	if( nIdx <= MAX_COUNTRYS )
		aCode = CountryCode[nIdx].iso3Digit;
	return aCode;
}

// -----------------------------------------------------------------------------
namespace
{
void /*SiHelp::*/ExecuteProcess(SiDirEntry const& _aProcess, ByteString const& _sParam)
{
	// we need at least two parameters, the first one is the return
	// value of this function, the second the name of the application
	// we want to start
	UniString aStr(_aProcess.GetFull(), osl_getThreadTextEncoding());
	rtl::OUString aAppPath(aStr);
	rtl::OUString aApplication;

 	FileBase::getFileURLFromSystemPath( aStr, aApplication );

	USHORT nOptions = NAMESPACE_VOS(OProcess)::TOption_SearchPath |
		NAMESPACE_VOS(OProcess)::TOption_Minimized;

	NAMESPACE_VOS(OProcess)::TProcessOption eOptions =
		(NAMESPACE_VOS(OProcess)::TProcessOption)nOptions;

	// now collect the additional parameters for the function
	// (the first two parameters should be ignored ( s.o. ) )
	::rtl::OUString* pArgs = new ::rtl::OUString [ 1 ];

	pArgs[0] = ::rtl::OUString( UniString(_sParam, osl_getThreadTextEncoding()));

	NAMESPACE_VOS(OArgumentList) aArgs( pArgs, 1 );

	NAMESPACE_VOS( OProcess ) aProcess( aApplication );
	aProcess.execute( eOptions, aArgs );
	aProcess.join();

	delete[] pArgs;
}
}

void SiHelp::KillQuickStarter(SiEnvironment* _pEnv, SiCompiledScript *_pCS)
{
	// #88505# try to stop QuickStarter
	if (_pEnv == NULL || _pCS == NULL) return; // Do nothing, if no Environment

#ifdef WNT
	SiDirEntry aQuickStartPath = _pEnv->GetProgPath(_pCS->GetInstallation()->GetInstallMode());
	aQuickStartPath += ByteString("program");
	aQuickStartPath += ByteString("quickstart.exe");
	if (aQuickStartPath.Exists())
	{
		// ByteString aInstruction(aQuickStartPath.GetFull());
		// aInstruction += " -killtray";
		// system(aInstruction.GetBuffer());
		ExecuteProcess(aQuickStartPath, ByteString("-killtray"));
	}
#endif
}

// -----------------------------------------------------------------------

namespace setup
{
	BOOL isAdabas(SiInstallation const* pInst)
	{
		if (pInst) 
		{
			ByteString sProductName = pInst->GetProductName();
			sal_Int32 nIndex = sProductName.ToLowerAscii().Search("adabas");
			
			if (nIndex != STRING_NOTFOUND)
			{
				return TRUE;
			}
		}
		return FALSE;
	}
}
