/*************************************************************************
 *
 *  $RCSfile: sw3table.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:21:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "swerror.h"
#include "doc.hxx"
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif

#ifndef _FMTFSIZE_HXX //autogen
#include <fmtfsize.hxx>
#endif
#ifndef _NODE_HXX //autogen
#include <node.hxx>
#endif
#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>
#include "sw3imp.hxx"
#include "swtable.hxx"
#include "ddefld.hxx"
#include "swddetbl.hxx"
#include "swtblfmt.hxx"
#include "ndindex.hxx"


#ifndef PRODUCT
static ULONG nCntntBox = 0;
#endif


/////////////////////////////////////////////////////////////////////////////

// Das Attribut darf im Prinzip nicht > 65535 werden, da sonst MAs
// Rechenroutinen baden gehen. Da einige alte Tabellen groessere Werte
// enthalten, setzt InTable() ggf. einen Divisionsfaktor, um den
// die gelesenen Werte heruntergeteilt werden. Normalerweise ist er 1.


void lcl_sw3io_AdjustFrmSize( SwFrmFmt* pFmt, long nAdj )
{
	if( pFmt && nAdj > 1
	 && pFmt->GetAttrSet().GetItemState( RES_FRM_SIZE, FALSE ) == SFX_ITEM_SET )
	{
		SwFmtFrmSize aSz( pFmt->GetFrmSize() );
		aSz.SetWidth( aSz.GetWidth() / nAdj );
		aSz.SetHeight( aSz.GetHeight() / nAdj );
		pFmt->SetAttr( aSz );
	}
}

/*  */

// Line- und Box-Formate fuer den 3.1-/4.0-Export sammeln

BOOL lcl_sw3io_CollectLineFmts( const SwTableLine*& rpLine, void* pPara );

BOOL lcl_sw3io_CollectBoxFmts( const SwTableBox*& rpBox, void* pPara )
{
	Sw3FrmFmts *pFrmFmts = (Sw3FrmFmts *)pPara;
	if( USHRT_MAX == pFrmFmts->GetPos( rpBox->GetFrmFmt() ) )
		pFrmFmts->Insert( rpBox->GetFrmFmt(), pFrmFmts->Count() );

	if( rpBox->GetTabLines().Count() )
		((SwTableBox *)rpBox)->GetTabLines()
			.ForEach( &lcl_sw3io_CollectLineFmts, pPara );

	return TRUE;
}

BOOL lcl_sw3io_CollectLineFmts( const SwTableLine*& rpLine, void* pPara )
{
	Sw3FrmFmts *pFrmFmts = (Sw3FrmFmts *)pPara;
	if( USHRT_MAX == pFrmFmts->GetPos( rpLine->GetFrmFmt() ) )
		pFrmFmts->Insert( rpLine->GetFrmFmt(), pFrmFmts->Count() );

	((SwTableLine *)rpLine)->GetTabBoxes()
		.ForEach( &lcl_sw3io_CollectBoxFmts, pPara );

	return TRUE;
}

void Sw3IoImp::CollectTblLineBoxFmts40()
{
	ASSERT( pExportInfo, "Wo ist die Export-Info?" );
	for( USHORT i=0; i<pDoc->GetTblFrmFmts()->Count(); i++ )
	{
		SwClientIter aIter( *(*pDoc->GetTblFrmFmts())[i] );
		SwTable *pTable = (SwTable *)aIter.First( TYPE(SwTable) );
		ASSERT( pTable, "Tabellen-Format ohne Tabelle" );
		if( !pTable )
			continue;

		if( !pExportInfo->pTblLineBoxFmts40 )
			pExportInfo->pTblLineBoxFmts40 = new Sw3FrmFmts;
		pTable->GetTabLines().ForEach( &lcl_sw3io_CollectLineFmts,
										 pExportInfo->pTblLineBoxFmts40 );
	}
}

/*  */

void Sw3IoImp::AddTblLineBoxFmt( SwFrmFmt *pFmt )
{
	if( !pTblLineBoxFmts )
		pTblLineBoxFmts = new Sw3FrmFmts;

	pTblLineBoxFmts->Insert( pFmt, pTblLineBoxFmts->Count() );
}

USHORT Sw3IoImp::GetTblLineBoxFmtId( SwFrmFmt *pFmt )
{
	USHORT nIdx = pTblLineBoxFmts ? pTblLineBoxFmts->GetPos( pFmt )
								  : USHRT_MAX;
	ASSERT( USHRT_MAX != nIdx, "Tabellen-Line/-Box-Format nicht gefunden" );
	if( USHRT_MAX == nIdx )
		Error();

	return nIdx;
}

USHORT Sw3IoImp::GetTblLineBoxFmtStrPoolId40( SwFrmFmt *pFmt )
{
	ASSERT( pExportInfo, "Wo ist die Export-Info?" );
	USHORT nPos = pExportInfo->pTblLineBoxFmts40
						? pExportInfo->pTblLineBoxFmts40->GetPos( pFmt )
						: USHRT_MAX;
	ASSERT( USHRT_MAX != nPos, "Tabellen-Line/-Box-Format nicht gefunden" );
	if( USHRT_MAX == nPos )
		Error();

	return aStringPool.Find( *((*pExportInfo->pTblLineBoxFmtNames40)[nPos]),
							 pFmt->GetPoolFmtId() );
}

SwFrmFmt *Sw3IoImp::GetTblLineBoxFmt( USHORT nIdx )
{
	ASSERT( pTblLineBoxFmts && nIdx < pTblLineBoxFmts->Count(),
			"Tabellen-Line/-Box-Format nicht gefunden" );
	if( pTblLineBoxFmts && nIdx < pTblLineBoxFmts->Count() )
		return (*pTblLineBoxFmts)[nIdx];

	return 0;
}

// Lesen einer Tabelle
// Der uebergebene Index zeigt anschliessend hinter die Tabelle
// Flag-Byte
// 	0x10 - Modified
// 	0x20 - HeadLineRepeat
// Anzahl Boxes
// Tabellen-Section-ID
// SWG_FRAMEFMT
// SWG_FIELDTYPE bei DDE-Tabelle
// x-mal SWG_TABLELINE


void Sw3IoImp::InTable( SwNodeIndex& rPos )
{
	Sw3FrmFmts *pOldTblLineBoxFmts = pTblLineBoxFmts;
	pTblLineBoxFmts = 0;
#ifndef PRODUCT
	ULONG nOldCntntBox = nCntntBox;
#endif


	// Bei einer Tabelle hoert eine 3.1-/4.0-Numerierung auf!
	if( !IsVersion(SWG_LONGIDX) )
		CloseNumRange40( rPos );

	OpenRec( SWG_TABLE );
	// Tabelle in Tabelle einfuegen wird nicht gemacht
	if( !bInsert || !pDoc->IsIdxInTbl( rPos ) )
	{
		BYTE cFlags = OpenFlagRec();
		UINT16 nBoxes, nTblIdDummy;
		BYTE cChgMode;
		*pStrm >> nBoxes;
		if( IsVersion(SWG_LAYFRAMES,SWG_LONGIDX) )
			*pStrm >> nTblIdDummy;
		if( nVersion >= SWG_TBLCHGMODE )
			*pStrm >> cChgMode;
		CloseFlagRec();
//JP 16.02.99: ueberfluessiges Flag
//		BOOL bModified = BOOL( ( cFlags & 0x10 ) != 0 );
		BOOL bHdRepeat = BOOL( ( cFlags & 0x20 ) != 0 );
		// Die Strukturen im Nodes-Array erzeugen
		// Erzeugen von:
		// TableNode..StartNode..TxtNode..EndNode.. (weitere Boxes) ..EndNode
		SwTableNode* pNd = pDoc->GetNodes().InsertTable( rPos, nBoxes,
								(SwTxtFmtColl*) pDoc->GetDfltTxtFmtColl() );
		if( pNd )
		{
			rPos = *pNd;
			SwTable* pTbl = &pNd->GetTable();
//JP 16.02.99: ueberfluessiges Flag
//			if( bModified )
//				pTbl->SetModified();
			pTbl->SetHeadlineRepeat( bHdRepeat );
			if( nVersion >= SWG_TBLCHGMODE )
				pTbl->SetTblChgMode( (TblChgMode)cChgMode );

			// Das Frame-Format der Tabelle einlesen
			SwFrmFmt* pFmt = pDoc->MakeTblFrmFmt( aEmptyStr, 0 );
			if( Peek() == SWG_FRAMEFMT )
				InFormat( SWG_FRAMEFMT, pFmt );
			// Da einige FRMSIZE-Attribute zu grosse Werte enthalten,
			// muessen die Werte heruntergeteilt werden.
			nSizeDivFac = 1;
			if( pFmt->GetAttrSet().GetItemState( RES_FRM_SIZE, FALSE )
				== SFX_ITEM_SET )
			{
				const SwFmtFrmSize &rSz = pFmt->GetFrmSize();
				if ( rSz.GetHeight() > 65535L || rSz.GetWidth() > 65535L )
				{
					SwFmtFrmSize aSz( rSz );
					SwTwips h = aSz.GetHeight();
					SwTwips w = aSz.GetWidth();
					while( h > 65535L || w > 65535L )
						w /= 2, h /= 2, nSizeDivFac *= 2;
					aSz.SetWidth( w );
					aSz.SetHeight( h );
					pFmt->SetAttr( aSz );
				}
			}
			// Falls wir im Insert-Mode sind, muss der Name der Tabelle
			// auf Eindeutigkeit ueberprueft werden
			if( bInsert )
			{
				String aName( pFmt->GetName() );
				Sw3StringPool::RemoveExtension( aName );
				pFmt->SetName( aEmptyStr );
				if( pDoc->FindTblFmtByName( aName ) )
					pFmt->SetName( pDoc->GetUniqueTblName() );
				else
					pFmt->SetName( aName );
			}
			pFmt->Add( pTbl );
			// Ist es eine DDE-Tabelle?
			SwDDEFieldType* pDDEFldType = 0;
			if( Peek() == SWG_FIELDTYPE )
				pDDEFldType = (SwDDEFieldType*) InFieldType();

			// Vordefinierte Layout-Frames loeschen
			// beim Einfuegen stoeren diese zur Zeit
			if( bInsert ) pNd->DelFrms();

			// Redlines am Start- oder End-Node einlesen
			while( Peek() == SWG_NODEREDLINE )
			{
				INT32 nDummy=0;
				InNodeRedline( rPos, nDummy );
			}

			// Die einzelnen Zeilen einlesen
			// aIdx zeigt auf den Startnode der ersten Box
			rPos = *pNd; rPos++;
#ifndef PRODUCT
			nCntntBox = 0;
#endif
			USHORT nLine = 0;
			while( BytesLeft() )
				InTableLine( pTbl->GetTabLines(), NULL, nLine++, rPos );
			rPos = pNd->EndOfSectionIndex()+1;

			ASSERT( nCntntBox == nBoxes ,
				"Anzahl der Boxen stimmt nicht mit den gelesenen ueberein" );

			if( pDDEFldType && !pNd->GetTable().IsTblComplex() )
			{
				//DDETabelle, dann tausche am Node den Tabellen-Pointer aus
				SwDDETable* pNewTable = new SwDDETable( pNd->GetTable(),
														pDDEFldType );
				pNd->SetNewTable( pNewTable, FALSE );
			}

			// Layout-Frames wieder erzeugen, falls eingefuegt
			// und falls (MA #$!) die Tbl nicht im FlyFrm ist
			if( bInsert && !nFlyLevel )
			{
				SwNodeIndex aIdx( *pNd->EndOfSectionNode() );
				pDoc->GetNodes().GoNext( &aIdx );
				pNd->MakeFrms( &aIdx );
			}
		}
		else Error();		// kein TblNode
	}


	CloseRec( SWG_TABLE );
	// Den Divisionsfaktor fur FRMSIZE wieder zuruecksetzen
	nSizeDivFac = 1;

	delete pTblLineBoxFmts;
	pTblLineBoxFmts = pOldTblLineBoxFmts;
#ifndef PRODUCT
	nCntntBox = nOldCntntBox;
#endif
}

// Schreiben einer Tabelle


void Sw3IoImp::OutTable( const SwTableNode& rNd )
{
	Sw3FrmFmts *pOldTblLineBoxFmts = pTblLineBoxFmts;
	pTblLineBoxFmts = 0;

	const SwTable& rTbl = rNd.GetTable();
	const SwTableLines& rLines = rTbl.GetTabLines();
	USHORT nLines = rLines.Count();
	SwTable* pOldTbl = pCurTbl;
	pCurTbl = (SwTable*) &rTbl;
	// 0x04 - Anzahl Boxes, Tabellen-ID
	// 0x10 - Modified
	// 0x20 - HeadLineRepeat
	BYTE   cFlags;
	if( IsSw31Or40Export() )
		cFlags = IsSw31Export() ? 0x04 : 0x05;
	else
		cFlags = 0x03;
	UINT16 nBoxes = 0;
//JP 16.02.99: ueberflussiges Flag
//	if( rTbl.IsModified() )
//		cFlags |= 0x10;
	if( rTbl.IsHeadlineRepeat() )
		cFlags |= 0x20;
	OpenRec( SWG_TABLE );
	*pStrm << (BYTE) cFlags;
	OpenValuePos16( nBoxes );

	// Im 3.1/4.0-Format stand hier der Index der Section. Bei IDX_NO_VALUE
	// wurde sie beim Laden nicht registriert.
	if( IsSw31Or40Export() )
		*pStrm << (UINT16)IDX_NO_VALUE;
	if( !IsSw31Export() )
		*pStrm << (BYTE)rTbl.GetTblChgMode();
	OutFormat( SWG_FRAMEFMT, *rTbl.GetFrmFmt() );
	// DDE-Tabelle? Dann den DDE-Feldtyp speichern
	if( IS_TYPE(SwDDETable, &rTbl) )
	{
		SwDDETable* pDDE = (SwDDETable*) &rTbl;
		OutFieldType( *pDDE->GetDDEFldType() );
	}
	if( !IsSw31Or40Export() )
	{
		OutNodeRedlines( rNd.GetIndex() );
		OutNodeRedlines( rNd.EndOfSectionIndex() );
	}

	for( USHORT i = 0; i < nLines && Good(); i++ )
		nBoxes += OutTableLine( *(rLines[ i ]) );
	CloseValuePos16( nBoxes );
	CloseRec( SWG_TABLE );
	pCurTbl = pOldTbl;
	aStat.nTbl++;

	delete pTblLineBoxFmts;
	pTblLineBoxFmts = pOldTblLineBoxFmts;
}

/**/


// Einlesen einer Zeile
// Flag-Byte (0)
//				0x10 - schon immer unbenutzt. Zur Zeit nicht benutzt,
//					   damit die anderen Flags wie bei Boxen sind.
//				0x20 - FrmFmtId ist vorhanden (seit SW5)
//				0x40 - FrmFmt ist geshared (seit SW5)
// String-ID des Frameformats
// Anzahl Boxes
// SWG_FRAMEFMT (optional)
// x-mal SWG_TABLEBOX


void Sw3IoImp::InTableLine
	( SwTableLines& rLines, SwTableBox* pUpper, USHORT nPos, SwNodeIndex& rPos )
{
	OpenRec( SWG_TABLELINE );
	BYTE cFlags = OpenFlagRec();
	UINT16 nBoxes, nFmtId = IDX_NO_VALUE;
	if( !IsVersion(SWG_LONGIDX) || (cFlags & 0x20) != 0 )
		*pStrm >> nFmtId;
	*pStrm >> nBoxes;
	CloseFlagRec();
	SwTableLineFmt* pFmt = 0;
	if( Peek() == SWG_FRAMEFMT )
	{
		pFmt = (SwTableLineFmt*) InFormat( SWG_FRAMEFMT, pDoc->MakeTableLineFmt() );
		lcl_sw3io_AdjustFrmSize( pFmt, nSizeDivFac );
		if( (cFlags & 0x40) != 0 )
			AddTblLineBoxFmt( pFmt );
	}
	else if( (cFlags & 0x20) != 0 )
	{
		pFmt = (SwTableLineFmt *)GetTblLineBoxFmt( nFmtId );
	}
	else if( !IsVersion(SWG_LONGIDX) )
	{
		// Ja, das funktioniert. Das Format steht zwar in keinem
		// Array mehr, aber es ist im String-Pool gecached.
		pFmt = (SwTableLineFmt *)FindFmt( nFmtId, SWG_FRAMEFMT );
	}

	if( pFmt )
	{
		// Default-Werte setzen:
		SwTableLine* pLine = new SwTableLine( pFmt, nBoxes, pUpper );
		rLines.C40_INSERT( SwTableLine, pLine, nPos );
		SwTableBoxes& rBoxes = pLine->GetTabBoxes();
		USHORT nBox = 0;
		while( BytesLeft() )
			InTableBox( rBoxes, nBox++, pLine, rPos );
	}
	else
	{
		ASSERT( pFmt, "Line-Format fehlt" );
		Error(); 	// kein FrameFmt
	}

	CloseRec( SWG_TABLELINE );
}

BOOL lcl_sw3io_IsLineFmtShared( SwFrmFmt& rFmt,	const SwTableLine& rLine )
{
	SwClientIter aIter( rFmt );

	SwClient* pLast;

	for( pLast = aIter.First( TYPE( SwTableLine ));
		 pLast && pLast == (SwClient *)&rLine;
		 pLast = aIter.Next() )
		;

	return pLast != 0;
}

// Schreiben einer Tabellenzeile. Red Returnwert ist die Summe
// aller in der Zeile enthaltenen Zellen.

USHORT Sw3IoImp::OutTableLine( const SwTableLine& rLine )
{
	USHORT nTotalBoxes = 0;
	const SwTableBoxes& rBoxes = rLine.GetTabBoxes();
	UINT16 nBoxes = rBoxes.Count();

	// 0x10: Format-Id ist enthalten (nur SW5)
	// 0x20: Format ist geshared (nur SW5)
	BYTE cFlags;

	SwFrmFmt* pFmt = rLine.GetFrmFmt();
	UINT16 nFmtId;
	if( IsSw31Or40Export() )
	{
		cFlags = 0x04;		// keine Flags, Fmt-Id, Anzahl Boxen
		nFmtId = GetTblLineBoxFmtStrPoolId40( pFmt );
	}
	else
	{
		cFlags = 0x02; // Anzahl Boxen
		if( lcl_sw3io_IsLineFmtShared( *pFmt, rLine ) )
		{
			cFlags += 0x40;		// Shared-Flag
			if( pFmt->IsWritten() )
			{
				cFlags += 0x22; // FmtId-Flag + FmtId
				nFmtId = GetTblLineBoxFmtId( pFmt );
			}
			else
			{
				AddTblLineBoxFmt( pFmt );
			}
		}
	}

	OpenRec( SWG_TABLELINE );
	*pStrm << (BYTE) cFlags;
	if( IsSw31Or40Export() || (cFlags & 0x20) != 0 )
		*pStrm << nFmtId;

	*pStrm << nBoxes;

	// OutFormat schreibt nur noch nicht geschriebene Formate raus,
	// deshalb muss das hier nicht ueberprueft werden.
	OutFormat( SWG_FRAMEFMT, *pFmt );

	for( USHORT i = 0; i < nBoxes && Good(); i++ )
		nTotalBoxes += OutTableBox( *( rBoxes[ i ]) );
	CloseRec( SWG_TABLELINE );
	return nTotalBoxes;

}

/**/


// Einlesen einer Zelle
// BYTE			Flag-Byte
//				0x10 - Zelle enthaelt weitere Zeilen
//				0x20 - Zellen enthaelt leeren Contentbereich (nie exportiert)
//				0x20 - FrmFmtId ist vorhanden (seit SW5)
//				0x40 - FrmFmt ist geshared (seit SW5)
// UINT16		String-ID des Frameformats
// UINT16		Anzahl Zeilen oder Section-ID (opt)
// SWG_FRAMEFMT (optional)
// SWG_CONTENTS	Inhalt oder
// SWG_TABLELINE (optional, mehrfach)


void Sw3IoImp::InTableBox
	 (SwTableBoxes& rBoxes, USHORT nPos,	// Array und Index
	  SwTableLine* pUpper,					// uebergeordnete Zeile
	  SwNodeIndex& rPos )					// Start-Index der Section
{
	OpenRec( SWG_TABLEBOX );
	BYTE   cFlags = OpenFlagRec();
	UINT16 nFmtId = IDX_NO_VALUE, nLines = 0;
	if( !IsVersion(SWG_LONGIDX) || (cFlags & 0x20) != 0 )
		*pStrm >> nFmtId;
	if( cFlags & 0x10 )
		*pStrm >> nLines;
	CloseFlagRec();

	// Frame-Format evtl. einlesen
	SwTableBoxFmt* pFmt;
	if( Peek() == SWG_FRAMEFMT )
	{
		pFmt = (SwTableBoxFmt*) InFormat( SWG_FRAMEFMT, pDoc->MakeTableBoxFmt() );
		lcl_sw3io_AdjustFrmSize( pFmt, nSizeDivFac );
		if( (cFlags & 0x40) != 0 )
			AddTblLineBoxFmt( pFmt );
	}
	else if( (cFlags & 0x20) != 0 )
	{
		ASSERT( IsVersion(SWG_LONGIDX), "0x20 doch schon frueher benutzt?" );
		pFmt = (SwTableBoxFmt *)GetTblLineBoxFmt( nFmtId );
	}
	else if( !IsVersion(SWG_LONGIDX) )
	{
		// Ja, das funktioniert. Das Format steht zwar in keinem
		// Array mehr, aber es ist im String-Pool gecached.
		pFmt = (SwTableBoxFmt *)FindFmt( nFmtId, SWG_FRAMEFMT );
	}

	if( pFmt )
	{
		SwTableBox* pBox;
		if( Peek() == SWG_CONTENTS )
		{
			pBox = new SwTableBox( pFmt, rPos, pUpper );
			InContents( rPos );

			// JP 12.09.97 - Bug 41223:
			// falls an der International Einstellung gedreht wurde, so muss
			// jetzt die entsprechende Aktualisierung erfolgen.
			pBox->ChgByLanguageSystem();

#ifndef PRODUCT
			++nCntntBox;
#endif
		}
		else
			pBox = new SwTableBox( pFmt, nLines, pUpper );
		rBoxes.C40_INSERT( SwTableBox, pBox, nPos );
		USHORT nBoxPos = 0;
		if( !BytesLeft() )
		{
			// JP 05.05.97: Bug 39569 - Zelle ohne StartNode und ohne Lines
			if( !pBox->GetSttNd() )
			{
				//JP 19.06.98: erst die neue Box erzeugen, damit diese sich
				//			als abhaengig ins Format eintraegt; sonst wird
				//			das Format im BoxDTOR geloescht !!!
				SwTableBox* pNewBox = new SwTableBox( pFmt, rPos, pUpper );
				rBoxes.C40_REPLACE( SwTableBox, pNewBox, nPos );
				delete pBox;
				pBox = pNewBox;
				rPos = pBox->GetSttNd()->EndOfSectionIndex() + 1;
#ifndef PRODUCT
				ASSERT( !this, "Tabellenzelle ohne Lines und ohne Content" );
				++nCntntBox;
#endif
			}
		}
		else
			while( BytesLeft() )
				InTableLine( pBox->GetTabLines(), pBox, nBoxPos++, rPos );

	}
	else
	{
		ASSERT( pFmt, "Box-Format fehlt" );
		Error(); 	// kein FrmFmt
	}
	CloseRec( SWG_TABLEBOX );
}

BOOL lcl_sw3io_IsBoxFmtShared( SwFrmFmt& rFmt, const SwTableBox& rBox )
{
	SwClientIter aIter( rFmt );

	SwClient* pLast;

	for( pLast = aIter.First( TYPE( SwTableBox ));
		 pLast && pLast == (SwClient *)&rBox;
		 pLast = aIter.Next() )
		;

	return pLast != 0;
}

USHORT Sw3IoImp::OutTableBox( const SwTableBox& rBox )
{
	const SwTableLines& rLines = rBox.GetTabLines();
	USHORT nLines = rLines.Count();
	USHORT nTotalBoxes = 0;

	BYTE cFlags;

	UINT16 nFmtId;
	SwFrmFmt* pFmt = rBox.GetFrmFmt();
	if( IsSw31Or40Export() )
	{
		cFlags = 0x02;		// keine Flags, FmtId
		nFmtId = GetTblLineBoxFmtStrPoolId40( pFmt );
	}
	else
	{
		cFlags = 0x00; 		// keine Flags, keine Daten
		if( lcl_sw3io_IsBoxFmtShared( *pFmt, rBox ) )
		{
			cFlags += 0x40;	// Format ist geshared
			if( pFmt->IsWritten() )
			{
				cFlags += 0x22; // FmtId-Flag + FmtId
				nFmtId = GetTblLineBoxFmtId( pFmt );
			}
			else
			{
				AddTblLineBoxFmt( pFmt );
			}
		}
	}

	if( nLines )
		cFlags += 0x12;
	OpenRec( SWG_TABLEBOX );
	*pStrm << (BYTE)   cFlags;
	if( IsSw31Or40Export() || (cFlags & 0x20) != 0 )
		*pStrm << (UINT16) nFmtId;
	if( cFlags & 0x10 )
		*pStrm << (UINT16) nLines;
	OutFormat( SWG_FRAMEFMT, *pFmt );
	if( rBox.GetSttNd() )
		// Inhalt ausgeben
		OutContents( SwNodeIndex( *rBox.GetSttNd() ) );
	if( nLines )
	{
		// Falls Zeilen vorhanden, diese ausgeben
		for( USHORT i = 0; i < nLines; i++)
			nTotalBoxes += OutTableLine( *( rLines[ i ]) );
	}
	else
		nTotalBoxes++;
	CloseRec( SWG_TABLEBOX );
	return nTotalBoxes;
}

